/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.route;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.racem.sea.fish.Ocean;
import us.racem.sea.route.RouteRegistry;
import us.racem.sea.route.RouteSegment;
import us.racem.sea.util.InterpolationLogger;
import us.racem.sea.util.SetUtils;

public class RouteParser {
    private static final InterpolationLogger logger = InterpolationLogger.getLogger(Ocean.class);
    private static final String logPrefix = "PRS";
    private static final String partRegexStr = "(?<PART>[^?\\#/\\[\\]]+)|\n(?<PARAM>\n  \\[\n    (?<NAME>[^?|/\\[\\]]+)\n    (?:\\s*):(?:\\s*)\n    (?<KIND>[^?|/\\[\\]]+)\n  ]\n  (?<SEP>\n    (?:\\s*)\n    ,\n    (?:\\s*)\n  )?\n)\n";
    private static final Pattern partRegexPtrn = Pattern.compile("(?<PART>[^?\\#/\\[\\]]+)|\n(?<PARAM>\n  \\[\n    (?<NAME>[^?|/\\[\\]]+)\n    (?:\\s*):(?:\\s*)\n    (?<KIND>[^?|/\\[\\]]+)\n  ]\n  (?<SEP>\n    (?:\\s*)\n    ,\n    (?:\\s*)\n  )?\n)\n", 12);
    private static final String delimRegexStr = "/{1,2}";
    private static final Pattern delimRegexPtrn = Pattern.compile("/{1,2}", 8);

    public static MatchObj matchOf(Matcher regex, MatchObj other) {
        Object ptrn;
        MatchSep sep = regex.group("SEP") == null ? MatchSep.NONE : MatchSep.AND;
        MatchKind kind = regex.group("PARAM") == null ? MatchKind.STRING : MatchKind.PATTERN;
        String name = switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case MatchKind.STRING -> regex.group("PART");
            case MatchKind.PATTERN -> regex.group("NAME");
        };
        switch (kind) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case STRING: {
                Object object = regex.group("PART");
                break;
            }
            case PATTERN: {
                Object object = ptrn = RouteRegistry.converters.get(regex.group("KIND")).regex();
            }
        }
        if (other != null) {
            ptrn = other.ptrn + "(" + (String)ptrn + ")";
        }
        return new MatchObj(name, (String)ptrn, kind, sep, other);
    }

    private static RouteSegment make(List<MatchObj> matchers, Method receiver, Object instance) {
        String ptrn = matchers.get((int)0).ptrn;
        String name = matchers.get((int)0).name;
        if (SetUtils.in(ptrn, RouteRegistry.tries)) {
            return SetUtils.take(ptrn, RouteRegistry.tries).root();
        }
        if (matchers.size() == 1) {
            return new RouteSegment(name, ptrn, null, receiver, instance);
        }
        return new RouteSegment(name, ptrn, null, null, null);
    }

    public static Pattern prefixOf(String path) {
        ArrayList<MatchObj> matchers = new ArrayList<MatchObj>();
        for (String part : delimRegexPtrn.split(path)) {
            Matcher regex = partRegexPtrn.matcher(part);
            MatchObj match = null;
            while (regex.find()) {
                if (regex.start() == -1) {
                    return null;
                }
                match = RouteParser.matchOf(regex, match);
            }
            if (match == null) continue;
            matchers.add(match);
        }
        return Pattern.compile(((MatchObj)matchers.get((int)0)).ptrn);
    }

    public static RouteSegment segmentsOf(String path, Method receiver, Object instance) {
        RouteSegment root;
        if (Objects.equals(path, "/") || Objects.equals(path, "//")) {
            return SetUtils.in("/", RouteRegistry.tries) ? SetUtils.take("/", RouteRegistry.tries).root() : new RouteSegment("/", "/", null, receiver, instance);
        }
        ArrayList<MatchObj> matchers = new ArrayList<MatchObj>();
        for (String part : delimRegexPtrn.split(path)) {
            Matcher regex = partRegexPtrn.matcher(part);
            MatchObj match2 = null;
            while (regex.find()) {
                if (regex.start() == -1) {
                    return null;
                }
                match2 = RouteParser.matchOf(regex, match2);
            }
            if (match2 == null) continue;
            matchers.add(match2);
        }
        if (((MatchObj)matchers.get((int)0)).kind != MatchKind.STRING) {
            return null;
        }
        List<MatchObj> pathMatchers = SetUtils.slice(matchers, 1, match -> match.sep == MatchSep.AND);
        List<MatchObj> queryMatchers = SetUtils.slice(matchers, match -> match.sep == MatchSep.AND);
        RouteSegment pivot = root = RouteParser.make(matchers, receiver, instance);
        for (MatchObj pathMatcher : pathMatchers) {
            pivot = pivot.fork(pathMatcher.name, pathMatcher.ptrn);
        }
        for (int i = 0; i < queryMatchers.size(); ++i) {
            String ptrn;
            MatchObj queryMatcher = queryMatchers.get(i);
            String name = queryMatcher.name;
            block0 : switch (i) {
                case 0: {
                    Object object = queryMatcher.ptrn;
                    break;
                }
                default: {
                    Object object;
                    switch (queryMatcher.kind) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case STRING: {
                            object = null;
                            break block0;
                        }
                        case PATTERN: 
                    }
                    object = ptrn = i == 1 ? "\\?" + name + "=" + queryMatcher.ptrn : "&" + name + "=" + queryMatcher.ptrn;
                }
            }
            if (ptrn == null) {
                return null;
            }
            pivot = pivot.fork(name, ptrn);
        }
        pivot.bind(receiver, instance);
        return root;
    }

    private static enum MatchSep {
        AND,
        NONE;

    }

    private static enum MatchKind {
        STRING,
        PATTERN;

    }

    private record MatchObj(String name, String ptrn, MatchKind kind, MatchSep sep, MatchObj other) {
    }
}

