/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.inject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import org.reflections.scanners.Scanners;
import us.racem.sea.fish.Ocean;
import us.racem.sea.inject.AnyInjector;
import us.racem.sea.mark.methods.DeleteMapping;
import us.racem.sea.mark.methods.GetMapping;
import us.racem.sea.mark.methods.PatchMapping;
import us.racem.sea.mark.methods.PostMapping;
import us.racem.sea.mark.methods.PutMapping;
import us.racem.sea.mark.methods.RequestMapping;
import us.racem.sea.route.RouteRegistry;
import us.racem.sea.util.InterpolationLogger;
import us.racem.sea.util.SetUtils;

public class RouteMappingInjector
extends AnyInjector {
    private static final InterpolationLogger logger = InterpolationLogger.getLogger(Ocean.class);
    private static final String logPrefix = "PTH";

    public RouteMappingInjector(String main) {
        super(main, Scanners.TypesAnnotated, Scanners.SubTypes, Scanners.MethodsAnnotated);
    }

    private Set<Method> find() {
        Set request = this.reflector.getMethodsAnnotatedWith(RequestMapping.class);
        Set get = this.reflector.getMethodsAnnotatedWith(GetMapping.class);
        Set put = this.reflector.getMethodsAnnotatedWith(PutMapping.class);
        Set patch = this.reflector.getMethodsAnnotatedWith(PatchMapping.class);
        Set post = this.reflector.getMethodsAnnotatedWith(PostMapping.class);
        Set delete = this.reflector.getMethodsAnnotatedWith(DeleteMapping.class);
        return SetUtils.union(request, get, put, patch, post, delete);
    }

    private String path(Method receiver) {
        RequestMapping request = receiver.getAnnotation(RequestMapping.class);
        GetMapping get = receiver.getAnnotation(GetMapping.class);
        PutMapping put = receiver.getAnnotation(PutMapping.class);
        PatchMapping patch = receiver.getAnnotation(PatchMapping.class);
        PostMapping post = receiver.getAnnotation(PostMapping.class);
        DeleteMapping delete = receiver.getAnnotation(DeleteMapping.class);
        if (!SetUtils.xor(request, get, put, patch, post, delete)) {
            return null;
        }
        if (request != null) {
            return request.path();
        }
        if (get != null) {
            return get.path();
        }
        if (put != null) {
            return put.path();
        }
        if (patch != null) {
            return patch.path();
        }
        if (post != null) {
            return post.path();
        }
        if (delete != null) {
            return delete.path();
        }
        throw new RuntimeException("Unreachable!");
    }

    @Override
    public void inject() {
        Set<Method> receivers = this.find();
        HashMap<Class, Object> instances = new HashMap<Class, Object>();
        logger.info("Methods: {}", receivers);
        for (Method receiver : receivers) {
            try {
                String route = this.path(receiver);
                Object instance = instances.computeIfAbsent(receiver.getDeclaringClass(), $ -> {
                    try {
                        return receiver.getDeclaringClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException err) {
                        throw new RuntimeException(err);
                    }
                });
                RouteRegistry.register(route, receiver, instance);
                logger.info("Registered Route: {}", route);
            }
            catch (Exception err) {
                logger.warn("Failed to register Route: {}", err);
            }
        }
    }
}

