/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.inject;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.reflections.scanners.Scanners;
import us.racem.sea.convert.AnyCodec;
import us.racem.sea.fish.Ocean;
import us.racem.sea.inject.AnyInjector;
import us.racem.sea.mark.inject.PathConverter;
import us.racem.sea.route.RouteRegistry;
import us.racem.sea.util.InterpolationLogger;

public class ConverterInjector
extends AnyInjector {
    private static final InterpolationLogger logger = InterpolationLogger.getLogger(Ocean.class);
    private static final String logPrefix = "CNV";

    public ConverterInjector(String main) {
        super(main, new Scanners[0]);
    }

    @Override
    public void inject() {
        List<Class> converterClasses = this.reflector.getSubTypesOf(AnyCodec.class).stream().filter(convertClass -> convertClass.isAnnotationPresent(PathConverter.class)).toList();
        for (Class converterClass : converterClasses) {
            try {
                AnyCodec converter = (AnyCodec)converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String name = converterClass.getAnnotation(PathConverter.class).value();
                RouteRegistry.register(name, converter);
                logger.info("Registered Converter: {}", converterClass.getSimpleName());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException err) {
                logger.warn("Failed to Initialize Converter: {}", err);
            }
        }
    }
}

