/*
 * Decompiled with CFR 0.152.
 */
package us.racem.sea.fish;

import java.lang.reflect.InvocationTargetException;
import us.racem.sea.fish.Ocean;
import us.racem.sea.fish.OceanExecutable;
import us.racem.sea.inject.AnyInjector;
import us.racem.sea.util.InterpolationLogger;

public class OceanInjector
extends OceanExecutable {
    private static final InterpolationLogger logger = InterpolationLogger.getLogger(Ocean.class);
    private static final String logPrefix = "INJ";
    private final String main;
    private final Class<? extends AnyInjector>[] injectorClasses;

    @SafeVarargs
    public OceanInjector(String main, Class<? extends AnyInjector> ... injectorClasses) {
        this.main = main;
        this.injectorClasses = injectorClasses;
    }

    @Override
    public void run() {
        for (Class<? extends AnyInjector> injectorClass : this.injectorClasses) {
            try {
                logger.info("Called: {}", injectorClass.getSimpleName());
                injectorClass.getDeclaredConstructor(String.class).newInstance(this.main).inject();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException err) {
                logger.warn("Failed to Initialize injector: {}", err);
            }
        }
    }
}

