/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.monoid.web.AbstractResource;

public class TextResource
extends AbstractResource {
    static final Pattern charsetPattern = Pattern.compile("charset=([^ ;]+);?");
    protected String text;

    public String toString() {
        if (this.text == null && this.inputStream != null) {
            this.text = this.readTextFromStream(this.inputStream);
        }
        return this.text;
    }

    protected String readTextFromStream(InputStream aTextStream) {
        Charset charset = this.getCharSet();
        int size = this.urlConnection.getContentLength();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size != -1 ? size : 1024);
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = aTextStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String streamedText = "";
        try {
            streamedText = bos.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return streamedText;
    }

    protected Charset getCharSet() {
        String contentType = this.urlConnection.getContentType();
        Matcher m = charsetPattern.matcher(contentType);
        Charset charset = Charset.forName("iso-8859-1");
        if (m.find()) {
            String charsetString = m.group(1);
            try {
                charset = Charset.forName(charsetString);
            }
            catch (IllegalCharsetNameException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return charset;
    }

    @Override
    String getAcceptedTypes() {
        return "text/html,text/plain,text/*";
    }
}

