/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web.jp.javacc;

import us.monoid.json.JSONException;
import us.monoid.json.JSONObject;

public class Predicates {

    static class Identity
    implements Test {
        Test child;

        Identity(Test aChild) {
            this.child = aChild;
        }

        @Override
        public boolean test(JSONObject json) throws JSONException {
            return this.child.test(json);
        }
    }

    static class Operator
    implements Test {
        String fieldName;
        char ops;
        Comparable value;

        Operator(String aFieldName, String anOperator, Comparable aValue) {
            this.fieldName = aFieldName;
            this.ops = anOperator.charAt(0);
            this.value = aValue;
        }

        @Override
        public boolean test(JSONObject json) throws JSONException {
            Comparable val = (Comparable)json.get(this.fieldName);
            int comparisonResult = val.compareTo(this.value);
            switch (this.ops) {
                case '>': {
                    return comparisonResult > 0;
                }
                case '=': {
                    return comparisonResult == 0;
                }
                case '<': {
                    return comparisonResult < 0;
                }
            }
            return false;
        }
    }

    public static interface Test {
        public boolean test(JSONObject var1) throws JSONException;
    }
}

