/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.simulationconstructionset.gui.GraphPropertiesPanel;
import us.ihmc.simulationconstructionset.gui.VarPropertiesPanel;
import us.ihmc.simulationconstructionset.gui.YoGraph;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryReader;

public class GraphPropertiesDialog
extends JDialog
implements ActionListener {
    private final JButton okButton;
    private final JButton applyButton;
    private final JButton cancelButton;
    private final GraphPropertiesPanel graphPropertiesPanel;
    private final VarPropertiesPanel[] varPropertiesPanels;
    private final JFrame parentFrame;
    private final YoGraph graph;

    public GraphPropertiesDialog(JFrame frame, YoGraph graph) {
        super(frame, "Graph Properties", false);
        this.parentFrame = frame;
        this.graph = graph;
        Container contentPane = this.getContentPane();
        List<YoBufferVariableEntryReader> entries = graph.getEntriesOnThisGraph();
        JPanel panels = new JPanel(new GridLayout(entries.size() + 1, 1));
        this.graphPropertiesPanel = new GraphPropertiesPanel(graph);
        panels.add(this.graphPropertiesPanel);
        this.varPropertiesPanels = new VarPropertiesPanel[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            this.varPropertiesPanels[i] = new VarPropertiesPanel(entries.get(i));
            panels.add(this.varPropertiesPanels[i]);
        }
        contentPane.add(panels);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        Point point = frame.getLocation();
        Dimension frameSize = frame.getSize();
        point.translate(frameSize.width / 4, frameSize.height / 2);
        this.setLocation(point);
        this.setResizable(false);
        this.setVisible(true);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int i;
        if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
        if (event.getSource() == this.applyButton) {
            this.graphPropertiesPanel.commitChanges();
            for (i = 0; i < this.varPropertiesPanels.length; ++i) {
                this.varPropertiesPanels[i].commitChanges();
            }
            this.graph.repaint();
        }
        if (event.getSource() == this.okButton) {
            this.graphPropertiesPanel.commitChanges();
            for (i = 0; i < this.varPropertiesPanels.length; ++i) {
                this.varPropertiesPanels[i].commitChanges();
            }
            this.graph.repaint();
            this.setVisible(false);
        }
        this.parentFrame.repaint();
    }
}

