/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.gui.JSliderYoVariableControl;
import us.ihmc.tools.thread.CloseableAndDisposable;
import us.ihmc.tools.thread.CloseableAndDisposableRegistry;

public class YoVariableSliderWindow
implements CloseableAndDisposable {
    private static final int MAX_CHANNELS_PER_ROW = 8;
    private JPanel mainPanel = new JPanel();
    private JFrame frame = new JFrame();
    private int numRow = 0;
    private int numCol = 0;
    private static final int sliderWidth = 80;
    private static final int sliderHeight = 300;
    private final Object slidersLock = new Object();
    private CloseableAndDisposableRegistry closeableAndDisposableRegistry;
    private final SelectedVariableHolder selectedVariableHolder;
    private int numberOfSliders;

    public YoVariableSliderWindow(SelectedVariableHolder selectedVariableHolder, CloseableAndDisposableRegistry closeableAndDisposableRegistry) {
        this(8, selectedVariableHolder, closeableAndDisposableRegistry);
    }

    public YoVariableSliderWindow(int numberOfSliders, SelectedVariableHolder selectedVariableHolder, CloseableAndDisposableRegistry closeableAndDisposableRegistry) {
        this.numberOfSliders = numberOfSliders;
        this.numCol = Math.min(numberOfSliders, 8);
        this.numRow = (int)Math.ceil((double)numberOfSliders / 8.0);
        this.closeableAndDisposableRegistry = closeableAndDisposableRegistry;
        this.selectedVariableHolder = selectedVariableHolder;
        this.frame.setDefaultCloseOperation(1);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.mainPanel, "Center");
        this.frame.setTitle("YoVariable Slider");
        this.mainPanel.removeAll();
        this.mainPanel.setLayout(new GridLayout(this.numRow, this.numCol));
        for (int i = 0; i < numberOfSliders; ++i) {
            this.mainPanel.add(new JSliderYoVariableControl(selectedVariableHolder, closeableAndDisposableRegistry));
        }
        this.frame.setVisible(true);
        this.frame.pack();
    }

    public void setTitle(String name) {
        this.frame.setTitle(name);
    }

    public void setFrameLocation(int x, int y) {
        this.frame.setLocation(x, y);
    }

    public void closeAndDispose() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                YoVariableSliderWindow.this.mainPanel.setVisible(false);
                YoVariableSliderWindow.this.mainPanel = null;
                YoVariableSliderWindow.this.frame.setVisible(false);
                YoVariableSliderWindow.this.frame.dispose();
                YoVariableSliderWindow.this.frame = null;
            }
        });
    }
}

