/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.simulatedSensors;

import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.simulatedSensors.WrenchCalculatorInterface;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CollisionShapeBasedWrenchCalculator
implements WrenchCalculatorInterface {
    private static final int WRENCH_SIZE = 6;
    private final String forceSensorName;
    private final List<ExternalForcePoint> contactPoints;
    private final Joint forceTorqueSensorJoint;
    private final RigidBodyTransform transformToParentJoint;
    private boolean doWrenchCorruption = false;
    private final DMatrixRMaj wrenchMatrix = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj corruptionMatrix = new DMatrixRMaj(6, 1);
    private final ReferenceFrame sensorFrame;
    private final RigidBodyTransform transformToOriginFrame = new RigidBodyTransform();
    private final Vector3D force = new Vector3D();
    private final Point3D contactPointOriginFrame = new Point3D();
    private final Vector3D contactVectorOriginFrame = new Vector3D();
    private final Vector3D tau = new Vector3D();

    public CollisionShapeBasedWrenchCalculator(String forceSensorName, List<ExternalForcePoint> contactPoints, Joint forceTorqueSensorJoint, RigidBodyTransform transformToParentJoint, YoRegistry registry) {
        this.forceSensorName = forceSensorName;
        this.contactPoints = contactPoints;
        this.forceTorqueSensorJoint = forceTorqueSensorJoint;
        this.transformToParentJoint = transformToParentJoint;
        this.sensorFrame = new ReferenceFrame(forceSensorName + "Frame", ReferenceFrame.getWorldFrame()){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set(CollisionShapeBasedWrenchCalculator.this.transformToOriginFrame);
            }
        };
    }

    @Override
    public String getName() {
        return this.forceSensorName;
    }

    @Override
    public void getTransformToParentJoint(RigidBodyTransform transformToPack) {
        transformToPack.set(this.transformToParentJoint);
    }

    @Override
    public void calculate() {
        int i;
        this.wrenchMatrix.zero();
        this.forceTorqueSensorJoint.getTransformToWorld((RigidBodyTransformBasics)this.transformToOriginFrame);
        this.transformToOriginFrame.multiply((RigidBodyTransformReadOnly)this.transformToParentJoint);
        this.sensorFrame.update();
        this.transformToOriginFrame.invert();
        for (i = 0; i < this.contactPoints.size(); ++i) {
            ExternalForcePoint contactPoint = this.contactPoints.get(i);
            Point3D tempContactPoint = new Point3D();
            contactPoint.getForce((Vector3DBasics)this.force);
            this.wrenchMatrix.set(3, 0, this.wrenchMatrix.get(3, 0) + this.force.getX());
            this.wrenchMatrix.set(4, 0, this.wrenchMatrix.get(4, 0) + this.force.getY());
            this.wrenchMatrix.set(5, 0, this.wrenchMatrix.get(5, 0) + this.force.getZ());
            this.transformToOriginFrame.transform((Vector3DBasics)this.force);
            this.contactPointOriginFrame.set(0.0, 0.0, 0.0);
            contactPoint.getPosition((Tuple3DBasics)tempContactPoint);
            this.transformToOriginFrame.transform((Point3DReadOnly)tempContactPoint, (Point3DBasics)this.contactPointOriginFrame);
            this.contactVectorOriginFrame.set((Tuple3DReadOnly)this.contactPointOriginFrame);
            this.tau.cross((Tuple3DReadOnly)this.contactVectorOriginFrame, (Tuple3DReadOnly)this.force);
            this.wrenchMatrix.set(0, 0, this.wrenchMatrix.get(0, 0) + this.tau.getX());
            this.wrenchMatrix.set(1, 0, this.wrenchMatrix.get(1, 0) + this.tau.getY());
            this.wrenchMatrix.set(2, 0, this.wrenchMatrix.get(2, 0) + this.tau.getZ());
        }
        if (this.doWrenchCorruption) {
            for (i = 0; i < 6; ++i) {
                this.wrenchMatrix.add(i, 0, this.corruptionMatrix.get(i, 0));
            }
        }
    }

    @Override
    public DMatrixRMaj getWrench() {
        return this.wrenchMatrix;
    }

    @Override
    public Joint getJoint() {
        return this.forceTorqueSensorJoint;
    }

    @Override
    public void corruptWrenchElement(int row, double value) {
        this.corruptionMatrix.add(row, 0, value);
    }

    @Override
    public void setDoWrenchCorruption(boolean value) {
        this.doWrenchCorruption = value;
    }
}

