/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class RotatableBoxTerrainObject
implements TerrainObject3D,
HeightMapWithNormals {
    protected final BoundingBox3D boundingBox = new BoundingBox3D();
    protected final Box3D box;
    public AppearanceDefinition appearance;
    protected Graphics3DObject linkGraphics;
    private final Point3D tempPoint = new Point3D();
    private final Vector3D zVector = new Vector3D(0.0, 0.0, 1.0);
    private final Point3D intersectionA = new Point3D();
    private final Point3D intersectionB = new Point3D();
    private final ArrayList<Shape3DReadOnly> terrainCollisionShapes = new ArrayList();
    private final Point3D ignoreIntesectionPoint = new Point3D();
    private final Vector3D ignoreNormal = new Vector3D();

    public RotatableBoxTerrainObject(Box3D box, AppearanceDefinition appearance) {
        this.box = box;
        this.appearance = appearance;
        this.boundingBox.set(box.getBoundingBox());
        this.addGraphics();
        this.terrainCollisionShapes.add((Shape3DReadOnly)this.box);
    }

    public RotatableBoxTerrainObject(RigidBodyTransform configuration, double lengthX, double widthY, double heightZ, AppearanceDefinition appearance) {
        this(new Box3D((RigidBodyTransformReadOnly)configuration, lengthX, widthY, heightZ), appearance);
    }

    protected void addGraphics() {
        RigidBodyTransform transformCenterConventionToBottomConvention = new RigidBodyTransform((RigidBodyTransformReadOnly)this.box.getPose());
        transformCenterConventionToBottomConvention.appendTranslation(0.0, 0.0, -this.box.getSizeZ() / 2.0);
        this.linkGraphics = new Graphics3DObject();
        this.linkGraphics.transform((RigidBodyTransformReadOnly)transformCenterConventionToBottomConvention);
        this.linkGraphics.addCube(this.box.getSizeX(), this.box.getSizeY(), this.box.getSizeZ(), this.appearance);
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.linkGraphics;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        this.tempPoint.set(x, y, z);
        this.zVector.set(0.0, 0.0, 1.0);
        int numberOfIntersections = this.box.intersectionWith((Point3DReadOnly)this.tempPoint, (Vector3DReadOnly)this.zVector, (Point3DBasics)this.intersectionA, (Point3DBasics)this.intersectionB);
        if (numberOfIntersections == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (numberOfIntersections == 1) {
            return this.intersectionA.getZ();
        }
        return Math.max(this.intersectionA.getZ(), this.intersectionB.getZ());
    }

    public double getXMin() {
        return this.boundingBox.getMinX();
    }

    public double getYMin() {
        return this.boundingBox.getMinY();
    }

    public double getXMax() {
        return this.boundingBox.getMaxX();
    }

    public double getYMax() {
        return this.boundingBox.getMaxY();
    }

    public double getZMin() {
        return this.boundingBox.getMinZ();
    }

    public double getZMax() {
        return this.boundingBox.getMaxZ();
    }

    public boolean isClose(double x, double y, double z) {
        return this.boundingBox.isXYInsideInclusive(x, y);
    }

    public void closestIntersectionTo(double x, double y, double z, Point3DBasics intersectionToPack) {
        this.tempPoint.set(x, y, z);
        this.box.evaluatePoint3DCollision((Point3DReadOnly)this.tempPoint, intersectionToPack, (Vector3DBasics)this.ignoreNormal);
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        this.tempPoint.set(x, y, z);
        this.box.evaluatePoint3DCollision((Point3DReadOnly)this.tempPoint, (Point3DBasics)this.ignoreIntesectionPoint, normalToPack);
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        this.tempPoint.set(x, y, z);
        this.box.evaluatePoint3DCollision((Point3DReadOnly)this.tempPoint, intersectionToPack, normalToPack);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        this.tempPoint.set(x, y, z);
        if (!this.box.isPointInside((Point3DReadOnly)this.tempPoint)) {
            return false;
        }
        this.box.evaluatePoint3DCollision((Point3DReadOnly)this.tempPoint, intersectionToPack, normalToPack);
        return true;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }

    public List<Shape3DReadOnly> getTerrainCollisionShapes() {
        return this.terrainCollisionShapes;
    }
}

