/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.JointPhysics;

public class SliderJointPhysics
extends JointPhysics<SliderJoint> {
    private double q_n;
    private double qd_n;
    private double[] k_qdd = new double[4];
    private double[] k_qd = new double[4];
    private Vector3D w_hXr_i = new Vector3D();
    private Vector3D temp1 = new Vector3D();
    private Vector3D temp2 = new Vector3D();
    private Vector3D vel_i = new Vector3D();

    public SliderJointPhysics(SliderJoint owner) {
        super(owner);
    }

    @Override
    protected void jointDependentChangeVelocity(double delta_qd) {
        ((SliderJoint)this.owner).getQDYoVariable().set(((SliderJoint)this.owner).getQDYoVariable().getDoubleValue() + delta_qd);
    }

    @Override
    protected void jointDependentSetAndGetRotation(RotationMatrixBasics Rh_i) {
        Rh_i.setIdentity();
    }

    @Override
    protected void jointDependentFeatherstonePassOne() {
        this.Q_i = ((SliderJoint)this.owner).doPDControl() + ((SliderJoint)this.owner).getTauYoVariable().getDoubleValue();
        if (((SliderJoint)this.owner).tauJointLimit != null) {
            if (((SliderJoint)this.owner).getQYoVariable().getDoubleValue() < ((SliderJoint)this.owner).q_min) {
                double limitTorque = ((SliderJoint)this.owner).k_limit * (((SliderJoint)this.owner).q_min - ((SliderJoint)this.owner).getQYoVariable().getDoubleValue()) - ((SliderJoint)this.owner).b_limit * ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue();
                if (limitTorque < 0.0) {
                    limitTorque = 0.0;
                }
                ((SliderJoint)this.owner).tauJointLimit.set(limitTorque);
            } else if (((SliderJoint)this.owner).getQYoVariable().getDoubleValue() > ((SliderJoint)this.owner).q_max) {
                double limitTorque = ((SliderJoint)this.owner).k_limit * (((SliderJoint)this.owner).q_max - ((SliderJoint)this.owner).getQYoVariable().getDoubleValue()) - ((SliderJoint)this.owner).b_limit * ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue();
                if (limitTorque > 0.0) {
                    limitTorque = 0.0;
                }
                ((SliderJoint)this.owner).tauJointLimit.set(limitTorque);
            } else {
                ((SliderJoint)this.owner).tauJointLimit.set(0.0);
            }
            this.Q_i += ((SliderJoint)this.owner).tauJointLimit.getDoubleValue();
        }
        if (((SliderJoint)this.owner).tauDamping != null) {
            if (((SliderJoint)this.owner).getQDYoVariable().getDoubleValue() > 0.0) {
                ((SliderJoint)this.owner).tauDamping.set(-((SliderJoint)this.owner).f_stiction - ((SliderJoint)this.owner).b_damp * ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue());
            } else if (((SliderJoint)this.owner).getQDYoVariable().getDoubleValue() < -0.0) {
                ((SliderJoint)this.owner).tauDamping.set(((SliderJoint)this.owner).f_stiction - ((SliderJoint)this.owner).b_damp * ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue());
            } else {
                ((SliderJoint)this.owner).tauDamping.set(0.0 - ((SliderJoint)this.owner).b_damp * ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue());
            }
            this.Q_i += ((SliderJoint)this.owner).tauDamping.getDoubleValue();
        }
        this.v_i.setX(this.v_i.getX() + ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue() * this.u_i.getX());
        this.v_i.setY(this.v_i.getY() + ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue() * this.u_i.getY());
        this.v_i.setZ(this.v_i.getZ() + ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue() * this.u_i.getZ());
    }

    @Override
    protected void jointDependentSet_d_i() {
        this.d_i.set(this.u_i);
        this.d_i.scale(((SliderJoint)this.owner).getQYoVariable().getDoubleValue());
        this.d_i.add((Tuple3DReadOnly)((SliderJoint)this.owner).getLink().getComOffset());
    }

    @Override
    protected void jointDependentFeatherstonePassTwo(Vector3DReadOnly w_h) {
        this.vel_i.set(this.u_i);
        this.vel_i.scale(((SliderJoint)this.owner).getQDYoVariable().getDoubleValue());
        this.c_hat_i.top.set(0.0, 0.0, 0.0);
        this.w_hXr_i.cross((Tuple3DReadOnly)w_h, (Tuple3DReadOnly)this.r_i);
        this.temp1.cross((Tuple3DReadOnly)w_h, (Tuple3DReadOnly)this.w_hXr_i);
        this.temp2.cross((Tuple3DReadOnly)w_h, (Tuple3DReadOnly)this.vel_i);
        this.temp2.scale(2.0);
        this.c_hat_i.bottom.add((Tuple3DReadOnly)this.temp1, (Tuple3DReadOnly)this.temp2);
        this.s_hat_i.top.set(0.0, 0.0, 0.0);
        this.s_hat_i.bottom.set(this.u_i);
    }

    @Override
    protected void jointDependentFeatherstonePassFour(double Q, int passNumber) {
        ((SliderJoint)this.owner).getQDDYoVariable().set(Q);
        this.k_qdd[passNumber] = Q;
        this.k_qd[passNumber] = ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue();
    }

    @Override
    protected void jointDependentRecordK(int passNumber) {
        this.k_qdd[passNumber] = ((SliderJoint)this.owner).getQDDYoVariable().getDoubleValue();
        this.k_qd[passNumber] = ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue();
    }

    @Override
    public void recursiveEulerIntegrate(double stepSize) {
        ((SliderJoint)this.owner).getQYoVariable().set(this.q_n + stepSize * ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue());
        ((SliderJoint)this.owner).getQDYoVariable().set(this.qd_n + stepSize * ((SliderJoint)this.owner).getQDDYoVariable().getDoubleValue());
        for (int i = 0; i < ((SliderJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((SliderJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveEulerIntegrate(stepSize);
        }
    }

    @Override
    public void recursiveRungeKuttaSum(double stepSize) {
        ((SliderJoint)this.owner).getQYoVariable().set(this.q_n + stepSize * (this.k_qd[0] / 6.0 + this.k_qd[1] / 3.0 + this.k_qd[2] / 3.0 + this.k_qd[3] / 6.0));
        ((SliderJoint)this.owner).getQDYoVariable().set(this.qd_n + stepSize * (this.k_qdd[0] / 6.0 + this.k_qdd[1] / 3.0 + this.k_qdd[2] / 3.0 + this.k_qdd[3] / 6.0));
        for (int i = 0; i < ((SliderJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((SliderJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRungeKuttaSum(stepSize);
        }
    }

    @Override
    public void recursiveSaveTempState() {
        this.q_n = ((SliderJoint)this.owner).getQYoVariable().getDoubleValue();
        this.qd_n = ((SliderJoint)this.owner).getQDYoVariable().getDoubleValue();
        for (int i = 0; i < ((SliderJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((SliderJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveSaveTempState();
        }
    }

    @Override
    public void recursiveRestoreTempState() {
        ((SliderJoint)this.owner).getQYoVariable().set(this.q_n);
        ((SliderJoint)this.owner).getQDYoVariable().set(this.qd_n);
        for (int i = 0; i < ((SliderJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((SliderJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRestoreTempState();
        }
    }

    @Override
    protected boolean jointDependentVerifyReasonableAccelerations() {
        return !(Math.abs(((SliderJoint)this.owner).getQDDYoVariable().getDoubleValue()) > 1.0E12);
    }
}

