/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.Graphics3DSpotLight;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.graphicsDescription.image.DepthImageCallback;
import us.ihmc.graphicsDescription.image.ImageCallback;
import us.ihmc.graphicsDescription.input.SelectedListener;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DBackgroundScaleMode;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.jMonkeyEngineToolkit.camera.CaptureDevice;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.simulationconstructionset.DataFileReader;
import us.ihmc.simulationconstructionset.DataFileWriter;
import us.ihmc.simulationconstructionset.ExitActionListener;
import us.ihmc.simulationconstructionset.ExtraPanelConfiguration;
import us.ihmc.simulationconstructionset.GotoInPointCommandExecutor;
import us.ihmc.simulationconstructionset.GotoOutPointCommandExecutor;
import us.ihmc.simulationconstructionset.GraphConfiguration;
import us.ihmc.simulationconstructionset.GraphicsUpdatablePlaybackListener;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.HeightMapFromGroundContactModel;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.ParameterRootNamespaceHolder;
import us.ihmc.simulationconstructionset.PlayCycleListener;
import us.ihmc.simulationconstructionset.PlaybackListener;
import us.ihmc.simulationconstructionset.RewoundListener;
import us.ihmc.simulationconstructionset.RewoundListenerHandler;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.RobotFromDescription;
import us.ihmc.simulationconstructionset.Simulation;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.SimulationDoneCriterion;
import us.ihmc.simulationconstructionset.SimulationDoneListener;
import us.ihmc.simulationconstructionset.StandardAllCommandsExecutor;
import us.ihmc.simulationconstructionset.SupportedGraphics3DAdapter;
import us.ihmc.simulationconstructionset.TimeHolder;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.ViewportConfiguration;
import us.ihmc.simulationconstructionset.commands.AddCameraKeyCommandExecutor;
import us.ihmc.simulationconstructionset.commands.AddKeyPointCommandExecutor;
import us.ihmc.simulationconstructionset.commands.AllCommandsExecutor;
import us.ihmc.simulationconstructionset.commands.CreateNewGraphWindowCommandExecutor;
import us.ihmc.simulationconstructionset.commands.CreateNewViewportWindowCommandExecutor;
import us.ihmc.simulationconstructionset.commands.CropBufferCommandExecutor;
import us.ihmc.simulationconstructionset.commands.CutBufferCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ExportSnapshotCommandExecutor;
import us.ihmc.simulationconstructionset.commands.NextCameraKeyCommandExecutor;
import us.ihmc.simulationconstructionset.commands.PackBufferCommandExecutor;
import us.ihmc.simulationconstructionset.commands.PreviousCameraKeyCommandExecutor;
import us.ihmc.simulationconstructionset.commands.RemoveCameraKeyCommandExecutor;
import us.ihmc.simulationconstructionset.commands.RunCommandsExecutor;
import us.ihmc.simulationconstructionset.commands.SetInPointCommandExecutor;
import us.ihmc.simulationconstructionset.commands.SetOutPointCommandExecutor;
import us.ihmc.simulationconstructionset.commands.StepBackwardCommandExecutor;
import us.ihmc.simulationconstructionset.commands.StepForwardCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ToggleCameraKeyModeCommandExecutor;
import us.ihmc.simulationconstructionset.commands.WriteDataCommandExecutor;
import us.ihmc.simulationconstructionset.dataBuffer.DataBufferTools;
import us.ihmc.simulationconstructionset.graphics.GraphicsDynamicGraphicsObject;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.GraphArrayWindow;
import us.ihmc.simulationconstructionset.gui.StandardGUIActions;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.ViewportWindow;
import us.ihmc.simulationconstructionset.gui.YoGraphicCheckBoxMenuItem;
import us.ihmc.simulationconstructionset.gui.YoGraphicMenuManager;
import us.ihmc.simulationconstructionset.gui.config.VarGroupList;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.gui.tools.SimulationOverheadPlotterFactory;
import us.ihmc.simulationconstructionset.physics.ScsPhysics;
import us.ihmc.simulationconstructionset.physics.collision.simple.CollisionManager;
import us.ihmc.simulationconstructionset.robotdefinition.RobotDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.scripts.Script;
import us.ihmc.simulationconstructionset.synchronization.SimulationSynchronizer;
import us.ihmc.simulationconstructionset.util.RealTimeRateEnforcer;
import us.ihmc.simulationconstructionset.util.TickAndUpdatable;
import us.ihmc.tools.TimestampProvider;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsChangedListener;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsHolder;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferIndexChangedListener;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferReader;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoVariable;

public class SimulationConstructionSet
implements Runnable,
YoVariableHolder,
RunCommandsExecutor,
AddKeyPointCommandExecutor,
AddCameraKeyCommandExecutor,
CreateNewGraphWindowCommandExecutor,
CreateNewViewportWindowCommandExecutor,
CropBufferCommandExecutor,
CutBufferCommandExecutor,
ExportSnapshotCommandExecutor,
GotoInPointCommandExecutor,
GotoOutPointCommandExecutor,
NextCameraKeyCommandExecutor,
PackBufferCommandExecutor,
PreviousCameraKeyCommandExecutor,
RemoveCameraKeyCommandExecutor,
SetInPointCommandExecutor,
SetOutPointCommandExecutor,
StepBackwardCommandExecutor,
StepForwardCommandExecutor,
ToggleCameraKeyModeCommandExecutor,
KeyPointsHolder,
GUIEnablerAndDisabler,
WriteDataCommandExecutor,
TimeHolder,
ParameterRootNamespaceHolder,
YoBufferReader,
TickAndUpdatable {
    public static final boolean DISABLE_DnD;
    private static final boolean TESTING_LOAD_STUFF = false;
    private static final boolean SHOW_REGISTRY_SIZES_ON_STARTUP = false;
    private static final int MIN_VARIABLES_FOR_HOTSPOT = 75;
    private static final int MIN_CHILDREN_FOR_HOTSPOT = 15;
    public static final String rootRegistryName = "root";
    private static final boolean DEBUG_CLOSE_AND_DISPOSE = false;
    private static double REAL_TIME_RATE;
    private double SECONDS_PER_FRAME = 0.04;
    private long TICKS_PER_PLAY_CYCLE;
    private long PLAY_CYCLE_TIME_MS;
    private double simulateDurationInSeconds = 10000.0;
    private StandardSimulationGUI myGUI;
    private StandardAllCommandsExecutor standardAllCommandsExecutor;
    private VarGroupList varGroupList = new VarGroupList();
    private YoRegistry rootRegistry;
    private JFrame jFrame;
    private JApplet jApplet;
    private boolean hasSimulationThreadStarted = false;
    private boolean isSimulationThreadRunning = false;
    private boolean isSimulating = false;
    private boolean simulateNoFasterThanRealTime = false;
    private final RealTimeRateEnforcer realTimeRateEnforcer = new RealTimeRateEnforcer();
    private boolean isPlaying = false;
    private boolean fastSimulate = false;
    private int numberOfTicksBeforeUpdatingGraphs = 15;
    private int ticksToSimulate = 0;
    private List<PlaybackListener> playbackListeners = null;
    private List<PlayCycleListener> playCycleListeners = null;
    private Simulation mySimulation;
    private Robot[] robots;
    private final SimulationSynchronizer simulationSynchronizer;
    private List<YoGraphicsListRegistry> yoGraphicListRegistries = new ArrayList<YoGraphicsListRegistry>();
    private RewoundListenerHandler rewoundListenerHandler = new RewoundListenerHandler();
    private YoBuffer myDataBuffer;
    private boolean defaultLoaded = false;
    private int lastIndexPlayed = 0;
    private String runningName = ThreadTools.getBaseSimpleClassName();
    private ScsPhysics physics;
    private final SimulationConstructionSetParameters parameters;
    private final YoGraphicMenuManager yoGraphicMenuManager;
    private YoNamespace parameterRootPath = null;
    private File defaultParameterFile = null;
    private YoRegistryChangedListener rootRegistryListener;
    private boolean isCloseAndDispose = false;
    private int fastTicks = 0;
    private boolean stopSimulationThread = false;
    private int ticksSimulated = 0;
    private boolean synchronizeGraphicsAndCamerasWhileSimulating = false;
    private boolean updateGraphsDuringPlayback = true;
    private long nextWakeMillis;
    private boolean systemExitDisabled = false;

    public static SimulationConstructionSet generateSimulationFromDataFile(File chosenFile) {
        LogTools.info((String)"Reading in Robot Configuration");
        RobotDefinitionFixedFrame robotConfig = new RobotDefinitionFixedFrame();
        robotConfig.createRobotDefinitionFromRobotConfigurationFile(chosenFile);
        LogTools.info((String)"Creating a robot from the configuration.");
        Robot robot = new Robot(robotConfig, robotConfig.getRobotName());
        LogTools.info((String)"Creating a Simulation Construction Set.");
        SimulationConstructionSet sim = new SimulationConstructionSet(robot);
        LogTools.info((String)"Reading in the data.");
        if (chosenFile.canRead() && (chosenFile.getName().endsWith(".data") || chosenFile.getName().endsWith(".data.gz") || chosenFile.getName().endsWith(".data.csv"))) {
            sim.readData(chosenFile);
        } else if (chosenFile.canRead() && (chosenFile.getName().endsWith(".state") || chosenFile.getName().endsWith(".state.gz"))) {
            sim.readState(chosenFile);
        }
        return sim;
    }

    public SimulationConstructionSet(Robot robot) {
        this(robot, new SimulationConstructionSetParameters());
    }

    public SimulationConstructionSet(Robot[] robots) {
        this(robots, new SimulationConstructionSetParameters());
    }

    public SimulationConstructionSet() {
        this(new SimulationConstructionSetParameters());
    }

    public SimulationConstructionSet(SimulationConstructionSetParameters parameters) {
        this((Robot)null, parameters);
    }

    public SimulationConstructionSet(Robot robot, SimulationConstructionSetParameters parameters) {
        this(new Robot[]{robot}, parameters);
    }

    public SimulationConstructionSet(Robot[] robotArray, SimulationConstructionSetParameters parameters) {
        this(new Simulation(robotArray, parameters.getDataBufferSize()), SupportedGraphics3DAdapter.instantiateDefaultGraphicsAdapter(parameters.getCreateGUI()), parameters);
    }

    public SimulationConstructionSet(Robot robot, Graphics3DAdapter graphicsAdapter, SimulationConstructionSetParameters parameters) {
        this(new Robot[]{robot}, graphicsAdapter, parameters);
    }

    public SimulationConstructionSet(Robot[] robotArray, Graphics3DAdapter graphicsAdapter, SimulationConstructionSetParameters parameters) {
        this(new Simulation(robotArray, parameters.getDataBufferSize()), graphicsAdapter, parameters);
    }

    public SimulationConstructionSet(Robot[] robotArray, SupportedGraphics3DAdapter supportedGraphicsAdapter, SimulationConstructionSetParameters parameters) {
        this(new Simulation(robotArray, parameters.getDataBufferSize()), supportedGraphicsAdapter.instantiateGraphics3DAdapter(), parameters);
    }

    public SimulationConstructionSet(Simulation simulation, SimulationConstructionSetParameters parameters) {
        this(simulation, SupportedGraphics3DAdapter.instantiateDefaultGraphicsAdapter(parameters.getCreateGUI()), parameters);
    }

    public SimulationConstructionSet(Simulation simulation, Graphics3DAdapter graphicsAdapter, SimulationConstructionSetParameters parameters) {
        this.parameters = parameters;
        this.standardAllCommandsExecutor = new StandardAllCommandsExecutor();
        boolean showGUI = graphicsAdapter != null && parameters.getCreateGUI();
        this.rootRegistry = new YoRegistry(rootRegistryName);
        if (showGUI) {
            EventDispatchThreadHelper.invokeAndWait(() -> this.createFrame(showGUI));
            this.yoGraphicMenuManager = new YoGraphicMenuManager();
        } else {
            this.yoGraphicMenuManager = null;
        }
        this.mySimulation = simulation;
        this.myDataBuffer = this.mySimulation.getDataBuffer();
        this.myDataBuffer.addListener((YoBufferIndexChangedListener)this.rewoundListenerHandler);
        this.simulationSynchronizer = this.mySimulation.getSimulationSynchronizer();
        List originalRootVariables = this.rootRegistry.collectSubtreeVariables();
        for (YoVariable yoVariable : originalRootVariables) {
            LogTools.info((String)("Original Variable: " + yoVariable));
        }
        this.myDataBuffer.addVariables(originalRootVariables);
        this.setupVarGroup("all", new String[0], new String[]{".*"});
        this.recomputeTiming();
        this.robots = this.mySimulation.getRobots();
        if (this.robots != null) {
            for (Robot robot : this.robots) {
                this.rootRegistry.addChild(robot.getRobotsYoRegistry());
            }
        }
        this.createAndAttachAChangedListenerToTheRootRegistry();
        if (showGUI) {
            EventDispatchThreadHelper.invokeAndWait(() -> this.createGUI(graphicsAdapter));
        }
        this.mySimulation.getDataBuffer().fillBuffer();
        this.attachPlaybackListener(new PlaybackListener(){

            public void indexChanged(int newIndex) {
            }

            @Override
            public void stop() {
                if (SimulationConstructionSet.this.myGUI != null && SimulationConstructionSet.this.myGUI.getGraphics3dAdapter() != null) {
                    SimulationConstructionSet.this.myGUI.getGraphics3dAdapter().pause();
                }
            }

            @Override
            public void play(double realTimeRate) {
                if (SimulationConstructionSet.this.myGUI != null && SimulationConstructionSet.this.myGUI.getGraphics3dAdapter() != null) {
                    SimulationConstructionSet.this.myGUI.getGraphics3dAdapter().play();
                }
            }
        });
        if (this.robots != null) {
            for (Robot robot : this.robots) {
                for (YoGraphicsListRegistry yoGraphicsListRegistry : robot.yoGraphicsListRegistries) {
                    this.addYoGraphicsListRegistry(yoGraphicsListRegistry);
                }
            }
        }
        if (this.myGUI != null && this.robots != null) {
            for (Robot robot : this.robots) {
                List<Graphics3DObject> staticLinkGraphics = robot.getStaticLinkGraphics();
                this.myGUI.addStaticLinkGraphics(staticLinkGraphics);
            }
        }
        this.standardAllCommandsExecutor.setup(this, this.myGUI, this.myDataBuffer);
    }

    private void createAndAttachAChangedListenerToTheRootRegistry() {
        this.rootRegistryListener = new YoRegistryChangedListener(){

            public void changed(YoRegistryChangedListener.Change change) {
                if (change.wasVariableAdded()) {
                    SimulationConstructionSet.this.myDataBuffer.addVariable(change.getTargetVariable());
                }
                if (change.wasCleared()) {
                    throw new RuntimeException("Clearing the SCS root Registry after the SCS has been started! Probably shouldn't do that...");
                }
                if (change.wasRegistryAdded()) {
                    SimulationConstructionSet.this.myDataBuffer.addVariables(change.getTargetRegistry().collectSubtreeVariables());
                    if (SimulationConstructionSet.this.myGUI != null) {
                        SimulationConstructionSet.this.myGUI.updateNamespaceHierarchyTree();
                    }
                }
            }
        };
        this.rootRegistry.addListener(this.rootRegistryListener);
    }

    public SimulationConstructionSet(Robot robot, JApplet jApplet, SimulationConstructionSetParameters parameters) {
        this(new Robot[]{robot}, jApplet, parameters);
    }

    public SimulationConstructionSet(Robot[] robots, JApplet jApplet, SimulationConstructionSetParameters parameters) {
        this(robots, parameters);
        this.jFrame = null;
        this.jApplet = jApplet;
        throw new RuntimeException("Not sure if this is all we have to do for jApplet. Problably not. We need to test and debug this constructor...");
    }

    public SimulationConstructionSetParameters getSimulationConstructionSetParameters() {
        return this.parameters;
    }

    public double getDT() {
        return this.mySimulation.getDT();
    }

    public int getCurrentIndex() {
        return this.myDataBuffer.getCurrentIndex();
    }

    public boolean isIndexBetweenBounds(int indexToCheck) {
        return this.myDataBuffer.isIndexBetweenBounds(indexToCheck);
    }

    public void setDT(double simulateDT, int recordFrequency) {
        this.mySimulation.setDT(simulateDT, recordFrequency);
        this.recomputeTiming();
    }

    public Robot[] getRobots() {
        return this.robots;
    }

    public StandardSimulationGUI getStandardSimulationGUI() {
        return this.myGUI;
    }

    public void addScript(Script script) {
        this.mySimulation.addScript(script);
    }

    public void setFrameSize(Dimension dimension) {
        this.jFrame.setSize(dimension);
    }

    public void setFrameLocation(int x, int y) {
        this.jFrame.setLocation(x, y);
    }

    public void setFrameMaximized() {
        this.jFrame.setExtendedState(6);
    }

    public JFrame getJFrame() {
        return this.jFrame;
    }

    public void setFrameAlwaysOnTop(boolean alwaysOnTop) {
        this.jFrame.setAlwaysOnTop(alwaysOnTop);
    }

    public YoRegistry getRootRegistry() {
        return this.rootRegistry;
    }

    public void addYoRegistry(YoRegistry registry) {
        if (registry == null) {
            throw new RuntimeException("Cannot add a null registry to SCS!");
        }
        this.rootRegistry.addChild(registry);
    }

    public List<YoVariable> getVariables() {
        return this.mySimulation.getVariables();
    }

    public YoVariable findVariable(String varname) {
        return this.mySimulation.findVariable(varname);
    }

    public YoVariable findVariable(String namespace, String varname) {
        return this.mySimulation.findVariable(namespace, varname);
    }

    public List<YoVariable> findVariables(String namespace, String varname) {
        return this.mySimulation.findVariables(namespace, varname);
    }

    public List<YoVariable> findVariables(String varname) {
        return this.mySimulation.findVariables(varname);
    }

    public List<YoVariable> findVariables(YoNamespace namespace) {
        return this.mySimulation.findVariables(namespace);
    }

    public boolean hasUniqueVariable(String varname) {
        return this.mySimulation.hasUniqueVariable(varname);
    }

    public boolean hasUniqueVariable(String namespace, String varname) {
        return this.mySimulation.hasUniqueVariable(namespace, varname);
    }

    public void setRecordDT(double recordDT) {
        this.mySimulation.setRecordDT(recordDT);
        this.recomputeTiming();
    }

    public long getRecordFreq() {
        return this.mySimulation.getRecordFreq();
    }

    public double getTimePerRecordTick() {
        double simulationDT = this.getDT();
        long recordFrequency = this.getRecordFreq();
        double timePerRecordTick = (double)recordFrequency * simulationDT;
        return timePerRecordTick;
    }

    @Override
    public void setPlaybackRealTimeRate(double realTimeRate) {
        REAL_TIME_RATE = realTimeRate;
        this.recomputeTiming();
    }

    public void setPlaybackDesiredFrameRate(double frameRate) {
        if (frameRate < 0.002) {
            frameRate = 0.002;
        }
        if (frameRate > 2.0) {
            frameRate = 2.0;
        }
        this.SECONDS_PER_FRAME = frameRate;
        this.recomputeTiming();
    }

    @Override
    public double getPlaybackRealTimeRate() {
        return REAL_TIME_RATE;
    }

    public double getPlaybackFrameRate() {
        return this.SECONDS_PER_FRAME;
    }

    public void recomputeTiming() {
        double dt = this.mySimulation.getDT();
        double recordFreq = this.mySimulation.getRecordFreq();
        this.TICKS_PER_PLAY_CYCLE = Math.max((int)(this.SECONDS_PER_FRAME * REAL_TIME_RATE / (dt * recordFreq)), 1);
        this.SECONDS_PER_FRAME = (double)this.TICKS_PER_PLAY_CYCLE * (dt * recordFreq) / REAL_TIME_RATE;
        this.PLAY_CYCLE_TIME_MS = (long)(1000.0 * this.SECONDS_PER_FRAME);
    }

    public long getTicksPerPlayCycle() {
        return this.TICKS_PER_PLAY_CYCLE;
    }

    public Graphics3DNode addStaticLink(Link staticLink) {
        return this.addStaticLinkGraphics(staticLink.getLinkGraphics());
    }

    public Graphics3DNode addStaticLinkGraphics(Graphics3DObject staticLinkGraphics) {
        if (this.myGUI != null) {
            return this.myGUI.addStaticLinkGraphics(staticLinkGraphics);
        }
        return null;
    }

    public Graphics3DNode addStaticLinkGraphics(Graphics3DObject staticLinkGraphics, Graphics3DNodeType nodeType) {
        if (this.myGUI != null) {
            return this.myGUI.addStaticLinkGraphics(staticLinkGraphics, nodeType);
        }
        return null;
    }

    public void removeGraphics3dNode(Graphics3DNode nodeToRemove) {
        if (this.myGUI != null) {
            this.myGUI.removeStaticGraphics3dNode(nodeToRemove);
        }
    }

    public List<Graphics3DNode> addStaticLinkGraphics(List<Graphics3DObject> staticLinkGraphics) {
        ArrayList<Graphics3DNode> ret = new ArrayList<Graphics3DNode>(staticLinkGraphics.size());
        for (Graphics3DObject linkGraphics : staticLinkGraphics) {
            ret.add(this.addStaticLinkGraphics(linkGraphics));
        }
        return ret;
    }

    public void setCameraTracking(boolean track, boolean trackX, boolean trackY, boolean trackZ) {
        if (this.myGUI != null) {
            this.myGUI.setCameraTracking(track, trackX, trackY, trackZ);
        }
    }

    public void setCameraDolly(boolean dolly, boolean dollyX, boolean dollyY, boolean dollyZ) {
        if (this.myGUI != null) {
            this.myGUI.setCameraDolly(dolly, dollyX, dollyY, dollyZ);
        }
    }

    public void setCameraTrackingVars(String xName, String yName, String zName) {
        if (this.myGUI != null) {
            this.myGUI.setCameraTrackingVars(xName, yName, zName);
        }
    }

    public void setCameraTrackingVars(String namespace, String xName, String yName, String zName) {
        if (this.myGUI != null) {
            this.myGUI.setCameraTrackingVars(namespace, xName, yName, zName);
        }
    }

    public void setCameraDollyVars(String xName, String yName, String zName) {
        if (this.myGUI != null) {
            this.myGUI.setCameraDollyVars(xName, yName, zName);
        }
    }

    public void setCameraDollyVars(String namespace, String xName, String yName, String zName) {
        if (this.myGUI != null) {
            this.myGUI.setCameraDollyVars(namespace, xName, yName, zName);
        }
    }

    public void setCameraTrackingOffsets(double dx, double dy, double dz) {
        if (this.myGUI != null) {
            this.myGUI.setCameraTrackingOffsets(dx, dy, dz);
        }
    }

    public void setCameraDollyOffsets(double dx, double dy, double dz) {
        if (this.myGUI != null) {
            this.myGUI.setCameraDollyOffsets(dx, dy, dz);
        }
    }

    public void setCameraFix(double fixX, double fixY, double fixZ) {
        if (this.myGUI != null) {
            this.myGUI.setCameraFix(fixX, fixY, fixZ);
        }
    }

    public void setCameraFix(Tuple3DBasics cameraFix) {
        if (this.myGUI != null) {
            this.myGUI.setCameraFix(cameraFix);
        }
    }

    public void setCameraPosition(double posX, double posY, double posZ) {
        if (this.myGUI != null) {
            this.myGUI.setCameraPosition(posX, posY, posZ);
        }
    }

    public void setCameraPosition(Tuple3DBasics cameraPosition) {
        if (this.myGUI != null) {
            this.myGUI.setCameraPosition(cameraPosition);
        }
    }

    public void attachExitActionListener(ExitActionListener listener) {
        if (this.myGUI != null) {
            this.myGUI.attachExitActionListener(listener);
        }
    }

    public void notifyExitActionListeners() {
        if (this.myGUI != null) {
            this.myGUI.notifyExitActionListeners();
        }
    }

    public void startOnAThread() {
        ThreadTools.startAThread((Runnable)this, (String)"Simulation Contruction Set");
        while (!this.hasSimulationThreadStarted()) {
            Thread.yield();
        }
    }

    public void closeAndDispose() {
        this.isCloseAndDispose = true;
        if (this.myGUI != null) {
            EventDispatchThreadHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SimulationConstructionSet.this.closeAndDisposeLocal();
                }
            });
        } else {
            this.closeAndDisposeLocal();
        }
    }

    private void closeAndDisposeLocal() {
        this.stop();
        if (this.jFrame != null) {
            this.jFrame.setVisible(false);
            this.jFrame.dispose();
        }
        this.notifyExitActionListeners();
        if (this.rootRegistry != null) {
            this.rootRegistry.removeListener(this.rootRegistryListener);
            this.rootRegistry.clear();
        }
        if (this.standardAllCommandsExecutor != null) {
            this.standardAllCommandsExecutor.closeAndDispose();
        }
        if (this.myGUI != null) {
            this.myGUI.closeAndDispose();
        }
        if (this.mySimulation != null) {
            this.mySimulation.closeAndDispose();
        }
        this.rootRegistry = null;
        this.standardAllCommandsExecutor = null;
        this.myGUI = null;
        this.myDataBuffer = null;
        this.robots = null;
        this.mySimulation = null;
        this.jFrame = null;
        ThreadTools.interruptLiveThreadsExceptThisOneContaining((String)"LWJGL Timer");
    }

    public void addButton(AbstractButton button) {
        if (this.myGUI != null) {
            this.myGUI.addButton(button);
        }
    }

    public void addComboBox(JComboBox<?> comboBox) {
        if (this.myGUI != null) {
            this.myGUI.addComboBox(comboBox);
        }
    }

    public void addJLabel(JLabel label) {
        if (this.myGUI != null) {
            this.myGUI.addJLabel(label);
        }
    }

    public void addTextField(JTextField textField) {
        if (this.myGUI != null) {
            this.myGUI.addTextField(textField);
        }
    }

    public void addRadioButton(JRadioButton button) {
        if (this.myGUI != null) {
            this.myGUI.addRadioButton(button);
        }
    }

    public void addCheckBox(JCheckBox checkBox) {
        if (this.myGUI != null) {
            this.myGUI.addCheckBox(checkBox);
        }
    }

    public void addMenuBar(JMenuBar menuBar) {
        if (this.myGUI != null) {
            this.myGUI.addMenuBar(menuBar);
        }
    }

    public void tickAndUpdate(double timeToSetInSeconds) {
        this.setTime(timeToSetInSeconds);
        this.tickAndUpdate();
    }

    public void tickAndUpdate() {
        this.rewoundListenerHandler.setEnable(false);
        this.mySimulation.tickAndUpdate();
        this.rewoundListenerHandler.setEnable(true);
        if (this.myGUI != null) {
            if (!this.fastSimulate) {
                this.myGUI.updateGraphs();
            } else {
                ++this.fastTicks;
                if (this.fastTicks > this.numberOfTicksBeforeUpdatingGraphs) {
                    this.fastTicks = 0;
                    this.myGUI.updateGraphs();
                }
            }
            this.myGUI.updateSimulationGraphics();
        }
    }

    public void tickAndUpdateLeisurely(int leisureRate) {
        this.rewoundListenerHandler.setEnable(false);
        this.mySimulation.tickAndUpdate();
        this.rewoundListenerHandler.setEnable(true);
        if (this.myGUI != null) {
            this.myGUI.updateGraphsLeisurely(leisureRate);
        }
    }

    public boolean updateAndTick() {
        this.myDataBuffer.writeIntoBuffer();
        boolean indexRolledOver = this.myDataBuffer.tickAndReadFromBuffer(1);
        if (this.myGUI != null) {
            this.myGUI.updateGraphs();
            this.myGUI.updateSimulationGraphics();
        }
        return indexRolledOver;
    }

    public boolean tick() {
        boolean ret = this.myDataBuffer.tickAndReadFromBuffer((int)this.TICKS_PER_PLAY_CYCLE);
        for (Robot robot : this.robots) {
            robot.updateForPlayback();
        }
        if (this.myGUI != null) {
            this.myGUI.updateGraphs();
            this.myGUI.updateSimulationGraphics();
        }
        return ret;
    }

    public boolean unTick() {
        boolean ret = this.myDataBuffer.tickAndReadFromBuffer((int)(-this.TICKS_PER_PLAY_CYCLE));
        for (Robot robot : this.robots) {
            robot.updateForPlayback();
        }
        if (this.myGUI != null) {
            this.myGUI.updateGraphs();
            this.myGUI.updateSimulationGraphics();
        }
        return ret;
    }

    public boolean tickButDoNotNotifySimulationRewoundListeners(int ticks) {
        return this.tick(ticks, false);
    }

    public boolean tickAndReadFromBuffer(int ticks) {
        return this.tick(ticks, true);
    }

    private boolean tick(int ticks, boolean notifySimulationRewoundListeners) {
        boolean ret;
        if (notifySimulationRewoundListeners) {
            ret = this.myDataBuffer.tickAndReadFromBuffer(ticks);
        } else {
            this.rewoundListenerHandler.setEnable(false);
            ret = this.myDataBuffer.tickAndReadFromBuffer(ticks);
            this.rewoundListenerHandler.setEnable(true);
        }
        for (Robot robot : this.robots) {
            robot.updateForPlayback();
        }
        if (this.myGUI != null) {
            this.myGUI.updateGraphs();
            this.myGUI.updateSimulationGraphics();
        }
        return ret;
    }

    public boolean setTick(int tick) {
        boolean ret = this.myDataBuffer.tickAndReadFromBuffer((int)((double)tick * (double)this.TICKS_PER_PLAY_CYCLE));
        for (Robot robot : this.robots) {
            robot.updateForPlayback();
        }
        if (this.myGUI != null) {
            this.myGUI.updateGraphs();
            this.myGUI.updateSimulationGraphics();
        }
        return ret;
    }

    public void setupEntryBox(String varname) {
        if (this.myGUI != null) {
            this.myGUI.setupEntryBox(varname);
        }
    }

    public void setupEntryBox(String[] varnames) {
        if (this.myGUI != null) {
            this.myGUI.setupEntryBox(varnames);
        }
    }

    public void setupGraph(String varname) {
        if (this.myGUI != null) {
            this.myGUI.setupGraph(varname);
        }
    }

    public void setupGraph(String ... varnames) {
        if (this.myGUI != null) {
            this.myGUI.setupGraph(varnames);
        }
    }

    public void setupVarGroup(String name, String[] vars) {
        this.varGroupList.setupVarGroup(name, vars);
        if (this.myGUI != null) {
            this.myGUI.updateVarGroupList(this.varGroupList);
        }
    }

    public void setupVarGroup(String name, String[] vars, String[] regularExpressions) {
        this.varGroupList.setupVarGroup(name, vars, regularExpressions);
        if (this.myGUI != null) {
            this.myGUI.updateVarGroupList(this.varGroupList);
        }
    }

    public void setupGraphGroup(String name, String[][] vars) {
        if (this.myGUI != null) {
            this.myGUI.setupGraphGroup(name, vars);
        }
    }

    public void setupGraphGroup(String name, String[][][] vars) {
        if (this.myGUI != null) {
            this.myGUI.setupGraphGroup(name, vars);
        }
    }

    public void setupGraphGroup(String name, String[][] vars, int numColumns) {
        if (this.myGUI != null) {
            this.myGUI.setupGraphGroup(name, vars, numColumns);
        }
    }

    public void setupGraphGroup(String name, String[][][] vars, int numColumns) {
        if (this.myGUI != null) {
            this.myGUI.setupGraphGroup(name, vars, numColumns);
        }
    }

    public void setupEntryBoxGroup(String name, String[] vars) {
        if (this.myGUI != null) {
            this.myGUI.setupEntryBoxGroup(name, vars);
        }
    }

    public void setupEntryBoxGroup(String name, String[] vars, String[] regularExpressions) {
        if (this.myGUI != null) {
            this.myGUI.setupEntryBoxGroup(name, vars, regularExpressions);
        }
    }

    public void setupConfiguration(String config, String varGroupName, String graphGroupName, String entryBoxGroupName) {
        if (this.myGUI != null && varGroupName != null && graphGroupName != null && entryBoxGroupName != null) {
            this.myGUI.setupConfiguration(config, graphGroupName, entryBoxGroupName);
        }
    }

    private boolean isDefaultFileExist() {
        boolean res;
        File configs = new File("Configurations");
        if (!configs.exists() && !(res = configs.mkdir())) {
            return false;
        }
        String path = configs.toURI().getPath();
        File defaultConfiguration = new File(path + "defaultConfiguration.guiConf");
        return defaultConfiguration.exists();
    }

    public void selectConfiguration(String name) {
        if (this.myGUI != null && !this.isDefaultFileExist()) {
            this.myGUI.selectGraphConfiguration(name);
        }
    }

    public void skipLoadingDefaultConfiguration() {
        this.defaultLoaded = true;
    }

    public void setupCamera(CameraConfiguration cameraConfiguration) {
        if (this.myGUI != null) {
            this.myGUI.setupCamera(cameraConfiguration);
        }
    }

    public void setupExtraPanel(ExtraPanelConfiguration panelConfiguration) {
        if (this.myGUI != null) {
            this.myGUI.setupExtraPanels(panelConfiguration);
        }
    }

    public Component getExtraPanel(String name) {
        return this.myGUI.getExtraPanel(name);
    }

    public void selectCamera(String cameraName) {
        if (this.myGUI != null) {
            this.myGUI.selectCamera(cameraName);
        }
    }

    public void setupViewport(ViewportConfiguration viewportConfiguration) {
        if (this.myGUI != null) {
            this.myGUI.setupViewport(viewportConfiguration);
        }
    }

    public void selectViewport(String viewportName) {
        if (this.myGUI != null) {
            this.myGUI.selectViewport(viewportName);
        }
    }

    public void setupGraphConfigurations(GraphConfiguration[] configurations) {
        if (this.myGUI != null) {
            this.myGUI.setupGraphConfigurations(configurations);
        }
    }

    private void createFrame(boolean showGUI) {
        if (showGUI) {
            try {
                if (this.parameters.getShowSplashScreen()) {
                    StandardSimulationGUI.showSplashScreen();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jFrame = new JFrame("Simulation Construction Set");
        this.jFrame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("Icon-v6.png")).getImage());
        try {
            JDialog dialog = new JDialog(this.jFrame, "", true);
            dialog.pack();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jFrame.repaint();
    }

    public Robot addRobot(RobotDescription robotDescription) {
        RobotFromDescription robot = new RobotFromDescription(robotDescription);
        this.addRobot(robot);
        return robot;
    }

    public void addRobot(Robot robot) {
        YoRegistry robotsYoRegistry = robot.getRobotsYoRegistry();
        YoRegistry parentRegistry = robotsYoRegistry.getParent();
        if (parentRegistry != null) {
            throw new RuntimeException("SimulationConstructionSet.addRobot(). Trying to add robot registry as child to root registry, but it already has a parent registry: " + parentRegistry);
        }
        boolean notifyListeners = false;
        this.rootRegistry.addChild(robotsYoRegistry, notifyListeners);
        this.mySimulation.addRobot(robot);
        this.robots = this.mySimulation.getRobots();
        if (this.myGUI != null) {
            this.myGUI.addRobot(robot);
        }
    }

    public void setRobot(Robot robot) {
        YoRegistry robotsYoRegistry = robot.getRobotsYoRegistry();
        YoRegistry parentRegistry = robotsYoRegistry.getParent();
        if (parentRegistry != null) {
            throw new RuntimeException("SimulationConstructionSet.setRobot(). Trying to add robot registry as child to root registry, but it already has a parent registry: " + parentRegistry);
        }
        boolean notifyListeners = false;
        this.rootRegistry.addChild(robotsYoRegistry, notifyListeners);
        this.mySimulation.setRobots(new Robot[]{robot});
        this.robots = this.mySimulation.getRobots();
        if (this.myGUI != null) {
            this.myGUI.setRobots(this.robots);
        }
    }

    private void createGUI(Graphics3DAdapter graphicsAdapter) {
        GroundContactModel groundContactModel;
        this.myGUI = this.jFrame != null ? new StandardSimulationGUI(graphicsAdapter, this.simulationSynchronizer, (AllCommandsExecutor)this.standardAllCommandsExecutor, null, this, (YoVariableHolder)this, this.robots, this.myDataBuffer, this.varGroupList, this.jFrame, this.rootRegistry) : new StandardSimulationGUI(graphicsAdapter, this.simulationSynchronizer, (AllCommandsExecutor)this.standardAllCommandsExecutor, null, this, (YoVariableHolder)this, this.robots, this.myDataBuffer, this.varGroupList, this.jApplet, this.rootRegistry);
        HeightMap heightMap = null;
        if (this.parameters.getUseAutoGroundGraphics() && this.robots != null && this.robots.length > 0 && (groundContactModel = this.robots[0].getGroundContactModel()) != null) {
            heightMap = HeightMapFromGroundContactModel.getHeightMap(groundContactModel);
        }
        this.myGUI.setup(heightMap);
        if (this.robots != null) {
            this.myGUI.updateRobotsAndCamera();
            this.myGUI.updateSimulationGraphics();
        }
    }

    public void setClipDistances(double near, double far) {
        if (this.myGUI != null) {
            this.myGUI.setClipDistances(near, far);
        }
    }

    public void setFieldOfView(double fieldOfView) {
        if (this.myGUI != null) {
            this.myGUI.setFieldOfView(fieldOfView);
        }
    }

    @Override
    public void disableGUIComponents() {
        if (this.myGUI != null) {
            this.myGUI.disableGUIComponents();
        }
        this.isPlaying = false;
    }

    @Override
    public void enableGUIComponents() {
        if (this.myGUI != null) {
            this.myGUI.enableGUIComponents();
        }
    }

    public void setBackgroundColor(Color color) {
        this.setBackgroundColor(new MutableColor(color));
    }

    public void setBackgroundColor(MutableColor color) {
        if (this.myGUI != null) {
            this.myGUI.setBackgroundColor(color);
        }
    }

    public void setBackgroundImage(URL fileURL, Graphics3DBackgroundScaleMode backgroundScaleMode) {
        this.myGUI.setBackgroundImage(fileURL, backgroundScaleMode);
    }

    public void setBackgroundImage(URL fileURL) {
        this.myGUI.setBackgroundImage(fileURL, Graphics3DBackgroundScaleMode.SCALE_REPEAT);
    }

    public void setGroundAppearance(AppearanceDefinition app) {
        if (this.myGUI != null) {
            this.myGUI.setGroundAppearance(app);
        }
    }

    public void setupSky(String skyBox) {
        if (this.myGUI != null) {
            this.myGUI.setupSky(skyBox);
        }
    }

    public void setupSky(String west, String east, String north, String south, String up, String down) {
        if (this.myGUI != null) {
            this.myGUI.setupSky(west, east, north, south, up, down);
        }
    }

    public void setGroundVisible(boolean isVisible) {
        if (this.myGUI != null) {
            this.myGUI.setGroundVisible(isVisible);
        }
    }

    @Override
    public void run() {
        if (!this.defaultLoaded && this.myGUI != null && this.parameters.getShowWindows()) {
            this.myGUI.loadDefaultGUIConfigurationFile();
            this.defaultLoaded = true;
            this.myGUI.saveNormalGUIConfigurationFile();
        }
        if (this.robots != null) {
            for (Robot robot : this.robots) {
                robot.update();
                try {
                    robot.doDynamicsButDoNotIntegrate();
                }
                catch (UnreasonableAccelerationException unreasonableAccelerationException) {
                    // empty catch block
                }
                robot.updateIMUMountAccelerations();
            }
            if (this.mySimulation != null) {
                this.mySimulation.forceClassLoading();
            }
            if (this.myGUI != null) {
                this.myGUI.updateRobotsAndCamera();
                this.myGUI.updateSimulationGraphics();
            }
        }
        if (this.myGUI != null) {
            StandardSimulationGUI.disposeSplashWindow();
        }
        if (this.myGUI != null) {
            if (this.parameters.getShowWindows()) {
                this.myGUI.show();
            }
            if (!this.parameters.getShowYoGraphicObjects() && this.yoGraphicMenuManager != null) {
                this.yoGraphicMenuManager.hideAllGraphics();
            }
            this.setYoGraphicsGlobalScale(this.parameters.getYoGraphicsGlobalScale());
        }
        this.hasSimulationThreadStarted = true;
        this.isSimulationThreadRunning = true;
        if (this.robots == null) {
            this.isSimulationThreadRunning = false;
            return;
        }
        this.fastTicks = 0;
        do {
            if (this.isSimulating) {
                try {
                    if (this.simulateNoFasterThanRealTime) {
                        this.realTimeRateEnforcer.sleepIfNecessaryToEnforceRealTimeRate(this.getTime());
                    }
                    this.simulateCycle();
                }
                catch (UnreasonableAccelerationException ex) {
                    LogTools.error((String)"Simulation Stopped due to unreasonable acceleration.");
                    LogTools.error((String)"Simulation either went unstable or is too stiff.");
                    LogTools.error((String)"Try reducing gains, ground stiffness and damping, or DT");
                    List<Joint> unreasonableAccelerationJoints = ex.getUnreasonableAccelerationJoints();
                    LogTools.error((String)"Joints with an unreasonable acceleration:");
                    for (Joint joint : unreasonableAccelerationJoints) {
                        LogTools.error((String)("     " + joint.getName()));
                    }
                    this.stop();
                    this.mySimulation.notifySimulateDoneListenersOfException(ex);
                }
                catch (Exception ex) {
                    LogTools.error((String)"Exception while running simulation! Stack trace:");
                    ex.printStackTrace();
                    this.stop();
                    this.mySimulation.notifySimulateDoneListenersOfException(ex);
                }
                catch (AssertionError ae) {
                    LogTools.error((String)"AssertionError while running simulation:");
                    ((Throwable)((Object)ae)).printStackTrace();
                    this.stop();
                    this.mySimulation.notifySimulateDoneListenersOfException((Throwable)((Object)ae));
                }
                continue;
            }
            if (this.isPlaying) {
                this.playCycle();
                continue;
            }
            this.loopCycle();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.stopSimulationThread);
        this.isSimulationThreadRunning = false;
    }

    public void stopSimulationThread() {
        this.stopSimulationThread = true;
        while (this.isSimulationThreadRunning) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setSynchronizeGraphicsAndCamerasWhileSimulating(boolean synchronizeGraphicsAndCamerasWhileSimulating) {
        this.synchronizeGraphicsAndCamerasWhileSimulating = synchronizeGraphicsAndCamerasWhileSimulating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulateCycle() throws UnreasonableAccelerationException {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            long recordFreq = this.mySimulation.getRecordFreq();
            if (this.ticksToSimulate < 0) {
                this.ticksToSimulate = 0;
            }
            long ticksThisCycle = Math.min((long)this.ticksToSimulate, recordFreq - (long)this.ticksSimulated);
            int i = 0;
            while ((long)i < ticksThisCycle) {
                if (this.myGUI != null && this.synchronizeGraphicsAndCamerasWhileSimulating) {
                    Object object = this.myGUI.getGraphicsConch();
                    synchronized (object) {
                        this.mySimulation.simulate();
                        this.myGUI.updateSimulationGraphics();
                    }
                } else {
                    this.mySimulation.simulate();
                }
                ++i;
            }
            this.ticksToSimulate = (int)((long)this.ticksToSimulate - ticksThisCycle);
            this.ticksSimulated = (int)((long)this.ticksSimulated + ticksThisCycle);
            if (this.mySimulation.checkSimulateDoneCriterion()) {
                this.ticksToSimulate = 0;
            }
            if (this.ticksToSimulate <= 0) {
                this.stop();
                this.mySimulation.notifySimulateDoneListeners();
            }
            if ((long)this.ticksSimulated < recordFreq) {
                return;
            }
            this.ticksSimulated = (int)((long)this.ticksSimulated - recordFreq);
            this.rewoundListenerHandler.setEnable(false);
            this.myDataBuffer.tickAndWriteIntoBuffer();
            this.rewoundListenerHandler.setEnable(true);
            if (this.myGUI != null) {
                if (!this.fastSimulate) {
                    this.myGUI.updateGraphs();
                } else {
                    ++this.fastTicks;
                    if (this.fastTicks > this.numberOfTicksBeforeUpdatingGraphs) {
                        this.fastTicks = 0;
                        this.myGUI.updateGraphs();
                    }
                }
                SimulationSynchronizer simulationSynchronizer2 = this.simulationSynchronizer;
                synchronized (simulationSynchronizer2) {
                    this.myGUI.updateSimulationGraphics();
                }
            }
        }
    }

    public void setGraphsUpdatedDuringPlayback(boolean updateGraphsDuringPlayback) {
        this.updateGraphsDuringPlayback = updateGraphsDuringPlayback;
    }

    public boolean areGraphsUpdatedDuringPlayback() {
        return this.updateGraphsDuringPlayback;
    }

    public void setSimulateNoFasterThanRealTime(boolean simulateNoFasterThanRealTime) {
        this.simulateNoFasterThanRealTime = simulateNoFasterThanRealTime;
        this.realTimeRateEnforcer.reset();
    }

    public boolean getSimulateNoFasterThanRealTime() {
        return this.simulateNoFasterThanRealTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playCycle() {
        long currentTime;
        if (this.myGUI == null) {
            return;
        }
        this.lastIndexPlayed = this.myDataBuffer.getCurrentIndex();
        while ((currentTime = System.currentTimeMillis()) < this.nextWakeMillis) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        long numTicks = (currentTime - this.nextWakeMillis) / this.PLAY_CYCLE_TIME_MS + 1L;
        this.nextWakeMillis += this.PLAY_CYCLE_TIME_MS * numTicks;
        Object object = this.myGUI.getGraphicsConch();
        synchronized (object) {
            int tick = Math.max((int)(this.TICKS_PER_PLAY_CYCLE * numTicks), 1);
            this.rewoundListenerHandler.setEnable(false);
            this.myDataBuffer.tickAndReadFromBuffer(tick);
            this.rewoundListenerHandler.setEnable(true);
            this.myGUI.updateRobots();
            this.myGUI.allowTickUpdatesNow();
            if (this.playCycleListeners != null) {
                for (int i = 0; i < this.playCycleListeners.size(); ++i) {
                    this.playCycleListeners.get(i).update(tick);
                }
            }
            this.myGUI.updateSimulationGraphics();
        }
        if (this.updateGraphsDuringPlayback) {
            this.myGUI.updateGraphs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> saveSimulationAsSequenceOfImages(String path, String NameNoExtension, CaptureDevice captureDevice) {
        this.myGUI.updateGraphs();
        try {
            Thread.sleep(125L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Vector<File> output = new Vector<File>();
        this.lastIndexPlayed = 0;
        if (this.myGUI == null) {
            return null;
        }
        this.myDataBuffer.gotoInPoint();
        while (this.lastIndexPlayed < this.myDataBuffer.getOutPoint()) {
            this.lastIndexPlayed = this.myDataBuffer.getCurrentIndex();
            File file = new File(path, NameNoExtension + "_" + this.lastIndexPlayed + ".jpeg");
            this.exportSnapshot(file, captureDevice);
            output.add(file);
            SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
            synchronized (simulationSynchronizer) {
                this.myDataBuffer.tickAndReadFromBuffer(1);
                this.myGUI.updateRobots();
                this.myGUI.updateSimulationGraphics();
                this.myGUI.allowTickUpdatesNow();
            }
            if (!this.updateGraphsDuringPlayback) continue;
            this.myGUI.updateGraphs();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loopCycle() {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            if (this.myGUI != null) {
                boolean tickUpdates = this.myGUI.allowTickUpdatesNow();
                this.myGUI.updateRobots();
                this.myGUI.updateSimulationGraphics();
                if (tickUpdates) {
                    this.myGUI.updateGraphs();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.isPlaying = false;
        this.isSimulating = false;
        this.realTimeRateEnforcer.reset();
        this.ticksToSimulate = 0;
        this.setScrollGraphsEnabled(true);
        if (!this.isCloseAndDispose) {
            SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
            synchronized (simulationSynchronizer) {
                this.doStopGuiCleanup();
            }
        } else {
            this.doStopGuiCleanup();
        }
    }

    private void doStopGuiCleanup() {
        if (this.myGUI != null) {
            this.myGUI.notifySimulationStopped();
            this.myGUI.updateGraphs();
            this.myGUI.updateSimulationGraphics();
            this.myGUI.updateGUI();
        }
        if (this.playbackListeners != null) {
            for (int i = 0; i < this.playbackListeners.size(); ++i) {
                PlaybackListener listener = this.playbackListeners.get(i);
                listener.stop();
            }
        }
        if (this.myDataBuffer != null) {
            this.rewoundListenerHandler.notifyListeners();
        }
    }

    public boolean hasSimulationThreadStarted() {
        return this.hasSimulationThreadStarted;
    }

    public boolean isSimulationThreadRunning() {
        return this.isSimulationThreadRunning;
    }

    @Override
    public boolean isSimulating() {
        return this.isSimulating;
    }

    public List<PlayCycleListener> getPlayCycleListeners() {
        return this.playCycleListeners;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isFastSimulateEnabled() {
        return this.fastSimulate;
    }

    public int getNumberOfTicksBeforeUpdatingGraphs() {
        return this.numberOfTicksBeforeUpdatingGraphs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play() {
        if (this.isSimulating || this.isPlaying) {
            return;
        }
        this.isSimulating = false;
        this.isPlaying = true;
        this.nextWakeMillis = System.currentTimeMillis();
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            if (this.playbackListeners != null) {
                for (int i = 0; i < this.playbackListeners.size(); ++i) {
                    PlaybackListener listener = this.playbackListeners.get(i);
                    listener.play(REAL_TIME_RATE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFastSimulate(boolean fastSimulate) {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            this.fastSimulate = fastSimulate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFastSimulate(boolean fastSimulate, int numberOfTicksBeforeUpdatingGraphs) {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            this.fastSimulate = fastSimulate;
            this.numberOfTicksBeforeUpdatingGraphs = numberOfTicksBeforeUpdatingGraphs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateOneTimeStep() throws UnreasonableAccelerationException {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            this.ticksToSimulate = 1;
            this.simulateCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateOneRecordStep() throws UnreasonableAccelerationException {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            this.ticksToSimulate = (int)this.mySimulation.getRecordFreq();
            this.simulateCycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateOneRecordStepNow() throws UnreasonableAccelerationException {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            long recordFreq = this.mySimulation.getRecordFreq();
            int i = 0;
            while ((long)i < recordFreq) {
                this.mySimulation.simulate();
                ++i;
            }
            this.mySimulation.notifySimulateDoneListeners();
            this.rewoundListenerHandler.setEnable(false);
            this.myDataBuffer.tickAndWriteIntoBuffer();
            this.rewoundListenerHandler.setEnable(true);
            if (this.myGUI != null) {
                this.myGUI.updateGraphs();
                this.myGUI.updateSimulationGraphics();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulate(int numTicks) {
        if (this.isSimulating) {
            SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
            synchronized (simulationSynchronizer) {
                this.ticksToSimulate += numTicks;
            }
        } else {
            this.ticksToSimulate += numTicks;
            this.isPlaying = false;
            this.isSimulating = true;
            this.realTimeRateEnforcer.reset();
        }
    }

    public void simulate(double simulationTime) {
        this.simulate((int)Math.round(simulationTime / this.mySimulation.getDT()));
    }

    @Override
    public void simulate() {
        if (this.isSimulating) {
            return;
        }
        this.simulate(this.simulateDurationInSeconds);
    }

    public void setScrollGraphsEnabled(boolean enable) {
        if (this.myDataBuffer != null) {
            this.myDataBuffer.setLockIndex(!enable);
        }
    }

    public boolean isSafeToScroll() {
        return !this.myDataBuffer.isIndexLocked();
    }

    public void setSimulateDuration(double simulateDurationInSeconds) {
        this.simulateDurationInSeconds = simulateDurationInSeconds;
    }

    public double getSimulateDuration() {
        return this.simulateDurationInSeconds;
    }

    public void doControl() {
        this.mySimulation.doControl();
    }

    public void doDynamicsAndIntegrate() throws UnreasonableAccelerationException {
        this.mySimulation.doDynamicsAndIntegrate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimulateDoneListener(SimulationDoneListener listener) {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            this.mySimulation.addSimulateDoneListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSimulateDoneCriterion(SimulationDoneCriterion criterion) {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            this.mySimulation.setSimulateDoneCriterion(criterion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimulateDoneListener(SimulationDoneListener listener) {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            this.mySimulation.removeSimulateDoneListener(listener);
        }
    }

    @Override
    public void gotoInPoint() {
        this.standardAllCommandsExecutor.gotoInPoint();
    }

    public void gotoInPointNow() {
        if (this.myGUI != null) {
            this.myGUI.gotoInPointNow();
        } else {
            this.myDataBuffer.gotoInPoint();
        }
    }

    @Override
    public void gotoOutPoint() {
        this.standardAllCommandsExecutor.gotoOutPoint();
    }

    public void gotoOutPointNow() {
        if (this.myGUI != null) {
            this.myGUI.gotoOutPointNow();
        } else {
            this.myDataBuffer.gotoOutPoint();
        }
    }

    @Override
    public void setInPoint() {
        this.standardAllCommandsExecutor.setInPoint();
    }

    public void setInOutPointFullBuffer() {
        this.standardAllCommandsExecutor.setInOutPointFullBuffer();
    }

    @Override
    public void addKeyPoint() {
        this.standardAllCommandsExecutor.addKeyPoint();
    }

    public List<Integer> getKeyPoints() {
        return this.standardAllCommandsExecutor.getKeyPoints();
    }

    @Override
    public void addCameraKey() {
        this.standardAllCommandsExecutor.addCameraKey();
    }

    public List<Integer> getCameraKeyPoints() {
        return this.standardAllCommandsExecutor.getCameraKeyPoints();
    }

    @Override
    public void removeCameraKey() {
        this.standardAllCommandsExecutor.removeCameraKey();
    }

    @Override
    public void nextCameraKey() {
        this.standardAllCommandsExecutor.nextCameraKey();
    }

    @Override
    public void previousCameraKey() {
        this.standardAllCommandsExecutor.previousCameraKey();
    }

    @Override
    public void setOutPoint() {
        this.standardAllCommandsExecutor.setOutPoint();
    }

    @Override
    public void stepBackward() {
        this.standardAllCommandsExecutor.stepBackward();
    }

    public void stepBackward(int steps) {
        if (this.myGUI != null) {
            this.myGUI.stepBackward(steps);
        } else {
            this.myDataBuffer.tickAndReadFromBuffer(-steps);
        }
    }

    public void stepBackwardNow() {
        if (this.myGUI != null) {
            this.myGUI.stepForwardNow(-1);
        } else {
            this.myDataBuffer.tickAndReadFromBuffer(-1);
        }
    }

    @Override
    public void stepForward() {
        this.standardAllCommandsExecutor.stepForward();
    }

    public void stepForward(int steps) {
        if (this.myGUI != null) {
            this.myGUI.stepForward(steps);
        } else {
            this.myDataBuffer.tickAndReadFromBuffer(steps);
        }
    }

    public void stepForwardNow(int steps) {
        if (this.myGUI != null) {
            this.myGUI.stepForwardNow(steps);
        } else {
            this.myDataBuffer.tickAndReadFromBuffer(steps);
        }
    }

    @Override
    public void cropBuffer() {
        this.standardAllCommandsExecutor.cropBuffer();
    }

    @Override
    public void cutBuffer() {
        this.standardAllCommandsExecutor.cutBuffer();
    }

    public void thinBuffer(int keepEveryNthPoint) {
        this.standardAllCommandsExecutor.thinBuffer(keepEveryNthPoint);
    }

    @Override
    public void packBuffer() {
        this.standardAllCommandsExecutor.packBuffer();
    }

    public void changeBufferSize(int bufferSize) {
        this.myDataBuffer.resizeBuffer(bufferSize);
        if (this.myGUI != null) {
            this.myGUI.zoomFullView();
        }
    }

    public void setExportDataDirectory(String directory) {
        this.myGUI.setExportDataDirectory(directory);
    }

    public void setImportDataDirectory(String directory) {
        this.myGUI.setImportDataDirectory(directory);
    }

    @Override
    public void exportSnapshot(File snapshotFile) {
        CaptureDevice capturableCanvas = this.myGUI.getActiveCaptureDevice();
        capturableCanvas.exportSnapshot(snapshotFile);
    }

    public void exportSnapshot(File snapshotFile, ViewportWindow viewportSelector) {
        CaptureDevice capturableCanvas = viewportSelector.getActiveCaptureDevice();
        capturableCanvas.exportSnapshot(snapshotFile);
    }

    public void exportSnapshot(File snapshotFile, CaptureDevice captureDevice) {
        captureDevice.exportSnapshot(snapshotFile);
    }

    public BufferedImage exportSnapshotAsBufferedImage() {
        CaptureDevice capturableCanvas = this.myGUI.getActiveCaptureDevice();
        return capturableCanvas.exportSnapshotAsBufferedImage();
    }

    public BufferedImage exportSnapshotAsBufferedImage(CaptureDevice captureDevice) {
        return captureDevice.exportSnapshotAsBufferedImage();
    }

    public void writeData(File chosenFile) {
        boolean binary = true;
        boolean compress = true;
        this.writeData("all", binary, compress, chosenFile);
    }

    public void writeData(String filename) {
        File file = new File(filename);
        this.writeData(file);
    }

    public void writeData(String varGroup, boolean binary, boolean compress, String filename) {
        File file = new File(filename);
        this.writeData(varGroup, binary, compress, file);
    }

    public void writeSpreadsheetFormattedData(String varGroupName, File chosenFile) {
        DataFileWriter dataWriter = new DataFileWriter(chosenFile);
        LogTools.info((String)("Writing Data File " + chosenFile.getAbsolutePath()));
        List<YoVariable> vars = DataBufferTools.getVarsFromGroup(this.myDataBuffer, varGroupName, this.varGroupList);
        dataWriter.writeSpreadsheetFormattedData(this.myDataBuffer, vars);
    }

    public void writeData(String varGroupName, boolean binary, boolean compress, File chosenFile) {
        List<YoVariable> vars = DataBufferTools.getVarsFromGroup(this.myDataBuffer, varGroupName, this.varGroupList);
        this.writeData(vars, binary, compress, chosenFile);
    }

    @Override
    public void writeData(List<YoVariable> vars, boolean binary, boolean compress, File chosenFile) {
        DataFileWriter dataWriter = new DataFileWriter(chosenFile);
        LogTools.info((String)("Writing Data File " + chosenFile.getAbsolutePath()));
        dataWriter.writeData(this.robots[0].getName(), this.mySimulation.getDT() * (double)this.mySimulation.getRecordFreq(), this.myDataBuffer, vars, binary, compress, this.robots[0]);
    }

    public void writeMatlabData(String varGroup, File chosenFile) {
        DataFileWriter dataWriter = new DataFileWriter(chosenFile);
        LogTools.info((String)("Writing Data File " + chosenFile.getAbsolutePath()));
        List<YoVariable> vars = DataBufferTools.getVarsFromGroup(this.myDataBuffer, varGroup, this.varGroupList);
        dataWriter.writeMatlabBinaryData(this.mySimulation.getDT() * (double)this.mySimulation.getRecordFreq(), this.myDataBuffer, vars);
    }

    public File createVideo(String videoFilename) {
        File videoFile = new File(videoFilename);
        this.createVideo(videoFile);
        return videoFile;
    }

    public void createVideo(File videoFile) {
        if (this.myGUI != null) {
            this.myGUI.getViewportPanel().getStandardGUIActions().createVideo(videoFile);
        } else {
            LogTools.error((String)"Can Not Create a Video if the gui wasn't created! myGUI was null");
        }
    }

    public YoBuffer getDataBuffer() {
        return this.myDataBuffer;
    }

    public StandardGUIActions getStandardGUIActions() {
        return this.myGUI.getStandardGUIActions();
    }

    public void setTimeVariableName(String timeVariableName) {
        this.myDataBuffer.setTimeVariableName(timeVariableName);
    }

    public String getTimeVariableName() {
        return this.myDataBuffer.getTimeVariableName();
    }

    public void writeState(File chosenFile) {
        this.writeState("all", false, false, chosenFile);
    }

    public void writeState(String filename) {
        File file = new File(filename);
        this.writeState(file);
    }

    public void writeState(String varGroup, boolean binary, boolean compress, String filename) {
        File file = new File(filename);
        this.writeState(varGroup, binary, compress, file);
    }

    public void writeState(String varGroupName, boolean binary, boolean compress, File chosenFile) {
        DataFileWriter dataWriter = new DataFileWriter(chosenFile);
        LogTools.info((String)("Writing State File " + chosenFile.getName()));
        List<YoVariable> vars = DataBufferTools.getVarsFromGroup(this.myDataBuffer, varGroupName, this.varGroupList);
        dataWriter.writeState(this.robots[0].getName(), this.mySimulation.getDT() * (double)this.mySimulation.getRecordFreq(), vars, binary, compress);
    }

    public void writeSpreadsheetFormattedState(String varGroupName, File chosenFile) {
        DataFileWriter dataWriter = new DataFileWriter(chosenFile);
        LogTools.info((String)("Writing Data File " + chosenFile.getAbsolutePath()));
        List<YoVariable> vars = DataBufferTools.getVarsFromGroup(this.myDataBuffer, varGroupName, this.varGroupList);
        dataWriter.writeSpreadsheetFormattedState(this.myDataBuffer, vars);
    }

    public void readData(String filename) {
        File file = new File(filename);
        this.readData(file);
    }

    public void readData(URL url) {
        DataFileReader dataReader = new DataFileReader(url);
        this.readData(dataReader);
    }

    public void readData(File chosenFile) {
        DataFileReader dataReader = new DataFileReader(chosenFile);
        this.readData(dataReader);
    }

    private void readData(DataFileReader dataReader) {
        YoVariableList newVarList = new YoVariableList("Imported");
        try {
            int npoints = dataReader.readData(newVarList, this.rootRegistry, this.myDataBuffer, this);
            if (npoints > 0) {
                double recordDT = dataReader.getRecordDT();
                this.setRecordDT(recordDT);
                if (this.myGUI != null) {
                    this.myGUI.zoomFullView();
                    this.myGUI.updateGraphs();
                    this.myGUI.updateSimulationGraphics();
                }
            } else {
                EventDispatchThreadHelper.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(SimulationConstructionSet.this.jFrame, "File not valid data file!");
                    }
                });
            }
        }
        catch (IOException exception) {
            JOptionPane.showMessageDialog(this.jFrame, "IOException in read data: " + exception);
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private void addVariablesToGUI(YoVariableList varList) {
        if (!varList.isEmpty() && this.myGUI != null) {
            this.myGUI.addVarList(varList);
        }
    }

    public YoVariableList getCombinedVarList() {
        return this.mySimulation.getCombinedVarList();
    }

    private void addVariablesToSimulationAndGUI(YoVariableList varList) {
        this.addVariablesToGUI(varList);
        this.mySimulation.addVarList(varList);
    }

    public void readState(String filename) {
        this.readState(filename, true);
    }

    public void readState(String filename, boolean printErrorForMissingVariables) {
        File file = new File(filename);
        this.readState(file, printErrorForMissingVariables);
    }

    public void readState(File chosenFile) {
        this.readState(chosenFile, true);
    }

    public void readState(File chosenFile, boolean printErrorForMissingVariables) {
        DataFileReader dataReader = new DataFileReader(chosenFile);
        try {
            dataReader.readState(this.mySimulation.getCombinedVarList(), printErrorForMissingVariables);
            this.myDataBuffer.tickAndWriteIntoBuffer();
            this.myDataBuffer.setInPoint();
            this.myDataBuffer.setOutPoint();
            if (this.myGUI != null) {
                this.myGUI.updateGraphs();
                this.myGUI.updateSimulationGraphics();
            }
        }
        catch (IOException exception) {
            JOptionPane.showMessageDialog(this.jFrame, "IOException in read state: " + exception.getMessage());
        }
    }

    public void maximizeMainWindow() {
        if (this.myGUI != null) {
            this.myGUI.maximizeMainWindow();
        }
    }

    @Override
    public GraphArrayWindow getGraphArrayWindow(String windowName) {
        return this.standardAllCommandsExecutor.getGraphArrayWindow(windowName);
    }

    @Override
    public ViewportWindow getViewportWindow(String windowName) {
        return this.standardAllCommandsExecutor.getViewportWindow(windowName);
    }

    @Override
    public GraphArrayWindow createNewGraphWindow() {
        return this.standardAllCommandsExecutor.createNewGraphWindow();
    }

    @Override
    public GraphArrayWindow createNewGraphWindow(String graphGroupName) {
        return this.standardAllCommandsExecutor.createNewGraphWindow(graphGroupName);
    }

    public GraphArrayWindow createNewGraphWindow(String graphGroupName, int screenID, boolean maximizeWindow) {
        return this.createNewGraphWindow(graphGroupName, screenID, null, null, maximizeWindow);
    }

    @Override
    public GraphArrayWindow createNewGraphWindow(String graphGroupName, int screenID, Point windowLocation, Dimension windowSize, boolean maximizeWindow) {
        return this.standardAllCommandsExecutor.createNewGraphWindow(graphGroupName, screenID, windowLocation, windowSize, maximizeWindow);
    }

    @Override
    public ViewportWindow createNewViewportWindow() {
        return this.standardAllCommandsExecutor.createNewViewportWindow();
    }

    @Override
    public ViewportWindow createNewViewportWindow(String viewportName) {
        return this.standardAllCommandsExecutor.createNewViewportWindow(viewportName);
    }

    @Override
    public ViewportWindow createNewViewportWindow(String viewportName, int screenID, boolean maximizeWindow) {
        return this.standardAllCommandsExecutor.createNewViewportWindow(viewportName, screenID, maximizeWindow);
    }

    public void addVarList(YoVariableList newVarList) {
        this.addVariablesToSimulationAndGUI(newVarList);
    }

    public void addVarLists(YoVariableList[] newVarLists) {
        for (int i = 0; i < newVarLists.length; ++i) {
            this.addVarList(newVarLists[i]);
        }
    }

    public void addVarLists(List<YoVariableList> newVarLists) {
        for (int i = 0; i < newVarLists.size(); ++i) {
            this.addVarList(newVarLists.get(i));
        }
        this.getDataBuffer().fillBuffer();
    }

    public void hideViewport() {
        this.standardAllCommandsExecutor.hideViewport();
    }

    public Boolean isViewportHidden() {
        return this.standardAllCommandsExecutor.isViewportHidden();
    }

    public void showViewport() {
        this.standardAllCommandsExecutor.showViewport();
    }

    public void attachPlaybackListener(PlaybackListener playbackListener) {
        if (this.playbackListeners == null) {
            this.playbackListeners = new ArrayList<PlaybackListener>();
        }
        this.playbackListeners.add(playbackListener);
        this.myDataBuffer.addListener((YoBufferIndexChangedListener)playbackListener);
    }

    public void attachPlayCycleListener(PlayCycleListener playCycleListener) {
        if (this.playCycleListeners == null) {
            this.playCycleListeners = new ArrayList<PlayCycleListener>();
        }
        this.playCycleListeners.add(playCycleListener);
    }

    public void applyDataProcessingFunction(YoBufferProcessor dataProcessingFunction) {
        this.myDataBuffer.applyProcessor(dataProcessingFunction);
    }

    public void attachSelectedListener(SelectedListener selectedListener) {
        if (this.myGUI != null) {
            this.myGUI.attachSelectedListener(selectedListener);
        }
    }

    public void attachSimulationRewoundListener(RewoundListener simulationRewoundListener) {
        this.rewoundListenerHandler.addListener(simulationRewoundListener);
    }

    public boolean areKeyPointsEnabled() {
        return this.standardAllCommandsExecutor.areKeyPointsEnabled();
    }

    public void toggleKeyPoints() {
        this.standardAllCommandsExecutor.toggleKeyPoints();
    }

    public void addListener(KeyPointsChangedListener listener) {
        this.standardAllCommandsExecutor.addListener(listener);
    }

    @Override
    public void toggleCameraKeyMode() {
        this.standardAllCommandsExecutor.toggleCameraKeyMode();
    }

    public void addExtraJpanel(Component extraPanel, String name, boolean showOnStart) {
        this.setupExtraPanel(new ExtraPanelConfiguration(name, extraPanel, showOnStart));
        if (showOnStart) {
            this.getStandardSimulationGUI().selectPanel(name);
        }
    }

    public void exportRobotDefinition(Robot robot, File chosenFile) {
        this.disableGUIComponents();
        try {
            BufferedWriter output = null;
            output = new BufferedWriter(new FileWriter(chosenFile));
            output.write(this.writeRobotConfig(robot));
            ((Writer)output).close();
        }
        catch (Exception e) {
            LogTools.error((String)"Error While Saving Robot Configuration File");
            e.printStackTrace();
        }
        this.enableGUIComponents();
    }

    private String writeRobotConfig(Robot r) {
        Object textToWrite = "";
        RobotDefinitionFixedFrame rd = new RobotDefinitionFixedFrame();
        rd.createRobotDefinitionFromRobot(r);
        textToWrite = (String)textToWrite + rd.toString();
        return textToWrite;
    }

    public static void main(String[] args) {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        int returnVal = fileChooser.showOpenDialog(new JFrame());
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            SimulationConstructionSet scs = SimulationConstructionSet.generateSimulationFromDataFile(file);
            Thread thread = new Thread((Runnable)scs, "SimulationConstructionSet");
            thread.start();
        } else {
            LogTools.error((String)"Open command cancelled by user.");
        }
    }

    public String getRunningName() {
        return this.runningName;
    }

    public void setRunName(String name) {
        this.runningName = name;
    }

    @Override
    public double getTime() {
        return this.robots[0].getTime();
    }

    public void setTime(double time) {
        for (Robot robot : this.robots) {
            robot.setTime(time);
        }
    }

    public VarGroupList getVarGroupList() {
        return this.varGroupList;
    }

    public static String getVersion() {
        return "12.06.22";
    }

    public int getInPoint() {
        return this.myDataBuffer.getInPoint();
    }

    public void setCurrentIndex(int index) {
        this.myDataBuffer.setCurrentIndex(index);
    }

    public void setIndexButDoNotNotifySimulationRewoundListeners(int index) {
        this.rewoundListenerHandler.setEnable(false);
        this.myDataBuffer.setCurrentIndex(index);
        this.rewoundListenerHandler.setEnable(true);
    }

    public int getOutPoint() {
        return this.myDataBuffer.getOutPoint();
    }

    public int getBufferSize() {
        return this.myDataBuffer.getBufferSize();
    }

    public GraphicsDynamicGraphicsObject addYoGraphic(YoGraphic yoGraphicObject) {
        return this.addYoGraphic(yoGraphicObject, true);
    }

    public GraphicsDynamicGraphicsObject addYoGraphic(YoGraphic yoGraphic, boolean updateFromSimulationThread) {
        if (this.myGUI != null) {
            return this.myGUI.addYoGraphic(yoGraphic, updateFromSimulationThread);
        }
        return null;
    }

    public void addYoGraphicsList(YoGraphicsList yoGraphicsList, boolean updateFromSimulationThread) {
        if (this.myGUI != null) {
            this.myGUI.addYoGraphicsList(yoGraphicsList, updateFromSimulationThread);
        }
    }

    public void addYoGraphicsList(YoGraphicsList yoGraphicsList, boolean updateFromSimulationThread, List<GraphicsUpdatable> graphicsUpdatablesToPack) {
        if (this.myGUI != null) {
            this.myGUI.addYoGraphicsList(yoGraphicsList, updateFromSimulationThread, graphicsUpdatablesToPack);
        }
    }

    public void addYoGraphicsListRegistry(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.addYoGraphicsListRegistry(yoGraphicsListRegistry, true);
    }

    public void addYoGraphicsListRegistry(YoGraphicsListRegistry yoGraphicsListRegistry, boolean updateFromSimulationThread) {
        List yoGraphicsLists;
        if (yoGraphicsListRegistry.areYoGraphicsRegistered()) {
            throw new RuntimeException("Already added this YoGraphicsListRegistry To SimulationConstructionSet: " + yoGraphicsListRegistry);
        }
        List graphicsUpdatablesToUpdateInAPlaybackListener = yoGraphicsListRegistry.getGraphicsUpdatablesToUpdateInAPlaybackListener();
        if (graphicsUpdatablesToUpdateInAPlaybackListener != null) {
            GraphicsUpdatablePlaybackListener playbackListener = new GraphicsUpdatablePlaybackListener(graphicsUpdatablesToUpdateInAPlaybackListener);
            this.attachPlaybackListener(playbackListener);
        }
        if (this.myGUI != null) {
            this.myGUI.addYoGraphicsListRegistry(yoGraphicsListRegistry, updateFromSimulationThread);
        }
        if ((yoGraphicsLists = yoGraphicsListRegistry.getYoGraphicsLists()) == null) {
            return;
        }
        if (this.yoGraphicMenuManager != null) {
            this.addCheckBoxesToYoGraphicCheckBoxMenuItem(yoGraphicsLists);
            this.displayYoGraphicMenu();
        }
        this.yoGraphicListRegistries.add(yoGraphicsListRegistry);
    }

    public void setYoGraphicsGlobalScale(double globalScale) {
        this.myGUI.setYoGraphicsGlobalScale(globalScale);
        this.parameters.setYoGraphicsGlobalScale(globalScale);
    }

    public double getGlobalYoGraphicsScale() {
        return this.myGUI.getYoGraphicsGlobalScale();
    }

    private void addCheckBoxesToYoGraphicCheckBoxMenuItem(final List<YoGraphicsList> yoGraphicsLists) {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                for (YoGraphicsList yoGraphicsList : yoGraphicsLists) {
                    if (yoGraphicsList == null) {
                        LogTools.info((String)"graphics list is null");
                        continue;
                    }
                    String label = yoGraphicsList.getLabel();
                    List yoGraphics = yoGraphicsList.getYoGraphics();
                    boolean selectedState = yoGraphicsList.checkAllYoGraphicsAreShowing();
                    YoGraphicCheckBoxMenuItem checkBox = new YoGraphicCheckBoxMenuItem(label, yoGraphics, selectedState);
                    SimulationConstructionSet.this.yoGraphicMenuManager.addCheckBox(checkBox);
                }
            }
        });
    }

    public SimulationOverheadPlotterFactory createSimulationOverheadPlotterFactory() {
        SimulationOverheadPlotterFactory simulationOverheadPlotterFactory = new SimulationOverheadPlotterFactory();
        simulationOverheadPlotterFactory.setSimulationConstructionSet(this);
        return simulationOverheadPlotterFactory;
    }

    public void hideAllYoGraphics() {
        int numberOfElements = this.yoGraphicListRegistries.size();
        for (int i = 0; i < numberOfElements; ++i) {
            YoGraphicsListRegistry yoGraphicsListRegistry = this.yoGraphicListRegistries.get(i);
            yoGraphicsListRegistry.hideYoGraphics();
        }
    }

    public boolean checkAllYoGraphicsListRegistriesAreShowing() {
        boolean ret = true;
        int numberOfElements = this.yoGraphicListRegistries.size();
        for (int i = 0; i < numberOfElements; ++i) {
            YoGraphicsListRegistry yoGraphicsListRegistry = this.yoGraphicListRegistries.get(i);
            ret = ret && yoGraphicsListRegistry.checkAllYoGraphicsListAreShowing();
        }
        return ret;
    }

    public void setYoGraphicsListVisible(String name, boolean visible) {
        ArrayList lists = new ArrayList();
        int numberOfElements = this.yoGraphicListRegistries.size();
        for (int i = 0; i < numberOfElements; ++i) {
            YoGraphicsListRegistry yoGraphicsListRegistry = this.yoGraphicListRegistries.get(i);
            lists.clear();
            yoGraphicsListRegistry.getRegisteredYoGraphicsLists(lists);
            int n = lists.size();
            for (int j = 0; j < n; ++j) {
                YoGraphicsList yoGraphicsList = (YoGraphicsList)lists.get(j);
                if (!yoGraphicsList.getLabel().equals(name)) continue;
                yoGraphicsList.setVisible(visible);
            }
        }
    }

    public void bringToFront() {
        this.jFrame.toFront();
        this.jFrame.repaint();
    }

    public List<YoGraphicsListRegistry> getYoGraphicsListRegistries() {
        return this.yoGraphicListRegistries;
    }

    private void displayYoGraphicMenu() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JMenuBar menuBar = new JMenuBar();
                menuBar.add(SimulationConstructionSet.this.yoGraphicMenuManager.getjMenu());
                SimulationConstructionSet.this.addMenuBar(menuBar);
            }
        });
    }

    public Graphics3DAdapter getGraphics3dAdapter() {
        if (this.myGUI != null) {
            return this.myGUI.getGraphics3dAdapter();
        }
        return null;
    }

    public void startStreamingVideoData(CameraConfiguration cameraConfiguration, int width, int height, ImageCallback imageCallback, TimestampProvider timestampProvider, int framesPerSecond) {
        if (this.myGUI != null) {
            this.myGUI.startStreamingVideoData(cameraConfiguration, width, height, imageCallback, timestampProvider, framesPerSecond);
        }
    }

    public void startStreamingDepthData(CameraConfiguration cameraConfiguration, int width, int height, double nearClip, double farClip, DepthImageCallback imageCallback, TimestampProvider timestampProvider, int framesPerSecond) {
        if (this.myGUI != null) {
            this.myGUI.startStreamingDepthData(cameraConfiguration, width, height, nearClip, farClip, imageCallback, timestampProvider, framesPerSecond);
        }
    }

    public void startStreamingDepthData(CameraConfiguration cameraConfiguration, int width, int height, double nearClip, double farClip, DepthImageCallback imageCallback, int framesPerSecond) {
        if (this.myGUI != null) {
            TimestampProvider timestampProvider = () -> Conversions.secondsToNanoseconds((double)this.getTime());
            this.myGUI.startStreamingDepthData(cameraConfiguration, width, height, nearClip, farClip, imageCallback, timestampProvider, framesPerSecond);
        }
    }

    public void disableSystemExit() {
        this.systemExitDisabled = true;
    }

    public void enableSystemExit() {
        this.systemExitDisabled = false;
    }

    public boolean systemExitDisabled() {
        return this.systemExitDisabled;
    }

    public StandardSimulationGUI getGUI() {
        return this.myGUI;
    }

    public ScsPhysics getPhysics() {
        return this.physics;
    }

    public void initPhysics(ScsPhysics physics) {
        this.physics = physics;
        this.mySimulation.initPhysics(physics);
    }

    public void repaintWindows() {
        if (this.myGUI != null) {
            this.myGUI.repaintWindows();
        }
    }

    public void initializeShapeCollision(CollisionManager collisionManager) {
        collisionManager.setUpCollisionVisualizer(this);
        this.mySimulation.initializeShapeCollision(collisionManager);
    }

    @Override
    public YoNamespace getParameterRootPath() {
        return this.parameterRootPath;
    }

    public void setParameterRootPath(YoRegistry registry) {
        this.parameterRootPath = registry.getNamespace();
    }

    public void setDefaultParameterFile(File parameterFile) {
        this.defaultParameterFile = parameterFile;
    }

    @Override
    public File getDefaultParameterFile() {
        return this.defaultParameterFile;
    }

    public void clearDirectionalLights() {
        if (this.myGUI != null) {
            this.myGUI.clearDirectionalLights();
        }
    }

    public void addDirectionalLight(Color color, Vector3D direction) {
        if (this.myGUI != null) {
            this.myGUI.addDirectionalLight(color, direction);
        }
    }

    public void setAmbientLight(Color color) {
        if (this.myGUI != null) {
            this.myGUI.setAmbientLight(color);
        }
    }

    public void addSpotLight(Graphics3DSpotLight spotLight) {
        if (this.myGUI != null) {
            this.myGUI.addSpotLight(spotLight);
        }
    }

    public void removeSpotLight(Graphics3DSpotLight spotLight) {
        if (this.myGUI != null) {
            this.myGUI.removeSpotLight(spotLight);
        }
    }

    static {
        boolean defaultValue = System.getProperty("os.name").toLowerCase().contains("inux");
        String disableDnDProperty = System.getProperty("scs.disablednd");
        DISABLE_DnD = disableDnDProperty == null || disableDnDProperty.isEmpty() ? defaultValue : Boolean.parseBoolean(disableDnDProperty);
        REAL_TIME_RATE = 1.0;
    }
}

