/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.simulationconstructionset.util.ground.RotatableBoxTerrainObject;

public class RotatableTableTerrainObject
extends RotatableBoxTerrainObject {
    double tableTopThickness = 1.0;

    public RotatableTableTerrainObject(RigidBodyTransform configuration, double lengthX, double widthY, double heightZ, double tableTopThickness) {
        super(configuration, lengthX, widthY, heightZ, YoAppearance.Blue());
        this.tableTopThickness = tableTopThickness;
        this.addGraphics();
    }

    @Override
    protected void addGraphics() {
        RotationMatrixBasics rotation = this.box.getOrientation();
        Point3DBasics center = this.box.getPosition();
        this.linkGraphics = new Graphics3DObject();
        FrameQuaternion orientation = new FrameQuaternion(ReferenceFrame.getWorldFrame(), (Orientation3DReadOnly)rotation);
        this.linkGraphics.identity();
        this.linkGraphics.translate(center.getX(), center.getY(), center.getZ() + this.box.getSizeZ() / 2.0 - this.tableTopThickness / 2.0);
        this.linkGraphics.rotate((Orientation3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation));
        this.linkGraphics.scale((Vector3DReadOnly)new Vector3D(this.box.getSizeX(), this.box.getSizeY(), this.tableTopThickness));
        this.linkGraphics.addModelFile("models/plasticTableTop.obj");
        this.linkGraphics.identity();
        this.linkGraphics.translate(center.getX(), center.getY(), center.getZ() + this.box.getSizeZ() / 2.0 - this.tableTopThickness / 2.0);
        this.linkGraphics.rotate((Orientation3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation));
        this.linkGraphics.scale((Vector3DReadOnly)new Vector3D(this.box.getSizeX(), this.box.getSizeY(), this.box.getSizeZ() - this.tableTopThickness / 2.0));
        this.linkGraphics.addModelFile("models/FoldingTableLegs.obj");
    }
}

