/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.KDTree;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class GroundProfileFromFile
extends GroundProfileFromHeightMap {
    private KDTree kdTree;
    private final BoundingBox3D boundingBox;
    private final double[] query = new double[2];

    public GroundProfileFromFile(String BDITerrainFilePath, int maxPointsInLeaves, RigidBodyTransform transform3D) {
        this(BDITerrainFilePath, maxPointsInLeaves, transform3D, new VariableType[]{VariableType.X, VariableType.Y, VariableType.Z});
    }

    public GroundProfileFromFile(String BDITerrainFilePath, RigidBodyTransform transform3D) {
        this(BDITerrainFilePath, 10, transform3D, new VariableType[]{VariableType.X, VariableType.Y, VariableType.Z});
    }

    public GroundProfileFromFile(String BDITerrainFilePath, int maxPointsInLeaves, RigidBodyTransform transform3D, VariableType[] variableOrder) {
        double[][] rawPoints = GroundProfileFromFile.loadPoints3D(BDITerrainFilePath, transform3D, variableOrder);
        double[][] XYpoints = new double[rawPoints.length][2];
        for (int i = 0; i < rawPoints.length; ++i) {
            XYpoints[i][0] = rawPoints[i][0];
            XYpoints[i][1] = rawPoints[i][1];
        }
        double zMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMin = Double.POSITIVE_INFINITY;
        double zMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < XYpoints.length; ++i) {
            if (XYpoints[i][0] < xMin) {
                xMin = XYpoints[i][0];
            }
            if (XYpoints[i][0] > xMax) {
                xMax = XYpoints[i][0];
            }
            if (XYpoints[i][1] < yMin) {
                yMin = XYpoints[i][1];
            }
            if (XYpoints[i][1] > yMax) {
                yMax = XYpoints[i][1];
            }
            if (rawPoints[i][2] < zMin) {
                zMin = rawPoints[i][2];
            }
            if (!(rawPoints[i][2] > zMax)) continue;
            zMax = rawPoints[i][2];
        }
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
        System.out.println(BDITerrainFilePath + ": (" + xMin + ", " + yMin + ", " + zMin + ") (" + xMax + ", " + yMax + ", " + zMax + ")");
        this.kdTree = new KDTree(XYpoints, (Object[])rawPoints, maxPointsInLeaves);
    }

    public static double[][] loadPoints3D(String filename, RigidBodyTransform transform3D, VariableType[] variableOrder) {
        System.out.println("loading points");
        System.out.flush();
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            System.out.println("Found " + filename);
            System.out.flush();
            double[][] points = GroundProfileFromFile.loadPoints3D(br, transform3D, variableOrder);
            br.close();
            return points;
        }
        catch (IOException e) {
            System.err.println("Could not open " + filename);
            System.err.flush();
            return null;
        }
    }

    public static double[][] loadPoints3D(BufferedReader bufferedReader, RigidBodyTransform transform3D, VariableType[] variableOrder) {
        Point3D point3d = new Point3D();
        double[] values = new double[3];
        try {
            ArrayList<double[]> pointsArrayList = new ArrayList<double[]>();
            boolean moreToRead = true;
            do {
                String lineIn;
                if ((lineIn = bufferedReader.readLine()) == null) {
                    moreToRead = false;
                    continue;
                }
                StringTokenizer s = new StringTokenizer(lineIn);
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                values[0] = Double.parseDouble(s.nextToken()) / 1000.0;
                values[1] = Double.parseDouble(s.nextToken()) / 1000.0;
                values[2] = Double.parseDouble(s.nextToken()) / 1000.0;
                for (int i = 0; i < 3; ++i) {
                    VariableType type = variableOrder[i];
                    if (type == VariableType.X) {
                        x = values[i];
                        continue;
                    }
                    if (type == VariableType.Y) {
                        y = values[i];
                        continue;
                    }
                    if (type != VariableType.Z) continue;
                    z = values[i];
                }
                if (z > 0.005) {
                    point3d.set(x, y, z);
                    transform3D.transform((Point3DBasics)point3d);
                    double[] point = new double[]{point3d.getX(), point3d.getY(), point3d.getZ()};
                    pointsArrayList.add(point);
                }
                if (!s.hasMoreTokens()) continue;
                System.err.println("KDTree::loadPoints3D(): extra scalar encountered on line: " + lineIn);
            } while (moreToRead);
            double[][] points = new double[pointsArrayList.size()][];
            pointsArrayList.toArray((T[])points);
            return points;
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        catch (NumberFormatException ex) {
            System.err.println(ex);
        }
        return null;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        double[] closest;
        block5: {
            block4: {
                if (!this.boundingBox.isXYInsideInclusive(x, y)) {
                    return 0.0;
                }
                this.query[0] = x;
                this.query[1] = y;
                closest = (double[])this.kdTree.closestObject(this.query, 0.02);
                if (closest == null) break block4;
                double[] dArray = new double[]{closest[0], closest[1]};
                if (!(KDTree.distanceSquared(this.query, dArray) > 1.0E-4)) break block5;
            }
            return 0.0;
        }
        return closest[2];
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics vector3d) {
        vector3d.set(0.0, 0.0, 1.0);
    }

    public static void main(String[] args) {
        String datafile = "TerrainFiles/rocks1.asc";
        double xOffset = 0.0;
        double yOffset = 0.0;
        double unitScale = 0.01;
        RigidBodyTransform transform3D = new RigidBodyTransform();
        transform3D.setRotationYawAndZeroTranslation(0.39269908169872414);
        GroundProfileFromFile groundProfile = new GroundProfileFromFile(datafile, 10, transform3D, new VariableType[]{VariableType.X, VariableType.Z, VariableType.Y});
        BoundingBox3D boundingBox = groundProfile.getBoundingBox();
        System.out.println("xMin: " + boundingBox.getMinX() + ", xMax: " + boundingBox.getMaxX());
        System.out.println("yMin: " + boundingBox.getMinY() + ", yMax: " + boundingBox.getMaxY());
        System.out.println("zMin: " + boundingBox.getMinZ() + ", zMax: " + boundingBox.getMaxZ());
        Robot rob = new Robot(""){};
        SimulationConstructionSet scs = new SimulationConstructionSet(rob);
        scs.setGroundVisible(false);
        Graphics3DObject groundLinkGraphics = new Graphics3DObject();
        HeightMapWithNormals heightMap = groundProfile.getHeightMapIfAvailable();
        groundLinkGraphics.addHeightMap((HeightMap)heightMap, 100, 100, YoAppearance.Green());
        scs.addStaticLinkGraphics(groundLinkGraphics);
        Link link = new Link("");
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(1.0);
        link.setLinkGraphics(linkGraphics);
        scs.addStaticLink(link);
        Thread thread = new Thread((Runnable)scs, "SimulationConstructionSet");
        thread.start();
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public static enum VariableType {
        X,
        Y,
        Z;

    }
}

