/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.YoDataInputStream;
import us.ihmc.simulationconstructionset.robotdefinition.RobotDefinitionFixedFrame;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.tools.YoFactories;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class DataFileReader {
    private static final boolean DEBUG = false;
    private boolean columnFormatted;
    private File inFile;
    private URL inURL;
    private int nVars;
    private int nPoints;
    private double recordDT;
    private ArrayList<String> varNames;

    public DataFileReader(File file) {
        this.inFile = file;
        this.inURL = null;
    }

    public DataFileReader(URL url) {
        this.inURL = url;
        this.inFile = null;
    }

    public double getRecordDT() {
        return this.recordDT;
    }

    private boolean parseLine(String line) {
        boolean ret = false;
        StringTokenizer st = new StringTokenizer(line);
        try {
            String nT = st.nextToken();
            if (nT.equals("$END_HEADER")) {
                ret = true;
            } else if (nT.equals("$NVAR")) {
                this.nVars = Integer.parseInt(st.nextToken());
                System.out.println("nVars equals: " + this.nVars);
            } else if (nT.equals("$DT")) {
                this.recordDT = Double.parseDouble(st.nextToken());
                System.out.println("recordDT equals: " + this.recordDT);
            } else if (nT.equals("$N")) {
                this.nPoints = Integer.parseInt(st.nextToken());
                System.out.println("nPoints equals: " + this.nPoints);
            } else if (nT.equals("$COLUMN")) {
                System.out.println("Column Formatted");
                this.columnFormatted = true;
            } else if (nT.equals("$ROW")) {
                System.out.println("Row Formatted");
                this.columnFormatted = false;
            } else if (nT.equals("$VAR")) {
                String vName = st.nextToken();
                this.varNames.add(vName);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println("No Such Element Exception!! " + noSuchElementException);
            throw new RuntimeException("No Such Element " + noSuchElementException);
        }
        return ret;
    }

    public int readData(YoVariableList newVars, YoRegistry rootRegistryToAddNewVariablesTo, YoBuffer dataBuffer) throws IOException {
        return this.readData(newVars, rootRegistryToAddNewVariablesTo, dataBuffer, null);
    }

    public int readData(YoVariableList newVars, YoRegistry rootRegistryToAddNewVariablesTo, YoBuffer dataBuffer, SimulationConstructionSet sim) throws IOException {
        if (this.inFile != null) {
            return this.readDataFile(newVars, rootRegistryToAddNewVariablesTo, dataBuffer, sim);
        }
        if (this.inURL != null) {
            return this.readDataURL(newVars, rootRegistryToAddNewVariablesTo, dataBuffer, sim);
        }
        return -1;
    }

    private int readDataFile(YoVariableList newVars, YoRegistry rootRegistryToAddNewVariablesTo, YoBuffer dataBuffer, SimulationConstructionSet sim) throws IOException {
        YoDataInputStream dataStream = this.inFile.getName().endsWith(".gz") ? new YoDataInputStream(new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.inFile))))) : new YoDataInputStream(new BufferedInputStream(new FileInputStream(this.inFile)));
        if (this.inFile.getName().endsWith(".csv")) {
            return this.readASCIICommaSeparatedData(dataStream, newVars, dataBuffer, rootRegistryToAddNewVariablesTo);
        }
        return this.readData(dataStream, newVars, rootRegistryToAddNewVariablesTo, dataBuffer, sim);
    }

    private int readDataURL(YoVariableList newVars, YoRegistry rootRegistryToAddNewVariablesTo, YoBuffer dataBuffer, SimulationConstructionSet sim) throws IOException {
        YoDataInputStream dataStream = this.inURL.getPath().endsWith(".gz") ? new YoDataInputStream(new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(this.inURL.openStream())))) : new YoDataInputStream(new BufferedInputStream(this.inURL.openStream()));
        if (this.inURL.getPath().endsWith(".csv")) {
            return this.readASCIICommaSeparatedData(dataStream, newVars, dataBuffer, rootRegistryToAddNewVariablesTo);
        }
        return this.readData(dataStream, newVars, rootRegistryToAddNewVariablesTo, dataBuffer, sim);
    }

    public int readData(YoDataInputStream dataStream, YoVariableList newVars, YoRegistry rootRegistryToAddNewVariablesTo, YoBuffer dataBuffer, SimulationConstructionSet sim) throws IOException {
        this.nPoints = -1;
        this.varNames = new ArrayList();
        String line = dataStream.readASCIILine();
        if (!line.startsWith("$BEGIN_HEADER")) {
            return this.readASCIIData(dataStream, newVars, dataBuffer, line, rootRegistryToAddNewVariablesTo);
        }
        boolean doneParsing = false;
        boolean inRobotConfig = false;
        Object robotConfig = "";
        while (!doneParsing && (line = dataStream.readASCIILine()) != null) {
            if (line.startsWith("$<RobotDefinition>")) {
                inRobotConfig = true;
                robotConfig = (String)robotConfig + line.substring(1, line.length()) + "\n";
                continue;
            }
            if (line.startsWith("$</RobotDefinition>")) {
                robotConfig = (String)robotConfig + line + "\n";
                inRobotConfig = false;
                continue;
            }
            if (inRobotConfig) {
                robotConfig = (String)robotConfig + line + "\n";
                continue;
            }
            if (inRobotConfig) continue;
            doneParsing = this.parseLine(line);
        }
        robotConfig = this.replaceAll((String)robotConfig, "\n$", "\n");
        if (sim != null) {
            RobotDefinitionFixedFrame compare = new RobotDefinitionFixedFrame();
            Robot robot = sim.getRobots()[0];
            compare.createRobotDefinitionFromRobot(robot);
            if (!((String)robotConfig).toString().equals(compare.toString())) {
                System.err.println("Warning: The robots do not match.");
            }
        }
        if (this.nPoints != -1) {
            dataBuffer.clearBuffers(this.nPoints);
        } else {
            dataBuffer.clearBuffers(1024);
        }
        if (this.columnFormatted) {
            this.loadColumnFormattedData(dataStream, newVars, rootRegistryToAddNewVariablesTo, dataBuffer);
        } else {
            this.loadRowFormattedData(dataStream, newVars, rootRegistryToAddNewVariablesTo, dataBuffer);
        }
        dataBuffer.setInPoint(0);
        dataBuffer.setOutPoint(this.nPoints - 1);
        dataBuffer.setCurrentIndex(0);
        dataStream.close();
        return this.nPoints;
    }

    private String replaceAll(String orig, String regex, String rep) {
        int index = 0;
        while (index + regex.length() < orig.length()) {
            if (orig.substring(index, index + regex.length()).equals(regex)) {
                orig = this.replace(orig, index, index + regex.length(), rep);
                index += rep.length() - 1;
            }
            ++index;
        }
        return orig;
    }

    private String replace(String fullString, int beginIndex, int endIndex, String replacement) {
        if (beginIndex >= 0 && beginIndex < fullString.length() && endIndex >= 0 && endIndex < fullString.length()) {
            String prefix = fullString.substring(0, beginIndex);
            String suffix = fullString.substring(endIndex);
            return prefix + replacement + suffix;
        }
        return null;
    }

    private void loadColumnFormattedData(YoDataInputStream dataStream, YoVariableList newVars, YoRegistry rootRegistryToAddNewVariablesTo, YoBuffer dataBuffer) throws IOException {
        for (int i = 0; i < this.nVars; ++i) {
            YoBufferVariableEntry newEntry = this.getDataBufferEntry(this.varNames.get(i), dataBuffer, rootRegistryToAddNewVariablesTo, newVars);
            for (int j = 0; j < this.nPoints; ++j) {
                newEntry.writeBufferAt((double)dataStream.readFloat(), j);
            }
        }
    }

    private YoBufferVariableEntry getDataBufferEntry(String varName, YoBuffer dataBuffer, YoRegistry rootRegistryToAddNewVariablesTo, YoVariableList newVars) throws IOException {
        YoBufferVariableEntry newEntry;
        YoVariable newVariable = dataBuffer.findVariable(varName);
        if (newVariable == null) {
            YoNamespace namespace = new YoNamespace(varName).getParent();
            String variableName = new YoNamespace(varName).getShortName();
            YoRegistry registry = YoFactories.findOrCreateRegistry((YoRegistry)rootRegistryToAddNewVariablesTo, (YoNamespace)namespace);
            newVariable = new YoDouble(variableName, "Created Variable in DataFileReader", registry);
            newVars.add(newVariable);
        }
        if ((newEntry = dataBuffer.getEntry(newVariable)) == null) {
            newEntry = dataBuffer.addVariable(newVariable);
        }
        return newEntry;
    }

    private void loadRowFormattedData(YoDataInputStream dataStream, YoVariableList newVars, YoRegistry rootRegistryToAddNewVariablesTo, YoBuffer dataBuffer) throws IOException {
        block6: {
            YoBufferVariableEntry[] entries = new YoBufferVariableEntry[this.nVars];
            for (int i = 0; i < this.nVars; ++i) {
                entries[i] = this.getDataBufferEntry(this.varNames.get(i), dataBuffer, rootRegistryToAddNewVariablesTo, newVars);
            }
            int j = 0;
            try {
                int numberOfPointsToIterateOver = this.nPoints != -1 ? this.nPoints : Integer.MAX_VALUE;
                for (j = 0; j < numberOfPointsToIterateOver; ++j) {
                    if (dataBuffer.getBufferSize() <= j) {
                        int newBufferSize = Math.min(j, 0x3FFFFFFF);
                        dataBuffer.resizeBuffer(newBufferSize *= 2);
                    }
                    for (int i = 0; i < this.nVars; ++i) {
                        double someData = dataStream.readFloat();
                        YoBufferVariableEntry entry = entries[i];
                        entry.writeBufferAt(someData, j);
                    }
                }
            }
            catch (IOException iOException) {
                if (this.nPoints != -1) break block6;
                this.nPoints = j;
            }
        }
    }

    private int readASCIIData(YoDataInputStream dataStream, YoVariableList newVars, YoBuffer dataBuffer, String line, YoRegistry rootRegistryToAddNewVariablesTo) throws IOException {
        this.nPoints = -1;
        this.varNames = new ArrayList();
        while (line != null) {
            StringTokenizer token = new StringTokenizer(line);
            String varName = token.nextToken();
            String equals = token.nextToken();
            if (!equals.equals("=")) {
                return -1;
            }
            if (varName.equals("DT")) {
                String valString = token.nextToken();
                if (!valString.endsWith(";")) {
                    return -1;
                }
                valString = valString.substring(0, valString.indexOf(";"));
                this.recordDT = Double.parseDouble(valString);
            } else {
                if (this.nPoints == -1) {
                    this.nPoints = token.countTokens() - 1;
                    dataBuffer.clearBuffers(this.nPoints);
                }
                YoBufferVariableEntry newEntry = this.getDataBufferEntry(varName, dataBuffer, rootRegistryToAddNewVariablesTo, newVars);
                String valString = token.nextToken();
                if (!valString.startsWith("[")) {
                    return -1;
                }
                int point = 0;
                valString = valString.substring(1);
                while (!valString.startsWith("];")) {
                    double value = Double.parseDouble(valString);
                    newEntry.writeBufferAt(value, point);
                    ++point;
                    if (!token.hasMoreTokens()) {
                        return -1;
                    }
                    valString = token.nextToken();
                }
                if (this.nPoints != point) {
                    return -1;
                }
            }
            line = dataStream.readASCIILine();
        }
        dataStream.close();
        System.out.println("nPoints = " + this.nPoints);
        System.out.println("recordDT equals: " + this.recordDT);
        dataBuffer.setInPoint(0);
        dataBuffer.setOutPoint(this.nPoints - 1);
        dataBuffer.setCurrentIndex(0);
        return this.nPoints;
    }

    private int readASCIICommaSeparatedData(YoDataInputStream dataStream, YoVariableList newVars, YoBuffer dataBuffer, YoRegistry rootRegistryToAddNewVariablesTo) throws IOException {
        this.nPoints = -1;
        this.varNames = new ArrayList();
        ArrayList<double[]> dataArrays = new ArrayList<double[]>();
        String line = dataStream.readASCIILine();
        StringTokenizer token = new StringTokenizer(line, ", ");
        while (token.hasMoreTokens()) {
            String varName = token.nextToken();
            if (varName.equals("DT")) continue;
            this.varNames.add(varName);
        }
        line = dataStream.readASCIILine();
        token = new StringTokenizer(line, ", ");
        String DTString = token.nextToken();
        this.recordDT = Double.parseDouble(DTString);
        boolean skipFirstOne = true;
        while (line != null) {
            double[] dataForThisTick = new double[this.varNames.size()];
            int point = 0;
            token = new StringTokenizer(line, ", ");
            if (skipFirstOne) {
                System.out.println(token.nextToken());
                skipFirstOne = false;
            }
            while (token.hasMoreTokens()) {
                double value;
                String valString = token.nextToken();
                dataForThisTick[point] = value = Double.parseDouble(valString);
                ++point;
            }
            dataArrays.add(dataForThisTick);
            line = dataStream.readASCIILine();
        }
        this.nPoints = dataArrays.size();
        dataBuffer.clearBuffers(this.nPoints);
        for (int i = 0; i < this.varNames.size(); ++i) {
            String varName = this.varNames.get(i);
            YoBufferVariableEntry newEntry = this.getDataBufferEntry(varName, dataBuffer, rootRegistryToAddNewVariablesTo, newVars);
            for (int j = 0; j < this.nPoints; ++j) {
                newEntry.writeBufferAt(((double[])dataArrays.get(j))[i], j);
            }
        }
        dataStream.close();
        System.out.println("nPoints = " + this.nPoints);
        System.out.println("recordDT equals: " + this.recordDT);
        dataBuffer.setInPoint(0);
        dataBuffer.setOutPoint(this.nPoints - 1);
        dataBuffer.setCurrentIndex(0);
        return this.nPoints;
    }

    public void readState(YoVariableList varList, boolean printErrorForMissingVariables) throws IOException {
        this.readState(varList, false, printErrorForMissingVariables, null);
    }

    public void readState(YoVariableList varList, boolean createMissingVariables, boolean printErrorForMissingVariables, YoRegistry registry) throws IOException {
        String line;
        BufferedReader in = this.inFile.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.inFile)))))) : new BufferedReader(new InputStreamReader(new FileInputStream(this.inFile)));
        while ((line = in.readLine()) != null) {
            YoVariable variable;
            boolean variableNotFound;
            int equalsIndex = DataFileReader.getEqualsIndex(line);
            int semiIndex = this.semiColonIndex(line);
            String varName = line.substring(0, equalsIndex).trim();
            String varVal = line.substring(equalsIndex + 1, semiIndex).trim();
            YoNamespace namespace = new YoNamespace(varName).getParent();
            if (namespace != null && registry != null) {
                varName = new YoNamespace(varName).getShortName();
                if (!namespace.startsWith(registry.getNamespace())) {
                    namespace.prepend(registry.getNamespace());
                }
            }
            boolean bl = variableNotFound = (variable = varList.findVariable(varName)) == null;
            if (variableNotFound) {
                if (createMissingVariables) {
                    if (namespace != null) {
                        YoRegistry registryToUse = YoFactories.findOrCreateRegistry((YoRegistry)registry, (YoNamespace)namespace);
                        if (registryToUse == null) {
                            if (printErrorForMissingVariables) {
                                System.err.println("Warning! Couldn't find an appropriate registry to use. Will just use " + registry);
                            }
                            registryToUse = registry;
                        }
                        variable = new YoDouble(varName, registryToUse);
                    } else {
                        variable = new YoDouble(varName, registry);
                    }
                    varList.add(variable);
                } else {
                    if (!printErrorForMissingVariables) continue;
                    System.err.println("Couldn't find variable " + varName + " in line:  " + line);
                    continue;
                }
            }
            variable.setValueFromDouble(Double.valueOf(varVal).doubleValue());
        }
        in.close();
    }

    private int semiColonIndex(String line) {
        int semiIndex = line.indexOf(";");
        if (semiIndex < 0) {
            throw new RuntimeException("State File Fomat Error.  No ; in line:  " + line);
        }
        return semiIndex;
    }

    private static int getEqualsIndex(String line) {
        int equalsIndex = line.indexOf("=");
        if (equalsIndex < 0) {
            throw new RuntimeException("State File Fomat Error.  No = in line:  " + line);
        }
        return equalsIndex;
    }
}

