/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.yoVariableSearch;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariablesHolder;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayTabbedPanel;
import us.ihmc.simulationconstructionset.gui.ForcedRepaintPopupMenu;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.YoSliderpanel;
import us.ihmc.simulationconstructionset.gui.YoVariableExplorerTabbedPane;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanel;

public class YoVariablePanelJPopupMenu
extends ForcedRepaintPopupMenu {
    private static final long serialVersionUID = -1080363015468056576L;
    private final GraphArrayPanel graphArrayPanel;
    private final EntryBoxArrayTabbedPanel entryBoxArrayPanel;
    private final SelectedVariableHolder selectedVariableHolder;
    private final YoVariableExplorerTabbedPane combinedVarPanel;
    private final BookmarkedVariablesHolder bookmarkedVariablesHolder;
    private JMenuItem bookmarkVariable;
    private JMenuItem addToSliderBoard;

    public YoVariablePanelJPopupMenu(SelectedVariableHolder selectedVariableHolder) {
        this.selectedVariableHolder = selectedVariableHolder;
        this.graphArrayPanel = null;
        this.entryBoxArrayPanel = null;
        this.combinedVarPanel = null;
        this.bookmarkedVariablesHolder = null;
    }

    public YoVariablePanelJPopupMenu(GraphArrayPanel graphArrayPanel, EntryBoxArrayTabbedPanel entryBoxArrayPanel, SelectedVariableHolder selectedVariableHolder, YoVariableExplorerTabbedPane combinedVarPanel, BookmarkedVariablesHolder bookmarkedVariablesHolder) {
        this.graphArrayPanel = graphArrayPanel;
        this.entryBoxArrayPanel = entryBoxArrayPanel;
        this.selectedVariableHolder = selectedVariableHolder;
        this.combinedVarPanel = combinedVarPanel;
        this.bookmarkedVariablesHolder = bookmarkedVariablesHolder;
        this.initialize();
    }

    private void initialize() {
        JMenuItem addToNewGraph = new JMenuItem("Add Variable to New Graph");
        addToNewGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YoVariablePanelJPopupMenu.this.graphArrayPanel != null) {
                    YoVariablePanelJPopupMenu.this.graphArrayPanel.addSelectedVariableGraph();
                } else {
                    System.err.println("Warning: Could not add variable to a new graph because graphArrayPanel was null.");
                }
                YoVariablePanelJPopupMenu.this.setVisible(false);
            }
        });
        this.add(addToNewGraph);
        JMenuItem addToNewEntryBox = new JMenuItem("Add Variable to new Entry Box");
        addToNewEntryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YoVariablePanelJPopupMenu.this.entryBoxArrayPanel != null) {
                    if (YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable() != null) {
                        YoVariablePanelJPopupMenu.this.entryBoxArrayPanel.addEntryBox(YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable());
                        YoVariablePanelJPopupMenu.this.entryBoxArrayPanel.updateUI();
                    }
                } else {
                    System.err.println("Warning: Could not add variable to a new entry box because entryBoxArrayPanel was null.");
                }
                YoVariablePanelJPopupMenu.this.setVisible(false);
            }
        });
        this.add(addToNewEntryBox);
        JMenuItem copyToClipBoard = new JMenuItem("Copy Name to Clipboard");
        copyToClipBoard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable() != null) {
                    StringSelection stringSelection = new StringSelection(YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable().getName());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
                YoVariablePanelJPopupMenu.this.setVisible(false);
            }
        });
        this.add(copyToClipBoard);
        JMenuItem copyFullNameToClipBoard = new JMenuItem("Copy Full Name to Clipboard");
        copyFullNameToClipBoard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable() != null) {
                    StringSelection stringSelection = new StringSelection(YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable().getFullNameString());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
                YoVariablePanelJPopupMenu.this.setVisible(false);
            }
        });
        this.add(copyFullNameToClipBoard);
        JMenuItem showNamespace = new JMenuItem("Open Namespace");
        showNamespace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YoVariablePanelJPopupMenu.this.combinedVarPanel != null) {
                    YoVariablePanelJPopupMenu.this.combinedVarPanel.setVisibleVarPanel(YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable().getRegistry());
                }
                YoVariablePanelJPopupMenu.this.setVisible(false);
            }
        });
        this.add(showNamespace);
        JMenuItem displayNamespaces = new JMenuItem("Display Namespaces");
        displayNamespaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YoVariablePanelJPopupMenu.this.combinedVarPanel != null) {
                    YoVariablePanel.addNamespaceToVarNames();
                }
                YoVariablePanelJPopupMenu.this.setVisible(false);
            }
        });
        this.add(displayNamespaces);
        this.bookmarkVariable = new JMenuItem("Bookmark Variable");
        this.bookmarkVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YoVariablePanelJPopupMenu.this.bookmarkedVariablesHolder != null) {
                    if (YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable() != null) {
                        YoVariablePanelJPopupMenu.this.bookmarkedVariablesHolder.addBookmark(YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable());
                    }
                } else {
                    System.err.println("Warning: Could not bookmark variable because bookmarkedVariablesHolder is null.");
                }
                YoVariablePanelJPopupMenu.this.setVisible(false);
            }
        });
        this.add(this.bookmarkVariable);
        this.addToSliderBoard = new JMenuItem("addToSliderBoard");
        this.addToSliderBoard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable() != null) {
                    JFrame tmp = new JFrame();
                    tmp.getContentPane().add(new YoSliderpanel(YoVariablePanelJPopupMenu.this.selectedVariableHolder.getSelectedVariable()));
                    tmp.setVisible(true);
                }
                YoVariablePanelJPopupMenu.this.setVisible(false);
            }
        });
        this.add(this.addToSliderBoard);
    }

    public void removeBookmarkVariable() {
        if (this.bookmarkVariable != null) {
            this.remove(this.bookmarkVariable);
        }
    }
}

