/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;

public class BoxShapeDescription<T extends BoxShapeDescription<T>>
implements CollisionShapeDescription<T> {
    private double halfLengthX;
    private double halfWidthY;
    private double halfHeightZ;
    private final RigidBodyTransform transform = new RigidBodyTransform();
    private final BoundingBox3D boundingBox = new BoundingBox3D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private boolean boundingBoxNeedsUpdating = true;

    public BoxShapeDescription(double halfLengthX, double halfWidthY, double halfHeightZ) {
        this.halfLengthX = halfLengthX;
        this.halfWidthY = halfWidthY;
        this.halfHeightZ = halfHeightZ;
        this.boundingBoxNeedsUpdating = true;
    }

    @Override
    public BoxShapeDescription<T> copy() {
        BoxShapeDescription<T> copy = new BoxShapeDescription<T>(this.halfLengthX, this.halfWidthY, this.halfHeightZ);
        copy.transform.set(this.transform);
        copy.boundingBox.set(this.boundingBox);
        return copy;
    }

    public double getHalfLengthX() {
        return this.halfLengthX;
    }

    public double getHalfWidthY() {
        return this.halfWidthY;
    }

    public double getHalfHeightZ() {
        return this.halfHeightZ;
    }

    public void getTransform(RigidBodyTransform transformToPack) {
        transformToPack.set(this.transform);
    }

    @Override
    public void applyTransform(RigidBodyTransform transformToWorld) {
        this.transform.preMultiply((RigidBodyTransformReadOnly)transformToWorld);
        this.boundingBoxNeedsUpdating = true;
    }

    @Override
    public void setFrom(T box) {
        this.halfLengthX = ((BoxShapeDescription)box).getHalfLengthX();
        this.halfWidthY = ((BoxShapeDescription)box).getHalfWidthY();
        this.halfHeightZ = ((BoxShapeDescription)box).getHalfHeightZ();
        ((BoxShapeDescription)box).getTransform(this.transform);
        this.boundingBoxNeedsUpdating = true;
    }

    @Override
    public void getBoundingBox(BoundingBox3D boundingBoxToPack) {
        if (this.boundingBoxNeedsUpdating) {
            this.updateBoundingBox();
            this.boundingBoxNeedsUpdating = false;
        }
        boundingBoxToPack.set(this.boundingBox);
    }

    private void updateBoundingBox() {
        throw new RuntimeException("Implement Me!");
    }

    @Override
    public boolean isPointInside(Point3D pointInWorld) {
        throw new RuntimeException("Implement Me!");
    }

    @Override
    public boolean rollContactIfRolling(Vector3D surfaceNormal, Point3D pointToRoll) {
        return false;
    }
}

