/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.simulationconstructionset.ContactingExternalForcePoint;
import us.ihmc.simulationconstructionset.ContactingExternalForcePointsVisualizer;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.CollisionHandler;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;
import us.ihmc.simulationconstructionset.physics.CollisionShapeWithLink;
import us.ihmc.simulationconstructionset.physics.Contacts;
import us.ihmc.simulationconstructionset.physics.collision.CollisionDetectionResult;
import us.ihmc.simulationconstructionset.physics.collision.CollisionHandlerListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class HybridImpulseSpringDamperCollisionHandler
implements CollisionHandler {
    private boolean visualize = true;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final BagOfBalls externalForcePointBalls;
    private final BagOfBalls newCollisionBalls;
    private final ContactingExternalForcePointsVisualizer contactingExternalForcePointsVisualizer;
    private final YoDouble coefficientOfFriction = new YoDouble("coefficientOfFriction", this.registry);
    private final YoDouble rotationalCoefficientOfFrictionBeta = new YoDouble("rotationalCoefficientOfFrictionBeta", this.registry);
    private final YoDouble coefficientOfRestitution = new YoDouble("coefficientOfRestitution", this.registry);
    private final YoDouble kpCollision = new YoDouble("kpCollision", this.registry);
    private final YoDouble kdCollision = new YoDouble("kdCollision", this.registry);
    private final YoDouble kdRotationalDamping = new YoDouble("kdRotationalDamping", this.registry);
    private final YoDouble pullingOutSpringHysteresisReduction = new YoDouble("pullingOutSpringHysteresisReduction", this.registry);
    private double velocityForMicrocollision = 0.05;
    private int numberOfCyclesPerContactPair = 1;
    private double minDistanceToConsiderDifferent = 0.003;
    private double percentMoveTowardTouchdownWhenSamePoint = 0.2;
    private static final boolean DEBUG = false;
    private static final boolean useAverageNewCollisionTouchdownPoints = true;
    private double maximumPenetrationToStart = 0.002;
    private static final boolean divideByNumberContacting = false;
    private static final boolean resolveCollisionWithAnImpact = false;
    private static final boolean allowMicroCollisions = false;
    private static final boolean performSpringDamper = true;
    private static final boolean createNewContactPairs = true;
    private static final boolean slipTowardEachOtherIfSlipping = false;
    private static final boolean allowRecyclingOfPointsInUse = true;
    private static boolean useShuffleContactingPairs = false;
    private final Random random;
    private final Vector3D normal = new Vector3D();
    private final Vector3D negative_normal = new Vector3D();
    private final Point3D point1 = new Point3D();
    private final Point3D point2 = new Point3D();
    private final Point3D tempPoint = new Point3D();
    private final Vector3D tempVectorForAveraging = new Vector3D();
    private List<CollisionHandlerListener> listeners = new ArrayList<CollisionHandlerListener>();
    private final YoInteger numberOfContacts = new YoInteger("numberOfContacts", this.registry);
    private final Point3D positionOne = new Point3D();
    private final Point3D positionTwo = new Point3D();
    private final Vector3D slipVector = new Vector3D();
    private final Vector3D tempNormal = new Vector3D();
    private final ArrayList<Contacts> shapesInContactList = new ArrayList();
    private final ArrayList<Integer> indices = new ArrayList();
    private final Vector3D normalComponent = new Vector3D();
    private final Point3D tempPositionForRollingOne = new Point3D();
    private final Vector3D tempSurfaceNormalForRolllingOne = new Vector3D();
    private final Point3D tempPositionForRollingTwo = new Point3D();
    private final Vector3D tempSurfaceNormalForRolllingTwo = new Vector3D();
    private final Vector3D tempVectorForRolling = new Vector3D();
    private final ArrayList<ContactingExternalForcePoint> pointsToRemove = new ArrayList();
    private final Point3D positionOneToConsider = new Point3D();
    private final Point3D positionTwoToConsider = new Point3D();
    private final Vector3D tempVector = new Vector3D();
    private final Vector3D tempForceVector = new Vector3D();
    private final ArrayList<ContactingExternalForcePoint> allContactingExternalForcePoints = new ArrayList();
    private final ArrayList<String> linkNamesOfForcePoints = new ArrayList();

    public HybridImpulseSpringDamperCollisionHandler(double epsilon, double mu, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(new Random(), epsilon, mu, parentRegistry, yoGraphicsListRegistry);
    }

    public HybridImpulseSpringDamperCollisionHandler(Random random, double epsilon, double mu, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.random = random;
        this.coefficientOfRestitution.set(epsilon);
        this.coefficientOfFriction.set(mu);
        this.rotationalCoefficientOfFrictionBeta.set(0.01);
        this.kpCollision.set(20000.0);
        this.kdCollision.set(5000.0);
        this.kdRotationalDamping.set(0.05);
        this.pullingOutSpringHysteresisReduction.set(0.8);
        if (yoGraphicsListRegistry == null) {
            this.visualize = false;
        }
        if (this.visualize) {
            this.externalForcePointBalls = BagOfBalls.createPatrioticBag((int)500, (double)8.0E-4, (String)"contactBalls", (YoRegistry)parentRegistry, (YoGraphicsListRegistry)yoGraphicsListRegistry);
            this.newCollisionBalls = new BagOfBalls(500, 0.001, "newCollisionBalls", YoAppearance.Black(), parentRegistry, yoGraphicsListRegistry);
            int maxNumberOfYoGraphicPositions = 500;
            this.contactingExternalForcePointsVisualizer = new ContactingExternalForcePointsVisualizer(maxNumberOfYoGraphicPositions, yoGraphicsListRegistry, parentRegistry);
            this.contactingExternalForcePointsVisualizer.setForceVectorScale(0.25);
        } else {
            this.externalForcePointBalls = null;
            this.newCollisionBalls = null;
            this.contactingExternalForcePointsVisualizer = null;
        }
        parentRegistry.addChild(this.registry);
    }

    public void setKp(double value) {
        this.kpCollision.set(value);
    }

    public void setKd(double value) {
        this.kdCollision.set(value);
    }

    @Override
    public void maintenanceBeforeCollisionDetection() {
        this.shapesInContactList.clear();
    }

    @Override
    public void maintenanceAfterCollisionDetection() {
        ContactingExternalForcePoint contactingExternalForcePointOne;
        int index;
        int numberOfCollisions = this.shapesInContactList.size();
        this.numberOfContacts.set(numberOfCollisions);
        if (useShuffleContactingPairs) {
            Collections.shuffle(this.shapesInContactList, this.random);
        }
        if (this.visualize) {
            this.newCollisionBalls.reset();
            this.externalForcePointBalls.reset();
        }
        for (int i = 0; i < numberOfCollisions; ++i) {
            Contacts shapesInContact = this.shapesInContactList.get(i);
            CollisionShapeWithLink shape1 = (CollisionShapeWithLink)shapesInContact.getShapeA();
            CollisionShapeWithLink shape2 = (CollisionShapeWithLink)shapesInContact.getShapeB();
            this.handleLocal(shape1, shape2, shapesInContact);
            if (!this.visualize) continue;
            int numberOfContacts = shapesInContact.getNumberOfContacts();
            for (int j = 0; j < numberOfContacts; ++j) {
                Point3D locationA = new Point3D();
                shapesInContact.getWorldA(j, locationA);
                this.newCollisionBalls.setBall((Point3DReadOnly)locationA);
            }
        }
        for (index = 0; index < this.allContactingExternalForcePoints.size(); ++index) {
            contactingExternalForcePointOne = this.allContactingExternalForcePoints.get(index);
            contactingExternalForcePointOne.setForce(0.0, 0.0, 0.0);
            contactingExternalForcePointOne.setImpulse(0.0, 0.0, 0.0);
            contactingExternalForcePointOne.setMoment(0.0, 0.0, 0.0);
            if (!this.visualize || !contactingExternalForcePointOne.isInContact()) continue;
            this.externalForcePointBalls.setBall((Point3DReadOnly)contactingExternalForcePointOne.getPositionCopy());
        }
        for (index = 0; index < this.allContactingExternalForcePoints.size(); ++index) {
            contactingExternalForcePointOne = this.allContactingExternalForcePoints.get(index);
            int indexOfContactingPair = contactingExternalForcePointOne.getIndexOfContactingPair();
            if (indexOfContactingPair == -1) continue;
            ContactingExternalForcePoint contactingExternalForcePointTwo = this.allContactingExternalForcePoints.get(indexOfContactingPair);
            if (index == indexOfContactingPair) {
                throw new RuntimeException();
            }
            if (this.allContactingExternalForcePoints.get(contactingExternalForcePointTwo.getIndexOfContactingPair()) != contactingExternalForcePointOne) {
                throw new RuntimeException();
            }
            if (index >= indexOfContactingPair) continue;
            this.performSpringDamper(contactingExternalForcePointOne, contactingExternalForcePointTwo);
        }
        if (this.visualize) {
            this.contactingExternalForcePointsVisualizer.update();
        }
    }

    public void useShuffleContactingPairs(boolean value) {
        useShuffleContactingPairs = value;
    }

    private void slipTowardEachOtherIfSlipping(ContactingExternalForcePoint contactingExternalForcePointOne, ContactingExternalForcePoint contactingExternalForcePointTwo) {
        boolean areSlipping = this.areSlipping(contactingExternalForcePointOne, contactingExternalForcePointTwo);
        if (areSlipping) {
            CollisionShapeWithLink collisionShapeOne = contactingExternalForcePointOne.getCollisionShape();
            CollisionShapeWithLink collisionShapeTwo = contactingExternalForcePointTwo.getCollisionShape();
            contactingExternalForcePointOne.getPosition((Tuple3DBasics)this.positionOne);
            contactingExternalForcePointTwo.getPosition((Tuple3DBasics)this.positionTwo);
            boolean isPointOneInside = collisionShapeTwo.getTransformedCollisionShapeDescription().isPointInside(this.positionOne);
            boolean isPointTwoInside = collisionShapeOne.getTransformedCollisionShapeDescription().isPointInside(this.positionTwo);
            if (!isPointOneInside && !isPointTwoInside) {
                contactingExternalForcePointOne.setIndexOfContactingPair(-1);
                contactingExternalForcePointTwo.setIndexOfContactingPair(-1);
                return;
            }
            this.slipVector.set((Tuple3DReadOnly)this.positionTwo);
            this.slipVector.sub((Tuple3DReadOnly)this.positionOne);
            contactingExternalForcePointOne.getSurfaceNormalInWorld((Vector3DBasics)this.tempNormal);
            this.subtractOffNormalComponent(this.tempNormal, this.slipVector);
            this.slipVector.scale(0.05);
            this.positionOne.add((Tuple3DReadOnly)this.slipVector);
            this.positionTwo.sub((Tuple3DReadOnly)this.slipVector);
            if (isPointOneInside) {
                contactingExternalForcePointTwo.setOffsetWorld((Tuple3DReadOnly)this.positionTwo);
            }
            if (isPointTwoInside) {
                contactingExternalForcePointOne.setOffsetWorld((Tuple3DReadOnly)this.positionOne);
            }
        }
    }

    private boolean areSlipping(ContactingExternalForcePoint contactingExternalForcePointOne, ContactingExternalForcePoint contactingExternalForcePointTwo) {
        boolean isSlippingTwo;
        boolean isSlippingOne = contactingExternalForcePointOne.getIsSlipping();
        if (isSlippingOne != (isSlippingTwo = contactingExternalForcePointOne.getIsSlipping())) {
            throw new RuntimeException("Inconsistent isSlipping states!?");
        }
        return isSlippingOne;
    }

    private void performSpringDamper(ContactingExternalForcePoint contactingExternalForcePointOne, ContactingExternalForcePoint contactingExternalForcePointTwo) {
        Point3D position = new Point3D();
        Vector3D velocity = new Vector3D();
        Vector3D angularVelocity = new Vector3D();
        Vector3D normal = new Vector3D();
        Point3D matchingPosition = new Point3D();
        Vector3D matchingVelocity = new Vector3D();
        Vector3D matchingAngularVelocity = new Vector3D();
        Vector3D matchingNormal = new Vector3D();
        contactingExternalForcePointOne.getPosition((Tuple3DBasics)position);
        contactingExternalForcePointOne.getVelocity((Vector3DBasics)velocity);
        contactingExternalForcePointOne.getAngularVelocity((Vector3DBasics)angularVelocity);
        contactingExternalForcePointOne.getSurfaceNormalInWorld((Vector3DBasics)normal);
        contactingExternalForcePointTwo.getPosition((Tuple3DBasics)matchingPosition);
        contactingExternalForcePointTwo.getVelocity((Vector3DBasics)matchingVelocity);
        contactingExternalForcePointTwo.getAngularVelocity((Vector3DBasics)matchingAngularVelocity);
        contactingExternalForcePointTwo.getSurfaceNormalInWorld((Vector3DBasics)matchingNormal);
        Vector3D positionDifference = new Vector3D();
        Vector3D velocityDifference = new Vector3D();
        Vector3D angularVelocityDifference = new Vector3D();
        positionDifference.set((Tuple3DReadOnly)matchingPosition);
        positionDifference.sub((Tuple3DReadOnly)position);
        velocityDifference.set(matchingVelocity);
        velocityDifference.sub((Tuple3DReadOnly)velocity);
        angularVelocityDifference.set(matchingAngularVelocity);
        angularVelocityDifference.sub((Tuple3DReadOnly)angularVelocity);
        boolean pullingOut = false;
        if (velocityDifference.dot((Tuple3DReadOnly)normal) > 0.005) {
            pullingOut = true;
        }
        Vector3D springForce = new Vector3D();
        Vector3D damperForce = new Vector3D();
        Vector3D rotationalDamperMoment = new Vector3D();
        springForce.set(positionDifference);
        springForce.scale(this.kpCollision.getDoubleValue());
        if (pullingOut) {
            springForce.scale(this.pullingOutSpringHysteresisReduction.getDoubleValue());
        }
        damperForce.set(velocityDifference);
        damperForce.scale(this.kdCollision.getDoubleValue());
        rotationalDamperMoment.set(angularVelocityDifference);
        rotationalDamperMoment.scale(this.kdRotationalDamping.getDoubleValue());
        Vector3D totalForce = new Vector3D();
        totalForce.set(springForce);
        totalForce.add((Tuple3DReadOnly)damperForce);
        double numberOfPointsContacting = contactingExternalForcePointOne.getNumberOfPointsInContactWithSameShape();
        if (numberOfPointsContacting < 1.0) {
            numberOfPointsContacting = 1.0;
        }
        Vector3D forceAlongNormal = new Vector3D((Tuple3DReadOnly)normal);
        forceAlongNormal.scale(totalForce.dot((Tuple3DReadOnly)normal) / normal.dot((Tuple3DReadOnly)normal));
        Vector3D forcePerpendicularToNormal = new Vector3D((Tuple3DReadOnly)totalForce);
        forcePerpendicularToNormal.sub((Tuple3DReadOnly)forceAlongNormal);
        double momentToForceRatio = rotationalDamperMoment.length() / forceAlongNormal.length();
        if (momentToForceRatio > this.rotationalCoefficientOfFrictionBeta.getDoubleValue()) {
            rotationalDamperMoment.scale(this.rotationalCoefficientOfFrictionBeta.getDoubleValue() / momentToForceRatio);
        }
        double forceRatio = forcePerpendicularToNormal.length() / forceAlongNormal.length();
        if (forceAlongNormal.dot((Tuple3DReadOnly)normal) >= 0.0) {
            contactingExternalForcePointOne.setForce(0.0, 0.0, 0.0);
            contactingExternalForcePointTwo.setForce(0.0, 0.0, 0.0);
            contactingExternalForcePointOne.setMoment(0.0, 0.0, 0.0);
            contactingExternalForcePointOne.setMoment(0.0, 0.0, 0.0);
            contactingExternalForcePointOne.setIsSlipping(true);
            contactingExternalForcePointTwo.setIsSlipping(true);
        } else if (forceRatio > this.coefficientOfFriction.getDoubleValue()) {
            forcePerpendicularToNormal.scale(this.coefficientOfFriction.getDoubleValue() / forceRatio);
            totalForce.set(forceAlongNormal);
            totalForce.add((Tuple3DReadOnly)forcePerpendicularToNormal);
            contactingExternalForcePointOne.setForce((Vector3DReadOnly)totalForce);
            contactingExternalForcePointOne.setMoment(rotationalDamperMoment);
            totalForce.negate();
            rotationalDamperMoment.negate();
            contactingExternalForcePointTwo.setForce((Vector3DReadOnly)totalForce);
            contactingExternalForcePointTwo.setMoment(rotationalDamperMoment);
            contactingExternalForcePointOne.setIsSlipping(true);
            contactingExternalForcePointTwo.setIsSlipping(true);
        } else {
            contactingExternalForcePointOne.setForce((Vector3DReadOnly)totalForce);
            contactingExternalForcePointOne.setMoment(rotationalDamperMoment);
            totalForce.negate();
            rotationalDamperMoment.negate();
            contactingExternalForcePointTwo.setForce((Vector3DReadOnly)totalForce);
            contactingExternalForcePointTwo.setMoment(rotationalDamperMoment);
            contactingExternalForcePointOne.setIsSlipping(false);
            contactingExternalForcePointTwo.setIsSlipping(false);
        }
        contactingExternalForcePointOne.setImpulse(0.0, 0.0, 0.0);
        contactingExternalForcePointTwo.setImpulse(0.0, 0.0, 0.0);
    }

    @Override
    public void handle(Contacts contacts) {
        this.shapesInContactList.add(contacts);
    }

    private void handleLocal(CollisionShapeWithLink shape1, CollisionShapeWithLink shape2, Contacts contacts) {
        boolean shapeOneIsGround = shape1.isGround();
        boolean shapeTwoIsGround = shape2.isGround();
        if (shapeOneIsGround && shapeTwoIsGround) {
            return;
        }
        Link linkOne = shape1.getLink();
        Link linkTwo = shape2.getLink();
        int numberOfContacts = contacts.getNumberOfContacts();
        this.indices.clear();
        for (int i = 0; i < numberOfContacts; ++i) {
            this.indices.add(i);
        }
        for (int cycle = 0; cycle < this.numberOfCyclesPerContactPair; ++cycle) {
            Collections.shuffle(this.indices, this.random);
            if (numberOfContacts > 1) {
                throw new RuntimeException("Only expecting one deepest contact each time...");
            }
            for (int j = 0; j < numberOfContacts; ++j) {
                int k;
                int i = this.indices.get(j);
                double distance = contacts.getDistance(i);
                if (distance > 0.0) continue;
                contacts.getWorldA(i, this.point1);
                contacts.getWorldB(i, this.point2);
                contacts.getWorldNormal(i, this.normal);
                if (!contacts.isNormalOnA()) {
                    this.normal.scale(-1.0);
                }
                if (Double.isNaN(this.normal.getX())) {
                    throw new RuntimeException("Normal is invalid. Contains NaN!");
                }
                this.negative_normal.set(this.normal);
                this.negative_normal.scale(-1.0);
                List<ContactingExternalForcePoint> contactingExternalForcePointsOne = linkOne.getContactingExternalForcePoints();
                List<ContactingExternalForcePoint> contactingExternalForcePointsTwo = linkTwo.getContactingExternalForcePoints();
                if (contactingExternalForcePointsOne.isEmpty()) {
                    throw new RuntimeException("No force points on link " + linkOne);
                }
                if (contactingExternalForcePointsTwo.isEmpty()) {
                    throw new RuntimeException("No force points on link " + linkTwo);
                }
                boolean contactPairAlreadyExists = false;
                List<ContactingExternalForcePoint> pointsThatAreContactingShapeOne = this.getPointsThatAreContactingOtherLink(contactingExternalForcePointsTwo, linkOne);
                List<ContactingExternalForcePoint> pointsThatAreContactingShapeTwo = this.getPointsThatAreContactingOtherLink(contactingExternalForcePointsOne, linkTwo);
                int pointsThatAreHoldingWeight = pointsThatAreContactingShapeOne.size();
                if (pointsThatAreHoldingWeight > 3) {
                    pointsThatAreHoldingWeight = 3;
                }
                for (k = 0; k < pointsThatAreContactingShapeOne.size(); ++k) {
                    pointsThatAreContactingShapeOne.get(k).setNumberOfPointsInContactWithSameShape(pointsThatAreHoldingWeight);
                }
                for (k = 0; k < pointsThatAreContactingShapeTwo.size(); ++k) {
                    pointsThatAreContactingShapeTwo.get(k).setNumberOfPointsInContactWithSameShape(pointsThatAreContactingShapeTwo.size());
                }
                ContactingExternalForcePoint externalForcePointOne = null;
                ContactingExternalForcePoint externalForcePointTwo = null;
                this.setSurfaceNormalToMatchNewCollision(pointsThatAreContactingShapeTwo, this.normal, this.negative_normal);
                this.removeContactOnPointsThatAreOutsideCollisionSandwhich(pointsThatAreContactingShapeTwo, this.point1, this.normal, this.point2, this.negative_normal);
                this.rollContactPointsIfRolling(pointsThatAreContactingShapeTwo);
                for (int k2 = 0; k2 < pointsThatAreContactingShapeTwo.size(); ++k2) {
                    ContactingExternalForcePoint contactPointToConsiderOne = pointsThatAreContactingShapeTwo.get(k2);
                    ContactingExternalForcePoint contactPointToConsiderTwo = this.allContactingExternalForcePoints.get(contactPointToConsiderOne.getIndexOfContactingPair());
                    Vector3D deltaVectorRemovingNormalComponentsOne = new Vector3D((Tuple3DReadOnly)contactPointToConsiderOne.getPositionCopy());
                    deltaVectorRemovingNormalComponentsOne.sub((Tuple3DReadOnly)this.point1);
                    this.subtractOffNormalComponent(this.normal, deltaVectorRemovingNormalComponentsOne);
                    double distanceToConsiderOne = deltaVectorRemovingNormalComponentsOne.length();
                    Vector3D deltaVectorRemovingNormalComponentsTwo = new Vector3D((Tuple3DReadOnly)contactPointToConsiderTwo.getPositionCopy());
                    deltaVectorRemovingNormalComponentsTwo.sub((Tuple3DReadOnly)this.point2);
                    this.subtractOffNormalComponent(this.normal, deltaVectorRemovingNormalComponentsTwo);
                    double distanceToConsiderTwo = deltaVectorRemovingNormalComponentsTwo.length();
                    if (!(distanceToConsiderOne < this.minDistanceToConsiderDifferent) && !(distanceToConsiderTwo < this.minDistanceToConsiderDifferent)) continue;
                    externalForcePointOne = contactPointToConsiderOne;
                    externalForcePointTwo = contactPointToConsiderTwo;
                    contactPairAlreadyExists = true;
                    boolean areSlipping = true;
                    if (!areSlipping) break;
                    contactPointToConsiderOne.getPosition((Tuple3DBasics)this.positionOne);
                    this.slipVector.set(deltaVectorRemovingNormalComponentsOne);
                    this.slipVector.scale(this.percentMoveTowardTouchdownWhenSamePoint);
                    this.positionOne.sub((Tuple3DReadOnly)this.slipVector);
                    contactPointToConsiderOne.setOffsetWorld((Tuple3DReadOnly)this.positionOne);
                    contactPointToConsiderTwo.getPosition((Tuple3DBasics)this.positionTwo);
                    this.slipVector.set(deltaVectorRemovingNormalComponentsTwo);
                    this.slipVector.scale(this.percentMoveTowardTouchdownWhenSamePoint);
                    this.positionTwo.sub((Tuple3DReadOnly)this.slipVector);
                    contactPointToConsiderTwo.setOffsetWorld((Tuple3DReadOnly)this.positionTwo);
                    break;
                }
                if (!contactPairAlreadyExists) {
                    externalForcePointOne = this.getAvailableContactingExternalForcePoint(contactingExternalForcePointsOne);
                    externalForcePointTwo = this.getAvailableContactingExternalForcePoint(contactingExternalForcePointsTwo);
                    if (externalForcePointOne != null && externalForcePointTwo != null) {
                        externalForcePointOne.setIndexOfContactingPair(externalForcePointTwo.getIndex());
                        externalForcePointTwo.setIndexOfContactingPair(externalForcePointOne.getIndex());
                        externalForcePointOne.setCollisionShape(shape1);
                        externalForcePointTwo.setCollisionShape(shape2);
                    } else {
                        throw new RuntimeException("No more contact pairs are available!");
                    }
                }
                int indexOfOne = externalForcePointOne.getIndex();
                int indexOfTwo = externalForcePointTwo.getIndex();
                int indexOfContactingPairOne = externalForcePointOne.getIndexOfContactingPair();
                int indexOfContactingPairTwo = externalForcePointTwo.getIndexOfContactingPair();
                if (indexOfOne != indexOfContactingPairTwo) {
                    throw new RuntimeException("");
                }
                if (indexOfTwo != indexOfContactingPairOne) {
                    throw new RuntimeException("");
                }
                if (this.allContactingExternalForcePoints.get(indexOfOne) != externalForcePointOne) {
                    throw new RuntimeException("Contacting pair indices are not consistent!!!");
                }
                if (this.allContactingExternalForcePoints.get(indexOfTwo) != externalForcePointTwo) {
                    throw new RuntimeException("Contacting pair indices are not consistent!!!");
                }
                if (!contactPairAlreadyExists) {
                    externalForcePointOne.setSurfaceNormalInWorld((Vector3DReadOnly)this.normal);
                    externalForcePointTwo.setSurfaceNormalInWorld((Vector3DReadOnly)this.negative_normal);
                    this.tempVectorForAveraging.set((Tuple3DReadOnly)this.point2);
                    this.tempVectorForAveraging.sub((Tuple3DReadOnly)this.point1);
                    this.tempVectorForAveraging.scale(0.5);
                    double penetrationLength = this.tempVectorForAveraging.length();
                    if (penetrationLength > this.maximumPenetrationToStart) {
                        this.tempVectorForAveraging.scale(this.maximumPenetrationToStart / penetrationLength);
                    }
                    this.tempPoint.set(this.point1);
                    this.tempPoint.add((Tuple3DReadOnly)this.tempVectorForAveraging);
                    externalForcePointOne.setOffsetWorld((Tuple3DReadOnly)this.tempPoint);
                    this.tempPoint.set(this.point2);
                    this.tempPoint.sub((Tuple3DReadOnly)this.tempVectorForAveraging);
                    externalForcePointTwo.setOffsetWorld((Tuple3DReadOnly)this.tempPoint);
                }
                Robot robot1 = linkOne.getParentJoint().getRobot();
                Robot robot2 = linkTwo.getParentJoint().getRobot();
                robot1.update();
                robot1.updateVelocities();
                if (robot2 == robot1) continue;
                robot2.update();
                robot2.updateVelocities();
            }
        }
    }

    private Vector3D subtractOffNormalComponent(Vector3D normal, Vector3D vectorToRemoveNormalComponent) {
        double percentOfNormalComponent = vectorToRemoveNormalComponent.dot((Tuple3DReadOnly)normal) / normal.dot((Tuple3DReadOnly)normal);
        this.normalComponent.set(normal);
        this.normalComponent.scale(percentOfNormalComponent);
        vectorToRemoveNormalComponent.sub((Tuple3DReadOnly)this.normalComponent);
        return vectorToRemoveNormalComponent;
    }

    private void rollContactPointsIfRolling(List<ContactingExternalForcePoint> pointsThatAreContactingShapeTwo) {
        for (int k = 0; k < pointsThatAreContactingShapeTwo.size(); ++k) {
            ContactingExternalForcePoint contactPointToConsiderOne = pointsThatAreContactingShapeTwo.get(k);
            ContactingExternalForcePoint contactPointToConsiderTwo = this.allContactingExternalForcePoints.get(contactPointToConsiderOne.getIndexOfContactingPair());
            contactPointToConsiderOne.getPosition((Tuple3DBasics)this.tempPositionForRollingOne);
            contactPointToConsiderOne.getSurfaceNormalInWorld((Vector3DBasics)this.tempSurfaceNormalForRolllingOne);
            CollisionShapeWithLink collisionShapeOne = contactPointToConsiderOne.getCollisionShape();
            CollisionShapeDescription<?> collisionShapeDescriptionOne = collisionShapeOne.getTransformedCollisionShapeDescription();
            boolean wasRollingOne = collisionShapeDescriptionOne.rollContactIfRolling(this.tempSurfaceNormalForRolllingOne, this.tempPositionForRollingOne);
            contactPointToConsiderOne.setOffsetWorld((Tuple3DReadOnly)this.tempPositionForRollingOne);
            contactPointToConsiderTwo.getPosition((Tuple3DBasics)this.tempPositionForRollingTwo);
            contactPointToConsiderTwo.getSurfaceNormalInWorld((Vector3DBasics)this.tempSurfaceNormalForRolllingTwo);
            CollisionShapeWithLink collisionShapeTwo = contactPointToConsiderTwo.getCollisionShape();
            CollisionShapeDescription<?> collisionShapeDescriptionTwo = collisionShapeTwo.getTransformedCollisionShapeDescription();
            boolean wasRollingTwo = collisionShapeDescriptionTwo.rollContactIfRolling(this.tempSurfaceNormalForRolllingTwo, this.tempPositionForRollingTwo);
            contactPointToConsiderTwo.setOffsetWorld((Tuple3DReadOnly)this.tempPositionForRollingTwo);
            if (wasRollingOne && wasRollingTwo) {
                return;
            }
            if (!wasRollingOne && !wasRollingTwo) {
                return;
            }
            if (wasRollingOne) {
                this.tempVectorForRolling.set((Tuple3DReadOnly)this.tempPositionForRollingOne);
                this.tempVectorForRolling.sub((Tuple3DReadOnly)this.tempPositionForRollingTwo);
                this.subtractOffNormalComponent(this.tempSurfaceNormalForRolllingOne, this.tempVectorForRolling);
                this.tempPositionForRollingTwo.add((Tuple3DReadOnly)this.tempVectorForRolling);
                contactPointToConsiderTwo.setOffsetWorld((Tuple3DReadOnly)this.tempPositionForRollingTwo);
            }
            if (!wasRollingTwo) continue;
            this.tempVectorForRolling.set((Tuple3DReadOnly)this.tempPositionForRollingTwo);
            this.tempVectorForRolling.sub((Tuple3DReadOnly)this.tempPositionForRollingOne);
            this.subtractOffNormalComponent(this.tempSurfaceNormalForRolllingTwo, this.tempVectorForRolling);
            this.tempPositionForRollingOne.add((Tuple3DReadOnly)this.tempVectorForRolling);
            contactPointToConsiderOne.setOffsetWorld((Tuple3DReadOnly)this.tempPositionForRollingOne);
        }
    }

    private void removeContactOnPointsThatAreOutsideCollisionSandwhich(List<ContactingExternalForcePoint> pointsThatAreContactingShapeTwo, Point3D point1, Vector3D normal, Point3D point2, Vector3D negativeNormal) {
        this.pointsToRemove.clear();
        for (int k = 0; k < pointsThatAreContactingShapeTwo.size(); ++k) {
            ContactingExternalForcePoint contactPointToConsiderOne = pointsThatAreContactingShapeTwo.get(k);
            ContactingExternalForcePoint contactPointToConsiderTwo = this.allContactingExternalForcePoints.get(contactPointToConsiderOne.getIndexOfContactingPair());
            contactPointToConsiderOne.getPosition((Tuple3DBasics)this.positionOneToConsider);
            contactPointToConsiderTwo.getPosition((Tuple3DBasics)this.positionTwoToConsider);
            this.tempVector.set((Tuple3DReadOnly)this.positionTwoToConsider);
            this.tempVector.sub((Tuple3DReadOnly)point1);
            if (this.tempVector.dot((Tuple3DReadOnly)normal) > 0.0) {
                contactPointToConsiderOne.setIndexOfContactingPair(-1);
                contactPointToConsiderTwo.setIndexOfContactingPair(-1);
                this.pointsToRemove.add(contactPointToConsiderOne);
                continue;
            }
            this.tempVector.set((Tuple3DReadOnly)this.positionOneToConsider);
            this.tempVector.sub((Tuple3DReadOnly)point2);
            if (!(this.tempVector.dot((Tuple3DReadOnly)negativeNormal) > 0.0)) continue;
            contactPointToConsiderOne.setIndexOfContactingPair(-1);
            contactPointToConsiderTwo.setIndexOfContactingPair(-1);
            this.pointsToRemove.add(contactPointToConsiderOne);
        }
        pointsThatAreContactingShapeTwo.removeAll(this.pointsToRemove);
    }

    private void setSurfaceNormalToMatchNewCollision(List<ContactingExternalForcePoint> pointsThatAreContactingShapeTwo, Vector3D normal, Vector3D negativeNormal) {
        for (int k = 0; k < pointsThatAreContactingShapeTwo.size(); ++k) {
            ContactingExternalForcePoint contactPointToConsiderOne = pointsThatAreContactingShapeTwo.get(k);
            ContactingExternalForcePoint contactPointToConsiderTwo = this.allContactingExternalForcePoints.get(contactPointToConsiderOne.getIndexOfContactingPair());
            contactPointToConsiderOne.setSurfaceNormalInWorld((Vector3DReadOnly)normal);
            contactPointToConsiderTwo.setSurfaceNormalInWorld((Vector3DReadOnly)negativeNormal);
        }
    }

    private void resolveCollisionWithAnImpact(CollisionShapeWithLink shape1, CollisionShapeWithLink shape2, boolean shapeOneIsGround, boolean shapeTwoIsGround, ContactingExternalForcePoint externalForcePointOne, ContactingExternalForcePoint externalForcePointTwo, boolean allowMicroCollisions) {
        boolean collisionOccurred;
        Vector3D p_world = new Vector3D();
        if (shapeTwoIsGround) {
            velocityWorld = new Vector3D(0.0, 0.0, 0.0);
            if (!allowMicroCollisions || externalForcePointOne.getVelocityCopy().lengthSquared() > this.velocityForMicrocollision * this.velocityForMicrocollision) {
                collisionOccurred = externalForcePointOne.resolveCollision((Vector3DReadOnly)velocityWorld, (Vector3DReadOnly)this.negative_normal, this.coefficientOfRestitution.getDoubleValue(), this.coefficientOfFriction.getDoubleValue(), (Vector3DBasics)p_world);
            } else {
                double penetrationSquared = this.point1.distanceSquared((Point3DReadOnly)this.point2);
                externalForcePointOne.resolveMicroCollision(penetrationSquared, (Vector3DReadOnly)velocityWorld, (Vector3DReadOnly)this.negative_normal, this.coefficientOfRestitution.getDoubleValue(), this.coefficientOfFriction.getDoubleValue(), (Vector3DBasics)p_world);
                collisionOccurred = true;
            }
        } else if (shapeOneIsGround) {
            velocityWorld = new Vector3D(0.0, 0.0, 0.0);
            if (!allowMicroCollisions || externalForcePointTwo.getVelocityCopy().lengthSquared() > this.velocityForMicrocollision * this.velocityForMicrocollision) {
                collisionOccurred = externalForcePointTwo.resolveCollision((Vector3DReadOnly)velocityWorld, (Vector3DReadOnly)this.normal, this.coefficientOfRestitution.getDoubleValue(), this.coefficientOfFriction.getDoubleValue(), (Vector3DBasics)p_world);
            } else {
                double penetrationSquared = this.point1.distanceSquared((Point3DReadOnly)this.point2);
                externalForcePointTwo.resolveMicroCollision(penetrationSquared, (Vector3DReadOnly)velocityWorld, (Vector3DReadOnly)this.normal, this.coefficientOfRestitution.getDoubleValue(), this.coefficientOfFriction.getDoubleValue(), (Vector3DBasics)p_world);
                collisionOccurred = true;
            }
        } else {
            Vector3D velocityVectorOne = externalForcePointOne.getVelocityCopy();
            Vector3D velocityVectorTwo = externalForcePointTwo.getVelocityCopy();
            Vector3D velocityDifference = new Vector3D();
            velocityDifference.sub((Tuple3DReadOnly)velocityVectorTwo, (Tuple3DReadOnly)velocityVectorOne);
            if (!allowMicroCollisions || velocityDifference.lengthSquared() > this.velocityForMicrocollision * this.velocityForMicrocollision) {
                collisionOccurred = externalForcePointOne.resolveCollision(externalForcePointTwo, (Vector3DReadOnly)this.negative_normal, this.coefficientOfRestitution.getDoubleValue(), this.coefficientOfFriction.getDoubleValue(), (Vector3DBasics)p_world);
            } else {
                double penetrationSquared = this.point1.distanceSquared((Point3DReadOnly)this.point2);
                collisionOccurred = externalForcePointOne.resolveMicroCollision(penetrationSquared, externalForcePointTwo, (Vector3DReadOnly)this.negative_normal, this.coefficientOfRestitution.getDoubleValue(), this.coefficientOfFriction.getDoubleValue(), (Vector3DBasics)p_world);
            }
        }
        if (collisionOccurred) {
            for (CollisionHandlerListener listener : this.listeners) {
                listener.collision(shape1, shape2, externalForcePointOne, externalForcePointTwo, null, null);
            }
        }
    }

    private List<ContactingExternalForcePoint> getPointsThatAreContactingOtherLink(List<ContactingExternalForcePoint> contactingExternalForcePointsOne, Link linkTwo) {
        ArrayList<ContactingExternalForcePoint> pointsThatAreContactingShapeTwo = new ArrayList<ContactingExternalForcePoint>();
        for (int k = 0; k < contactingExternalForcePointsOne.size(); ++k) {
            ContactingExternalForcePoint brotherContactingExternalForcePointTwo;
            ContactingExternalForcePoint contactingExternalForcePointOne = contactingExternalForcePointsOne.get(k);
            int indexOfContactingPair = contactingExternalForcePointOne.getIndexOfContactingPair();
            if (indexOfContactingPair == -1 || (brotherContactingExternalForcePointTwo = this.allContactingExternalForcePoints.get(indexOfContactingPair)).getLink() != linkTwo) continue;
            pointsThatAreContactingShapeTwo.add(contactingExternalForcePointOne);
        }
        return pointsThatAreContactingShapeTwo;
    }

    private ContactingExternalForcePoint getAvailableContactingExternalForcePoint(List<ContactingExternalForcePoint> contactingExternalForcePoints) {
        for (int i = 0; i < contactingExternalForcePoints.size(); ++i) {
            ContactingExternalForcePoint contactingExternalForcePoint = contactingExternalForcePoints.get(i);
            if (contactingExternalForcePoint.getIndexOfContactingPair() != -1) continue;
            return contactingExternalForcePoint;
        }
        int indexWithSmallestForce = -1;
        double smallestForceSquared = Double.POSITIVE_INFINITY;
        for (int i = 0; i < contactingExternalForcePoints.size(); ++i) {
            contactingExternalForcePoints.get(i).getForce((Vector3DBasics)this.tempForceVector);
            double forceSquared = this.tempForceVector.dot((Tuple3DReadOnly)this.tempForceVector);
            if (!(forceSquared < smallestForceSquared)) continue;
            smallestForceSquared = forceSquared;
            indexWithSmallestForce = i;
        }
        ContactingExternalForcePoint contactingExternalForcePointToRecycleOne = contactingExternalForcePoints.get(indexWithSmallestForce);
        int indexOfContactingPair = contactingExternalForcePointToRecycleOne.getIndexOfContactingPair();
        ContactingExternalForcePoint contactingExternalForcePointToRecycleTwo = this.allContactingExternalForcePoints.get(indexOfContactingPair);
        contactingExternalForcePointToRecycleOne.setIndexOfContactingPair(-1);
        contactingExternalForcePointToRecycleTwo.setIndexOfContactingPair(-1);
        return contactingExternalForcePointToRecycleOne;
    }

    @Override
    public void addListener(CollisionHandlerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void handleCollisions(CollisionDetectionResult results) {
        this.maintenanceBeforeCollisionDetection();
        this.detachNonContactingPairs(results);
        for (int i = 0; i < results.getNumberOfCollisions(); ++i) {
            Contacts collision = results.getCollision(i);
            this.handle(collision);
        }
        this.maintenanceAfterCollisionDetection();
    }

    @Override
    public void addContactingExternalForcePoints(Link link, List<ContactingExternalForcePoint> contactingExternalForcePoints) {
        int index = this.allContactingExternalForcePoints.size();
        for (int i = 0; i < contactingExternalForcePoints.size(); ++i) {
            ContactingExternalForcePoint contactingExternalForcePoint = contactingExternalForcePoints.get(i);
            contactingExternalForcePoint.setIndex(index);
            this.allContactingExternalForcePoints.add(contactingExternalForcePoint);
            this.linkNamesOfForcePoints.add(link.getName());
            ++index;
        }
        if (this.visualize) {
            this.contactingExternalForcePointsVisualizer.addPoints(contactingExternalForcePoints);
        }
    }

    private void detachNonContactingPairs(CollisionDetectionResult results) {
        int i;
        ArrayList<String> linkNamesOfContacting = new ArrayList<String>();
        for (i = 0; i < results.getNumberOfCollisions(); ++i) {
            Contacts contact = results.getCollision(i);
            CollisionShapeWithLink shapeA = (CollisionShapeWithLink)contact.getShapeA();
            CollisionShapeWithLink shapeB = (CollisionShapeWithLink)contact.getShapeB();
            if (!linkNamesOfContacting.contains(shapeA.getLink().getName())) {
                linkNamesOfContacting.add(shapeA.getLink().getName());
            }
            if (linkNamesOfContacting.contains(shapeB.getLink().getName())) continue;
            linkNamesOfContacting.add(shapeB.getLink().getName());
        }
        for (i = 0; i < this.allContactingExternalForcePoints.size(); ++i) {
            boolean isPairedWhileNonContacting;
            ContactingExternalForcePoint contactingExternalForcePoint = this.allContactingExternalForcePoints.get(i);
            boolean isContacting = false;
            for (int j = 0; j < linkNamesOfContacting.size(); ++j) {
                if (!((String)linkNamesOfContacting.get(j)).equals(this.linkNamesOfForcePoints.get(i))) continue;
                isContacting = true;
                break;
            }
            if (isContacting) continue;
            boolean bl = isPairedWhileNonContacting = contactingExternalForcePoint.getIndexOfContactingPair() != -1;
            if (!isPairedWhileNonContacting) continue;
            this.allContactingExternalForcePoints.get(contactingExternalForcePoint.getIndexOfContactingPair()).setIndexOfContactingPair(-1);
            contactingExternalForcePoint.setIndexOfContactingPair(-1);
        }
    }
}

