/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import us.ihmc.graphicsDescription.plotting.PlotterColors;
import us.ihmc.graphicsDescription.plotting.artifact.ArtifactsChangedListener;
import us.ihmc.plotting.Plotter;
import us.ihmc.plotting.PlotterLegendPanel;
import us.ihmc.plotting.PlotterShowHideMenu;
import us.ihmc.simulationconstructionset.PlaybackListener;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimulationOverheadPlotter
implements PlaybackListener {
    private final Plotter plotter = new Plotter(PlotterColors.javaFXStyle(), false);
    private final PlotterLegendPanel legendPanel;
    private final PlotterShowHideMenu plotterShowHideMenu;
    private JMenuBar menuBar;
    private JCheckBoxMenuItem trackBodyCB;
    private YoDouble xVariableToTrack;
    private YoDouble yVariableToTrack;
    private YoDouble yawVariableToTrack;

    public SimulationOverheadPlotter() {
        this(true, true);
    }

    public SimulationOverheadPlotter(boolean createLegendPanel, boolean createShowHideMenu) {
        this.plotter.setViewRange(1.0);
        this.legendPanel = createLegendPanel ? this.plotter.createPlotterLegendPanel() : null;
        this.buildMenuBar();
        if (createShowHideMenu) {
            this.plotterShowHideMenu = new PlotterShowHideMenu(this.plotter);
            this.plotter.addArtifactsChangedListener((ArtifactsChangedListener)this.plotterShowHideMenu);
        } else {
            this.plotterShowHideMenu = null;
        }
    }

    public JFrame createAndDisplayJFrame() {
        JFrame jFrame = new JFrame("Simulation Overhead Plotter");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
        jFrame.setJMenuBar(this.menuBar);
        JPanel plotterAndLegendPanel = this.plotter.createAndAttachPlotterLegendPanel();
        jFrame.getContentPane().add((Component)plotterAndLegendPanel, "Center");
        jFrame.pack();
        jFrame.setVisible(true);
        return jFrame;
    }

    public void setXVariableToTrack(YoDouble xVariableToTrack) {
        this.xVariableToTrack = xVariableToTrack;
    }

    public void setYVariableToTrack(YoDouble yVariableToTrack) {
        this.yVariableToTrack = yVariableToTrack;
    }

    public void setYawVariableToTrack(YoDouble yawVariableToTrack) {
        this.yawVariableToTrack = yawVariableToTrack;
    }

    public void setDrawHistory(boolean drawHistory) {
        this.plotter.setDrawHistory(drawHistory);
    }

    private JMenuBar buildMenuBar() {
        this.menuBar = new JMenuBar();
        JMenu menu = new JMenu("Options");
        menu.getAccessibleContext().setAccessibleDescription("Options");
        this.menuBar.add(menu);
        this.trackBodyCB = new JCheckBoxMenuItem("track body");
        this.trackBodyCB.setSelected(true);
        menu.add(this.trackBodyCB);
        return this.menuBar;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public Plotter getPlotter() {
        return this.plotter;
    }

    public JPanel getJPanel() {
        return this.plotter.getJPanel();
    }

    public JPanel getJPanelWithCheckBoxes() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.plotter.getJPanel(), "Center");
        jPanel.add((Component)this.trackBodyCB, "North");
        return jPanel;
    }

    public JPanel getJPanelKey() {
        return this.legendPanel;
    }

    public void update() {
        this.recenterIfTrackingIsSelected();
        this.plotter.update();
    }

    private void recenterIfTrackingIsSelected() {
        if (this.trackBodyCB.isSelected()) {
            if (this.xVariableToTrack != null) {
                this.plotter.setFocusPointX(this.xVariableToTrack.getDoubleValue());
            }
            if (this.yVariableToTrack != null) {
                this.plotter.setFocusPointY(this.yVariableToTrack.getDoubleValue());
            }
            if (this.yawVariableToTrack != null) {
                this.plotter.setFocusOrientationYaw(this.yawVariableToTrack.getDoubleValue());
            }
        }
    }

    public void indexChanged(int newIndex) {
        this.update();
    }

    @Override
    public void play(double realTimeRate) {
    }

    @Override
    public void stop() {
    }

    public PlotterShowHideMenu getShowHideMenuPanel() {
        return this.plotterShowHideMenu;
    }
}

