/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.HeightMapFromGroundContactModel;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationDoneCriterion;
import us.ihmc.simulationconstructionset.SimulationDoneListener;
import us.ihmc.simulationconstructionset.Simulator;
import us.ihmc.simulationconstructionset.SupportedGraphics3DAdapter;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.graphics.GraphicsRobot;
import us.ihmc.simulationconstructionset.physics.ScsPhysics;
import us.ihmc.simulationconstructionset.physics.collision.simple.CollisionManager;
import us.ihmc.simulationconstructionset.physics.collision.simple.DoNothingCollisionArbiter;
import us.ihmc.simulationconstructionset.scripts.Script;
import us.ihmc.simulationconstructionset.synchronization.SimulationSynchronizer;
import us.ihmc.simulationconstructionset.util.ground.FlatGroundProfile;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoVariable;

public class Simulation
implements YoVariableHolder,
Serializable {
    private static final long serialVersionUID = 8438645717978048239L;
    private CollisionManager collisionManager;
    private Graphics3DAdapter myGraphics;
    private final SimulationSynchronizer simulationSynchronizer;
    private double SIMULATION_DT = 4.0E-4;
    private int RECORD_FREQ = 1;
    private Robot[] robots;
    private Simulator mySimulator;
    private YoBuffer myDataBuffer;
    private YoVariableList myCombinedVarList = new YoVariableList("Combined");
    private List<SimulationDoneListener> simulateDoneListeners = new ArrayList<SimulationDoneListener>();
    private List<SimulationDoneCriterion> simulateDoneCriterions;

    public void initPhysics(ScsPhysics physics) {
        this.mySimulator.setCollisions(physics.collisionDetector, physics.collisionArbiter, physics.collisionHandler, physics.visualize);
        for (Robot robot : this.robots) {
            if (physics.collisionConfigure == null) continue;
            physics.collisionConfigure.setup(robot, physics.collisionDetector, physics.collisionHandler);
        }
    }

    public double getDT() {
        if (this.mySimulator != null) {
            return this.mySimulator.getDT();
        }
        return 1.0;
    }

    public void setDT(double simulateDT, int recordFrequency) {
        if (this.mySimulator != null) {
            this.mySimulator.setDT(simulateDT);
        }
        this.SIMULATION_DT = simulateDT;
        this.RECORD_FREQ = recordFrequency;
    }

    public void setRecordDT(double recordDT) {
        this.RECORD_FREQ = (int)Math.round(recordDT / this.mySimulator.getDT());
        if (this.RECORD_FREQ < 1) {
            this.RECORD_FREQ = 1;
        }
    }

    public long getRecordFreq() {
        return this.RECORD_FREQ;
    }

    public void addScript(Script script) {
        this.mySimulator.addScript(script);
    }

    public List<YoVariable> getVariables() {
        return this.myDataBuffer.getVariables();
    }

    public YoVariable findVariable(String varname) {
        return this.myDataBuffer.findVariable(varname);
    }

    public boolean hasUniqueVariable(String varname) {
        return this.myDataBuffer.hasUniqueVariable(varname);
    }

    public YoVariable findVariable(String namespace, String varname) {
        return this.myDataBuffer.findVariable(namespace, varname);
    }

    public boolean hasUniqueVariable(String namespace, String varname) {
        return this.myDataBuffer.hasUniqueVariable(namespace, varname);
    }

    public List<YoVariable> findVariables(String namespace, String varname) {
        return this.myDataBuffer.findVariables(namespace, varname);
    }

    public List<YoVariable> findVariables(String varname) {
        return this.myDataBuffer.findVariables(varname);
    }

    public List<YoVariable> findVariables(YoNamespace namespace) {
        return this.myDataBuffer.findVariables(namespace);
    }

    public Simulation(Robot robot, int dataBufferSize) {
        this(new Robot[]{robot}, dataBufferSize);
    }

    public Simulation(Robot[] robots, int dataBufferSize) {
        this.simulationSynchronizer = new SimulationSynchronizer();
        if (robots != null && robots[0] == null) {
            robots = null;
        }
        this.myDataBuffer = new YoBuffer(dataBufferSize);
        this.setRobots(robots);
    }

    public void closeAndDispose() {
        this.myDataBuffer.clear();
        this.myDataBuffer = null;
        this.mySimulator = null;
    }

    public void setRobots(Robot[] robots) {
        this.robots = robots;
        this.mySimulator = new Simulator(this.simulationSynchronizer, robots, this.SIMULATION_DT);
        this.setDT(this.SIMULATION_DT, this.RECORD_FREQ);
        if (robots != null) {
            for (Robot robot : robots) {
                this.addVariablesFromARobot(robot);
            }
        }
        this.myDataBuffer.fillBuffer();
        this.updateRobots(robots);
    }

    public void addRobot(Robot robot) {
        Robot[] newRobots;
        if (this.robots == null) {
            newRobots = new Robot[]{robot};
        } else {
            newRobots = new Robot[this.robots.length + 1];
            for (int i = 0; i < this.robots.length; ++i) {
                newRobots[i] = this.robots[i];
            }
            newRobots[newRobots.length - 1] = robot;
        }
        this.robots = newRobots;
        if (this.mySimulator == null) {
            this.mySimulator = new Simulator(this.simulationSynchronizer, this.robots, this.SIMULATION_DT);
        } else {
            this.mySimulator.setRobots(this.robots);
        }
        this.setDT(this.SIMULATION_DT, this.RECORD_FREQ);
        this.addVariablesFromARobot(robot);
        this.myDataBuffer.fillBuffer();
        this.updateRobots(this.robots);
    }

    private void updateRobots(Robot[] robots) {
        if (robots != null) {
            for (Robot robot : robots) {
                robot.update();
            }
        }
    }

    private void addVariablesFromARobot(Robot robot) {
        this.myDataBuffer.addVariables(robot.getRobotsYoRegistry().collectSubtreeVariables());
        this.myCombinedVarList.addAll((Collection)robot.getRobotsYoRegistry().collectSubtreeVariables());
    }

    public YoBuffer getDataBuffer() {
        return this.myDataBuffer;
    }

    public Robot[] getRobots() {
        return this.robots;
    }

    public YoVariableList getCombinedVarList() {
        return this.myCombinedVarList;
    }

    public synchronized void setSimulateDoneCriterion(SimulationDoneCriterion criterion) {
        if (criterion == null) {
            return;
        }
        if (this.simulateDoneCriterions == null) {
            this.simulateDoneCriterions = new ArrayList<SimulationDoneCriterion>();
        }
        this.simulateDoneCriterions.add(criterion);
    }

    public synchronized void addSimulateDoneListener(SimulationDoneListener listener) {
        this.simulateDoneListeners.add(listener);
    }

    public synchronized void removeSimulateDoneListener(SimulationDoneListener listener) {
        this.simulateDoneListeners.remove(listener);
    }

    public void notifySimulateDoneListeners() {
        for (int i = 0; i < this.simulateDoneListeners.size(); ++i) {
            this.simulateDoneListeners.get(i).simulationDone();
        }
    }

    public void notifySimulateDoneListenersOfException(Throwable throwable) {
        for (int i = 0; i < this.simulateDoneListeners.size(); ++i) {
            this.simulateDoneListeners.get(i).simulationDoneWithException(throwable);
        }
    }

    public boolean checkSimulateDoneCriterion() {
        if (this.simulateDoneCriterions == null) {
            return false;
        }
        for (int i = 0; i < this.simulateDoneCriterions.size(); ++i) {
            if (!this.simulateDoneCriterions.get(i).isSimulationDone()) continue;
            return true;
        }
        return false;
    }

    protected void simulate() throws UnreasonableAccelerationException {
        this.mySimulator.simulate();
    }

    public synchronized void simulate(int numTicks) throws UnreasonableAccelerationException {
        int i;
        while (numTicks > 0) {
            for (i = 0; i < this.RECORD_FREQ; ++i) {
                this.mySimulator.simulate();
                if (!this.checkSimulateDoneCriterion()) continue;
                numTicks = -1;
            }
            this.myDataBuffer.tickAndWriteIntoBuffer();
            numTicks -= this.RECORD_FREQ;
        }
        for (i = 0; i < this.simulateDoneListeners.size(); ++i) {
            this.simulateDoneListeners.get(i).simulationDone();
        }
    }

    protected void doControl() {
        this.mySimulator.doControl();
    }

    protected void doDynamicsAndIntegrate() throws UnreasonableAccelerationException {
        this.mySimulator.doDynamicsAndIntegrate();
    }

    protected void forceClassLoading() {
        this.mySimulator.forceClassLoading();
    }

    public void tickAndUpdate() {
        this.myDataBuffer.tickAndWriteIntoBuffer();
    }

    public synchronized void simulate(double simulationTime) throws UnreasonableAccelerationException {
        this.simulate((int)(simulationTime / this.mySimulator.getDT()));
    }

    public void setupSimulationGraphics(List<GraphicsRobot> graphicsRobotsToUpdate) {
        if (this.robots.length > 0) {
            GroundContactModel groundContactModel = this.robots[0].getGroundContactModel();
            Object heightMap = null;
            if (groundContactModel != null) {
                heightMap = HeightMapFromGroundContactModel.getHeightMap(groundContactModel);
            }
            if (heightMap == null) {
                heightMap = new FlatGroundProfile();
            }
            this.myGraphics = SupportedGraphics3DAdapter.instantiateDefaultGraphicsAdapter(true);
            this.myGraphics.setHeightMap(heightMap);
            for (GraphicsRobot graphicsRobot : graphicsRobotsToUpdate) {
                this.myGraphics.addRootNode(graphicsRobot.getRootNode());
            }
        }
    }

    public Graphics3DAdapter getSimulationGraphics() {
        return this.myGraphics;
    }

    public void addVarList(YoVariableList newVarList) {
        this.myCombinedVarList.addAll((Collection)newVarList);
        this.myDataBuffer.addVariables(newVarList.getVariables());
    }

    public SimulationSynchronizer getSimulationSynchronizer() {
        return this.simulationSynchronizer;
    }

    public void initializeShapeCollision(CollisionManager collisionManager) {
        collisionManager.createCollisionShapesFromRobots(this.robots);
        collisionManager.setUpEnvironment();
        DoNothingCollisionArbiter collisionArbiter = new DoNothingCollisionArbiter();
        this.initPhysics(new ScsPhysics(null, collisionManager.getCollisionDetector(), collisionArbiter, collisionManager.getCollisionHandler(), collisionManager.getCollisionVisualizer()));
    }
}

