/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.simulationconstructionset.FunctionToIntegrate;
import us.ihmc.yoVariables.variable.YoDouble;

public class FunctionIntegrator {
    private FunctionToIntegrate function;
    private double[] q_n;
    private double[][] k;
    private int vectorSize;
    private double[] tempDerivative;
    private YoDouble[] outputs;

    public FunctionIntegrator(FunctionToIntegrate function) {
        this.function = function;
        this.vectorSize = function.getVectorSize();
        this.q_n = new double[this.vectorSize];
        this.k = new double[4][this.vectorSize];
        this.outputs = function.getOutputVariables();
    }

    public void saveTempState() {
        for (int i = 0; i < this.vectorSize; ++i) {
            this.q_n[i] = this.outputs[i].getDoubleValue();
        }
    }

    public void doDynamics(int passNumber) {
        this.tempDerivative = this.function.computeDerivativeVector();
        for (int i = 0; i < this.vectorSize; ++i) {
            this.k[passNumber][i] = this.tempDerivative[i];
        }
    }

    public void restoreTempState() {
        for (int i = 0; i < this.vectorSize; ++i) {
            this.outputs[i].set(this.q_n[i]);
        }
    }

    public void eulerIntegrate(double stepSize) {
        for (int i = 0; i < this.vectorSize; ++i) {
            this.outputs[i].set(this.outputs[i].getDoubleValue() + stepSize * this.tempDerivative[i]);
        }
    }

    public void rungeKuttaSum(double stepSize) {
        for (int i = 0; i < this.vectorSize; ++i) {
            this.outputs[i].set(this.q_n[i] + stepSize * (this.k[0][i] / 6.0 + this.k[1][i] / 3.0 + this.k[2][i] / 3.0 + this.k[3][i] / 6.0));
        }
    }
}

