/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;

public class CylinderShapeDescription<T extends CylinderShapeDescription<T>>
implements CollisionShapeDescription<T> {
    private double smoothingRadius = 0.0;
    private final Cylinder3D cylinder3d;
    private final Vector3D orthogonalComponent = new Vector3D();

    public CylinderShapeDescription(double radius, double height) {
        this.cylinder3d = new Cylinder3D(height, radius);
    }

    public double getRadius() {
        return this.cylinder3d.getRadius();
    }

    public double getHeight() {
        return this.cylinder3d.getLength();
    }

    public void set(CylinderShapeDescription<T> other) {
        this.smoothingRadius = other.smoothingRadius;
        this.cylinder3d.set(other.cylinder3d);
    }

    @Override
    public CylinderShapeDescription<T> copy() {
        CylinderShapeDescription<T> copy = new CylinderShapeDescription<T>(this.cylinder3d.getRadius(), this.cylinder3d.getLength());
        copy.set(copy);
        return copy;
    }

    public double getSmoothingRadius() {
        return this.smoothingRadius;
    }

    @Override
    public void applyTransform(RigidBodyTransform transformToWorld) {
        this.cylinder3d.applyTransform((Transform)transformToWorld);
    }

    @Override
    public void setFrom(T cylinder) {
        this.cylinder3d.set(((CylinderShapeDescription)cylinder).getSupportingVertexHolder());
    }

    public Cylinder3D getSupportingVertexHolder() {
        return this.cylinder3d;
    }

    public void getProjection(Point3D pointToProject, Point3D closestPointOnCylinderToPack) {
        closestPointOnCylinderToPack.set(pointToProject);
        this.cylinder3d.orthogonalProjection((Point3DBasics)closestPointOnCylinderToPack);
    }

    @Override
    public void getBoundingBox(BoundingBox3D boundingBoxToPack) {
        boundingBoxToPack.set(this.cylinder3d.getBoundingBox());
    }

    @Override
    public boolean isPointInside(Point3D pointInWorld) {
        return this.cylinder3d.distance((Point3DReadOnly)pointInWorld) <= this.smoothingRadius;
    }

    @Override
    public boolean rollContactIfRolling(Vector3D surfaceNormal, Point3D pointToRoll) {
        return this.projectToBottomOfCurvedSurface((Vector3DReadOnly)surfaceNormal, (Point3DBasics)pointToRoll);
    }

    public boolean projectToBottomOfCurvedSurface(Vector3DReadOnly surfaceNormal, Point3DBasics pointToProject) {
        double normalDot = surfaceNormal.dot((Tuple3DReadOnly)this.cylinder3d.getAxis());
        this.orthogonalComponent.scaleAdd(-normalDot, (Tuple3DReadOnly)this.cylinder3d.getAxis(), (Tuple3DReadOnly)surfaceNormal);
        boolean wasRolling = Math.abs(this.orthogonalComponent.getX()) >= 1.0E-7 || Math.abs(this.orthogonalComponent.getY()) >= 1.0E-7;
        this.orthogonalComponent.normalize();
        double positionAlongAxis = EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)this.cylinder3d.getPosition(), (Vector3DReadOnly)this.cylinder3d.getAxis());
        pointToProject.set((Tuple3DReadOnly)this.cylinder3d.getPosition());
        pointToProject.scaleAdd(this.cylinder3d.getRadius(), (Tuple3DReadOnly)this.orthogonalComponent, (Tuple3DReadOnly)pointToProject);
        pointToProject.scaleAdd(positionAlongAxis, (Tuple3DReadOnly)this.cylinder3d.getAxis(), (Tuple3DReadOnly)pointToProject);
        return wasRolling;
    }
}

