/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.torqueSpeedCurve;

import us.ihmc.commons.MathTools;
import us.ihmc.simulationconstructionset.torqueSpeedCurve.TorqueSpeedCurve;

public class TypicalTorqueSpeedCurve
implements TorqueSpeedCurve {
    private double maxSpeed;
    private double maxTorque;
    private double maxSpeedAtMaxTorque;

    public TypicalTorqueSpeedCurve() {
    }

    public TypicalTorqueSpeedCurve(double maxSpeed, double maxTorque, double maxSpeedAtMaxTorque) {
        this.maxSpeed = maxSpeed;
        this.maxTorque = maxTorque;
        this.maxSpeedAtMaxTorque = maxSpeedAtMaxTorque;
    }

    public void setMaxSpeed(double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public void setMaxTorque(double maxTorque) {
        this.maxTorque = maxTorque;
    }

    public void setMaxSpeedAtMaxTorque(double maxSpeedAtMaxTorque) {
        this.maxSpeedAtMaxTorque = maxSpeedAtMaxTorque;
    }

    @Override
    public double limitTorque(double torque, double speed) {
        if (speed < 0.0 && torque > 0.0) {
            return Math.min(torque, this.maxTorque);
        }
        if (speed > 0.0 && torque < 0.0) {
            return Math.max(torque, -this.maxTorque);
        }
        double absoluteSpeed = Math.abs(speed);
        if (absoluteSpeed > this.maxSpeed) {
            return 0.0;
        }
        if (absoluteSpeed < this.maxSpeedAtMaxTorque) {
            return MathTools.clamp((double)torque, (double)(-this.maxTorque), (double)this.maxTorque);
        }
        double percent = 1.0 - (absoluteSpeed - this.maxSpeedAtMaxTorque) / (this.maxSpeed - this.maxSpeedAtMaxTorque);
        double maxScaledTorque = percent * this.maxTorque;
        return MathTools.clamp((double)torque, (double)(-maxScaledTorque), (double)maxScaledTorque);
    }
}

