/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfigurationList;
import us.ihmc.simulationconstructionset.ExtraPanelConfiguration;
import us.ihmc.simulationconstructionset.commands.AllCommandsExecutor;
import us.ihmc.simulationconstructionset.commands.SelectGUIConfigFromFileCommandExecutor;
import us.ihmc.simulationconstructionset.commands.SelectGraphConfigurationCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ZoomGraphCommandExecutor;
import us.ihmc.simulationconstructionset.gui.ActiveCameraHolder;
import us.ihmc.simulationconstructionset.gui.DollyCheckBox;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.ExitActionListenerNotifier;
import us.ihmc.simulationconstructionset.gui.GUIConfigurationSaveAndLoad;
import us.ihmc.simulationconstructionset.gui.TrackCheckBox;
import us.ihmc.simulationconstructionset.gui.actions.AddCameraKeyAction;
import us.ihmc.simulationconstructionset.gui.actions.AddKeyPointAction;
import us.ihmc.simulationconstructionset.gui.actions.CreateNewGraphWindowAction;
import us.ihmc.simulationconstructionset.gui.actions.CreateNewViewportWindowAction;
import us.ihmc.simulationconstructionset.gui.actions.CreateYoVariableSliderWindowAction;
import us.ihmc.simulationconstructionset.gui.actions.CropBufferAction;
import us.ihmc.simulationconstructionset.gui.actions.CutBufferAction;
import us.ihmc.simulationconstructionset.gui.actions.GotoInPointAction;
import us.ihmc.simulationconstructionset.gui.actions.GotoOutPointAction;
import us.ihmc.simulationconstructionset.gui.actions.HideShowViewportAction;
import us.ihmc.simulationconstructionset.gui.actions.NextCameraKeyAction;
import us.ihmc.simulationconstructionset.gui.actions.PackBufferAction;
import us.ihmc.simulationconstructionset.gui.actions.PlayAction;
import us.ihmc.simulationconstructionset.gui.actions.PreviousCameraKeyAction;
import us.ihmc.simulationconstructionset.gui.actions.RemoveCameraKeyAction;
import us.ihmc.simulationconstructionset.gui.actions.SelectCameraAction;
import us.ihmc.simulationconstructionset.gui.actions.SelectGUIConfigFromFileAction;
import us.ihmc.simulationconstructionset.gui.actions.SetInPointAction;
import us.ihmc.simulationconstructionset.gui.actions.SetOutPointAction;
import us.ihmc.simulationconstructionset.gui.actions.SimulateAction;
import us.ihmc.simulationconstructionset.gui.actions.StepBackwardAction;
import us.ihmc.simulationconstructionset.gui.actions.StepForwardAction;
import us.ihmc.simulationconstructionset.gui.actions.StopAction;
import us.ihmc.simulationconstructionset.gui.actions.ThinBufferAction;
import us.ihmc.simulationconstructionset.gui.actions.ToggleCameraKeyModeAction;
import us.ihmc.simulationconstructionset.gui.actions.ToggleKeyPointModeAction;
import us.ihmc.simulationconstructionset.gui.actions.ZoomInAction;
import us.ihmc.simulationconstructionset.gui.actions.ZoomOutAction;
import us.ihmc.simulationconstructionset.gui.actions.configActions.SelectGraphConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.configActions.SelectGraphGroupAction;
import us.ihmc.simulationconstructionset.gui.actions.configActions.SelectVarGroupAction;
import us.ihmc.simulationconstructionset.gui.actions.configActions.SelectViewportAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.AboutAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.CameraPropertiesAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.DataBufferPropertiesAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ExportDataAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ExportGraphsToFileAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ExportSimulationTo3DMaxAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ExportSnapshotAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ImportDataAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.LoadConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.LoadGraphGroupAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.LoadParametersAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.MediaCaptureAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.OpenH264LicenseAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.PlaybackPropertiesAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.PrintGraphsAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ResizeViewportAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SaveConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SaveGraphConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SaveParametersAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SaveRobotConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SelectEntryBoxGroupAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SelectExtraPanelAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.YoGraphicsPropertiesAction;
import us.ihmc.simulationconstructionset.gui.config.CameraSelector;
import us.ihmc.simulationconstructionset.gui.config.ConfigurationList;
import us.ihmc.simulationconstructionset.gui.config.EntryBoxGroupList;
import us.ihmc.simulationconstructionset.gui.config.EntryBoxGroupSelector;
import us.ihmc.simulationconstructionset.gui.config.ExtraPanelConfigurationList;
import us.ihmc.simulationconstructionset.gui.config.ExtraPanelSelector;
import us.ihmc.simulationconstructionset.gui.config.GraphGroupList;
import us.ihmc.simulationconstructionset.gui.config.GraphGroupSelector;
import us.ihmc.simulationconstructionset.gui.config.VarGroupList;
import us.ihmc.simulationconstructionset.gui.config.VarGroupSelector;
import us.ihmc.simulationconstructionset.gui.config.ViewportConfigurationList;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.AboutDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.AllDialogConstructorsHolder;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.CameraPropertiesDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.DataBufferPropertiesDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportDataDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportGraphsToFileConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportSimulationTo3DMaxDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportSnapshotDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ImportDataDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadGraphGroupDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.MediaCaptureDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.PlaybackPropertiesDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.PrintGraphsDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ResizeViewportDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveGraphConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveRobotConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.YoGraphicsPropertiesDialogConstructor;

public class StandardGUIActions
implements GUIEnablerAndDisabler {
    private ArrayList<AbstractAction> guiActions = new ArrayList();
    private OpenH264LicenseAction openH264LicenseAction;
    private AboutAction aboutAction;
    protected JMenu cameraMenu;
    protected JMenu viewportMenu;
    protected JMenu viewMenu;
    protected JMenu extraPanelsMenu;
    protected JMenu cameraKeysMenu;
    private CameraPropertiesAction cameraPropertiesAction;
    private YoGraphicsPropertiesAction yoGraphicsPropertiesAction;
    private JMenu configurationMenu;
    private CreateNewGraphWindowAction createNewGraphWindowAction;
    private CreateNewViewportWindowAction createNewViewportWindowAction;
    private CreateYoVariableSliderWindowAction createYoVariableSliderWindowAction;
    private CropBufferAction cropBufferAction;
    private PackBufferAction packBufferAction;
    private CutBufferAction cutBufferAction;
    private ThinBufferAction thinBufferAction;
    private DataBufferPropertiesAction dataBufferPropertiesAction;
    private DollyCheckBox dollyCheckBox;
    private JMenu entryBoxGroupsMenu;
    private JMenuItem exitMenuItem;
    private ExportDataAction exportAction;
    private MediaCaptureAction mediaCapture;
    private ExportSnapshotAction exportSnapshotAction;
    private GotoInPointAction goInPointAction;
    private GotoOutPointAction goOutPointAction;
    private JMenu graphGroupsMenu;
    private HideShowViewportAction hideShowViewportAction;
    private AddCameraKeyAction addCameraKeyAction;
    private RemoveCameraKeyAction removeCameraKeyAction;
    private NextCameraKeyAction nextCameraKeyAction;
    private PreviousCameraKeyAction previousCameraKeyAction;
    private ImportDataAction importDataAction;
    private PlayAction playAction;
    private PlaybackPropertiesAction playbackPropertiesAction;
    private PrintGraphsAction printGraphsAction;
    private ExportGraphsToFileAction exportGraphsToFileAction;
    private ResizeViewportAction resizeViewportAction;
    private JMenu runMenu;
    private SaveParametersAction saveParametersAction;
    private LoadParametersAction loadParametersAction;
    private SetInPointAction setInPointAction;
    private AddKeyPointAction setKeyAction;
    private SetOutPointAction setOutPointAction;
    private SaveConfigurationAction saveConfigurationAction;
    private SaveGraphConfigurationAction saveGraphConfigurationAction;
    private LoadGraphGroupAction loadGraphConfigurationAction;
    private LoadConfigurationAction loadConfigurationAction;
    private SaveRobotConfigurationAction saveRobotConfigurationAction;
    private ExportSimulationTo3DMaxAction exportSimulationTo3DMaxAction;
    private SimulateAction simulateAction;
    private StepBackwardAction stepBackwardAction;
    private StepForwardAction stepForwardAction;
    private StopAction stopAction;
    private ToggleKeyPointModeAction toggleKeyPointModeAction;
    private ToggleCameraKeyModeAction toggleCameraKeyModeAction;
    private TrackCheckBox trackCheckBox;
    private JMenu varGroupsMenu;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;

    protected void createMainWindowActions(AllCommandsExecutor allCommandsExecutor, AllDialogConstructorsHolder allDialogConstructorsHolder, ActiveCameraHolder activeCameraHolder) {
        ExportDataDialogConstructor exportDataDialogConstructor = allDialogConstructorsHolder.getExportDataDialogConstructor();
        this.exportAction = new ExportDataAction(exportDataDialogConstructor);
        this.guiActions.add(this.exportAction);
        ImportDataDialogConstructor importDataDialogConstructor = allDialogConstructorsHolder.getImportDataDialogConstructor();
        this.importDataAction = new ImportDataAction(importDataDialogConstructor);
        this.guiActions.add(this.importDataAction);
        MediaCaptureDialogConstructor mediaCaptureDialogConstructor = allDialogConstructorsHolder.getMediaCaptureDialogConstructor();
        this.mediaCapture = new MediaCaptureAction(mediaCaptureDialogConstructor);
        this.guiActions.add(this.mediaCapture);
        ExportSnapshotDialogConstructor exportSnapshotDialogConstructor = allDialogConstructorsHolder.getExportSnapshotDialogConstructor();
        this.exportSnapshotAction = new ExportSnapshotAction(exportSnapshotDialogConstructor);
        this.guiActions.add(this.exportSnapshotAction);
        this.saveParametersAction = new SaveParametersAction(allDialogConstructorsHolder.getSaveParametersConstructor());
        this.guiActions.add(this.saveParametersAction);
        this.loadParametersAction = new LoadParametersAction(allDialogConstructorsHolder.getLoadParametersConstructor());
        this.guiActions.add(this.loadParametersAction);
        this.simulateAction = new SimulateAction(allCommandsExecutor);
        this.guiActions.add(this.simulateAction);
        this.playAction = new PlayAction(allCommandsExecutor);
        this.guiActions.add(this.playAction);
        this.stopAction = new StopAction(allCommandsExecutor);
        this.guiActions.add(this.stopAction);
        this.goInPointAction = new GotoInPointAction(allCommandsExecutor);
        this.guiActions.add(this.goInPointAction);
        this.goOutPointAction = new GotoOutPointAction(allCommandsExecutor);
        this.guiActions.add(this.goOutPointAction);
        this.setInPointAction = new SetInPointAction(allCommandsExecutor);
        this.guiActions.add(this.setInPointAction);
        this.setOutPointAction = new SetOutPointAction(allCommandsExecutor);
        this.guiActions.add(this.setOutPointAction);
        this.stepForwardAction = new StepForwardAction(allCommandsExecutor);
        this.guiActions.add(this.stepForwardAction);
        this.stepBackwardAction = new StepBackwardAction(allCommandsExecutor);
        this.guiActions.add(this.stepBackwardAction);
        PlaybackPropertiesDialogConstructor playbackPropertiesDialogConstructor = allDialogConstructorsHolder.getPlaybackPropertiesDialogConstructor();
        this.playbackPropertiesAction = new PlaybackPropertiesAction(playbackPropertiesDialogConstructor);
        this.guiActions.add(this.playbackPropertiesAction);
        SaveConfigurationDialogConstructor saveConfigurationDialogConstructor = allDialogConstructorsHolder.getSaveConfigurationDialogConstructor();
        this.saveConfigurationAction = new SaveConfigurationAction(saveConfigurationDialogConstructor);
        this.guiActions.add(this.saveConfigurationAction);
        LoadConfigurationDialogConstructor loadConfigurationDialogConstructor = allDialogConstructorsHolder.getLoadConfigurationDialogConstructor();
        this.loadConfigurationAction = new LoadConfigurationAction(loadConfigurationDialogConstructor);
        this.guiActions.add(this.loadConfigurationAction);
        SaveGraphConfigurationDialogConstructor saveGraphConfigurationDialogConstructor = allDialogConstructorsHolder.getSaveGraphConfigurationDialogConstructor();
        this.saveGraphConfigurationAction = new SaveGraphConfigurationAction(saveGraphConfigurationDialogConstructor);
        this.guiActions.add(this.saveGraphConfigurationAction);
        LoadGraphGroupDialogConstructor loadGraphGroupDialogConstructor = allDialogConstructorsHolder.getLoadGraphGroupDialogConstructor();
        this.loadGraphConfigurationAction = new LoadGraphGroupAction(loadGraphGroupDialogConstructor);
        this.guiActions.add(this.loadGraphConfigurationAction);
        SaveRobotConfigurationDialogConstructor saveRobotConfigurationDialogConstructor = allDialogConstructorsHolder.getSaveRobotConfigurationDialogConstructor();
        this.saveRobotConfigurationAction = new SaveRobotConfigurationAction(saveRobotConfigurationDialogConstructor);
        this.guiActions.add(this.saveRobotConfigurationAction);
        ExportSimulationTo3DMaxDialogConstructor exportSimulationTo3DMaxDialogConstructor = allDialogConstructorsHolder.getExportSimulationTo3DMaxDialogConstructor();
        this.exportSimulationTo3DMaxAction = new ExportSimulationTo3DMaxAction(exportSimulationTo3DMaxDialogConstructor);
        this.guiActions.add(this.exportSimulationTo3DMaxAction);
        this.zoomInAction = new ZoomInAction(allCommandsExecutor);
        this.guiActions.add(this.zoomInAction);
        this.zoomOutAction = new ZoomOutAction(allCommandsExecutor);
        this.guiActions.add(this.zoomOutAction);
        PrintGraphsDialogConstructor printGraphsDialogConstructor = allDialogConstructorsHolder.getPrintGraphsDialogConstructor();
        this.printGraphsAction = new PrintGraphsAction(printGraphsDialogConstructor);
        this.guiActions.add(this.printGraphsAction);
        this.exportGraphsToFileAction = new ExportGraphsToFileAction(allDialogConstructorsHolder.getExportGraphsToFileConstructor());
        this.guiActions.add(this.exportGraphsToFileAction);
        this.cropBufferAction = new CropBufferAction(allCommandsExecutor);
        this.guiActions.add(this.cropBufferAction);
        this.packBufferAction = new PackBufferAction(allCommandsExecutor);
        this.guiActions.add(this.packBufferAction);
        this.cutBufferAction = new CutBufferAction(allCommandsExecutor);
        this.guiActions.add(this.cutBufferAction);
        this.thinBufferAction = new ThinBufferAction(allCommandsExecutor);
        this.guiActions.add(this.thinBufferAction);
        DataBufferPropertiesDialogConstructor dataBufferPropertiesDialogConstructor = allDialogConstructorsHolder.getDataBufferPropertiesDialogConstructor();
        this.dataBufferPropertiesAction = new DataBufferPropertiesAction(dataBufferPropertiesDialogConstructor);
        this.guiActions.add(this.dataBufferPropertiesAction);
        this.toggleKeyPointModeAction = new ToggleKeyPointModeAction(allCommandsExecutor);
        this.guiActions.add(this.toggleKeyPointModeAction);
        this.setKeyAction = new AddKeyPointAction(allCommandsExecutor);
        this.guiActions.add(this.setKeyAction);
        this.trackCheckBox = new TrackCheckBox(activeCameraHolder);
        this.trackCheckBox.setRequestFocusEnabled(false);
        this.dollyCheckBox = new DollyCheckBox(activeCameraHolder);
        this.dollyCheckBox.setRequestFocusEnabled(false);
        CameraPropertiesDialogConstructor cameraPropertiesDialogConstructor = allDialogConstructorsHolder.getCameraPropertiesDialogConstructor();
        this.cameraPropertiesAction = new CameraPropertiesAction(cameraPropertiesDialogConstructor, this.trackCheckBox, this.dollyCheckBox);
        this.guiActions.add(this.cameraPropertiesAction);
        YoGraphicsPropertiesDialogConstructor yoGraphicsPropertiesDialogConstructor = allDialogConstructorsHolder.getYoGraphicsPropertiesDialogConstructor();
        this.yoGraphicsPropertiesAction = new YoGraphicsPropertiesAction(yoGraphicsPropertiesDialogConstructor);
        this.guiActions.add(this.yoGraphicsPropertiesAction);
        this.hideShowViewportAction = new HideShowViewportAction(allCommandsExecutor);
        this.guiActions.add(this.hideShowViewportAction);
        this.createNewGraphWindowAction = new CreateNewGraphWindowAction(allCommandsExecutor);
        this.guiActions.add(this.createNewGraphWindowAction);
        this.createNewViewportWindowAction = new CreateNewViewportWindowAction(allCommandsExecutor);
        this.guiActions.add(this.createNewViewportWindowAction);
        this.createYoVariableSliderWindowAction = new CreateYoVariableSliderWindowAction(allCommandsExecutor);
        this.guiActions.add(this.createYoVariableSliderWindowAction);
        AboutDialogConstructor aboutDialogConstructor = allDialogConstructorsHolder.getAboutDialogConstructor();
        this.aboutAction = new AboutAction(aboutDialogConstructor);
        this.openH264LicenseAction = new OpenH264LicenseAction();
        this.guiActions.add(this.aboutAction);
        this.guiActions.add(this.openH264LicenseAction);
    }

    protected void createViewportWindowActions(StandardGUIActions actions, ExportSnapshotDialogConstructor exportSnapshotDialogConstructor, MediaCaptureDialogConstructor mediaCaptureDialogConstructor, CameraPropertiesDialogConstructor cameraPropertiesDialogConstructor, ResizeViewportDialogConstructor resizeViewportDialogConstructor, ActiveCameraHolder activeCameraHolder, ViewportSelectorCommandExecutor viewportSelector) {
        this.exportAction = actions.exportAction;
        this.guiActions.add(this.exportAction);
        this.importDataAction = actions.importDataAction;
        this.guiActions.add(this.importDataAction);
        this.exportSnapshotAction = new ExportSnapshotAction(exportSnapshotDialogConstructor);
        this.guiActions.add(this.exportSnapshotAction);
        this.mediaCapture = new MediaCaptureAction(mediaCaptureDialogConstructor);
        this.guiActions.add(this.mediaCapture);
        this.simulateAction = actions.simulateAction;
        this.guiActions.add(this.simulateAction);
        this.playAction = actions.playAction;
        this.guiActions.add(this.playAction);
        this.stopAction = actions.stopAction;
        this.guiActions.add(this.stopAction);
        this.goInPointAction = actions.goInPointAction;
        this.guiActions.add(this.goInPointAction);
        this.goOutPointAction = actions.goOutPointAction;
        this.guiActions.add(this.goOutPointAction);
        this.setInPointAction = actions.setInPointAction;
        this.guiActions.add(this.setInPointAction);
        this.setOutPointAction = actions.setOutPointAction;
        this.guiActions.add(this.setOutPointAction);
        this.stepForwardAction = actions.stepForwardAction;
        this.guiActions.add(this.stepForwardAction);
        this.stepBackwardAction = actions.stepBackwardAction;
        this.guiActions.add(this.stepBackwardAction);
        this.playbackPropertiesAction = actions.playbackPropertiesAction;
        this.guiActions.add(this.playbackPropertiesAction);
        this.trackCheckBox = new TrackCheckBox(activeCameraHolder);
        this.trackCheckBox.setRequestFocusEnabled(false);
        this.dollyCheckBox = new DollyCheckBox(activeCameraHolder);
        this.dollyCheckBox.setRequestFocusEnabled(false);
        this.cameraPropertiesAction = new CameraPropertiesAction(cameraPropertiesDialogConstructor, this.trackCheckBox, this.dollyCheckBox);
        this.guiActions.add(this.cameraPropertiesAction);
        this.yoGraphicsPropertiesAction = actions.yoGraphicsPropertiesAction;
        this.guiActions.add(this.yoGraphicsPropertiesAction);
        this.hideShowViewportAction = new HideShowViewportAction(viewportSelector);
        this.guiActions.add(this.hideShowViewportAction);
        this.resizeViewportAction = new ResizeViewportAction(resizeViewportDialogConstructor);
        this.guiActions.add(this.resizeViewportAction);
        this.createNewGraphWindowAction = actions.createNewGraphWindowAction;
        this.guiActions.add(this.createNewGraphWindowAction);
        this.createNewViewportWindowAction = actions.createNewViewportWindowAction;
        this.guiActions.add(this.createNewViewportWindowAction);
        this.loadParametersAction = actions.loadParametersAction;
        this.guiActions.add(this.loadParametersAction);
        this.saveParametersAction = actions.saveParametersAction;
        this.guiActions.add(this.saveParametersAction);
    }

    public void createVideoExportActions(StandardGUIActions actions, ActiveCameraHolder activeCameraHolder) {
        this.simulateAction = actions.simulateAction;
        this.guiActions.add(this.simulateAction);
        this.playAction = actions.playAction;
        this.guiActions.add(this.playAction);
        this.stopAction = actions.stopAction;
        this.guiActions.add(this.stopAction);
        this.goInPointAction = actions.goInPointAction;
        this.guiActions.add(this.goInPointAction);
        this.goOutPointAction = actions.goOutPointAction;
        this.guiActions.add(this.goOutPointAction);
        this.setInPointAction = actions.setInPointAction;
        this.guiActions.add(this.setInPointAction);
        this.setOutPointAction = actions.setOutPointAction;
        this.guiActions.add(this.setOutPointAction);
        this.stepForwardAction = actions.stepForwardAction;
        this.guiActions.add(this.stepForwardAction);
        this.stepBackwardAction = actions.stepBackwardAction;
        this.guiActions.add(this.stepBackwardAction);
        this.playbackPropertiesAction = actions.playbackPropertiesAction;
        this.guiActions.add(this.playbackPropertiesAction);
        this.trackCheckBox = new TrackCheckBox(activeCameraHolder);
        this.trackCheckBox.setRequestFocusEnabled(false);
        this.dollyCheckBox = new DollyCheckBox(activeCameraHolder);
        this.dollyCheckBox.setRequestFocusEnabled(false);
        this.toggleKeyPointModeAction = actions.toggleKeyPointModeAction;
        this.guiActions.add(this.toggleKeyPointModeAction);
        this.setKeyAction = actions.setKeyAction;
        this.guiActions.add(this.setKeyAction);
    }

    protected void createGraphWindowActions(StandardGUIActions actions, ZoomGraphCommandExecutor zoomGraphCommandExecutor, SaveGraphConfigurationDialogConstructor saveGraphConfigurationDialogConstructor, LoadGraphGroupDialogConstructor loadGraphGroupDialogConstructor, PrintGraphsDialogConstructor printGraphsDialogConstructor, ExportGraphsToFileConstructor exportGraphsToFileConstructor) {
        this.exportAction = actions.exportAction;
        this.guiActions.add(this.exportAction);
        this.importDataAction = actions.importDataAction;
        this.guiActions.add(this.importDataAction);
        this.simulateAction = actions.simulateAction;
        this.guiActions.add(this.simulateAction);
        this.playAction = actions.playAction;
        this.guiActions.add(this.playAction);
        this.stopAction = actions.stopAction;
        this.guiActions.add(this.stopAction);
        this.goInPointAction = actions.goInPointAction;
        this.guiActions.add(this.goInPointAction);
        this.goOutPointAction = actions.goOutPointAction;
        this.guiActions.add(this.goOutPointAction);
        this.setInPointAction = actions.setInPointAction;
        this.guiActions.add(this.setInPointAction);
        this.setOutPointAction = actions.setOutPointAction;
        this.guiActions.add(this.setOutPointAction);
        this.stepForwardAction = actions.stepForwardAction;
        this.guiActions.add(this.stepForwardAction);
        this.stepBackwardAction = actions.stepBackwardAction;
        this.guiActions.add(this.stepBackwardAction);
        this.playbackPropertiesAction = actions.playbackPropertiesAction;
        this.guiActions.add(this.playbackPropertiesAction);
        this.toggleKeyPointModeAction = actions.toggleKeyPointModeAction;
        this.guiActions.add(this.toggleKeyPointModeAction);
        this.setKeyAction = actions.setKeyAction;
        this.guiActions.add(this.setKeyAction);
        this.saveGraphConfigurationAction = new SaveGraphConfigurationAction(saveGraphConfigurationDialogConstructor);
        this.guiActions.add(this.saveGraphConfigurationAction);
        this.loadGraphConfigurationAction = new LoadGraphGroupAction(loadGraphGroupDialogConstructor);
        this.guiActions.add(this.loadGraphConfigurationAction);
        this.zoomInAction = new ZoomInAction(zoomGraphCommandExecutor);
        this.guiActions.add(this.zoomInAction);
        this.zoomOutAction = new ZoomOutAction(zoomGraphCommandExecutor);
        this.guiActions.add(this.zoomOutAction);
        this.printGraphsAction = new PrintGraphsAction(printGraphsDialogConstructor);
        this.guiActions.add(this.printGraphsAction);
        this.exportGraphsToFileAction = new ExportGraphsToFileAction(exportGraphsToFileConstructor);
        this.guiActions.add(this.exportGraphsToFileAction);
        this.cropBufferAction = actions.cropBufferAction;
        this.guiActions.add(this.cropBufferAction);
        this.packBufferAction = actions.packBufferAction;
        this.guiActions.add(this.packBufferAction);
        this.cutBufferAction = actions.cutBufferAction;
        this.guiActions.add(this.cutBufferAction);
        this.thinBufferAction = actions.thinBufferAction;
        this.guiActions.add(this.thinBufferAction);
        this.dataBufferPropertiesAction = actions.dataBufferPropertiesAction;
        this.guiActions.add(this.dataBufferPropertiesAction);
        this.createNewGraphWindowAction = actions.createNewGraphWindowAction;
        this.guiActions.add(this.createNewGraphWindowAction);
        this.createNewViewportWindowAction = actions.createNewViewportWindowAction;
        this.guiActions.add(this.createNewViewportWindowAction);
        this.loadParametersAction = actions.loadParametersAction;
        this.guiActions.add(this.loadParametersAction);
        this.saveParametersAction = actions.saveParametersAction;
        this.guiActions.add(this.saveParametersAction);
    }

    protected JPanel createWindowButtons(Action[][] allActions, JToolBar[] toolBars, boolean trackAndDolly) {
        for (int j = 0; j < allActions.length; ++j) {
            Action[] actions = allActions[j];
            toolBars[j] = new JToolBar();
            toolBars[j].setBorderPainted(true);
            toolBars[j].setFloatable(false);
            Action[] actionArray = actions;
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                Action action = actionArray[i];
                if (action.getValue("SmallIcon") == null) continue;
                JButton button = toolBars[j].add(action);
                String name = (String)action.getValue("Name");
                button.setName(name);
                button.setToolTipText(name);
            }
        }
        JPanel buttonPanel = new JPanel(new FlowLayout());
        for (JToolBar toolBar : toolBars) {
            buttonPanel.add(toolBar);
        }
        if (trackAndDolly) {
            buttonPanel.add(this.trackCheckBox);
            buttonPanel.add(this.dollyCheckBox);
        }
        return buttonPanel;
    }

    protected JPanel createMainWindowButtons() {
        Action[] fileActions = new Action[]{this.mediaCapture, this.exportSnapshotAction};
        Action[] runActions = new Action[]{this.simulateAction, this.playAction, this.stopAction};
        Action[] stepActions = new Action[]{this.setInPointAction, this.goInPointAction, this.stepBackwardAction, this.stepForwardAction, this.goOutPointAction, this.setOutPointAction};
        Action[] keyActions = new Action[]{this.setKeyAction, this.toggleKeyPointModeAction};
        Action[] playbackPropertiesActions = new Action[]{};
        Action[] graphsActions = new Action[]{this.zoomInAction, this.zoomOutAction};
        Action[] cameraActions = new Action[]{};
        Action[] windowActions = new Action[]{};
        Action[] helpActions = new Action[]{};
        Action[][] allActions = new Action[][]{fileActions, runActions, stepActions, keyActions, playbackPropertiesActions, graphsActions, cameraActions, windowActions, helpActions};
        JToolBar[] toolBars = new JToolBar[allActions.length];
        return this.createWindowButtons(allActions, toolBars, true);
    }

    private JMenu createParameterMenu() {
        JMenu parameterMenu = new JMenu("Parameters");
        parameterMenu.setName("Parameters");
        parameterMenu.setMnemonic('p');
        parameterMenu.add(this.saveParametersAction);
        parameterMenu.add(this.loadParametersAction);
        return parameterMenu;
    }

    protected JMenuBar createMainWindowMenus(final ExitActionListenerNotifier exitActionListenerNotifier) {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setName("File");
        fileMenu.setMnemonic('f');
        menuBar.add(fileMenu);
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                exitActionListenerNotifier.notifyExitActionListeners();
            }
        });
        fileMenu.add(this.exportAction);
        fileMenu.add(this.importDataAction);
        fileMenu.addSeparator();
        fileMenu.add(this.mediaCapture);
        fileMenu.add(this.exportSnapshotAction);
        fileMenu.addSeparator();
        fileMenu.add(this.exitMenuItem);
        this.runMenu = new JMenu("Run");
        this.runMenu.setName("Run");
        this.runMenu.setMnemonic('r');
        menuBar.add(this.runMenu);
        this.runMenu.add(this.simulateAction);
        this.runMenu.add(this.playAction);
        this.runMenu.add(this.stopAction);
        this.runMenu.addSeparator();
        this.runMenu.add(this.goInPointAction);
        this.runMenu.add(this.goOutPointAction);
        this.runMenu.add(this.setInPointAction);
        this.runMenu.add(this.setOutPointAction);
        this.runMenu.addSeparator();
        this.runMenu.add(this.stepForwardAction);
        this.runMenu.add(this.stepBackwardAction);
        this.runMenu.addSeparator();
        this.runMenu.add(this.playbackPropertiesAction);
        this.configurationMenu = new JMenu("Configuration");
        this.configurationMenu.setName("Configuration");
        this.configurationMenu.setMnemonic('o');
        menuBar.add(this.configurationMenu);
        this.varGroupsMenu = new JMenu("VarGroups");
        this.varGroupsMenu.setName("VarGroups");
        this.varGroupsMenu.setName("VarGroups");
        this.varGroupsMenu.setMnemonic('v');
        this.configurationMenu.add(this.varGroupsMenu);
        this.graphGroupsMenu = new JMenu("GraphGroups");
        this.graphGroupsMenu.setName("GraphGroups");
        this.graphGroupsMenu.setMnemonic('g');
        this.configurationMenu.add(this.graphGroupsMenu);
        this.entryBoxGroupsMenu = new JMenu("EntryBoxGroups");
        this.entryBoxGroupsMenu.setName("EntryBoxGroups");
        this.graphGroupsMenu.setMnemonic('e');
        this.configurationMenu.add(this.entryBoxGroupsMenu);
        this.configurationMenu.addSeparator();
        this.configurationMenu.add(this.saveConfigurationAction);
        this.configurationMenu.add(this.loadConfigurationAction);
        this.configurationMenu.add(this.saveRobotConfigurationAction);
        this.configurationMenu.add(this.exportSimulationTo3DMaxAction);
        JMenu graphsMenu = new JMenu("Graphs");
        graphsMenu.setName("Graphs");
        graphsMenu.setMnemonic('g');
        menuBar.add(graphsMenu);
        graphsMenu.add(this.zoomInAction);
        graphsMenu.add(this.zoomOutAction);
        graphsMenu.addSeparator();
        graphsMenu.add(this.printGraphsAction);
        graphsMenu.add(this.exportGraphsToFileAction);
        JMenu dataBufferMenu = new JMenu("Data Buffer");
        dataBufferMenu.setName("Data Buffer");
        dataBufferMenu.setMnemonic('d');
        menuBar.add(dataBufferMenu);
        dataBufferMenu.add(this.cropBufferAction);
        dataBufferMenu.add(this.packBufferAction);
        dataBufferMenu.add(this.cutBufferAction);
        dataBufferMenu.add(this.thinBufferAction);
        dataBufferMenu.add(this.dataBufferPropertiesAction);
        this.viewportMenu = new JMenu("Viewport");
        this.viewportMenu.setName("Viewport");
        this.viewportMenu.setMnemonic('v');
        this.viewportMenu.add(this.cameraPropertiesAction);
        this.viewportMenu.add(this.yoGraphicsPropertiesAction);
        this.viewportMenu.add(this.hideShowViewportAction);
        this.cameraMenu = new JMenu("Camera");
        this.cameraMenu.setName("Camera");
        this.cameraMenu.setMnemonic('c');
        this.viewportMenu.add(this.cameraMenu);
        this.viewMenu = new JMenu("Views");
        this.viewMenu.setName("Views");
        this.viewportMenu.add(this.viewMenu);
        this.extraPanelsMenu = new JMenu("Extra Panels");
        this.extraPanelsMenu.setName("Extra Panels");
        this.viewportMenu.add(this.extraPanelsMenu);
        this.cameraKeysMenu = new JMenu("Camera Keys");
        this.cameraKeysMenu.setName("Camera Keys");
        menuBar.add(this.viewportMenu);
        JMenu windowMenu = new JMenu("Window");
        windowMenu.setName("Window");
        windowMenu.setMnemonic('w');
        windowMenu.add(this.createNewGraphWindowAction);
        windowMenu.add(this.createNewViewportWindowAction);
        windowMenu.add(this.createYoVariableSliderWindowAction);
        menuBar.add(windowMenu);
        menuBar.add(this.createParameterMenu());
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setName("Help");
        helpMenu.setMnemonic('h');
        menuBar.add(helpMenu);
        helpMenu.add(this.openH264LicenseAction);
        helpMenu.add(this.aboutAction);
        return menuBar;
    }

    public JPanel createVideoExportPanelButtons() {
        Action[] fileActions = new Action[]{};
        Action[] runActions = new Action[]{this.playAction, this.stopAction};
        Action[] stepActions = new Action[]{this.goInPointAction, this.stepBackwardAction, this.stepForwardAction, this.goOutPointAction};
        Action[] keyActions = new Action[]{this.setKeyAction, this.toggleKeyPointModeAction};
        Action[] playbackPropertiesActions = new Action[]{};
        Action[] graphsActions = new Action[]{};
        Action[] cameraActions = new Action[]{};
        Action[] windowActions = new Action[]{};
        Action[] helpActions = new Action[]{};
        Action[][] allActions = new Action[][]{fileActions, runActions, stepActions, keyActions, playbackPropertiesActions, graphsActions, cameraActions, windowActions, helpActions};
        JToolBar[] toolBars = new JToolBar[allActions.length];
        return this.createWindowButtons(allActions, toolBars, true);
    }

    protected JPanel createViewportWindowButtons() {
        Action[] fileActions = new Action[]{this.exportAction, this.importDataAction, this.mediaCapture, this.exportSnapshotAction};
        Action[] runActions = new Action[]{this.simulateAction, this.playAction, this.stopAction};
        Action[] stepActions = new Action[]{this.setInPointAction, this.goInPointAction, this.stepBackwardAction, this.stepForwardAction, this.goOutPointAction, this.setOutPointAction};
        Action[] playbackPropertiesActions = new Action[]{};
        Action[] graphsActions = new Action[]{};
        Action[] cameraActions = new Action[]{};
        Action[] windowActions = new Action[]{};
        Action[] helpActions = new Action[]{};
        Action[][] allActions = new Action[][]{fileActions, runActions, stepActions, playbackPropertiesActions, graphsActions, cameraActions, windowActions, helpActions};
        JToolBar[] toolBars = new JToolBar[allActions.length];
        return this.createWindowButtons(allActions, toolBars, true);
    }

    protected JMenuBar createViewportWindowMenus() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        menuBar.add(fileMenu);
        fileMenu.add(this.exportAction);
        fileMenu.add(this.importDataAction);
        fileMenu.addSeparator();
        fileMenu.add(this.mediaCapture);
        fileMenu.add(this.exportSnapshotAction);
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic('r');
        menuBar.add(this.runMenu);
        this.runMenu.add(this.simulateAction);
        this.runMenu.add(this.playAction);
        this.runMenu.add(this.stopAction);
        this.runMenu.addSeparator();
        this.runMenu.add(this.goInPointAction);
        this.runMenu.add(this.goOutPointAction);
        this.runMenu.add(this.setInPointAction);
        this.runMenu.add(this.setOutPointAction);
        this.runMenu.addSeparator();
        this.runMenu.add(this.stepForwardAction);
        this.runMenu.add(this.stepBackwardAction);
        this.runMenu.addSeparator();
        this.runMenu.add(this.playbackPropertiesAction);
        this.viewportMenu = new JMenu("Viewport");
        this.viewportMenu.setMnemonic('v');
        this.viewportMenu.add(this.cameraPropertiesAction);
        this.viewportMenu.add(this.yoGraphicsPropertiesAction);
        this.viewportMenu.add(this.hideShowViewportAction);
        this.viewportMenu.add(this.resizeViewportAction);
        this.cameraMenu = new JMenu("Camera");
        this.cameraMenu.setMnemonic('c');
        this.viewportMenu.add(this.cameraMenu);
        menuBar.add(this.viewportMenu);
        JMenu windowMenu = new JMenu("Window");
        windowMenu.setMnemonic('w');
        windowMenu.add(this.createNewGraphWindowAction);
        windowMenu.add(this.createNewViewportWindowAction);
        menuBar.add(windowMenu);
        menuBar.add(this.createParameterMenu());
        return menuBar;
    }

    protected JPanel createGraphWindowButtons() {
        Action[] fileActions = new Action[]{this.exportAction, this.importDataAction};
        Action[] runActions = new Action[]{this.simulateAction, this.playAction, this.stopAction};
        Action[] stepActions = new Action[]{this.setInPointAction, this.goInPointAction, this.stepBackwardAction, this.stepForwardAction, this.goOutPointAction, this.setOutPointAction};
        Action[] keyActions = new Action[]{this.setKeyAction, this.toggleKeyPointModeAction};
        Action[] playbackPropertiesActions = new Action[]{};
        Action[] graphsActions = new Action[]{this.zoomInAction, this.zoomOutAction, this.printGraphsAction, this.exportGraphsToFileAction};
        Action[] cameraActions = new Action[]{};
        Action[] windowActions = new Action[]{};
        Action[] helpActions = new Action[]{};
        Action[][] allActions = new Action[][]{fileActions, runActions, stepActions, keyActions, playbackPropertiesActions, graphsActions, cameraActions, windowActions, helpActions};
        JToolBar[] toolBars = new JToolBar[allActions.length];
        return this.createWindowButtons(allActions, toolBars, false);
    }

    protected JMenuBar createGraphWindowMenus() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        menuBar.add(fileMenu);
        fileMenu.add(this.exportAction);
        fileMenu.add(this.importDataAction);
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic('r');
        menuBar.add(this.runMenu);
        this.runMenu.add(this.simulateAction);
        this.runMenu.add(this.playAction);
        this.runMenu.add(this.stopAction);
        this.runMenu.addSeparator();
        this.runMenu.add(this.goInPointAction);
        this.runMenu.add(this.goOutPointAction);
        this.runMenu.add(this.setInPointAction);
        this.runMenu.add(this.setOutPointAction);
        this.runMenu.addSeparator();
        this.runMenu.add(this.stepForwardAction);
        this.runMenu.add(this.stepBackwardAction);
        this.runMenu.addSeparator();
        this.runMenu.add(this.playbackPropertiesAction);
        this.configurationMenu = new JMenu("Configuration");
        this.configurationMenu.setMnemonic('o');
        menuBar.add(this.configurationMenu);
        this.graphGroupsMenu = new JMenu("GraphGroups");
        this.graphGroupsMenu.setMnemonic('g');
        this.configurationMenu.add(this.graphGroupsMenu);
        JMenu graphsMenu = new JMenu("Graphs");
        graphsMenu.setMnemonic('g');
        menuBar.add(graphsMenu);
        graphsMenu.add(this.zoomInAction);
        graphsMenu.add(this.zoomOutAction);
        graphsMenu.addSeparator();
        graphsMenu.add(this.printGraphsAction);
        graphsMenu.add(this.exportGraphsToFileAction);
        JMenu dataBufferMenu = new JMenu("Data Buffer");
        dataBufferMenu.setMnemonic('d');
        menuBar.add(dataBufferMenu);
        dataBufferMenu.add(this.cropBufferAction);
        dataBufferMenu.add(this.packBufferAction);
        dataBufferMenu.add(this.cutBufferAction);
        dataBufferMenu.add(this.thinBufferAction);
        dataBufferMenu.add(this.dataBufferPropertiesAction);
        JMenu windowMenu = new JMenu("Window");
        windowMenu.setMnemonic('w');
        menuBar.add(windowMenu);
        windowMenu.add(this.createNewGraphWindowAction);
        windowMenu.add(this.createNewViewportWindowAction);
        menuBar.add(this.createParameterMenu());
        return menuBar;
    }

    protected void setupConfigurationMenu(final ConfigurationList configurationList, final SelectGraphConfigurationCommandExecutor configurationSelector, final SelectGUIConfigFromFileCommandExecutor selectGUIConfigFromFileCommandExecutor) {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardGUIActions.this.setupConfigurationMenuThreadUnsafe(configurationList, configurationSelector, selectGUIConfigFromFileCommandExecutor);
            }
        });
    }

    private void setupConfigurationMenuThreadUnsafe(ConfigurationList configurationList, SelectGraphConfigurationCommandExecutor configurationSelector, SelectGUIConfigFromFileCommandExecutor selectGUIConfigFromFileCommandExecutor) {
        String[] potentialConfigurationFilenames;
        this.configurationMenu.removeAll();
        if (this.saveConfigurationAction != null) {
            this.configurationMenu.add(this.saveConfigurationAction);
        }
        if (this.loadConfigurationAction != null) {
            this.configurationMenu.add(this.loadConfigurationAction);
        }
        if (this.saveGraphConfigurationAction != null) {
            this.configurationMenu.add(this.saveGraphConfigurationAction);
        }
        if (this.loadGraphConfigurationAction != null) {
            this.configurationMenu.add(this.loadGraphConfigurationAction);
        }
        if (this.saveRobotConfigurationAction != null) {
            this.configurationMenu.add(this.saveRobotConfigurationAction);
        }
        if (this.exportSimulationTo3DMaxAction != null) {
            this.configurationMenu.add(this.exportSimulationTo3DMaxAction);
        }
        this.configurationMenu.addSeparator();
        String[] names = configurationList.getConfigurationNames();
        for (int i = 0; i < names.length; ++i) {
            this.configurationMenu.add(new SelectGraphConfigurationAction(configurationSelector, names[i]));
        }
        this.configurationMenu.addSeparator();
        if (this.varGroupsMenu != null) {
            this.configurationMenu.add(this.varGroupsMenu);
        }
        if (this.graphGroupsMenu != null) {
            this.configurationMenu.add(this.graphGroupsMenu);
        }
        if (this.entryBoxGroupsMenu != null) {
            this.configurationMenu.add(this.entryBoxGroupsMenu);
        }
        this.configurationMenu.addSeparator();
        String path = GUIConfigurationSaveAndLoad.getConfigurationDirectoryPath();
        for (String child : potentialConfigurationFilenames = GUIConfigurationSaveAndLoad.getPotentialConfigurationFilenames()) {
            if (!child.endsWith(".guiConf")) continue;
            int index = child.indexOf(".");
            String name = child.substring(0, index);
            this.configurationMenu.add(new SelectGUIConfigFromFileAction(path + "/" + child, name, selectGUIConfigFromFileCommandExecutor));
        }
    }

    protected void setupGraphGroupsMenu(final GraphGroupList graphGroupList, final GraphGroupSelector graphGroupSelector) {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardGUIActions.this.graphGroupsMenu.removeAll();
                Object[] names = graphGroupList.getGraphGroupNames();
                Arrays.sort(names);
                for (Object name : names) {
                    StandardGUIActions.this.graphGroupsMenu.add(new SelectGraphGroupAction(graphGroupSelector, (String)name));
                }
            }
        });
    }

    protected void setupEntryBoxGroupMenu(final EntryBoxGroupList entryBoxGroupList, final EntryBoxGroupSelector entryBoxGroupSelector) {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardGUIActions.this.entryBoxGroupsMenu.removeAll();
                Object[] names = entryBoxGroupList.getEntryBoxGroupNames();
                Arrays.sort(names);
                for (Object name : names) {
                    StandardGUIActions.this.entryBoxGroupsMenu.add(new SelectEntryBoxGroupAction(entryBoxGroupSelector, (String)name));
                }
            }
        });
    }

    protected void setupViewportMenu(AllCommandsExecutor allCommandsExecutor, ViewportConfigurationList viewportConfigurationList, ViewportSelectorCommandExecutor viewportSelector) {
        if (this.viewportMenu == null) {
            this.viewportMenu = new JMenu();
        } else {
            this.viewportMenu.removeAll();
        }
        if (this.viewMenu != null) {
            this.viewMenu.removeAll();
        } else {
            this.viewMenu = new JMenu("Views");
        }
        String[] names = viewportConfigurationList.getViewportConfigurationNames();
        for (int i = 0; i < names.length; ++i) {
            this.viewMenu.add(new SelectViewportAction(viewportSelector, names[i]));
        }
        if (this.cameraMenu == null) {
            this.cameraMenu = new JMenu();
        }
        if (this.extraPanelsMenu == null) {
            // empty if block
        }
        if (this.cameraKeysMenu == null) {
            this.cameraKeysMenu = new JMenu("Camera Keys");
        }
        if (this.addCameraKeyAction == null) {
            this.addCameraKeyAction = new AddCameraKeyAction(allCommandsExecutor);
            this.cameraKeysMenu.add(this.addCameraKeyAction);
        }
        if (this.removeCameraKeyAction == null) {
            this.removeCameraKeyAction = new RemoveCameraKeyAction(allCommandsExecutor);
            this.cameraKeysMenu.add(this.removeCameraKeyAction);
        }
        if (this.nextCameraKeyAction == null) {
            this.nextCameraKeyAction = new NextCameraKeyAction(allCommandsExecutor);
            this.cameraKeysMenu.add(this.nextCameraKeyAction);
        }
        if (this.previousCameraKeyAction == null) {
            this.previousCameraKeyAction = new PreviousCameraKeyAction(allCommandsExecutor);
            this.cameraKeysMenu.add(this.previousCameraKeyAction);
        }
        if (this.toggleCameraKeyModeAction == null) {
            this.toggleCameraKeyModeAction = new ToggleCameraKeyModeAction(allCommandsExecutor);
            this.cameraKeysMenu.add(this.toggleCameraKeyModeAction);
        }
        this.viewportMenu.add(this.viewMenu);
        if (this.extraPanelsMenu != null) {
            this.viewportMenu.add(this.extraPanelsMenu);
        }
        this.viewportMenu.add(this.cameraMenu);
        this.viewportMenu.add(this.cameraPropertiesAction);
        this.viewportMenu.add(this.yoGraphicsPropertiesAction);
        this.viewportMenu.add(this.hideShowViewportAction);
        this.viewportMenu.add(this.cameraKeysMenu);
        if (this.resizeViewportAction != null) {
            this.viewportMenu.add(this.resizeViewportAction);
        }
    }

    protected void setupCameraMenu(CameraConfigurationList cameraConfigurationList, CameraSelector cameraSelector) {
        String[] names;
        this.cameraMenu.removeAll();
        for (String name : names = cameraConfigurationList.getCameraConfigurationNames()) {
            this.cameraMenu.add(new SelectCameraAction(cameraSelector, name));
        }
    }

    protected void setupExtraPanelsMenu(ExtraPanelConfigurationList extraPanelConfigurationList, ExtraPanelSelector panelSelector) {
        this.extraPanelsMenu.removeAll();
        for (ExtraPanelConfiguration extraPanelConfiguration : extraPanelConfigurationList.getConfigurationList()) {
            JCheckBoxMenuItem myItem = new JCheckBoxMenuItem(new SelectExtraPanelAction(panelSelector, extraPanelConfiguration));
            myItem.setSelected(extraPanelConfiguration.showOnStart());
            this.extraPanelsMenu.add(myItem);
        }
    }

    protected void updateVarGroupList(VarGroupList varGroupList, VarGroupSelector varGroupSelector) {
        this.varGroupsMenu.removeAll();
        String[] names = varGroupList.getVarGroupNames();
        for (int i = 0; i < names.length; ++i) {
            this.varGroupsMenu.add(new SelectVarGroupAction(varGroupSelector, names[i]));
        }
    }

    @Override
    public void disableGUIComponents() {
        if (this.guiActions != null) {
            EventDispatchThreadHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (Action action : StandardGUIActions.this.guiActions) {
                        action.setEnabled(false);
                    }
                }
            });
        }
    }

    @Override
    public void enableGUIComponents() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (StandardGUIActions.this.guiActions != null) {
                    for (Action action : StandardGUIActions.this.guiActions) {
                        action.setEnabled(true);
                    }
                }
            }
        });
    }

    protected void makeCheckBoxesConsistentWithCamera() {
        if (this.trackCheckBox != null) {
            this.trackCheckBox.makeCheckBoxConsistent();
        }
        if (this.dollyCheckBox != null) {
            this.dollyCheckBox.makeCheckBoxConsistent();
        }
    }

    protected void makeCameraConsistentWithCheckBoxes() {
        if (this.trackCheckBox != null) {
            this.trackCheckBox.makeCameraConsistent();
        }
        if (this.dollyCheckBox != null) {
            this.dollyCheckBox.makeCameraConsistent();
        }
    }

    protected void notifySimulationStopped() {
        EventDispatchThreadHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                StandardGUIActions.this.simulateAction.setEnabled(true);
                StandardGUIActions.this.playAction.setEnabled(true);
            }
        });
    }

    public void setExportDataDirectory(String directory) {
        this.exportAction.setCurrentDirectory(directory);
    }

    public void loadGUIConfigurationFile(File file) {
        this.loadConfigurationAction.loadGUIConfigurationFile(file);
    }

    public void setImportDataDirectory(String directory) {
        this.importDataAction.setCurrentDirectory(directory);
    }

    public void createVideo(File file) {
        this.mediaCapture.createVideoFromFile(file);
    }

    public ArrayList<AbstractAction> getGuiActions() {
        return this.guiActions;
    }

    public void closeAndDispose() {
        if (this.guiActions != null) {
            this.guiActions.clear();
            this.guiActions = null;
        }
        this.openH264LicenseAction = null;
        this.aboutAction = null;
        if (this.cameraMenu != null) {
            this.cameraMenu.removeAll();
            this.cameraMenu = null;
        }
        if (this.viewportMenu != null) {
            this.viewportMenu.removeAll();
            this.viewportMenu = null;
        }
        if (this.viewMenu != null) {
            this.viewMenu.removeAll();
            this.viewMenu = null;
        }
        if (this.extraPanelsMenu != null) {
            this.extraPanelsMenu.removeAll();
            this.extraPanelsMenu = null;
        }
        if (this.cameraKeysMenu != null) {
            this.cameraKeysMenu.removeAll();
            this.cameraKeysMenu = null;
        }
        this.cameraPropertiesAction = null;
        this.yoGraphicsPropertiesAction = null;
        if (this.configurationMenu != null) {
            this.configurationMenu.removeAll();
            this.configurationMenu = null;
        }
        this.createNewGraphWindowAction = null;
        this.createNewViewportWindowAction = null;
        this.cropBufferAction = null;
        this.packBufferAction = null;
        this.cutBufferAction = null;
        this.thinBufferAction = null;
        if (this.dataBufferPropertiesAction != null) {
            this.dataBufferPropertiesAction.closeAndDispose();
            this.dataBufferPropertiesAction = null;
        }
        this.dollyCheckBox = null;
        if (this.entryBoxGroupsMenu != null) {
            this.entryBoxGroupsMenu.removeAll();
            this.entryBoxGroupsMenu = null;
        }
        if (this.exitMenuItem != null) {
            this.exitMenuItem.removeAll();
            this.exitMenuItem = null;
        }
        if (this.exportAction != null) {
            this.exportAction.closeAndDispose();
            this.exportAction = null;
        }
        this.mediaCapture = null;
        this.exportSnapshotAction = null;
        this.goInPointAction = null;
        this.goOutPointAction = null;
        if (this.graphGroupsMenu != null) {
            this.graphGroupsMenu.removeAll();
            this.graphGroupsMenu = null;
        }
        this.hideShowViewportAction = null;
        this.addCameraKeyAction = null;
        this.removeCameraKeyAction = null;
        this.nextCameraKeyAction = null;
        this.previousCameraKeyAction = null;
        if (this.importDataAction != null) {
            this.importDataAction.closeAndDispose();
            this.importDataAction = null;
        }
        this.playAction = null;
        this.playbackPropertiesAction = null;
        this.resizeViewportAction = null;
        if (this.runMenu != null) {
            this.runMenu.removeAll();
            this.runMenu = null;
        }
        this.setInPointAction = null;
        this.setKeyAction = null;
        this.setOutPointAction = null;
        this.saveConfigurationAction = null;
        this.saveGraphConfigurationAction = null;
        this.loadConfigurationAction = null;
        this.saveRobotConfigurationAction = null;
        this.exportSimulationTo3DMaxAction = null;
        this.simulateAction = null;
        this.stepBackwardAction = null;
        this.stepForwardAction = null;
        this.stopAction = null;
        if (this.toggleKeyPointModeAction != null) {
            this.toggleKeyPointModeAction.closeAndDispose();
            this.toggleKeyPointModeAction = null;
        }
        this.toggleCameraKeyModeAction = null;
        this.trackCheckBox = null;
        if (this.varGroupsMenu != null) {
            this.varGroupsMenu.removeAll();
            this.varGroupsMenu = null;
        }
        if (this.zoomInAction != null) {
            this.zoomInAction.closeAndDispose();
            this.zoomInAction = null;
        }
        if (this.zoomOutAction != null) {
            this.zoomOutAction.closeAndDispose();
            this.zoomOutAction = null;
        }
        if (this.printGraphsAction != null) {
            this.printGraphsAction.closeAndDispose();
            this.printGraphsAction = null;
        }
        if (this.exportGraphsToFileAction != null) {
            this.exportGraphsToFileAction.closeAndDispose();
            this.exportGraphsToFileAction = null;
        }
    }
}

