/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import us.ihmc.simulationconstructionset.commands.RunCommandsExecutor;
import us.ihmc.simulationconstructionset.gui.ViewportAdapterAndCameraControllerHolder;
import us.ihmc.simulationconstructionset.gui.ViewportPanel;

public class Canvas3DPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -4186691483384418845L;
    private ViewportAdapterAndCameraControllerHolder view;
    private ViewportPanel viewportPanel;
    private boolean active = false;
    private AbstractBorder border;
    private Canvas canvas;
    private SpaceKeyListener spaceKeyListener;

    public Canvas3DPanel(RunCommandsExecutor runCommandsExecutor, ViewportAdapterAndCameraControllerHolder viewportAdapterAndCameraControllerHolder, ViewportPanel viewportPanel) {
        super(new GridLayout(1, 1));
        this.view = viewportAdapterAndCameraControllerHolder;
        this.viewportPanel = viewportPanel;
        this.canvas = viewportAdapterAndCameraControllerHolder.getViewportAdapter().getCanvas();
        this.add(this.canvas);
        this.setRequestFocusEnabled(true);
        this.canvas.addMouseListener(this);
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        this.border = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        this.setBorder(this.border);
        this.spaceKeyListener = new SpaceKeyListener(runCommandsExecutor);
        this.canvas.addKeyListener(this.spaceKeyListener);
    }

    public ViewportAdapterAndCameraControllerHolder getStandard3DView() {
        return this.view;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.viewportPanel.setActiveView(this.view, this);
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        if (active) {
            Border redline = BorderFactory.createLineBorder(Color.red);
            this.border = BorderFactory.createCompoundBorder(redline, loweredbevel);
        } else {
            this.border = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        }
        this.setBorder(this.border);
    }

    public void closeAndDispose() {
        this.removeAll();
        if (this.canvas != null) {
            this.canvas.removeKeyListener(this.spaceKeyListener);
            this.canvas = null;
        }
        if (this.spaceKeyListener != null) {
            this.spaceKeyListener.closeAndDispose();
        }
        this.view = null;
        this.viewportPanel = null;
        this.border = null;
    }

    private class SpaceKeyListener
    implements KeyListener {
        private RunCommandsExecutor runCommandsExecutor;

        public SpaceKeyListener(RunCommandsExecutor runCommandsExecutor) {
            this.runCommandsExecutor = runCommandsExecutor;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == ' ') {
                if (this.runCommandsExecutor.isSimulating()) {
                    this.runCommandsExecutor.stop();
                } else {
                    this.runCommandsExecutor.simulate();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        public void closeAndDispose() {
            this.runCommandsExecutor = null;
        }
    }
}

