/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraPropertiesHolder;
import us.ihmc.simulationconstructionset.gui.ActiveCameraHolder;

public class CameraPropertiesDialog
extends JDialog
implements ActionListener {
    private NumberFormat numFormat;
    private JCheckBox trackCheckBox;
    private JCheckBox trackXCheckBox;
    private JCheckBox trackYCheckBox;
    private JCheckBox trackZCheckBox;
    private JCheckBox dollyCheckBox;
    private JCheckBox dollyXCheckBox;
    private JCheckBox dollyYCheckBox;
    private JCheckBox dollyZCheckBox;
    private JTextField trackXTextField;
    private JTextField trackYTextField;
    private JTextField trackZTextField;
    private JTextField dollyXTextField;
    private JTextField dollyYTextField;
    private JTextField dollyZTextField;
    private JTextField fixXTextField;
    private JTextField fixYTextField;
    private JTextField fixZTextField;
    private JTextField camXTextField;
    private JTextField camYTextField;
    private JTextField camZTextField;
    private double newTrackDx;
    private double newTrackDy;
    private double newTrackDz;
    private double newDollyDx;
    private double newDollyDy;
    private double newDollyDz;
    private double newFixX;
    private double newFixY;
    private double newFixZ;
    private double newCamX;
    private double newCamY;
    private double newCamZ;
    private JButton trackCurrentButton;
    private JButton dollyCurrentButton;
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private CameraPropertiesPanel cameraPropertiesPanel;
    private Container parentContainer;
    private JFrame parentFrame;
    private ActiveCameraHolder cameraHolder;
    private JCheckBox GUITrackCheckBox;
    private JCheckBox GUIDollyCheckBox;

    public CameraPropertiesDialog(Container parentContainer, JFrame frame, JCheckBox GUITrackCheckBox, JCheckBox GUIDollyCheckBox, ActiveCameraHolder cameraHolder) {
        super(frame, "Camera Properties", false);
        this.parentContainer = parentContainer;
        this.parentFrame = frame;
        this.cameraHolder = cameraHolder;
        this.GUITrackCheckBox = GUITrackCheckBox;
        this.GUIDollyCheckBox = GUIDollyCheckBox;
        this.numFormat = NumberFormat.getInstance();
        this.numFormat.setMaximumFractionDigits(4);
        this.numFormat.setMinimumFractionDigits(1);
        this.numFormat.setGroupingUsed(false);
        Container contentPane = this.getContentPane();
        this.cameraPropertiesPanel = new CameraPropertiesPanel();
        contentPane.add(this.cameraPropertiesPanel);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        Point point = parentContainer.getLocation();
        Dimension frameSize = parentContainer.getSize();
        point.translate(frameSize.width / 2, frameSize.height / 4);
        this.setLocation(point);
        this.setResizable(false);
        this.pack();
        int width = this.trackXTextField.getSize().width;
        width = Math.max(width, this.trackYTextField.getSize().width);
        width = Math.max(width, this.trackZTextField.getSize().width);
        width = Math.max(width, this.dollyXTextField.getSize().width);
        width = Math.max(width, this.dollyYTextField.getSize().width);
        width = Math.max(width, this.dollyZTextField.getSize().width);
        width = Math.max(width, this.fixXTextField.getSize().width);
        width = Math.max(width, this.fixYTextField.getSize().width);
        width = Math.max(width, this.fixZTextField.getSize().width);
        width = Math.max(width, this.camXTextField.getSize().width);
        width = Math.max(width, this.camYTextField.getSize().width);
        width = Math.max(width, this.camZTextField.getSize().width);
        width = width * 5 / 4;
        Dimension size = this.trackXTextField.getSize();
        size.width = width;
        this.trackXTextField.setSize(size);
        this.trackXTextField.setPreferredSize(size);
        this.trackXTextField.setMinimumSize(size);
        this.trackYTextField.setSize(size);
        this.trackYTextField.setPreferredSize(size);
        this.trackYTextField.setMinimumSize(size);
        this.trackZTextField.setSize(size);
        this.trackZTextField.setPreferredSize(size);
        this.trackZTextField.setMinimumSize(size);
        this.dollyXTextField.setSize(size);
        this.dollyXTextField.setPreferredSize(size);
        this.dollyXTextField.setMinimumSize(size);
        this.dollyYTextField.setSize(size);
        this.dollyYTextField.setPreferredSize(size);
        this.dollyYTextField.setMinimumSize(size);
        this.dollyZTextField.setSize(size);
        this.dollyZTextField.setPreferredSize(size);
        this.dollyZTextField.setMinimumSize(size);
        this.fixXTextField.setSize(size);
        this.fixXTextField.setPreferredSize(size);
        this.fixXTextField.setMinimumSize(size);
        this.fixYTextField.setSize(size);
        this.fixYTextField.setPreferredSize(size);
        this.fixYTextField.setMinimumSize(size);
        this.fixZTextField.setSize(size);
        this.fixZTextField.setPreferredSize(size);
        this.fixZTextField.setMinimumSize(size);
        this.camXTextField.setSize(size);
        this.camXTextField.setPreferredSize(size);
        this.camXTextField.setMinimumSize(size);
        this.camYTextField.setSize(size);
        this.camYTextField.setPreferredSize(size);
        this.camYTextField.setMinimumSize(size);
        this.camZTextField.setSize(size);
        this.camZTextField.setPreferredSize(size);
        this.camZTextField.setMinimumSize(size);
        this.pack();
        this.setVisible(true);
        GUITrackCheckBox.setEnabled(false);
        GUIDollyCheckBox.setEnabled(false);
        parentContainer.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.GUITrackCheckBox.setEnabled(true);
            this.GUIDollyCheckBox.setEnabled(true);
        }
        if (event.getSource() == this.applyButton) {
            this.cameraPropertiesPanel.commitChanges();
        }
        if (event.getSource() == this.okButton) {
            this.cameraPropertiesPanel.commitChanges();
            this.setVisible(false);
            this.GUITrackCheckBox.setEnabled(true);
            this.GUIDollyCheckBox.setEnabled(true);
        }
        this.parentContainer.repaint();
    }

    public class CameraPropertiesPanel
    extends JPanel
    implements ActionListener {
        public CameraPropertiesPanel() {
            JPanel trackPanel = new JPanel();
            JPanel dollyPanel = new JPanel();
            CameraPropertiesHolder listener = CameraPropertiesDialog.this.cameraHolder.getCameraPropertiesForActiveCamera();
            CameraPropertiesDialog.this.newTrackDx = listener.getTrackingXOffset();
            CameraPropertiesDialog.this.newTrackDy = listener.getTrackingYOffset();
            CameraPropertiesDialog.this.newTrackDz = listener.getTrackingZOffset();
            CameraPropertiesDialog.this.newDollyDx = listener.getDollyXOffset();
            CameraPropertiesDialog.this.newDollyDy = listener.getDollyYOffset();
            CameraPropertiesDialog.this.newDollyDz = listener.getDollyZOffset();
            CameraPropertiesDialog.this.newFixX = listener.getFixX();
            CameraPropertiesDialog.this.newFixY = listener.getFixY();
            CameraPropertiesDialog.this.newFixZ = listener.getFixZ();
            CameraPropertiesDialog.this.newCamX = listener.getCamX();
            CameraPropertiesDialog.this.newCamY = listener.getCamY();
            CameraPropertiesDialog.this.newCamZ = listener.getCamZ();
            GridBagLayout trackGridbag = new GridBagLayout();
            trackPanel.setLayout(trackGridbag);
            Border blackLine = BorderFactory.createLineBorder(Color.black);
            trackPanel.setBorder(blackLine);
            GridBagLayout dollyGridbag = new GridBagLayout();
            dollyPanel.setLayout(dollyGridbag);
            blackLine = BorderFactory.createLineBorder(Color.black);
            dollyPanel.setBorder(blackLine);
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel fixLabel = new JLabel("       Fix Position:       ");
            this.setConstraints(constraints, 0, 0, 2, 17);
            trackGridbag.setConstraints(fixLabel, constraints);
            trackPanel.add(fixLabel);
            CameraPropertiesDialog.this.trackCheckBox = new JCheckBox("Track", listener.isTracking());
            CameraPropertiesDialog.this.trackCheckBox.setName("Track");
            CameraPropertiesDialog.this.trackCheckBox.addActionListener(this);
            this.setConstraints(constraints, 2, 0, 1, 13);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.trackCheckBox, constraints);
            trackPanel.add(CameraPropertiesDialog.this.trackCheckBox);
            CameraPropertiesDialog.this.trackCurrentButton = new TrackCurrentButton();
            this.setConstraints(constraints, 3, 0, 2, 17);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.trackCurrentButton, constraints);
            trackPanel.add(CameraPropertiesDialog.this.trackCurrentButton);
            JLabel fixXLabel = new JLabel("  X:  ");
            this.setConstraints(constraints, 0, 1, 1, 17);
            trackGridbag.setConstraints(fixXLabel, constraints);
            trackPanel.add(fixXLabel);
            String fixXVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newFixX);
            CameraPropertiesDialog.this.fixXTextField = new JTextField(fixXVal);
            CameraPropertiesDialog.this.fixXTextField.addActionListener(this);
            this.setConstraints(constraints, 1, 1, 1, 17);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.fixXTextField, constraints);
            trackPanel.add(CameraPropertiesDialog.this.fixXTextField);
            CameraPropertiesDialog.this.trackXCheckBox = new JCheckBox("Track X", listener.isTrackingX());
            CameraPropertiesDialog.this.trackXCheckBox.addActionListener(this);
            this.setConstraints(constraints, 2, 1, 1, 13);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.trackXCheckBox, constraints);
            trackPanel.add(CameraPropertiesDialog.this.trackXCheckBox);
            JLabel trackDXLabel = new JLabel("  X Offset:  ");
            this.setConstraints(constraints, 3, 1, 1, 13);
            trackGridbag.setConstraints(trackDXLabel, constraints);
            trackPanel.add(trackDXLabel);
            String trackDXVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newTrackDx);
            CameraPropertiesDialog.this.trackXTextField = new JTextField(trackDXVal);
            CameraPropertiesDialog.this.trackXTextField.addActionListener(this);
            this.setConstraints(constraints, 4, 1, 1, 17);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.trackXTextField, constraints);
            trackPanel.add(CameraPropertiesDialog.this.trackXTextField);
            JLabel fixYLabel = new JLabel("  Y:  ");
            this.setConstraints(constraints, 0, 2, 1, 17);
            trackGridbag.setConstraints(fixYLabel, constraints);
            trackPanel.add(fixYLabel);
            String fixYVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newFixY);
            CameraPropertiesDialog.this.fixYTextField = new JTextField(fixYVal);
            CameraPropertiesDialog.this.fixYTextField.addActionListener(this);
            this.setConstraints(constraints, 1, 2, 1, 17);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.fixYTextField, constraints);
            trackPanel.add(CameraPropertiesDialog.this.fixYTextField);
            CameraPropertiesDialog.this.trackYCheckBox = new JCheckBox("Track Y", listener.isTrackingY());
            CameraPropertiesDialog.this.trackYCheckBox.addActionListener(this);
            this.setConstraints(constraints, 2, 2, 1, 13);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.trackYCheckBox, constraints);
            trackPanel.add(CameraPropertiesDialog.this.trackYCheckBox);
            JLabel trackDYLabel = new JLabel("  Y Offset:  ");
            this.setConstraints(constraints, 3, 2, 1, 13);
            trackGridbag.setConstraints(trackDYLabel, constraints);
            trackPanel.add(trackDYLabel);
            String trackDYVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newTrackDy);
            CameraPropertiesDialog.this.trackYTextField = new JTextField(trackDYVal);
            CameraPropertiesDialog.this.trackYTextField.addActionListener(this);
            this.setConstraints(constraints, 4, 2, 1, 17);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.trackYTextField, constraints);
            trackPanel.add(CameraPropertiesDialog.this.trackYTextField);
            JLabel fixZLabel = new JLabel("  Z:  ");
            this.setConstraints(constraints, 0, 3, 1, 17);
            trackGridbag.setConstraints(fixZLabel, constraints);
            trackPanel.add(fixZLabel);
            String fixZVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newFixZ);
            CameraPropertiesDialog.this.fixZTextField = new JTextField(fixZVal);
            CameraPropertiesDialog.this.fixZTextField.addActionListener(this);
            this.setConstraints(constraints, 1, 3, 1, 17);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.fixZTextField, constraints);
            trackPanel.add(CameraPropertiesDialog.this.fixZTextField);
            CameraPropertiesDialog.this.trackZCheckBox = new JCheckBox("Track Z", listener.isTrackingZ());
            CameraPropertiesDialog.this.trackZCheckBox.addActionListener(this);
            this.setConstraints(constraints, 2, 3, 1, 13);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.trackZCheckBox, constraints);
            trackPanel.add(CameraPropertiesDialog.this.trackZCheckBox);
            JLabel trackDZLabel = new JLabel("  Z Offset:  ");
            this.setConstraints(constraints, 3, 3, 1, 13);
            trackGridbag.setConstraints(trackDZLabel, constraints);
            trackPanel.add(trackDZLabel);
            String trackDZVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newTrackDz);
            CameraPropertiesDialog.this.trackZTextField = new JTextField(trackDZVal);
            CameraPropertiesDialog.this.trackZTextField.addActionListener(this);
            this.setConstraints(constraints, 4, 3, 1, 17);
            trackGridbag.setConstraints(CameraPropertiesDialog.this.trackZTextField, constraints);
            trackPanel.add(CameraPropertiesDialog.this.trackZTextField);
            JLabel cameraLabel = new JLabel("  Camera Position:  ");
            this.setConstraints(constraints, 0, 0, 2, 17);
            dollyGridbag.setConstraints(cameraLabel, constraints);
            dollyPanel.add(cameraLabel);
            CameraPropertiesDialog.this.dollyCheckBox = new JCheckBox("Dolly", listener.isDolly());
            CameraPropertiesDialog.this.dollyCheckBox.setName("Dolly");
            CameraPropertiesDialog.this.dollyCheckBox.addActionListener(this);
            this.setConstraints(constraints, 2, 0, 1, 13);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.dollyCheckBox, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.dollyCheckBox);
            CameraPropertiesDialog.this.dollyCurrentButton = new DollyCurrentButton();
            this.setConstraints(constraints, 3, 0, 2, 17);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.dollyCurrentButton, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.dollyCurrentButton);
            JLabel camXLabel = new JLabel("  X:  ");
            this.setConstraints(constraints, 0, 1, 1, 17);
            dollyGridbag.setConstraints(camXLabel, constraints);
            dollyPanel.add(camXLabel);
            String camXVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newCamX);
            CameraPropertiesDialog.this.camXTextField = new JTextField(camXVal);
            CameraPropertiesDialog.this.camXTextField.addActionListener(this);
            this.setConstraints(constraints, 1, 1, 1, 17);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.camXTextField, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.camXTextField);
            CameraPropertiesDialog.this.dollyXCheckBox = new JCheckBox("Dolly X", listener.isDollyX());
            CameraPropertiesDialog.this.dollyXCheckBox.addActionListener(this);
            this.setConstraints(constraints, 2, 1, 1, 13);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.dollyXCheckBox, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.dollyXCheckBox);
            JLabel dollyDXLabel = new JLabel("  X Offset:  ");
            this.setConstraints(constraints, 3, 1, 1, 13);
            dollyGridbag.setConstraints(dollyDXLabel, constraints);
            dollyPanel.add(dollyDXLabel);
            String dollyDXVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newDollyDx);
            CameraPropertiesDialog.this.dollyXTextField = new JTextField(dollyDXVal);
            CameraPropertiesDialog.this.dollyXTextField.addActionListener(this);
            this.setConstraints(constraints, 4, 1, 1, 17);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.dollyXTextField, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.dollyXTextField);
            JLabel camYLabel = new JLabel("  Y:  ");
            this.setConstraints(constraints, 0, 2, 1, 17);
            dollyGridbag.setConstraints(camYLabel, constraints);
            dollyPanel.add(camYLabel);
            String camYVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newCamY);
            CameraPropertiesDialog.this.camYTextField = new JTextField(camYVal);
            CameraPropertiesDialog.this.camYTextField.addActionListener(this);
            this.setConstraints(constraints, 1, 2, 1, 17);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.camYTextField, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.camYTextField);
            CameraPropertiesDialog.this.dollyYCheckBox = new JCheckBox("Dolly Y", listener.isDollyY());
            CameraPropertiesDialog.this.dollyYCheckBox.addActionListener(this);
            this.setConstraints(constraints, 2, 2, 1, 13);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.dollyYCheckBox, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.dollyYCheckBox);
            JLabel dollyDYLabel = new JLabel("  Y Offset:  ");
            this.setConstraints(constraints, 3, 2, 1, 13);
            dollyGridbag.setConstraints(dollyDYLabel, constraints);
            dollyPanel.add(dollyDYLabel);
            String dollyDYVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newDollyDy);
            CameraPropertiesDialog.this.dollyYTextField = new JTextField(dollyDYVal);
            CameraPropertiesDialog.this.dollyYTextField.addActionListener(this);
            this.setConstraints(constraints, 4, 2, 1, 17);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.dollyYTextField, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.dollyYTextField);
            JLabel camZLabel = new JLabel("  Z:  ");
            this.setConstraints(constraints, 0, 3, 1, 17);
            dollyGridbag.setConstraints(camZLabel, constraints);
            dollyPanel.add(camZLabel);
            String camZVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newCamZ);
            CameraPropertiesDialog.this.camZTextField = new JTextField(camZVal);
            CameraPropertiesDialog.this.camZTextField.addActionListener(this);
            this.setConstraints(constraints, 1, 3, 1, 17);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.camZTextField, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.camZTextField);
            CameraPropertiesDialog.this.dollyZCheckBox = new JCheckBox("Dolly Z", listener.isDollyZ());
            CameraPropertiesDialog.this.dollyZCheckBox.addActionListener(this);
            this.setConstraints(constraints, 2, 3, 1, 13);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.dollyZCheckBox, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.dollyZCheckBox);
            JLabel dollyDZLabel = new JLabel("  Z Offset:  ");
            this.setConstraints(constraints, 3, 3, 1, 13);
            dollyGridbag.setConstraints(dollyDZLabel, constraints);
            dollyPanel.add(dollyDZLabel);
            String dollyDZVal = CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newDollyDz);
            CameraPropertiesDialog.this.dollyZTextField = new JTextField(dollyDZVal);
            CameraPropertiesDialog.this.dollyZTextField.addActionListener(this);
            this.setConstraints(constraints, 4, 3, 1, 17);
            dollyGridbag.setConstraints(CameraPropertiesDialog.this.dollyZTextField, constraints);
            dollyPanel.add(CameraPropertiesDialog.this.dollyZTextField);
            this.setLayout(new GridLayout(2, 1));
            this.add(trackPanel);
            this.add(dollyPanel);
            this.updateTracking();
            this.updateEnabling();
        }

        private void setConstraints(GridBagConstraints constraints, int gridx, int gridy, int gridwidth, int anchor) {
            constraints.gridx = gridx;
            constraints.gridy = gridy;
            constraints.gridwidth = gridwidth;
            constraints.anchor = anchor;
        }

        public void commitChanges() {
            this.updateTracking();
            this.updateEnabling();
            CameraPropertiesHolder listener = CameraPropertiesDialog.this.cameraHolder.getCameraPropertiesForActiveCamera();
            listener.setFixX(CameraPropertiesDialog.this.newFixX);
            listener.setFixY(CameraPropertiesDialog.this.newFixY);
            listener.setFixZ(CameraPropertiesDialog.this.newFixZ);
            listener.setCamX(CameraPropertiesDialog.this.newCamX);
            listener.setCamY(CameraPropertiesDialog.this.newCamY);
            listener.setCamZ(CameraPropertiesDialog.this.newCamZ);
            listener.setTracking(CameraPropertiesDialog.this.trackCheckBox.isSelected());
            listener.setTrackingX(CameraPropertiesDialog.this.trackXCheckBox.isSelected());
            listener.setTrackingY(CameraPropertiesDialog.this.trackYCheckBox.isSelected());
            listener.setTrackingZ(CameraPropertiesDialog.this.trackZCheckBox.isSelected());
            listener.setDolly(CameraPropertiesDialog.this.dollyCheckBox.isSelected());
            listener.setDollyX(CameraPropertiesDialog.this.dollyXCheckBox.isSelected());
            listener.setDollyY(CameraPropertiesDialog.this.dollyYCheckBox.isSelected());
            listener.setDollyZ(CameraPropertiesDialog.this.dollyZCheckBox.isSelected());
            listener.setTrackingXOffset(CameraPropertiesDialog.this.newTrackDx);
            listener.setTrackingYOffset(CameraPropertiesDialog.this.newTrackDy);
            listener.setTrackingZOffset(CameraPropertiesDialog.this.newTrackDz);
            listener.setDollyXOffset(CameraPropertiesDialog.this.newDollyDx);
            listener.setDollyYOffset(CameraPropertiesDialog.this.newDollyDy);
            listener.setDollyZOffset(CameraPropertiesDialog.this.newDollyDz);
            listener.update();
            CameraPropertiesDialog.this.GUITrackCheckBox.setSelected(CameraPropertiesDialog.this.trackCheckBox.isSelected());
            CameraPropertiesDialog.this.GUIDollyCheckBox.setSelected(CameraPropertiesDialog.this.dollyCheckBox.isSelected());
            CameraPropertiesDialog.this.fixXTextField.setText(CameraPropertiesDialog.this.numFormat.format(listener.getFixX()));
            CameraPropertiesDialog.this.fixYTextField.setText(CameraPropertiesDialog.this.numFormat.format(listener.getFixY()));
            CameraPropertiesDialog.this.fixZTextField.setText(CameraPropertiesDialog.this.numFormat.format(listener.getFixZ()));
            CameraPropertiesDialog.this.camXTextField.setText(CameraPropertiesDialog.this.numFormat.format(listener.getCamX()));
            CameraPropertiesDialog.this.camYTextField.setText(CameraPropertiesDialog.this.numFormat.format(listener.getCamY()));
            CameraPropertiesDialog.this.camZTextField.setText(CameraPropertiesDialog.this.numFormat.format(listener.getCamZ()));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.updateTracking();
            this.updateEnabling();
        }

        private void updateEnabling() {
            if (CameraPropertiesDialog.this.trackCheckBox.isSelected()) {
                CameraPropertiesDialog.this.trackXCheckBox.setEnabled(true);
                CameraPropertiesDialog.this.trackYCheckBox.setEnabled(true);
                CameraPropertiesDialog.this.trackZCheckBox.setEnabled(true);
                if (CameraPropertiesDialog.this.trackXCheckBox.isSelected()) {
                    CameraPropertiesDialog.this.trackXTextField.setEnabled(true);
                } else {
                    CameraPropertiesDialog.this.trackXTextField.setEnabled(false);
                }
                if (CameraPropertiesDialog.this.trackYCheckBox.isSelected()) {
                    CameraPropertiesDialog.this.trackYTextField.setEnabled(true);
                } else {
                    CameraPropertiesDialog.this.trackYTextField.setEnabled(false);
                }
                if (CameraPropertiesDialog.this.trackZCheckBox.isSelected()) {
                    CameraPropertiesDialog.this.trackZTextField.setEnabled(true);
                } else {
                    CameraPropertiesDialog.this.trackZTextField.setEnabled(false);
                }
            } else {
                CameraPropertiesDialog.this.trackXCheckBox.setEnabled(false);
                CameraPropertiesDialog.this.trackYCheckBox.setEnabled(false);
                CameraPropertiesDialog.this.trackZCheckBox.setEnabled(false);
                CameraPropertiesDialog.this.trackXTextField.setEnabled(false);
                CameraPropertiesDialog.this.trackYTextField.setEnabled(false);
                CameraPropertiesDialog.this.trackZTextField.setEnabled(false);
            }
            if (CameraPropertiesDialog.this.dollyCheckBox.isSelected()) {
                CameraPropertiesDialog.this.dollyXCheckBox.setEnabled(true);
                CameraPropertiesDialog.this.dollyYCheckBox.setEnabled(true);
                CameraPropertiesDialog.this.dollyZCheckBox.setEnabled(true);
                if (CameraPropertiesDialog.this.dollyXCheckBox.isSelected()) {
                    CameraPropertiesDialog.this.dollyXTextField.setEnabled(true);
                } else {
                    CameraPropertiesDialog.this.dollyXTextField.setEnabled(false);
                }
                if (CameraPropertiesDialog.this.dollyYCheckBox.isSelected()) {
                    CameraPropertiesDialog.this.dollyYTextField.setEnabled(true);
                } else {
                    CameraPropertiesDialog.this.dollyYTextField.setEnabled(false);
                }
                if (CameraPropertiesDialog.this.dollyZCheckBox.isSelected()) {
                    CameraPropertiesDialog.this.dollyZTextField.setEnabled(true);
                } else {
                    CameraPropertiesDialog.this.dollyZTextField.setEnabled(false);
                }
            } else {
                CameraPropertiesDialog.this.dollyXCheckBox.setEnabled(false);
                CameraPropertiesDialog.this.dollyYCheckBox.setEnabled(false);
                CameraPropertiesDialog.this.dollyZCheckBox.setEnabled(false);
                CameraPropertiesDialog.this.dollyXTextField.setEnabled(false);
                CameraPropertiesDialog.this.dollyYTextField.setEnabled(false);
                CameraPropertiesDialog.this.dollyZTextField.setEnabled(false);
            }
        }

        private void updateTracking() {
            this.updateTrackXOffset();
            this.updateTrackYOffset();
            this.updateTrackZOffset();
            this.updateDollyXOffset();
            this.updateDollyYOffset();
            this.updateDollyZOffset();
            this.updateFixX();
            this.updateFixY();
            this.updateFixZ();
            this.updateCamX();
            this.updateCamY();
            this.updateCamZ();
        }

        private void updateTrackXOffset() {
            CameraPropertiesDialog.this.newTrackDx = this.updateTrackDolly(CameraPropertiesDialog.this.trackXTextField, CameraPropertiesDialog.this.newTrackDx);
        }

        private void updateTrackYOffset() {
            CameraPropertiesDialog.this.newTrackDy = this.updateTrackDolly(CameraPropertiesDialog.this.trackYTextField, CameraPropertiesDialog.this.newTrackDy);
        }

        private void updateTrackZOffset() {
            CameraPropertiesDialog.this.newTrackDz = this.updateTrackDolly(CameraPropertiesDialog.this.trackZTextField, CameraPropertiesDialog.this.newTrackDz);
        }

        private void updateDollyXOffset() {
            CameraPropertiesDialog.this.newDollyDx = this.updateTrackDolly(CameraPropertiesDialog.this.dollyXTextField, CameraPropertiesDialog.this.newDollyDx);
        }

        private void updateDollyYOffset() {
            CameraPropertiesDialog.this.newDollyDy = this.updateTrackDolly(CameraPropertiesDialog.this.dollyYTextField, CameraPropertiesDialog.this.newDollyDy);
        }

        private void updateDollyZOffset() {
            CameraPropertiesDialog.this.newDollyDz = this.updateTrackDolly(CameraPropertiesDialog.this.dollyZTextField, CameraPropertiesDialog.this.newDollyDz);
        }

        private void updateFixX() {
            CameraPropertiesDialog.this.newFixX = this.updateTrackDolly(CameraPropertiesDialog.this.fixXTextField, CameraPropertiesDialog.this.newFixX);
        }

        private void updateFixY() {
            CameraPropertiesDialog.this.newFixY = this.updateTrackDolly(CameraPropertiesDialog.this.fixYTextField, CameraPropertiesDialog.this.newFixY);
        }

        private void updateFixZ() {
            CameraPropertiesDialog.this.newFixZ = this.updateTrackDolly(CameraPropertiesDialog.this.fixZTextField, CameraPropertiesDialog.this.newFixZ);
        }

        private void updateCamX() {
            CameraPropertiesDialog.this.newCamX = this.updateTrackDolly(CameraPropertiesDialog.this.camXTextField, CameraPropertiesDialog.this.newCamX);
        }

        private void updateCamY() {
            CameraPropertiesDialog.this.newCamY = this.updateTrackDolly(CameraPropertiesDialog.this.camYTextField, CameraPropertiesDialog.this.newCamY);
        }

        private void updateCamZ() {
            CameraPropertiesDialog.this.newCamZ = this.updateTrackDolly(CameraPropertiesDialog.this.camZTextField, CameraPropertiesDialog.this.newCamZ);
        }

        private double updateTrackDolly(JTextField textField, double oldVal) {
            double newVal = oldVal;
            String text = textField.getText();
            try {
                double val;
                newVal = val = Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                textField.setText(CameraPropertiesDialog.this.numFormat.format(newVal));
            }
            return newVal;
        }
    }

    public class DollyCurrentButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 6700937880902001238L;

        public DollyCurrentButton() {
            super("Dolly Current");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CameraPropertiesHolder cameraPropertiesHolder = CameraPropertiesDialog.this.cameraHolder.getCameraPropertiesForActiveCamera();
            CameraPropertiesDialog.this.newDollyDx = -cameraPropertiesHolder.getDollyXVar() + CameraPropertiesDialog.this.newCamX;
            CameraPropertiesDialog.this.dollyXTextField.setText(CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newDollyDx));
            CameraPropertiesDialog.this.newDollyDy = -cameraPropertiesHolder.getDollyYVar() + CameraPropertiesDialog.this.newCamY;
            CameraPropertiesDialog.this.dollyYTextField.setText(CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newDollyDy));
            CameraPropertiesDialog.this.newDollyDz = -cameraPropertiesHolder.getDollyZVar() + CameraPropertiesDialog.this.newCamZ;
            CameraPropertiesDialog.this.dollyZTextField.setText(CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newDollyDz));
        }
    }

    public class TrackCurrentButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -4680530982540091563L;

        public TrackCurrentButton() {
            super("Track Current");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CameraPropertiesHolder cameraPropertiesHolder = CameraPropertiesDialog.this.cameraHolder.getCameraPropertiesForActiveCamera();
            CameraPropertiesDialog.this.newTrackDx = -cameraPropertiesHolder.getTrackXVar() + CameraPropertiesDialog.this.newFixX;
            CameraPropertiesDialog.this.trackXTextField.setText(CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newTrackDx));
            CameraPropertiesDialog.this.newTrackDy = -cameraPropertiesHolder.getTrackYVar() + CameraPropertiesDialog.this.newFixY;
            CameraPropertiesDialog.this.trackYTextField.setText(CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newTrackDy));
            CameraPropertiesDialog.this.newTrackDz = -cameraPropertiesHolder.getTrackZVar() + CameraPropertiesDialog.this.newFixZ;
            CameraPropertiesDialog.this.trackZTextField.setText(CameraPropertiesDialog.this.numFormat.format(CameraPropertiesDialog.this.newTrackDz));
        }
    }
}

