/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.ExternalTorque;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.physics.CollisionShape;
import us.ihmc.simulationconstructionset.physics.collision.CollisionHandlerListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DefaultCollisionVisualizer
implements CollisionHandlerListener {
    private SimulationConstructionSet scs;
    private YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    private List<YoGraphicVector> activeRedYoGraphicVectors = new ArrayList<YoGraphicVector>();
    private List<YoGraphicVector> activeBlueYoGraphicVectors = new ArrayList<YoGraphicVector>();
    private BagOfBalls collisionPositionsVizOne;
    private BagOfBalls collisionPositionsVizTwo;
    private int total;
    private YoRegistry registry;
    private double impulseScale = 0.1;
    private double forceScale = 0.005;
    private double collisionBallRadius = 0.01;

    public DefaultCollisionVisualizer(double forceScale, double impulseScale, double collisionBallRadius, SimulationConstructionSet scs, int numberOfVectorsToCreate) {
        this.forceScale = forceScale;
        this.impulseScale = impulseScale;
        this.collisionBallRadius = collisionBallRadius;
        this.initialize(scs, numberOfVectorsToCreate);
    }

    private void initialize(SimulationConstructionSet scs, int numberOfVectorsToCreate) {
        this.scs = scs;
        YoRegistry rootRegistry = scs.getRootRegistry();
        this.registry = new YoRegistry(this.getClass().getSimpleName());
        rootRegistry.addChild(this.registry);
        this.collisionPositionsVizOne = new BagOfBalls(50, this.collisionBallRadius, "CollisionOne", YoAppearance.Red(), this.registry, this.yoGraphicsListRegistry);
        this.collisionPositionsVizTwo = new BagOfBalls(50, this.collisionBallRadius, "CollisionTwo", YoAppearance.Blue(), this.registry, this.yoGraphicsListRegistry);
        for (int i = 0; i < numberOfVectorsToCreate; ++i) {
            this.addImpulseYoGraphicVector(i * 2, true, this.impulseScale);
            this.addImpulseYoGraphicVector(i * 2 + 1, false, this.impulseScale);
        }
        scs.addYoGraphicsListRegistry(this.yoGraphicsListRegistry);
    }

    public void callBeforeCollisionDetection() {
        this.total = 0;
    }

    @Override
    public void collision(CollisionShape shapeA, CollisionShape shapeB, ExternalForcePoint forceA, ExternalForcePoint forceB, ExternalTorque torqueA, ExternalTorque torqueB) {
        if (this.total >= this.activeRedYoGraphicVectors.size()) {
            return;
        }
        YoGraphicVector yoGraphicVectorA = this.activeRedYoGraphicVectors.get(this.total);
        YoGraphicVector yoGraphicVectorB = this.activeBlueYoGraphicVectors.get(this.total);
        if (forceA != null) {
            this.collisionPositionsVizOne.setBallLoop((FramePoint3DReadOnly)forceA.getYoPosition());
            yoGraphicVectorA.set((FramePoint3DReadOnly)forceA.getYoPosition(), (FrameVector3DReadOnly)forceA.getYoImpulse());
        }
        if (forceB != null) {
            this.collisionPositionsVizTwo.setBallLoop((FramePoint3DReadOnly)forceB.getYoPosition());
            yoGraphicVectorB.set((FramePoint3DReadOnly)forceB.getYoPosition(), (FrameVector3DReadOnly)forceB.getYoImpulse());
        }
        ++this.total;
    }

    public void addImpulseYoGraphicVector(int num, boolean isRed, double scale) {
        List<YoGraphicVector> active = isRed ? this.activeRedYoGraphicVectors : this.activeBlueYoGraphicVectors;
        YoDouble yo0 = new YoDouble("locX_" + num, this.registry);
        YoDouble yo1 = new YoDouble("locY_" + num, this.registry);
        YoDouble yo2 = new YoDouble("locZ_" + num, this.registry);
        YoDouble yo3 = new YoDouble("vecX_" + num, this.registry);
        YoDouble yo4 = new YoDouble("vecY_" + num, this.registry);
        YoDouble yo5 = new YoDouble("vecZ_" + num, this.registry);
        String name = "ContactVisualized" + num;
        AppearanceDefinition appearance = isRed ? YoAppearance.Red() : YoAppearance.Blue();
        YoGraphicVector yoGraphicVector = new YoGraphicVector(name, yo0, yo1, yo2, yo3, yo4, yo5, scale, appearance);
        yoGraphicVector.setLineRadiusWhenOneMeterLong(0.005);
        yoGraphicVector.setMinAndMaxRadiusScaleFactors(0.01, 1.5);
        this.yoGraphicsListRegistry.registerYoGraphic("CollisionVectors", (YoGraphic)yoGraphicVector);
        active.add(yoGraphicVector);
    }

    public void setToInfinity(YoGraphicVector yoGraphicVector) {
        double largeNumber = 1000000.0;
        yoGraphicVector.set(largeNumber, largeNumber, largeNumber, 0.0, 0.0, 0.0);
    }

    public void setForceScale(double forceScale) {
        this.forceScale = forceScale;
    }
}

