/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.hierarchyTree;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import us.ihmc.simulationconstructionset.commands.WriteDataCommandExecutor;
import us.ihmc.simulationconstructionset.gui.CreatedNewRegistriesListener;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.ForcedRepaintPopupMenu;
import us.ihmc.simulationconstructionset.gui.RegistrySettingsChangedListener;
import us.ihmc.simulationconstructionset.gui.hierarchyTree.NamespaceHierarchyNodeRenderer;
import us.ihmc.simulationconstructionset.gui.hierarchyTree.RegistrySelectedListener;
import us.ihmc.simulationconstructionset.util.RegularExpression;
import us.ihmc.simulationconstructionset.util.SimpleFileWriter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class NamespaceHierarchyTree
extends JScrollPane
implements MouseListener,
FocusListener,
CreatedNewRegistriesListener {
    private static final long serialVersionUID = -8489413083414697473L;
    private JTree tree;
    private JFileChooser fileChooser = new JFileChooser();
    private DefaultTreeModel model;
    private DefaultMutableTreeNode top;
    private LinkedHashMap<YoRegistry, DefaultMutableTreeNode> registryTreeNodeMap = new LinkedHashMap();
    private LinkedHashMap<DefaultMutableTreeNode, YoRegistry> treeNodeRegistryMap = new LinkedHashMap();
    private final JFrame frame;
    private final WriteDataCommandExecutor writeDataCommandExecutor;
    private final RegistrySelectedListener registrySelectedListener;
    protected JPopupMenu popupMenu;
    private final YoRegistry root;
    private List<RegistrySettingsChangedListener> registrySettingsChangedListeners = new ArrayList<RegistrySettingsChangedListener>();
    private String filterText = "";
    private boolean showOnlyParameters = false;
    private boolean needToSetupTree = true;
    private YoRegistry topOfTreeRegistry;

    public NamespaceHierarchyTree(RegistrySelectedListener namespaceSelectedListener, JFrame frame, WriteDataCommandExecutor writeDataCommandExecutor, YoRegistry rootRegistry) {
        EventDispatchThreadHelper.checkThatInEventDispatchThread();
        this.registrySelectedListener = namespaceSelectedListener;
        this.topOfTreeRegistry = this.root = rootRegistry;
        this.frame = frame;
        this.writeDataCommandExecutor = writeDataCommandExecutor;
        this.top = new DefaultMutableTreeNode(rootRegistry.getNamespace().getName());
        this.model = new DefaultTreeModel(this.top);
        this.tree = new JTree();
        this.tree.setModel(this.model);
        this.tree.setShowsRootHandles(true);
        this.add(this.tree);
        this.setViewportView(this.tree);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addMouseListener(this);
        this.tree.setToggleClickCount(0);
        this.initPopupMenu();
        this.setUpTree(rootRegistry);
        this.tree.setCellRenderer(new NamespaceHierarchyNodeRenderer(this.treeNodeRegistryMap));
    }

    public void filter(String filterText) {
        this.filterText = filterText;
        this.createdNewRegistries();
    }

    public void filterParameters(boolean showOnlyParameters) {
        this.showOnlyParameters = showOnlyParameters;
        this.createdNewRegistries();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.needToSetupTree) {
            this.setUpTree(this.topOfTreeRegistry);
            this.needToSetupTree = false;
        }
        super.paintComponent(g);
    }

    private void setUpTree(YoRegistry currentregistry) {
        EventDispatchThreadHelper.checkThatInEventDispatchThread();
        this.addNode(currentregistry);
        for (YoRegistry child : currentregistry.getChildren()) {
            this.setUpTree(child);
        }
    }

    private void initPopupMenu() {
        this.popupMenu = new ForcedRepaintPopupMenu();
        JMenuItem toggleVaribleSend = new JMenuItem("Toggle Variable Send");
        toggleVaribleSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceHierarchyTree.this.toggleVariableSend(e);
                NamespaceHierarchyTree.this.popupMenu.setVisible(false);
            }
        });
        this.popupMenu.add(toggleVaribleSend);
        JMenuItem recursiveToggleVaribleSend = new JMenuItem("Recursive Toggle Variable Send");
        recursiveToggleVaribleSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceHierarchyTree.this.recursiveToggleVariableSend(e);
                NamespaceHierarchyTree.this.popupMenu.setVisible(false);
            }
        });
        this.popupMenu.add(recursiveToggleVaribleSend);
        JMenuItem toggleVariableLog = new JMenuItem("Toggle Variable Log");
        toggleVariableLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceHierarchyTree.this.toggleVariableLog(e);
                NamespaceHierarchyTree.this.popupMenu.setVisible(false);
            }
        });
        this.popupMenu.add(toggleVariableLog);
        JMenuItem recursiveToggleVariableLog = new JMenuItem("Recursive Toggle Variable Log");
        recursiveToggleVariableLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceHierarchyTree.this.recursiveToggleVariableLog(e);
                NamespaceHierarchyTree.this.popupMenu.setVisible(false);
            }
        });
        this.popupMenu.add(recursiveToggleVariableLog);
        JMenuItem exportBinaryRegistryData = new JMenuItem("Export to binary format");
        exportBinaryRegistryData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceHierarchyTree.this.exportRegistryData(e, true);
                NamespaceHierarchyTree.this.popupMenu.setVisible(false);
            }
        });
        this.popupMenu.add(exportBinaryRegistryData);
        JMenuItem exportASCIIRegistryData = new JMenuItem("Export to ASCII format");
        exportASCIIRegistryData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceHierarchyTree.this.exportRegistryData(e, false);
                NamespaceHierarchyTree.this.popupMenu.setVisible(false);
            }
        });
        this.popupMenu.add(exportASCIIRegistryData);
        JMenuItem save = new JMenuItem("Save Configuration");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceHierarchyTree.this.saveConfiguration();
                NamespaceHierarchyTree.this.popupMenu.setVisible(false);
            }
        });
        this.popupMenu.add(save);
        JMenuItem load = new JMenuItem("Load Configuration");
        load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceHierarchyTree.this.loadConfiguration();
                NamespaceHierarchyTree.this.popupMenu.setVisible(false);
            }
        });
        this.popupMenu.add(load);
        this.popupMenu.addFocusListener(this);
    }

    private void addNode(YoRegistry registry) {
        EventDispatchThreadHelper.checkThatInEventDispatchThread();
        if (!this.tree.isExpanded(new TreePath(this.top.getPath()))) {
            this.tree.expandPath(new TreePath(this.top.getPath()));
        }
        boolean match = RegularExpression.check((String)registry.getNamespace().getName(), (String)this.filterText);
        if (this.showOnlyParameters && match) {
            match = registry.hasParametersDeep();
        }
        if (match) {
            if (registry.getParent() == null || !this.registryTreeNodeMap.containsKey(registry.getParent())) {
                DefaultMutableTreeNode newTopLevelAncestor = new DefaultMutableTreeNode(registry.getNamespace().getShortName());
                this.registryTreeNodeMap.put(registry, newTopLevelAncestor);
                this.treeNodeRegistryMap.put(newTopLevelAncestor, registry);
                this.top.add(newTopLevelAncestor);
                this.model.setRoot(this.top);
            } else {
                DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(registry.getNamespace().getShortName());
                this.registryTreeNodeMap.put(registry, newChild);
                this.treeNodeRegistryMap.put(newChild, registry);
                this.registryTreeNodeMap.get(registry.getParent()).add(newChild);
            }
        }
    }

    public void showNamespace(YoRegistry registry) {
        if (this.registryTreeNodeMap.containsKey(registry)) {
            TreePath pathToNamespace = new TreePath(this.registryTreeNodeMap.get(registry).getPath());
            this.tree.expandPath(pathToNamespace);
            this.tree.scrollPathToVisible(pathToNamespace);
            this.tree.setSelectionPath(pathToNamespace);
        } else {
            System.err.println("Warning: " + registry.getNamespace().getName() + " not found.");
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        TreePath treePath;
        if (arg0.getClickCount() == 2 && (treePath = this.tree.getPathForLocation(arg0.getX(), arg0.getY())) != null && treePath.getPathCount() >= 1 && this.registryTreeNodeMap.containsValue(treePath.getLastPathComponent())) {
            YoRegistry registry = this.treeNodeRegistryMap.get(treePath.getLastPathComponent());
            this.registrySelectedListener.registryWasSelected(registry);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.popupMenu.show((Component)arg0.getSource(), arg0.getX(), arg0.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.popupMenu.show((Component)arg0.getSource(), arg0.getX(), arg0.getY());
        }
    }

    private void recursiveToggleVariableSend(ActionEvent arg0) {
        boolean toggleSend = true;
        boolean toggleLog = false;
        boolean recursive = true;
        this.toggleVariableSendOrLog(arg0, toggleSend, toggleLog, recursive);
    }

    private void toggleVariableSend(ActionEvent arg0) {
        boolean toggleSend = true;
        boolean toggleLog = false;
        boolean recursive = false;
        this.toggleVariableSendOrLog(arg0, toggleSend, toggleLog, recursive);
    }

    private void recursiveToggleVariableLog(ActionEvent arg0) {
        boolean toggleSend = false;
        boolean toggleLog = true;
        boolean recursive = true;
        this.toggleVariableSendOrLog(arg0, toggleSend, toggleLog, recursive);
    }

    private void toggleVariableLog(ActionEvent arg0) {
        boolean toggleSend = false;
        boolean toggleLog = true;
        boolean recursive = false;
        this.toggleVariableSendOrLog(arg0, toggleSend, toggleLog, recursive);
    }

    private void toggleVariableSendOrLog(ActionEvent arg0, boolean toggleSend, boolean toggleLog, boolean recursive) {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        ArrayList<YoRegistry> changedRegistries = new ArrayList<YoRegistry>();
        for (int i = 0; i < selectionPaths.length; ++i) {
            TreePath path = selectionPaths[i];
            TreeNode parentNode = (TreeNode)path.getLastPathComponent();
            YoRegistry parentRegistry = this.treeNodeRegistryMap.get(parentNode);
            this.recursiveToggleVariableSendOrLog(recursive, toggleSend, toggleLog, parentNode, parentRegistry, changedRegistries);
        }
        this.notifyRegistrySettingsChangedListeners(changedRegistries);
    }

    private void exportRegistryData(ActionEvent e, final boolean binary) {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        ArrayList<YoVariable> allVariables = new ArrayList<YoVariable>();
        for (int i = 0; i < selectionPaths.length; ++i) {
            TreePath path = selectionPaths[i];
            TreeNode parentNode = (TreeNode)path.getLastPathComponent();
            YoRegistry parentRegistry = this.treeNodeRegistryMap.get(parentNode);
            allVariables.addAll(parentRegistry.collectSubtreeVariables());
        }
        FileFilter filterFilter = new FileFilter(){

            @Override
            public String getDescription() {
                if (binary) {
                    return ".data.gz";
                }
                return ".m";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(this.getDescription());
            }
        };
        this.fileChooser.setFileFilter(filterFilter);
        if (this.fileChooser.showSaveDialog(this.frame) == 0) {
            String fileExt = filterFilter.getDescription();
            File chosenFile = this.fileChooser.getSelectedFile();
            String fileName = chosenFile.getName();
            if (!fileName.endsWith(fileExt)) {
                fileName = fileName.concat(fileExt);
                if (!chosenFile.getName().equals(fileName)) {
                    chosenFile = new File(chosenFile.getParent(), fileName);
                }
            }
            this.writeDataCommandExecutor.writeData(allVariables, binary, binary, chosenFile);
        }
    }

    private void recursiveToggleVariableSendOrLog(boolean recursive, boolean toggleSend, boolean toggleLog, TreeNode parentNode, YoRegistry parentRegistry, List<YoRegistry> changedRegistries) {
        changedRegistries.add(parentRegistry);
        this.model.nodeChanged(parentNode);
        if (recursive) {
            Enumeration<? extends TreeNode> childrenNodes = parentNode.children();
            while (childrenNodes.hasMoreElements()) {
                TreeNode childNode = childrenNodes.nextElement();
                YoRegistry childRegistry = this.treeNodeRegistryMap.get(childNode);
                this.recursiveToggleVariableSendOrLog(recursive, toggleSend, toggleLog, childNode, childRegistry, changedRegistries);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void loadConfiguration() {
        File configs = new File("Configurations");
        JFileChooser openDialog = new JFileChooser(configs);
        File selectedFile = null;
        if (0 == openDialog.showOpenDialog(openDialog)) {
            selectedFile = openDialog.getSelectedFile();
        }
        this.loadConfiguration(selectedFile);
    }

    public void loadConfiguration(File selectedFile) {
        if (selectedFile != null && selectedFile.exists()) {
            List treeNodes = this.root.collectSubtreeRegistries();
            this.notifyRegistrySettingsChangedListeners();
        }
    }

    private void notifyRegistrySettingsChangedListeners() {
        for (RegistrySettingsChangedListener listener : this.registrySettingsChangedListeners) {
            listener.registrySettingsChanged();
        }
    }

    private void notifyRegistrySettingsChangedListeners(List<YoRegistry> yoVariableRegistries) {
        for (RegistrySettingsChangedListener listener : this.registrySettingsChangedListeners) {
            listener.registrySettingsChanged(yoVariableRegistries);
        }
    }

    public void saveConfiguration() {
        System.out.println("save");
        File configs = new File("Configurations");
        JFileChooser saveDialog = new JFileChooser(configs);
        File selectedFile = null;
        if (0 == saveDialog.showSaveDialog(this)) {
            selectedFile = saveDialog.getSelectedFile();
        }
        if (selectedFile != null) {
            SimpleFileWriter writer = new SimpleFileWriter(selectedFile);
            List treeNodes = this.root.collectSubtreeRegistries();
            Object outString = "";
            for (YoRegistry node : treeNodes) {
                outString = (String)outString + node.getNamespace().getName() + "\n";
            }
            writer.write((String)outString);
            writer.close();
        }
    }

    @Override
    public void createdNewRegistries() {
        this.top.removeAllChildren();
        this.registryTreeNodeMap.clear();
        this.treeNodeRegistryMap.clear();
        this.topOfTreeRegistry = this.root;
        this.needToSetupTree = true;
    }

    public void addRegistrySettingsChangedListener(RegistrySettingsChangedListener listener) {
        this.registrySettingsChangedListeners.add(listener);
    }
}

