/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveRobotConfigurationDialogConstructor;
import us.ihmc.tools.gui.MyFileFilter;

public class SaveRobotConfigurationDialogGenerator
implements SaveRobotConfigurationDialogConstructor {
    private FileFilter dataFileFilter = new MyFileFilter(new String[]{".robotConf"}, "Robot Configuration (.robotConf)");
    private JFileChooser dataFileChooser;
    private JFrame frame;
    private SimulationConstructionSet sim;

    public SaveRobotConfigurationDialogGenerator(SimulationConstructionSet sim, JFrame frame) {
        this.frame = frame;
        this.sim = sim;
        try {
            String defaultDirString;
            URL defaultDirURL;
            this.dataFileChooser = new JFileChooser();
            if (sim != null && (defaultDirURL = sim.getClass().getResource(".")) != null && (defaultDirString = defaultDirURL.getPath()) != null) {
                int index = defaultDirString.indexOf("classes");
                if (index > 0) {
                    defaultDirString = defaultDirString.substring(0, index);
                }
                this.setCurrentDirectory(defaultDirString);
            }
            this.dataFileChooser.setAcceptAllFileFilterUsed(false);
            this.dataFileChooser.addChoosableFileFilter(this.dataFileFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentDirectory(File directory) {
        this.dataFileChooser.setCurrentDirectory(directory);
    }

    @Override
    public void setCurrentDirectory(String directory) {
        this.dataFileChooser.setCurrentDirectory(new File(directory));
    }

    @Override
    public void constructDialog() {
        if (this.dataFileChooser.showSaveDialog(this.frame) == 0) {
            Robot robot = this.sim.getRobots()[0];
            File file = this.dataFileChooser.getSelectedFile();
            String fileEnding = ".robotConf";
            String filename = file.getName();
            if (!filename.endsWith(fileEnding)) {
                filename = filename.concat(fileEnding);
                if (!file.getName().equals(filename)) {
                    File newChosenFile;
                    file = newChosenFile = new File(file.getParent(), filename);
                }
            }
            if (robot != null && file != null) {
                this.sim.exportRobotDefinition(robot, file);
            } else {
                System.err.println("File could not be written.");
            }
        }
    }

    public void closeAndDispose() {
        this.dataFileFilter = null;
        this.dataFileChooser = null;
        this.frame = null;
        this.sim = null;
    }
}

