/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.ExportDataDialogListener;
import us.ihmc.simulationconstructionset.gui.config.VarGroupList;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportDataDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogs.ExportDataDialog;
import us.ihmc.simulationconstructionset.gui.dialogs.SCSExportDataFormat;
import us.ihmc.tools.gui.MyFileFilter;

public class ExportDataDialogGenerator
implements ExportDataDialogConstructor,
ExportDataDialogListener {
    private JFrame frame;
    private SimulationConstructionSet sim;
    private VarGroupList varGroupList;
    private JFileChooser dataFileChooser;
    private JFileChooser stateFileChooser;
    private File chosenFile;
    private FileFilter stateFileFilter = new MyFileFilter(new String[]{".state", ".state.gz"}, "State (.state, .state.gz)");
    private FileFilter dataFileFilter = new MyFileFilter(new String[]{".data", ".data.gz", ".data.csv", ".mat"}, "Data (.data, .data.gz, .data.csv, .mat)");

    public ExportDataDialogGenerator(SimulationConstructionSet sim, VarGroupList varGroupList, JFrame frame) {
        this.frame = frame;
        this.sim = sim;
        this.varGroupList = varGroupList;
        try {
            String defaultDirString;
            URL defaultDirURL;
            this.stateFileChooser = new JFileChooser();
            this.dataFileChooser = new JFileChooser();
            if (sim != null && (defaultDirURL = sim.getClass().getResource(".")) != null && (defaultDirString = defaultDirURL.getPath()) != null) {
                int idx = defaultDirString.indexOf("classes");
                if (idx > 0) {
                    defaultDirString = defaultDirString.substring(0, idx);
                }
                this.setCurrentDirectory(defaultDirString);
            }
            this.dataFileChooser.setAcceptAllFileFilterUsed(false);
            this.stateFileChooser.setAcceptAllFileFilterUsed(false);
            this.stateFileChooser.addChoosableFileFilter(this.stateFileFilter);
            this.dataFileChooser.addChoosableFileFilter(this.dataFileFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void closeAndDispose() {
        this.frame = null;
        this.sim = null;
        this.varGroupList = null;
        this.dataFileChooser = null;
        this.stateFileChooser = null;
        this.chosenFile = null;
        this.stateFileFilter = null;
        this.dataFileFilter = null;
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.stateFileChooser.setCurrentDirectory(dir);
        this.dataFileChooser.setCurrentDirectory(dir);
    }

    @Override
    public void setCurrentDirectory(String dir) {
        this.dataFileChooser.setCurrentDirectory(new File(dir));
        this.stateFileChooser.setCurrentDirectory(new File(dir));
    }

    @Override
    public void constructDialog() {
        new ExportDataDialog(this.frame, this.varGroupList, this);
    }

    @Override
    public void export(String varGroup, int dataType, SCSExportDataFormat dataFormat, int dataCompression) {
        this.sim.disableGUIComponents();
        String fileEnding = dataType == 1 ? ".data" : ".state";
        if ((dataFormat == SCSExportDataFormat.ASCII || dataFormat == SCSExportDataFormat.BINARY) && dataCompression == 5) {
            fileEnding = fileEnding.concat(".gz");
        }
        if (dataFormat == SCSExportDataFormat.SPREADSHEET) {
            fileEnding = fileEnding.concat(".csv");
        } else if (dataFormat == SCSExportDataFormat.MATLAB) {
            fileEnding = ".mat";
        }
        if (dataType == 1) {
            if (this.dataFileChooser.showSaveDialog(this.frame) == 0) {
                this.chosenFile = this.dataFileChooser.getSelectedFile();
                String filename = this.chosenFile.getName();
                if (!filename.endsWith(fileEnding)) {
                    filename = filename.concat(fileEnding);
                    if (!this.chosenFile.getName().equals(filename)) {
                        File newChosenFile;
                        this.chosenFile = newChosenFile = new File(this.chosenFile.getParent(), filename);
                    }
                }
                boolean compress = dataCompression == 5;
                switch (dataFormat) {
                    case ASCII: {
                        this.sim.writeData(varGroup, false, compress, this.chosenFile);
                        break;
                    }
                    case BINARY: {
                        this.sim.writeData(varGroup, true, compress, this.chosenFile);
                        break;
                    }
                    case MATLAB: {
                        this.sim.writeMatlabData(varGroup, this.chosenFile);
                        break;
                    }
                    case SPREADSHEET: {
                        this.sim.writeSpreadsheetFormattedData(varGroup, this.chosenFile);
                    }
                }
            }
        } else if (this.stateFileChooser.showSaveDialog(this.frame) == 0) {
            this.chosenFile = this.stateFileChooser.getSelectedFile();
            String filename = this.chosenFile.getName();
            if (!filename.endsWith(fileEnding)) {
                filename = filename.concat(fileEnding);
                if (!this.chosenFile.getName().equals(filename)) {
                    File newChosenFile;
                    this.chosenFile = newChosenFile = new File(this.chosenFile.getParent(), filename);
                }
            }
            boolean compress = dataCompression == 5;
            switch (dataFormat) {
                case ASCII: {
                    this.sim.writeState(varGroup, false, compress, this.chosenFile);
                    break;
                }
                case BINARY: {
                    this.sim.writeState(varGroup, true, compress, this.chosenFile);
                    break;
                }
                case SPREADSHEET: {
                    this.sim.writeSpreadsheetFormattedState(varGroup, this.chosenFile);
                    break;
                }
                case MATLAB: {
                    this.sim.writeMatlabData(varGroup, this.chosenFile);
                }
            }
        }
        this.sim.enableGUIComponents();
    }
}

