/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import us.ihmc.simulationconstructionset.gui.YoGraph;

public class GraphPropertiesPanel
extends JPanel
implements ActionListener {
    private static final NumberFormat numFormat = new DecimalFormat(" 0.00000;-0.00000");
    private final JTextField minTextField;
    private final JTextField maxTextField;
    private final JTextField baseLineTextField;
    private final JRadioButton individualButton;
    private final JRadioButton autoButton;
    private final JRadioButton manualButton;
    private final JRadioButton timePlotButton;
    private final JRadioButton phasePlotButton;
    private final JRadioButton baseLineButton;
    private final JButton createFFTPlotButton;
    private final JButton createBodePlotButton;
    private final YoGraph graph;
    private double newMinVal;
    private double newMaxVal;
    private double[] newBaseVal;

    public GraphPropertiesPanel(YoGraph graph) {
        this.graph = graph;
        this.newMinVal = graph.getManualMinScaling();
        this.newMaxVal = graph.getManualMaxScaling();
        double[] baseLines = graph.getBaseLines();
        this.newBaseVal = baseLines != null && baseLines.length > 0 ? baseLines : new double[]{0.0};
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        Border blackLine = BorderFactory.createLineBorder(Color.black);
        TitledBorder title = BorderFactory.createTitledBorder(blackLine, "Master Setting");
        this.setBorder(title);
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel scalingLabel = new JLabel("Scaling:  ");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        gridbag.setConstraints(scalingLabel, constraints);
        this.add(scalingLabel);
        this.individualButton = new JRadioButton("Individual", graph.getScalingMethod() == 0);
        this.individualButton.addActionListener(this);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        gridbag.setConstraints(this.individualButton, constraints);
        this.add(this.individualButton);
        this.autoButton = new JRadioButton("Auto", graph.getScalingMethod() == 1);
        this.autoButton.addActionListener(this);
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        gridbag.setConstraints(this.autoButton, constraints);
        this.add(this.autoButton);
        this.manualButton = new JRadioButton("Manual", graph.getScalingMethod() == 2);
        this.manualButton.addActionListener(this);
        constraints.gridx = 5;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        gridbag.setConstraints(this.manualButton, constraints);
        this.add(this.manualButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.individualButton);
        group.add(this.autoButton);
        group.add(this.manualButton);
        JLabel settingsLabel = new JLabel("Manual Settings:  ");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        gridbag.setConstraints(settingsLabel, constraints);
        this.add(settingsLabel);
        JLabel minSettingsLabel = new JLabel("  Min:  ");
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        gridbag.setConstraints(minSettingsLabel, constraints);
        this.add(minSettingsLabel);
        String minValString = numFormat.format(this.newMinVal);
        this.minTextField = new JTextField(minValString);
        this.minTextField.addActionListener(this);
        this.minTextField.setEnabled(graph.getScalingMethod() == 2);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        gridbag.setConstraints(this.minTextField, constraints);
        this.add(this.minTextField);
        JLabel maxSettingsLabel = new JLabel("  Max:  ");
        constraints.gridx = 4;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        gridbag.setConstraints(maxSettingsLabel, constraints);
        this.add(maxSettingsLabel);
        String maxValString = numFormat.format(this.newMaxVal);
        this.maxTextField = new JTextField(maxValString);
        this.maxTextField.addActionListener(this);
        this.maxTextField.setEnabled(graph.getScalingMethod() == 2);
        constraints.gridx = 5;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        gridbag.setConstraints(this.maxTextField, constraints);
        this.add(this.maxTextField);
        JLabel rangeLabel = new JLabel("Data Range:  ");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        gridbag.setConstraints(rangeLabel, constraints);
        this.add(rangeLabel);
        JLabel minRangeLabel = new JLabel("  Min:  ");
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        gridbag.setConstraints(minRangeLabel, constraints);
        this.add(minRangeLabel);
        minValString = numFormat.format(graph.getMin());
        JLabel minTextLabel = new JLabel(minValString);
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        gridbag.setConstraints(minTextLabel, constraints);
        this.add(minTextLabel);
        JLabel maxRangeLabel = new JLabel("  Max:  ");
        constraints.gridx = 4;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        gridbag.setConstraints(maxRangeLabel, constraints);
        this.add(maxRangeLabel);
        maxValString = numFormat.format(graph.getMax());
        JLabel maxTextLabel = new JLabel(maxValString);
        constraints.gridx = 5;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        gridbag.setConstraints(maxTextLabel, constraints);
        this.add(maxTextLabel);
        JLabel typeLabel = new JLabel("Plot Type:  ");
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        gridbag.setConstraints(typeLabel, constraints);
        this.add(typeLabel);
        this.timePlotButton = new JRadioButton("Time", graph.getPlotType() == 100);
        this.timePlotButton.addActionListener(this);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        gridbag.setConstraints(this.timePlotButton, constraints);
        this.add(this.timePlotButton);
        this.phasePlotButton = new JRadioButton("Phase", graph.getPlotType() == 101);
        this.phasePlotButton.addActionListener(this);
        constraints.gridx = 3;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        gridbag.setConstraints(this.phasePlotButton, constraints);
        this.add(this.phasePlotButton);
        this.createFFTPlotButton = new JButton("FFT");
        this.createFFTPlotButton.addActionListener(this);
        constraints.gridx = 4;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        gridbag.setConstraints(this.createFFTPlotButton, constraints);
        this.add(this.createFFTPlotButton);
        this.createBodePlotButton = new JButton("Bode");
        this.createBodePlotButton.addActionListener(this);
        constraints.gridx = 5;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        gridbag.setConstraints(this.createBodePlotButton, constraints);
        this.add(this.createBodePlotButton);
        JLabel baseLineLabel = new JLabel("Base Line:  ");
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        gridbag.setConstraints(baseLineLabel, constraints);
        this.add(baseLineLabel);
        Object baseLineValString = "";
        for (double current : this.newBaseVal) {
            baseLineValString = (String)baseLineValString + numFormat.format(current) + ",";
        }
        this.baseLineTextField = new JTextField((String)baseLineValString);
        this.baseLineTextField.addActionListener(this);
        this.baseLineTextField.setEnabled(true);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        gridbag.setConstraints(this.baseLineTextField, constraints);
        this.add(this.baseLineTextField);
        this.baseLineButton = new JRadioButton("Show Base Line", graph.getShowBaseLines());
        this.baseLineButton.setSelected(true);
        this.baseLineButton.addActionListener(this);
        constraints.gridx = 3;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        gridbag.setConstraints(this.baseLineButton, constraints);
        this.add(this.baseLineButton);
        ButtonGroup plotGroup = new ButtonGroup();
        plotGroup.add(this.timePlotButton);
        plotGroup.add(this.phasePlotButton);
    }

    public void commitChanges() {
        this.updateMinTextField();
        this.updateMaxTextField();
        this.updateBaseLineTextField();
        this.graph.setManualScaling(this.newMinVal, this.newMaxVal);
        if (this.individualButton.isSelected()) {
            this.graph.setScalingMethod(0);
        } else if (this.autoButton.isSelected()) {
            this.graph.setScalingMethod(1);
        } else {
            this.graph.setScalingMethod(2);
        }
        if (this.timePlotButton.isSelected()) {
            this.graph.setPlotType(100);
        }
        if (this.phasePlotButton.isSelected()) {
            this.graph.setPlotType(101);
        }
        this.graph.setShowBaseLines(this.baseLineButton.isSelected());
        this.graph.setBaseLines(this.newBaseVal);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.maxTextField) {
            this.updateMaxTextField();
        }
        if (event.getSource() == this.minTextField) {
            this.updateMinTextField();
        }
        if (event.getSource() == this.autoButton) {
            this.maxTextField.setEnabled(false);
            this.minTextField.setEnabled(false);
        }
        if (event.getSource() == this.manualButton) {
            this.maxTextField.setEnabled(true);
            this.minTextField.setEnabled(true);
        }
        if (event.getSource() == this.individualButton) {
            this.maxTextField.setEnabled(false);
            this.minTextField.setEnabled(false);
        }
        if (event.getSource() == this.baseLineButton) {
            this.baseLineTextField.setEnabled(this.baseLineButton.isSelected());
        }
        if (event.getSource() == this.createFFTPlotButton) {
            this.graph.createFFTPlotsFromEntriesBetweenInOutPoints();
        }
        if (event.getSource() == this.createBodePlotButton) {
            this.graph.createBodePlotFromEntriesBetweenInOutPoints();
        }
    }

    public void updateMaxTextField() {
        String text = this.maxTextField.getText();
        try {
            double val;
            this.newMaxVal = val = Double.valueOf(text).doubleValue();
        }
        catch (NumberFormatException e) {
            this.maxTextField.setText(numFormat.format(this.newMaxVal));
        }
    }

    public void updateMinTextField() {
        String text = this.minTextField.getText();
        try {
            double val;
            this.newMinVal = val = Double.valueOf(text).doubleValue();
        }
        catch (NumberFormatException e) {
            this.minTextField.setText(numFormat.format(this.newMinVal));
        }
    }

    public void updateBaseLineTextField() {
        String text = this.baseLineTextField.getText();
        try {
            this.newBaseVal = this.setBaseLines(text);
        }
        catch (NumberFormatException e) {
            Object baseLineValString = "";
            for (double current : this.newBaseVal) {
                baseLineValString = (String)baseLineValString + numFormat.format(current) + ",";
            }
            this.baseLineTextField.setText((String)baseLineValString);
        }
    }

    public double[] setBaseLines(String baseLinesCommaSeperated) {
        String[] lines = baseLinesCommaSeperated.split(",");
        double[] values = new double[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            values[i] = Double.valueOf(lines[i]);
        }
        return values;
    }
}

