/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.util.ground.RepeatingHeightMap;

public class RepeatingGroundProfile
implements GroundProfile3D {
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private double xDistance;
    private double yDistance;
    private final GroundProfile3D groundProfile;
    private final RepeatingHeightMap heightMap;
    private final BoundingBox3D boundingBox;

    public RepeatingGroundProfile(GroundProfile3D groundProfile, double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.xDistance = this.xMax - this.xMin;
        this.yDistance = this.yMax - this.yMin;
        this.groundProfile = groundProfile;
        double zMin = groundProfile.getBoundingBox().getMinZ();
        double zMax = groundProfile.getBoundingBox().getMaxZ();
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
        this.heightMap = new RepeatingHeightMap(groundProfile.getHeightMapIfAvailable(), xMin, xMax, yMin, yMax);
    }

    private double xLocal(double xGlobal) {
        return Math.abs(xGlobal - this.xMin) % this.xDistance + this.xMin;
    }

    private double yLocal(double yGlobal) {
        return Math.abs(yGlobal - this.yMin) % this.yDistance + this.yMin;
    }

    public boolean isClose(double x, double y, double z) {
        return this.groundProfile.isClose(this.xLocal(x), this.yLocal(y), z);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        double localX = this.xLocal(x);
        double localY = this.yLocal(y);
        return this.groundProfile.checkIfInside(localX, localY, z, intersectionToPack, normalToPack);
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this.heightMap;
    }
}

