/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import net.jafama.FastMath;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.simulationconstructionset.BallAndSocketSCSJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.BallAndSocketJointPhysics;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class BallAndSocketJoint
extends Joint
implements BallAndSocketSCSJoint {
    private static final long serialVersionUID = 6863566500545068060L;
    private YoBoolean isPinned;
    public final YoDouble q_qs;
    public final YoDouble q_qx;
    public final YoDouble q_qy;
    public final YoDouble q_qz;
    public final YoDouble qd_wx;
    public final YoDouble qd_wy;
    public final YoDouble qd_wz;
    public final YoDouble qdd_wx;
    public final YoDouble qdd_wy;
    public final YoDouble qdd_wz;
    public final YoDouble tau_wx;
    public final YoDouble tau_wy;
    public final YoDouble tau_wz;
    public final YoQuaternion quaternion;
    public final YoVector3D angularVelocity;
    public final YoVector3D angularAcceleration;
    public final YoVector3D torqueVector;
    private final boolean createYawPitchRollYoVariable;
    public final YoDouble q_yaw;
    public final YoDouble q_pitch;
    public final YoDouble q_roll;

    public BallAndSocketJoint(String name, Tuple3DReadOnly offset, Robot rob) {
        this(name, offset, rob, false);
    }

    public BallAndSocketJoint(String name, Tuple3DReadOnly offset, Robot rob, boolean createYawPitchRollYoVariable) {
        super((String)name, offset, rob, 6);
        this.physics = new BallAndSocketJointPhysics(this);
        YoRegistry registry = rob.getRobotsYoRegistry();
        this.createYawPitchRollYoVariable = createYawPitchRollYoVariable;
        if (name == null) {
            name = "";
        } else if (!((String)name).isEmpty()) {
            name = (String)name + "_";
        }
        this.q_qs = new YoDouble("q_" + (String)name + "qs", "BallAndSocketJoint orientation quaternion qs", registry);
        this.q_qs.set(1.0);
        this.q_qx = new YoDouble("q_" + (String)name + "qx", "BallAndSocketJoint orientation quaternion qx", registry);
        this.q_qy = new YoDouble("q_" + (String)name + "qy", "BallAndSocketJoint orientation quaternion qy", registry);
        this.q_qz = new YoDouble("q_" + (String)name + "qz", "BallAndSocketJoint orientation quaternion qz", registry);
        this.qd_wx = new YoDouble("qd_" + (String)name + "wx", "BallAndSocketJoint rotational velocity about x", registry);
        this.qd_wy = new YoDouble("qd_" + (String)name + "wy", "BallAndSocketJoint rotational velocity about y", registry);
        this.qd_wz = new YoDouble("qd_" + (String)name + "wz", "BallAndSocketJoint rotational velocity about z", registry);
        this.qdd_wx = new YoDouble("qdd_" + (String)name + "wx", "BallAndSocketJoint rotational acceleration about x", registry);
        this.qdd_wy = new YoDouble("qdd_" + (String)name + "wy", "BallAndSocketJoint rotational acceleration about y", registry);
        this.qdd_wz = new YoDouble("qdd_" + (String)name + "wz", "BallAndSocketJoint rotational acceleration about z", registry);
        this.tau_wx = new YoDouble("tau_" + (String)name + "wx", "BallAndSocketJoint torque about x", registry);
        this.tau_wy = new YoDouble("tau_" + (String)name + "wy", "BallAndSocketJoint torque about y", registry);
        this.tau_wz = new YoDouble("tau_" + (String)name + "wz", "BallAndSocketJoint torque about z", registry);
        this.quaternion = new YoQuaternion(this.q_qx, this.q_qy, this.q_qz, this.q_qs);
        this.angularVelocity = new YoVector3D(this.qd_wx, this.qd_wy, this.qd_wz);
        this.angularAcceleration = new YoVector3D(this.qdd_wx, this.qdd_wy, this.qdd_wz);
        this.torqueVector = new YoVector3D(this.tau_wx, this.tau_wy, this.tau_wz);
        if (createYawPitchRollYoVariable) {
            this.q_yaw = new YoDouble("q_" + (String)name + "yaw", "BallAndSocketJoint yaw orientation", registry);
            this.q_pitch = new YoDouble("q_" + (String)name + "pitch", "BallAndSocketJoint pitch orientation", registry);
            this.q_roll = new YoDouble("q_" + (String)name + "roll", "BallAndSocketJoint roll orientation", registry);
        } else {
            this.q_yaw = null;
            this.q_pitch = null;
            this.q_roll = null;
        }
        this.isPinned = new YoBoolean((String)name + "IsPinned", "Whether this BallAndSocketJoint is pinned or not", registry);
        this.jointTransform3D.getRotation().set((Orientation3DReadOnly)this.quaternion);
        this.physics.u_i = null;
    }

    @Override
    public void setOrientation(Orientation3DReadOnly orientation) {
        this.quaternion.set(orientation);
    }

    public void setYawPitchRoll(double yaw, double pitch, double roll) {
        this.quaternion.setYawPitchRoll(yaw, pitch, roll);
    }

    public void setYawPitchRoll(double yaw, double pitch, double roll, double wz, double wy, double wx) {
        this.setYawPitchRoll(yaw, pitch, roll);
        this.angularVelocity.set(wx, wy, wz);
    }

    public void setRotation(RotationMatrixReadOnly rotation) {
        this.setOrientation((Orientation3DReadOnly)rotation);
    }

    public void setQuaternion(QuaternionReadOnly q) {
        this.setOrientation((Orientation3DReadOnly)q);
    }

    @Override
    public void setAngularVelocityInBody(Vector3DReadOnly angularVelocityInBody) {
        this.angularVelocity.set((Tuple3DReadOnly)angularVelocityInBody);
    }

    public void setAngularAccelerationInBody(Vector3DReadOnly angularAccelerationInBody) {
        this.angularAcceleration.set((Tuple3DReadOnly)angularAccelerationInBody);
    }

    @Override
    public void getAngularVelocity(FrameVector3DBasics angularVelocityToPack, ReferenceFrame bodyFrame) {
        angularVelocityToPack.setIncludingFrame(bodyFrame, (Tuple3DReadOnly)this.angularVelocity);
    }

    public YoDouble getQuaternionQs() {
        return this.q_qs;
    }

    public YoDouble getQuaternionQx() {
        return this.q_qx;
    }

    public YoDouble getQuaternionQy() {
        return this.q_qy;
    }

    public YoDouble getQuaternionQz() {
        return this.q_qz;
    }

    public YoQuaternion getOrientation() {
        return this.quaternion;
    }

    public Quaternion getQuaternion() {
        return new Quaternion((QuaternionReadOnly)this.quaternion);
    }

    public void getQuaternion(QuaternionBasics quaternionToPack) {
        quaternionToPack.set((QuaternionReadOnly)this.quaternion);
    }

    public YoDouble getAngularVelocityX() {
        return this.qd_wx;
    }

    public YoDouble getAngularVelocityY() {
        return this.qd_wy;
    }

    public YoDouble getAngularVelocityZ() {
        return this.qd_wz;
    }

    public YoVector3D getAngularVelocity() {
        return this.angularVelocity;
    }

    public Vector3D getAngularVelocityInBody() {
        return new Vector3D((Tuple3DReadOnly)this.angularVelocity);
    }

    public void getAngularVelocityInBody(Vector3DBasics vectorToPack) {
        vectorToPack.set((Tuple3DReadOnly)this.angularVelocity);
    }

    public YoDouble getAngularAccelerationX() {
        return this.qdd_wx;
    }

    public YoDouble getAngularAccelerationY() {
        return this.qdd_wy;
    }

    public YoDouble getAngularAccelerationZ() {
        return this.qdd_wz;
    }

    public YoVector3D getAngularAcceleration() {
        return this.angularAcceleration;
    }

    public Vector3D getAngularAccelerationInBody() {
        return new Vector3D((Tuple3DReadOnly)this.angularAcceleration);
    }

    public void getAngularAccelerationInBody(Vector3DBasics angularAccelerationInBodyToPack) {
        angularAccelerationInBodyToPack.set((Tuple3DReadOnly)this.angularAcceleration);
    }

    public void getAngularAcceleration(FrameVector3DBasics angularAccelerationToPack, ReferenceFrame bodyFrame) {
        angularAccelerationToPack.setIncludingFrame(bodyFrame, (Tuple3DReadOnly)this.angularAcceleration);
    }

    public void getYawPitchRoll(YoDouble yaw, YoDouble pitch, YoDouble roll) {
        double pitchArgument = -2.0 * this.q_qx.getDoubleValue() * this.q_qz.getDoubleValue() + 2.0 * this.q_qs.getDoubleValue() * this.q_qy.getDoubleValue();
        pitch.set(FastMath.asin((double)pitchArgument));
        if (Math.abs(pitch.getDoubleValue()) < 1.5393804002589986) {
            yaw.set(FastMath.atan2((double)(2.0 * this.q_qx.getDoubleValue() * this.q_qy.getDoubleValue() + 2.0 * this.q_qz.getDoubleValue() * this.q_qs.getDoubleValue()), (double)(1.0 - 2.0 * this.q_qy.getDoubleValue() * this.q_qy.getDoubleValue() - 2.0 * this.q_qz.getDoubleValue() * this.q_qz.getDoubleValue())));
            roll.set(FastMath.atan2((double)(2.0 * this.q_qy.getDoubleValue() * this.q_qz.getDoubleValue() + 2.0 * this.q_qx.getDoubleValue() * this.q_qs.getDoubleValue()), (double)(1.0 - 2.0 * this.q_qx.getDoubleValue() * this.q_qx.getDoubleValue() - 2.0 * this.q_qy.getDoubleValue() * this.q_qy.getDoubleValue())));
        } else {
            yaw.set(2.0 * FastMath.atan2((double)this.q_qz.getDoubleValue(), (double)this.q_qs.getDoubleValue()));
            roll.set(0.0);
        }
    }

    public double[] getYawPitchRoll() {
        double[] yawPitchRollToReturn = new double[3];
        double pitchArgument = -2.0 * this.q_qx.getDoubleValue() * this.q_qz.getDoubleValue() + 2.0 * this.q_qs.getDoubleValue() * this.q_qy.getDoubleValue();
        double pitch = 0.0;
        double roll = 0.0;
        double yaw = 0.0;
        pitch = FastMath.asin((double)pitchArgument);
        if (Math.abs(pitch) < 1.5393804002589986) {
            yaw = FastMath.atan2((double)(2.0 * this.q_qx.getDoubleValue() * this.q_qy.getDoubleValue() + 2.0 * this.q_qz.getDoubleValue() * this.q_qs.getDoubleValue()), (double)(1.0 - 2.0 * this.q_qy.getDoubleValue() * this.q_qy.getDoubleValue() - 2.0 * this.q_qz.getDoubleValue() * this.q_qz.getDoubleValue()));
            roll = FastMath.atan2((double)(2.0 * this.q_qy.getDoubleValue() * this.q_qz.getDoubleValue() + 2.0 * this.q_qx.getDoubleValue() * this.q_qs.getDoubleValue()), (double)(1.0 - 2.0 * this.q_qx.getDoubleValue() * this.q_qx.getDoubleValue() - 2.0 * this.q_qy.getDoubleValue() * this.q_qy.getDoubleValue()));
        } else {
            yaw = 2.0 * FastMath.atan2((double)this.q_qz.getDoubleValue(), (double)this.q_qs.getDoubleValue());
            roll = 0.0;
        }
        yawPitchRollToReturn[0] = yaw;
        yawPitchRollToReturn[1] = pitch;
        yawPitchRollToReturn[2] = roll;
        return yawPitchRollToReturn;
    }

    public boolean isPinned() {
        return this.isPinned.getValue();
    }

    public void setPinned(boolean isPinned) {
        this.isPinned.set(isPinned);
    }

    @Override
    public void update() {
        this.jointTransform3D.getRotation().set((Orientation3DReadOnly)this.quaternion);
        if (this.createYawPitchRollYoVariable) {
            this.getYawPitchRoll(this.q_yaw, this.q_pitch, this.q_roll);
        }
    }

    @Override
    public void setJointTorque(Vector3DReadOnly jointTorque) {
        this.torqueVector.set((Tuple3DReadOnly)jointTorque);
    }

    @Override
    public YoVector3D getJointTorque() {
        return this.torqueVector;
    }
}

