/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class StairGroundProfile
extends GroundProfileFromHeightMap {
    private final BoundingBox3D boundingBox;
    private final double groundXStep;
    private final double groundZStep;
    private final double startStairsAtX;

    public StairGroundProfile(double groundXStep, double groundZStep) {
        double xMin = -1.0;
        double xMax = 4.0;
        double yMin = -1.0;
        double yMax = 1.0;
        this.startStairsAtX = 0.0;
        this.groundXStep = groundXStep;
        this.groundZStep = groundZStep;
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Double.POSITIVE_INFINITY;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public StairGroundProfile(double groundXStep, double groundZStep, double xMin, double xMax, double yMin, double yMax, double startStairsAtX) {
        this.startStairsAtX = startStairsAtX;
        this.groundXStep = groundXStep;
        this.groundZStep = groundZStep;
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Double.POSITIVE_INFINITY;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        int stairNumber = (int)Math.ceil(x - this.startStairsAtX / this.groundXStep);
        if (x < this.startStairsAtX || y < this.boundingBox.getMinY() || y > this.boundingBox.getMaxY()) {
            return 0.0;
        }
        return (double)stairNumber * this.groundZStep;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        normal.set(0.0, 0.0, 1.0);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

