/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;

public class ShipCorridorGroundProfile
implements GroundProfile3D,
HeightMapWithNormals {
    private final BoundingBox3D boundingBox;
    private final double zGroundPosition;
    private final double yMaxCorridor;
    private final double yMinCorridor;
    private final double maxWallHeight;
    private final double wallInclination;
    private final double wallEndY = 2.0;
    private Vector3D tempVector = new Vector3D();
    private Vector3D tempVectorTwo = new Vector3D();

    public ShipCorridorGroundProfile(double xMax, double xMin, double yMax, double yMin, double yMaxCorridor, double yMinCorridor, double zGroundPosition, double maxWallHeight) {
        this.yMaxCorridor = yMaxCorridor;
        this.yMinCorridor = yMinCorridor;
        this.zGroundPosition = zGroundPosition;
        this.maxWallHeight = maxWallHeight;
        this.wallInclination = Math.toRadians(2.0);
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Double.POSITIVE_INFINITY;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public ShipCorridorGroundProfile(double xMax, double xMin, double yMax, double yMin, double yMaxCorridor, double yMinCorridor, double zGroundPosition, double maxWallHeight, double wallInclination) {
        this.yMaxCorridor = yMaxCorridor;
        this.yMinCorridor = yMinCorridor;
        this.zGroundPosition = zGroundPosition;
        this.maxWallHeight = maxWallHeight;
        this.wallInclination = wallInclination;
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Double.POSITIVE_INFINITY;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, heightAt, normalToPack);
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        double height;
        if (y > this.yMaxCorridor && y < 2.0) {
            height = (y - this.yMaxCorridor) / Math.tan(this.wallInclination);
            if (height >= this.maxWallHeight) {
                height = this.maxWallHeight;
            }
        } else if (y < this.yMaxCorridor && y > this.yMinCorridor) {
            height = this.zGroundPosition;
        } else if (y > -2.0 && y < this.yMinCorridor) {
            height = (-y - this.yMaxCorridor) / Math.tan(this.wallInclination);
            if (height >= this.maxWallHeight) {
                height = this.maxWallHeight;
            }
        } else {
            height = this.maxWallHeight;
        }
        return height;
    }

    public boolean isClose(double x, double y, double z) {
        return true;
    }

    public void closestIntersectionTo(double x, double y, double z, Point3DBasics intersection) {
        double r;
        double separationAngleFromVertical = 1.5707963267948966 - 0.5 * (1.5707963267948966 + this.wallInclination);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
        if (y > 0.0 && y > this.yMaxCorridor - z * Math.tan(separationAngleFromVertical)) {
            r = Math.cos(this.wallInclination) * (this.getAbsWallY(z) - y);
            intersection.setZ(z - r * Math.sin(this.wallInclination));
            intersection.setY(y + r * Math.cos(this.wallInclination));
        }
        if (Math.abs(y) < z * Math.tan(separationAngleFromVertical)) {
            // empty if block
        }
        if (y < 0.0 && y < this.yMinCorridor + z * Math.tan(separationAngleFromVertical)) {
            r = Math.cos(this.wallInclination) * (this.getAbsWallY(z) + y);
            intersection.setZ(z - r * Math.sin(this.wallInclination));
            intersection.setY(y - r * Math.cos(this.wallInclination));
        }
        intersection.setX(x);
    }

    public double getAbsWallY(double z) {
        double y = -1.0;
        if (z > 0.0 && z < this.maxWallHeight) {
            y = this.yMaxCorridor + z * Math.tan(this.wallInclination);
        }
        return y;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        double height = this.heightAt(x, y, z);
        if (y > this.yMaxCorridor && y < 2.0) {
            normal.setY(-1.0);
            normal.setZ(Math.tan(this.wallInclination));
            if (height >= this.maxWallHeight) {
                normal.setY(0.0);
                normal.setZ(1.0);
            }
        } else if (y < this.yMaxCorridor && y > this.yMinCorridor) {
            normal.setY(0.0);
            normal.setZ(1.0);
        } else if (y > -2.0 && y < this.yMinCorridor) {
            normal.setY(1.0);
            normal.setZ(Math.tan(this.wallInclination));
            if (height >= this.maxWallHeight) {
                normal.setY(0.0);
                normal.setZ(1.0);
            }
        } else {
            normal.setY(0.0);
            normal.setZ(1.0);
        }
        normal.setX(0.0);
        normal.normalize();
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        this.closestIntersectionTo(x, y, z, intersectionToPack);
        this.surfaceNormalAt(x, y, z, normalToPack);
        this.tempVector.set((Tuple3DReadOnly)intersectionToPack);
        this.tempVectorTwo.set(x, y, z);
        this.tempVector.sub((Tuple3DReadOnly)this.tempVectorTwo);
        double dotProduct = this.tempVector.dot((Tuple3DReadOnly)normalToPack);
        return dotProduct < 0.0;
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersection, Vector3DBasics normal) {
        this.closestIntersectionTo(x, y, z, intersection);
        this.surfaceNormalAt(x, y, z, normal);
    }

    public double getYMaxCorridor() {
        return this.yMaxCorridor;
    }

    public double getYMinCorridor() {
        return this.yMinCorridor;
    }

    public double getWallInclination() {
        return this.wallInclination;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }
}

