/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;

public class SphereShapeDescription<T extends SphereShapeDescription<T>>
implements CollisionShapeDescription<T> {
    private double radius;
    private Point3D center = new Point3D();
    private final BoundingBox3D boundingBox = new BoundingBox3D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private boolean boundingBoxNeedsUpdating = true;
    private final Vector3D tempVectorForRolling = new Vector3D();

    public SphereShapeDescription(double radius, Point3D center) {
        this.radius = radius;
        this.center.set(center);
        this.boundingBoxNeedsUpdating = true;
    }

    @Override
    public SphereShapeDescription<T> copy() {
        SphereShapeDescription<T> copy = new SphereShapeDescription<T>(this.radius, this.center);
        this.boundingBoxNeedsUpdating = true;
        return copy;
    }

    public double getRadius() {
        return this.radius;
    }

    public void getCenter(Point3D centerToPack) {
        centerToPack.set(this.center);
    }

    @Override
    public void setFrom(T sphereShapeDescription) {
        this.radius = ((SphereShapeDescription)sphereShapeDescription).getRadius();
        ((SphereShapeDescription)sphereShapeDescription).getCenter(this.center);
        this.boundingBoxNeedsUpdating = true;
    }

    @Override
    public void applyTransform(RigidBodyTransform transform) {
        transform.transform((Point3DBasics)this.center);
        this.boundingBoxNeedsUpdating = true;
    }

    @Override
    public void getBoundingBox(BoundingBox3D boundingBoxToPack) {
        if (this.boundingBoxNeedsUpdating) {
            this.updateBoundingBox();
            this.boundingBoxNeedsUpdating = false;
        }
        boundingBoxToPack.set(this.boundingBox);
    }

    private void updateBoundingBox() {
        this.boundingBox.set(this.center.getX() - this.radius, this.center.getY() - this.radius, this.center.getZ() - this.radius, this.center.getX() + this.radius, this.center.getY() + this.radius, this.center.getZ() + this.radius);
    }

    @Override
    public boolean isPointInside(Point3D pointInWorld) {
        return this.center.distanceSquared((Point3DReadOnly)pointInWorld) <= this.radius * this.radius;
    }

    @Override
    public boolean rollContactIfRolling(Vector3D surfaceNormal, Point3D pointToRoll) {
        pointToRoll.set(this.center);
        this.tempVectorForRolling.set(surfaceNormal);
        this.tempVectorForRolling.normalize();
        this.tempVectorForRolling.scale(this.radius);
        pointToRoll.add((Tuple3DReadOnly)this.tempVectorForRolling);
        return true;
    }
}

