/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.ArrayList;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.util.ground.Contactable;
import us.ihmc.simulationconstructionset.util.ground.StickSlipContactCalculator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class SimpleStickSlipContactModel {
    private final ArrayList<ExternalForcePoint> contactPointAs = new ArrayList();
    private final ArrayList<Contactable> contactableBs = new ArrayList();
    private final ArrayList<YoInteger> contactPointAContactingContactableIndices = new ArrayList();
    private final ArrayList<YoInteger> contactPointAContactingGroundContactIndices = new ArrayList();
    private final Point3D contactATempPosition = new Point3D();
    private final YoDouble kContact;
    private final YoDouble bContact;
    private final YoDouble alphaStick;
    private final YoDouble alphaSlip;
    private final StickSlipContactCalculator stickSlipContactCalculator;
    private final YoRegistry registry;

    public SimpleStickSlipContactModel(String namePrefix, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.kContact = new YoDouble(namePrefix + "KContact", this.registry);
        this.bContact = new YoDouble(namePrefix + "BContact", this.registry);
        this.alphaStick = new YoDouble(namePrefix + "AlphaStick", this.registry);
        this.alphaSlip = new YoDouble(namePrefix + "AlphaSlip", this.registry);
        this.stickSlipContactCalculator = new StickSlipContactCalculator();
        parentRegistry.addChild(this.registry);
    }

    public void setKContact(double kContact) {
        this.kContact.set(kContact);
    }

    public void setBContact(double bContact) {
        this.bContact.set(bContact);
    }

    public void setFrictionCoefficients(double alphaStick, double alphaSlip) {
        if (alphaSlip > alphaStick) {
            throw new RuntimeException("alphaSlip > alphaStick");
        }
        if (alphaSlip < 0.0 || alphaStick < 0.0) {
            throw new RuntimeException("alphaStick and alphaSlip must both be greater than 0.0");
        }
        this.alphaStick.set(alphaStick);
        this.alphaSlip.set(alphaSlip);
    }

    public void addContactPoint(ExternalForcePoint contactPoint) {
        this.contactPointAs.add(contactPoint);
        YoInteger contactableIndex = new YoInteger(contactPoint.getName() + "ContactableIndex", this.registry);
        this.contactPointAContactingContactableIndices.add(contactableIndex);
        contactableIndex.set(-1);
        YoInteger contactIndex = new YoInteger(contactPoint.getName() + "GroundContactIndex", this.registry);
        this.contactPointAContactingGroundContactIndices.add(contactIndex);
        contactIndex.set(-1);
    }

    public void addContactable(Contactable contactable) {
        this.contactableBs.add(contactable);
    }

    public void doContact() {
        int contactableBIndex;
        ExternalForcePoint contactPointA;
        int externalForcePointIndex;
        for (externalForcePointIndex = 0; externalForcePointIndex < this.contactPointAs.size(); ++externalForcePointIndex) {
            contactPointA = this.contactPointAs.get(externalForcePointIndex);
            if (this.contactPointAContactingContactableIndices.get(externalForcePointIndex).getIntegerValue() >= 0) continue;
            for (contactableBIndex = 0; contactableBIndex < this.contactableBs.size(); ++contactableBIndex) {
                Contactable contactableB = this.contactableBs.get(contactableBIndex);
                contactPointA.getPosition((Tuple3DBasics)this.contactATempPosition);
                boolean areInContact = contactableB.isPointOnOrInside(this.contactATempPosition);
                if (!areInContact) continue;
                int contactPointBIndex = contactableB.getAndLockAvailableContactPoint();
                GroundContactPoint contactPointB = contactableB.getLockedContactPoint(contactPointBIndex);
                this.contactPointAContactingContactableIndices.get(externalForcePointIndex).set(contactableBIndex);
                this.contactPointAContactingGroundContactIndices.get(externalForcePointIndex).set(contactPointBIndex);
                this.stickSlipContactCalculator.doContactMade(contactPointA, contactableB, contactPointB);
            }
        }
        for (externalForcePointIndex = 0; externalForcePointIndex < this.contactPointAs.size(); ++externalForcePointIndex) {
            contactPointA = this.contactPointAs.get(externalForcePointIndex);
            contactableBIndex = this.contactPointAContactingContactableIndices.get(externalForcePointIndex).getIntegerValue();
            int contactPointBIndex = this.contactPointAContactingGroundContactIndices.get(externalForcePointIndex).getIntegerValue();
            if (contactableBIndex < 0) continue;
            Contactable contactableB = this.contactableBs.get(contactableBIndex);
            GroundContactPoint contactPointB = contactableB.getLockedContactPoint(contactPointBIndex);
            contactPointA.getPosition((Tuple3DBasics)this.contactATempPosition);
            boolean areInContact = contactableB.isPointOnOrInside(this.contactATempPosition);
            if (areInContact) {
                this.stickSlipContactCalculator.doCurrentlyInContact(contactPointA, contactableB, contactPointB, this.kContact.getDoubleValue(), this.bContact.getDoubleValue(), this.alphaStick.getDoubleValue(), this.alphaSlip.getDoubleValue());
                continue;
            }
            this.stickSlipContactCalculator.doContactBroken(contactPointA, contactPointB);
            this.contactPointAContactingContactableIndices.get(externalForcePointIndex).set(-1);
            this.contactPointAContactingGroundContactIndices.get(externalForcePointIndex).set(-1);
            contactableB.unlockContactPoint(contactPointB);
        }
    }
}

