/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.commands.WriteDataCommandExecutor;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariablesHolder;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariablesPanel;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayPanel;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.YoEntryBox;
import us.ihmc.simulationconstructionset.gui.YoVariableDoubleClickListener;
import us.ihmc.simulationconstructionset.gui.YoVariableRegistryParameterPanel;
import us.ihmc.simulationconstructionset.gui.YoVariableRegistryVarPanel;
import us.ihmc.simulationconstructionset.gui.hierarchyTree.NamespaceHierarchyTree;
import us.ihmc.simulationconstructionset.gui.hierarchyTree.NamespaceSearchPanel;
import us.ihmc.simulationconstructionset.gui.hierarchyTree.RegistrySelectedListener;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanel;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanelJPopupMenu;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariableSearchPanel;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableList;

public class YoVariableExplorerTabbedPane
extends JPanel
implements RegistrySelectedListener {
    private static final long serialVersionUID = -3403238490036872889L;
    private final YoRegistry rootRegistry;
    private final LinkedHashMap<JComponent, Integer> tabIndices = new LinkedHashMap();
    private JTabbedPane tabPane;
    private YoVariablePanel visibleVarPanel;
    private YoRegistry visibleVarPanelRegistry;
    private JScrollPane scrollPane;
    private NamespaceHierarchyTree namespaceHierarchyTree;
    private JSplitPane splitPane;
    private JPanel variableDisplayPanel;
    private YoVariableSearchPanel variableSearchPanel;
    private YoEntryBox entryBox;
    private boolean onlyParametersState = false;
    private JCheckBox onlyParameters;
    private Timer alertChangeListenersTimer;
    private TimerTask alertChangeListenersTask;
    private final long OBSERVER_NOTIFICATION_PERIOD = 250L;
    private JScrollPane bookmarkedVariablesScrollPane;
    private final SelectedVariableHolder selectedVariableHolder;
    private YoVariablePanelJPopupMenu varPanelJPopupMenu;
    private int tabIndex = 0;

    public YoVariableExplorerTabbedPane(YoVariableDoubleClickListener yoVariableDoubleClickListener, JFrame frame, BookmarkedVariablesHolder bookmarkedVariablesHolder, final SelectedVariableHolder selectedVariableHolder, EntryBoxArrayPanel entryBoxArrayPanel, WriteDataCommandExecutor writeDataCommandExecutor, YoRegistry rootRegistry) {
        this.setName("CombinedVarPanel");
        this.setLayout(new BorderLayout());
        this.rootRegistry = rootRegistry;
        this.selectedVariableHolder = selectedVariableHolder;
        this.tabPane = new JTabbedPane();
        this.tabPane.setName("CombinedVarPanel");
        this.tabPane.addChangeListener(new TabChangedAction());
        this.entryBox = new YoEntryBox(entryBoxArrayPanel, selectedVariableHolder);
        if (selectedVariableHolder != null) {
            selectedVariableHolder.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    YoVariableExplorerTabbedPane.this.entryBox.setVariableInThisBox(selectedVariableHolder.getSelectedVariable());
                }
            });
        }
        this.variableDisplayPanel = new JPanel(new BorderLayout());
        this.variableDisplayPanel.setName("VariableDisplayPanel");
        this.onlyParameters = new JCheckBox("Show parameters only");
        this.onlyParameters.setAlignmentX(0.0f);
        this.onlyParameters.addActionListener(new ShowOnlyParameterAction());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.namespaceHierarchyTree = new NamespaceHierarchyTree(this, frame, writeDataCommandExecutor, rootRegistry);
        NamespaceSearchPanel namespaceSearchPanel = new NamespaceSearchPanel(this.namespaceHierarchyTree);
        BookmarkedVariablesPanel bookmarkedVariablesPanel = new BookmarkedVariablesPanel(new YoVariableList("Bookmarked Variables"), selectedVariableHolder, bookmarkedVariablesHolder);
        this.bookmarkedVariablesScrollPane = new JScrollPane(bookmarkedVariablesPanel, 20, 31);
        this.splitPane = new JSplitPane(0, true, this.scrollPane, this.bookmarkedVariablesScrollPane);
        this.splitPane.setDividerSize(3);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerLocation(200);
        this.variableDisplayPanel.add((Component)this.splitPane, "Center");
        this.variableDisplayPanel.add((Component)this.entryBox, "South");
        this.insertTab("Name Space", namespaceSearchPanel, this.tabIndex++);
        this.insertTab("Variables", this.variableDisplayPanel, this.tabIndex++);
        this.tabPane.setSelectedIndex(0);
        this.add((Component)this.onlyParameters, "North");
        this.add((Component)this.tabPane, "Center");
        this.tabPane.setMinimumSize(new Dimension(400, 100));
        this.createAndStartPeriodicUIUpdateThread();
    }

    public void addVariableSearchPanel(YoVariableSearchPanel variableSearchPanel) {
        this.insertTab("Search", variableSearchPanel, this.tabIndex++);
        this.variableSearchPanel = variableSearchPanel;
        this.tabPane.setSelectedComponent(variableSearchPanel);
        this.variableSearchPanel.setShowOnlyParameters(this.onlyParameters.isSelected());
    }

    private void insertTab(String name, JComponent component, int tabIndex) {
        this.tabPane.insertTab(name, null, component, null, tabIndex);
        this.tabIndices.put(component, tabIndex);
    }

    public void addExtraVarPanel(YoVariablePanel extraVarPanel) {
        this.setVisibleVarPanel(extraVarPanel, null);
    }

    public void setVisibleVarPanel(String namespaceName) {
        YoNamespace fullNamespace = new YoNamespace(namespaceName);
        YoRegistry registry = this.rootRegistry.findRegistry(fullNamespace);
        if (registry == null) {
            System.err.println("CombinedVarPanel.setVisibleVarPanel() can't find registry named " + namespaceName);
        }
        this.setVisibleVarPanel(registry);
    }

    public void setVisibleVarPanel(YoRegistry registry) {
        YoVariablePanel varPanel = this.onlyParameters.isSelected() ? new YoVariableRegistryParameterPanel(registry, this.selectedVariableHolder, this.varPanelJPopupMenu) : new YoVariableRegistryVarPanel(registry, this.selectedVariableHolder, this.varPanelJPopupMenu);
        this.setVisibleVarPanel(varPanel, registry);
    }

    private void setVisibleVarPanel(YoVariablePanel varPanel, YoRegistry registry) {
        if (this.visibleVarPanel != null) {
            this.scrollPane.remove(this.visibleVarPanel);
        }
        this.visibleVarPanel = varPanel;
        this.visibleVarPanelRegistry = registry;
        this.scrollPane.add(this.visibleVarPanel);
        this.scrollPane.setViewportView(this.visibleVarPanel);
        Integer tabIndex = this.tabIndices.get(this.variableDisplayPanel);
        this.tabPane.setSelectedIndex(tabIndex);
        String name = varPanel.getName();
        String[] split = name.split("\\.");
        if (split.length > 0) {
            this.tabPane.setTitleAt(tabIndex, split[split.length - 1]);
        }
        this.updateOnlyParametersCheckboxEnabled();
    }

    public YoVariablePanel getVisibleVarPanel() {
        return this.visibleVarPanel;
    }

    private void createAndStartPeriodicUIUpdateThread() {
        this.alertChangeListenersTimer = new Timer("CombinedVarPanelTimer");
        this.alertChangeListenersTask = new TimerTask(){

            @Override
            public void run() {
                YoVariableExplorerTabbedPane.this.repaint();
                EventDispatchThreadHelper.justRun(new Runnable(){

                    @Override
                    public void run() {
                        YoVariableExplorerTabbedPane.this.entryBox.updateActiveContainer();
                    }
                });
            }
        };
        this.alertChangeListenersTimer.schedule(this.alertChangeListenersTask, 1000L, 250L);
    }

    public void closeAndDispose() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                YoVariableExplorerTabbedPane.this.closeAndDisposeLocal();
            }
        });
    }

    private void closeAndDisposeLocal() {
        this.removeAll();
        this.visibleVarPanel = null;
        this.onlyParameters = null;
        if (this.scrollPane != null) {
            this.scrollPane.removeAll();
            this.scrollPane = null;
        }
        this.namespaceHierarchyTree = null;
        if (this.splitPane != null) {
            this.splitPane.removeAll();
            this.splitPane = null;
        }
        if (this.variableDisplayPanel != null) {
            this.variableDisplayPanel.removeAll();
            this.variableDisplayPanel = null;
        }
        this.variableSearchPanel.removeAll();
        this.variableSearchPanel = null;
        this.entryBox = null;
        if (this.alertChangeListenersTimer != null) {
            this.alertChangeListenersTimer.cancel();
            this.alertChangeListenersTimer = null;
        }
        this.alertChangeListenersTask = null;
        if (this.bookmarkedVariablesScrollPane != null) {
            this.bookmarkedVariablesScrollPane.removeAll();
            this.bookmarkedVariablesScrollPane = null;
        }
    }

    public void showNamespace(YoRegistry titleOfNamespace) {
        this.tabPane.setSelectedComponent(this.namespaceHierarchyTree);
        this.namespaceHierarchyTree.showNamespace(titleOfNamespace);
    }

    public NamespaceHierarchyTree getNamespaceHierarchyTree() {
        return this.namespaceHierarchyTree;
    }

    @Override
    public void registryWasSelected(YoRegistry selectedRegistry) {
        this.setVisibleVarPanel(selectedRegistry);
    }

    public void setVarPanelJPopupMenu(YoVariablePanelJPopupMenu varPanelJPopupMenu) {
        this.varPanelJPopupMenu = varPanelJPopupMenu;
    }

    public YoVariableSearchPanel getYoVariableSearchPanel() {
        return this.variableSearchPanel;
    }

    private void updateOnlyParametersCheckboxEnabled() {
        if (this.tabPane.getSelectedComponent().equals(this.variableDisplayPanel) && this.visibleVarPanel != null && this.visibleVarPanelRegistry == null) {
            this.onlyParametersState = this.onlyParameters.isSelected();
            this.onlyParameters.setEnabled(false);
            this.onlyParameters.setSelected(false);
        } else if (!this.onlyParameters.isEnabled()) {
            this.onlyParameters.setSelected(this.onlyParametersState);
            this.onlyParameters.setEnabled(true);
        }
    }

    private class ShowOnlyParameterAction
    implements ActionListener {
        private ShowOnlyParameterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (YoVariableExplorerTabbedPane.this.namespaceHierarchyTree != null) {
                YoVariableExplorerTabbedPane.this.namespaceHierarchyTree.filterParameters(YoVariableExplorerTabbedPane.this.onlyParameters.isSelected());
            }
            if (YoVariableExplorerTabbedPane.this.visibleVarPanelRegistry != null) {
                YoVariableExplorerTabbedPane.this.setVisibleVarPanel(YoVariableExplorerTabbedPane.this.visibleVarPanelRegistry);
            }
            if (YoVariableExplorerTabbedPane.this.variableSearchPanel != null) {
                YoVariableExplorerTabbedPane.this.variableSearchPanel.setShowOnlyParameters(YoVariableExplorerTabbedPane.this.onlyParameters.isSelected());
            }
        }
    }

    private class TabChangedAction
    implements ChangeListener {
        private TabChangedAction() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            YoVariableExplorerTabbedPane.this.updateOnlyParametersCheckboxEnabled();
        }
    }
}

