/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.scripts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import us.ihmc.simulationconstructionset.scripts.Script;
import us.ihmc.simulationconstructionset.scripts.TimeScriptEntry;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class TimeScript
implements Script {
    private ArrayList<TimeScriptEntry> sortedTimeScriptEntryList = new ArrayList();
    private final YoInteger nextTimeScriptIndex;
    private boolean inComment = false;

    public TimeScript(YoRegistry registry) {
        this.nextTimeScriptIndex = new YoInteger("nextTimeScriptIndex", registry);
        this.nextTimeScriptIndex.set(0);
    }

    @Override
    public void doScript(double t) {
        if (this.nextTimeScriptIndex.getIntegerValue() >= this.sortedTimeScriptEntryList.size()) {
            return;
        }
        TimeScriptEntry timeScriptEntry = this.sortedTimeScriptEntryList.get(this.nextTimeScriptIndex.getIntegerValue());
        if (t >= timeScriptEntry.getTime()) {
            timeScriptEntry.setVarsToValues();
            timeScriptEntry.doCommands();
            this.nextTimeScriptIndex.increment();
        }
    }

    public void addEntry(TimeScriptEntry timeScriptEntry) {
        if (timeScriptEntry == null) {
            return;
        }
        this.sortedTimeScriptEntryList.add(timeScriptEntry);
        Collections.sort(this.sortedTimeScriptEntryList);
    }

    public void removeEntry(TimeScriptEntry timeScriptEntry) {
        this.sortedTimeScriptEntryList.remove(timeScriptEntry);
    }

    public void readTimeScript(YoVariableHolder holder, String pathname) {
        this.readTimeScript(holder, new File(pathname));
    }

    public void readTimeScript(YoVariableHolder holder, String parent, String child) {
        this.readTimeScript(holder, new File(parent, child));
    }

    public void readTimeScript(YoVariableHolder holder, URL url) {
        try {
            InputStream inputStream = url.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            this.readTimeScript(holder, in);
        }
        catch (IOException exception) {
            System.err.println("Error when trying to readTimeScript: " + exception);
        }
    }

    public void readTimeScript(YoVariableHolder holder, File file) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            this.readTimeScript(holder, in);
        }
        catch (FileNotFoundException exception) {
            System.err.println("Error when trying to readTimeScript: " + exception);
        }
    }

    public void readTimeScript(YoVariableHolder holder, BufferedReader in) {
        StringBuffer buffer = new StringBuffer();
        try {
            this.packBufferWithoutComments(in, buffer);
            in.close();
        }
        catch (FileNotFoundException exception) {
            System.err.println("Error when trying to readTimeScript: " + exception);
        }
        catch (IOException exception) {
            System.err.println("Error when trying to readTimeScript: " + exception);
        }
        ArrayList<String> strings = this.extractStrings(buffer);
        for (int i = 0; i < strings.size(); ++i) {
            this.addEntry(this.parseTimeScriptEntry(holder, strings.get(i)));
        }
    }

    private TimeScriptEntry parseTimeScriptEntry(YoVariableHolder holder, String line) {
        int equalIndex = line.indexOf("=");
        if (equalIndex < 1) {
            System.err.println("Bad file format.  Line must start with t= ");
            System.err.println(line);
            return null;
        }
        String t_part = line.substring(0, equalIndex);
        if (!(t_part = t_part.trim()).equals("t")) {
            System.err.println("Bad file format.  Line must start with t= ");
            System.err.println(line);
            return null;
        }
        int colonIndex = line.indexOf(":");
        if (colonIndex < 0) {
            System.err.println("Bad file format.  No : in line ");
            System.err.println(line);
            return null;
        }
        t_part = line.substring(equalIndex + 1, colonIndex).trim();
        double time = Double.parseDouble(t_part);
        TimeScriptEntry ret = new TimeScriptEntry(time);
        line = line.substring(colonIndex + 1);
        while (line.length() > 0) {
            equalIndex = line.indexOf("=");
            if (equalIndex < 1) {
                System.err.println("Error! Bad file format.  Line must start with varname = ");
                System.err.println(line);
                return null;
            }
            String varname = line.substring(0, equalIndex).trim();
            YoVariable variable = holder.findVariable(varname);
            if (variable == null) {
                System.err.println("Warning!  Variable not recognized: " + varname);
                throw new RuntimeException();
            }
            int semicolonIndex = line.indexOf(";");
            if (semicolonIndex < 0) {
                System.err.println("Error! Bad file format.  No ; in line ");
                System.err.println(line);
                return null;
            }
            t_part = line.substring(equalIndex + 1, semicolonIndex).trim();
            switch (variable.getType()) {
                case DOUBLE: {
                    double value = Double.parseDouble(t_part);
                    ret.addVarValue((YoDouble)variable, value);
                    break;
                }
                case BOOLEAN: {
                    boolean value = t_part.equals("1.0") ? true : Boolean.parseBoolean(t_part);
                    ret.addVarValue((YoBoolean)variable, value);
                    break;
                }
                case ENUM: {
                    YoEnum yoEnum = (YoEnum)variable;
                    Object value = Enum.valueOf(yoEnum.getEnumType(), t_part);
                    ret.addVarValue(yoEnum, (Enum)value);
                    break;
                }
                case INTEGER: {
                    int value = Integer.parseInt(t_part);
                    ret.addVarValue((YoInteger)variable, value);
                    break;
                }
                default: {
                    throw new RuntimeException("Should not get here!");
                }
            }
            line = line.substring(semicolonIndex + 1).trim();
        }
        return ret;
    }

    private ArrayList<String> extractStrings(StringBuffer buffer) {
        ArrayList<String> ret = new ArrayList<String>();
        boolean done = false;
        int index = 0;
        StringBuffer tempBuffer2 = new StringBuffer();
        char c = ' ';
        while (!done) {
            StringBuffer tempBuffer1 = new StringBuffer();
            while (index < buffer.length()) {
                char c2 = buffer.charAt(index);
                c = c2;
                if (c2 == ':' || (c = buffer.charAt(index)) == 59) break;
                tempBuffer1.append(c);
                ++index;
            }
            if (index < buffer.length()) {
                tempBuffer1.append(c);
            }
            if (c == ':' && tempBuffer2.length() > 0) {
                ret.add(tempBuffer2.toString().trim());
                tempBuffer2 = new StringBuffer();
            }
            tempBuffer2.append(tempBuffer1.toString());
            if (index == buffer.length()) {
                done = true;
                if (c != ':') {
                    ret.add(tempBuffer2.toString().trim());
                }
            }
            ++index;
        }
        return ret;
    }

    private void packBufferWithoutComments(BufferedReader in, StringBuffer buffer) {
        this.inComment = false;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                this.packBufferWithLine(line, buffer);
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void packBufferWithLine(String line, StringBuffer buffer) {
        if (this.inComment) {
            int endCommentIndex = line.indexOf("*/");
            if (endCommentIndex >= 0) {
                this.inComment = false;
                line = line.substring(endCommentIndex + 2);
            } else {
                return;
            }
        }
        int lineCommentIndex = line.indexOf("//");
        int startCommentIndex = line.indexOf("/*");
        if (startCommentIndex >= 0 && (lineCommentIndex < 0 || lineCommentIndex > startCommentIndex)) {
            buffer.append(line.substring(0, startCommentIndex));
            line = line.substring(startCommentIndex);
            this.inComment = true;
            this.packBufferWithLine(line, buffer);
            return;
        }
        if (lineCommentIndex >= 0) {
            buffer.append(line.substring(0, lineCommentIndex));
            return;
        }
        buffer.append(line);
    }
}

