/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ImportDataDialogConstructor;
import us.ihmc.tools.gui.MyFileFilter;

public class ImportDataDialogGenerator
implements ImportDataDialogConstructor {
    private JFileChooser fileChooser;
    private File chosenFile;
    private FileFilter stateFileFilter = new MyFileFilter(new String[]{".state", ".state.gz"}, "State (.state, .state.gz)");
    private FileFilter dataFileFilter = new MyFileFilter(new String[]{".data", ".data.gz", ".data.csv"}, "Data (.data, .data.gz, .data.csv)");
    private FileFilter stateOrDataFileFilter = new MyFileFilter(new String[]{".data", ".data.gz", ".data.csv", ".state", ".state.gz"}, "Data or State (.data, .data.gz, .data.csv, .state, .state.gz)");
    private SimulationConstructionSet sim;
    private JFrame frame;

    public ImportDataDialogGenerator(SimulationConstructionSet sim, Robot[] robots, JFrame frame) {
        this.sim = sim;
        this.frame = frame;
        try {
            String defaultDirString;
            URL defaultDirURL;
            this.fileChooser = new JFileChooser();
            if (robots != null && (defaultDirURL = robots.getClass().getResource(".")) != null && (defaultDirString = defaultDirURL.getPath()) != null) {
                int idx = defaultDirString.indexOf("classes");
                if (idx > 0) {
                    defaultDirString = defaultDirString.substring(0, idx);
                }
                this.setCurrentDirectory(defaultDirString);
            }
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.addChoosableFileFilter(this.stateFileFilter);
            this.fileChooser.addChoosableFileFilter(this.dataFileFilter);
            this.fileChooser.addChoosableFileFilter(this.stateOrDataFileFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.fileChooser.setCurrentDirectory(dir);
    }

    @Override
    public void setCurrentDirectory(String dir) {
        this.fileChooser.setCurrentDirectory(new File(dir));
    }

    @Override
    public void constructDialog() {
        this.sim.disableGUIComponents();
        if (this.fileChooser.showOpenDialog(this.frame) == 0) {
            this.chosenFile = this.fileChooser.getSelectedFile();
            if (this.chosenFile.canRead() && (this.chosenFile.getName().endsWith(".data") || this.chosenFile.getName().endsWith(".data.gz") || this.chosenFile.getName().endsWith(".data.csv"))) {
                this.sim.readData(this.chosenFile);
            } else if (this.chosenFile.canRead() && (this.chosenFile.getName().endsWith(".state") || this.chosenFile.getName().endsWith(".state.gz"))) {
                this.sim.readState(this.chosenFile);
            } else {
                JOptionPane.showMessageDialog(this.frame, "File not found or not readable!");
            }
        }
        this.sim.enableGUIComponents();
    }

    @Override
    public void closeAndDispose() {
        this.fileChooser = null;
        this.chosenFile = null;
        this.stateFileFilter = null;
        this.dataFileFilter = null;
        this.stateOrDataFileFilter = null;
        this.sim = null;
        this.frame = null;
    }
}

