/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.YoEntryBox;
import us.ihmc.yoVariables.variable.YoVariable;

public class EntryBoxArrayPanel
extends JPanel {
    private static final long serialVersionUID = 269886151605236788L;
    private static final int ENTRY_BOX_HEIGHT = 26;
    public static final int DESIRED_PIXELS_PER_ENTRY_BOX = 200;
    public static final int MAXIMUM_PIXELS_PER_ENTRY_BOX = 400;
    public static final int MAX_ENTRY_BOXES = 100;
    private static final boolean DEBUG = false;
    private List<YoEntryBox> entryBoxesOnThisPanel;
    private SelectedVariableHolder selectedVariableHolder;
    private final FlowLayout layout;
    private Timer alertChangeListenersTimer;
    private TimerTask alertChangeListenersTask;
    private final long OBSERVER_NOTIFICATION_PERIOD = 250L;

    public EntryBoxArrayPanel(Container frame, SelectedVariableHolder holder, List<? extends YoVariable> varsToEnter) {
        this.setName("EntryBoxArrayPanel");
        this.layout = new FlowLayout(0, 0, 0);
        this.setLayout(this.layout);
        this.selectedVariableHolder = holder;
        this.setBackground(Color.lightGray);
        this.setOpaque(true);
        this.entryBoxesOnThisPanel = new ArrayList<YoEntryBox>();
        this.addEntryBox(new YoEntryBox(this, this.selectedVariableHolder));
        if (varsToEnter != null) {
            for (int i = 0; i < varsToEnter.size(); ++i) {
                if (varsToEnter.get(i) == null) continue;
                this.addEntryBox(varsToEnter.get(i));
            }
        }
        this.createAndStartPeriodicUIUpdateThread();
        this.validate();
    }

    private void createAndStartPeriodicUIUpdateThread() {
        this.alertChangeListenersTimer = new Timer("EntryBoxArrayPanelTimer");
        this.alertChangeListenersTask = new TimerTask(){

            @Override
            public void run() {
                final ArrayList entryBoxes = new ArrayList(EntryBoxArrayPanel.this.entryBoxesOnThisPanel);
                if (entryBoxes.size() > 0) {
                    EventDispatchThreadHelper.justRun(new Runnable(){

                        @Override
                        public void run() {
                            for (YoEntryBox entryBox : entryBoxes) {
                                entryBox.updateActiveContainer();
                            }
                        }
                    });
                }
            }
        };
        this.alertChangeListenersTimer.schedule(this.alertChangeListenersTask, 1000L, 250L);
    }

    public void closeAndDispose() {
        this.printIfDebug("Closing and Disposing " + this.getClass().getSimpleName());
        this.removeAll();
        if (this.entryBoxesOnThisPanel != null) {
            this.entryBoxesOnThisPanel.clear();
            this.entryBoxesOnThisPanel = null;
        }
        this.selectedVariableHolder = null;
        if (this.alertChangeListenersTask != null) {
            this.alertChangeListenersTask.cancel();
            this.alertChangeListenersTask = null;
        }
        if (this.alertChangeListenersTimer != null) {
            this.alertChangeListenersTimer.cancel();
            this.alertChangeListenersTimer.purge();
            this.alertChangeListenersTimer = null;
        }
    }

    private void printIfDebug(String string) {
    }

    public boolean isHoldingVariable(YoVariable v) {
        boolean ret = false;
        for (int i = 0; i < this.entryBoxesOnThisPanel.size(); ++i) {
            YoEntryBox e = this.entryBoxesOnThisPanel.get(i);
            if (!e.isHoldingVariable(v)) continue;
            ret = true;
        }
        return ret;
    }

    public List<YoEntryBox> getEntryBoxesOnThisPanel() {
        return this.entryBoxesOnThisPanel;
    }

    public synchronized void addEntryBox(YoEntryBox entryBox) {
        this.selectedVariableHolder.addChangeListener((ChangeListener)entryBox);
        int numBoxes = this.entryBoxesOnThisPanel.size();
        if (numBoxes > 100) {
            return;
        }
        if (numBoxes < 100) {
            this.entryBoxesOnThisPanel.add(entryBox);
            this.add(entryBox);
        } else {
            YoEntryBox lastEntryBox = this.entryBoxesOnThisPanel.get(numBoxes - 1);
            if (lastEntryBox.getNumVars() == 0) {
                this.entryBoxesOnThisPanel.remove(lastEntryBox);
                this.remove(lastEntryBox);
                this.entryBoxesOnThisPanel.add(entryBox);
                this.add(entryBox);
            }
        }
        this.checkStatus();
    }

    public void addEntryBox(final YoVariable v) {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                YoEntryBox entryBox = new YoEntryBox(EntryBoxArrayPanel.this.getEntryBoxArrayPanel(), EntryBoxArrayPanel.this.selectedVariableHolder);
                entryBox.addVariable(v);
                EntryBoxArrayPanel.this.addEntryBox(entryBox);
            }
        });
    }

    private EntryBoxArrayPanel getEntryBoxArrayPanel() {
        return this;
    }

    public void removeEntryBox(YoEntryBox entryBox) {
        this.entryBoxesOnThisPanel.remove(entryBox);
        this.remove(entryBox);
        this.checkStatus();
    }

    public void removeAllEntryBoxes() {
        this.entryBoxesOnThisPanel.clear();
        this.removeAll();
        this.updateRowsColumns();
    }

    public synchronized void checkStatus() {
        EventDispatchThreadHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                EntryBoxArrayPanel.this.checkStatusThreadUnsafe();
            }
        });
    }

    private synchronized void checkStatusThreadUnsafe() {
        YoEntryBox dirtyEntryBox = null;
        int numEntryBoxes = this.entryBoxesOnThisPanel.size();
        for (int i = 0; i < numEntryBoxes; ++i) {
            YoEntryBox entryBox = this.entryBoxesOnThisPanel.get(i);
            if (entryBox.getNumVars() != 0 || i >= numEntryBoxes - 1) continue;
            dirtyEntryBox = entryBox;
        }
        if (dirtyEntryBox != null) {
            this.remove(dirtyEntryBox);
            this.entryBoxesOnThisPanel.remove(dirtyEntryBox);
            this.checkStatus();
        } else {
            YoEntryBox lastEntryBox;
            if (numEntryBoxes == 0) {
                this.addEntryBox(new YoEntryBox(this, this.selectedVariableHolder));
            } else if (numEntryBoxes < 100 && (lastEntryBox = this.entryBoxesOnThisPanel.get(numEntryBoxes - 1)).getNumVars() > 0) {
                this.addEntryBox(new YoEntryBox(this, this.selectedVariableHolder));
            }
            this.updateRowsColumns();
        }
    }

    public void updateRowsColumns() {
        int numRows = 1;
        int accumulatedWidth = 0;
        int panelWidth = this.getWidth();
        if (panelWidth == 0) {
            panelWidth = 1428;
        }
        for (YoEntryBox box : this.entryBoxesOnThisPanel) {
            if ((accumulatedWidth += box.getPreferredSize().width) <= panelWidth) continue;
            ++numRows;
            accumulatedWidth = box.getPreferredSize().width;
        }
        this.setPreferredSize(new Dimension(panelWidth, numRows * 26));
    }

    public String getXMLRepresentationOfClass() {
        String returnString = "<Entry Boxes>";
        int numOfFullBoxes = 0;
        List<YoEntryBox> entryBoxesOnThisPanel = this.getEntryBoxesOnThisPanel();
        for (int i = 0; i < entryBoxesOnThisPanel.size(); ++i) {
            YoEntryBox yo = entryBoxesOnThisPanel.get(i);
            if (yo.getVariableInThisBox() == null) continue;
            ++numOfFullBoxes;
        }
        int currentBox = 0;
        for (int i = 0; i < entryBoxesOnThisPanel.size(); ++i) {
            YoEntryBox yo = entryBoxesOnThisPanel.get(i);
            if (yo.getVariableInThisBox() == null) continue;
            returnString = returnString + yo.getVariableInThisBox().getFullNameString();
            if (++currentBox >= numOfFullBoxes) continue;
            returnString = returnString + ",";
        }
        returnString = returnString + "</Entry Boxes>";
        return returnString;
    }
}

