/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandListener;

public class HideShowViewportAction
extends AbstractAction
implements ViewportSelectorCommandListener {
    private static final long serialVersionUID = 1774088226210361744L;
    private ViewportSelectorCommandExecutor viewportSelector;

    public HideShowViewportAction(ViewportSelectorCommandExecutor viewportSelector) {
        super("Hide Viewport");
        this.viewportSelector = viewportSelector;
        this.putValue("MnemonicKey", new Integer(86));
        this.putValue("LongDescription", "Long Description");
        this.putValue("ShortDescription", "Short Description");
        viewportSelector.registerViewportSelectorCommandListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.viewportSelector.isViewportHidden()) {
            this.viewportSelector.showViewport();
        } else {
            this.viewportSelector.hideViewport();
        }
    }

    @Override
    public void updateViewportStatus() {
        if (this.viewportSelector.isViewportHidden()) {
            this.putValue("Name", "Show Viewport");
        } else {
            this.putValue("Name", "Hide Viewport");
        }
    }

    @Override
    public void closeAndDispose() {
        if (this.viewportSelector != null) {
            this.viewportSelector.closeAndDispose();
        }
        this.viewportSelector = null;
    }
}

