/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.io.Serializable;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public final class SpatialVector
implements Serializable {
    private static final long serialVersionUID = 971129051271759424L;
    public Vector3D top = new Vector3D();
    public Vector3D bottom = new Vector3D();
    Vector3D temp1 = new Vector3D();

    public void getTop(Vector3DBasics topToPack) {
        topToPack.set((Tuple3DReadOnly)this.top);
    }

    public void getBottom(Vector3DBasics bottomToPack) {
        bottomToPack.set((Tuple3DReadOnly)this.bottom);
    }

    public double getTopX() {
        return this.top.getX();
    }

    public double getTopY() {
        return this.top.getY();
    }

    public double getTopZ() {
        return this.top.getZ();
    }

    public double getBottomX() {
        return this.bottom.getX();
    }

    public double getBottomY() {
        return this.bottom.getY();
    }

    public double getBottomZ() {
        return this.bottom.getZ();
    }

    public void setFromVector3d(Vector3DReadOnly v1, Vector3DReadOnly v2) {
        this.top.setX(v1.getX());
        this.top.setY(v1.getY());
        this.top.setZ(v1.getZ());
        this.bottom.setX(v2.getX());
        this.bottom.setY(v2.getY());
        this.bottom.setZ(v2.getZ());
    }

    public String toString() {
        return "x1: " + this.top.getX() + " y1: " + this.top.getY() + " z1: " + this.top.getZ() + " x2: " + this.bottom.getX() + " y2: " + this.bottom.getY() + " z2: " + this.bottom.getZ();
    }

    public void set(SpatialVector sV) {
        this.top.set(sV.top);
        this.bottom.set(sV.bottom);
    }

    public final void getMatrix(DMatrix M) {
        M.set(0, 0, this.top.getX());
        M.set(1, 0, this.top.getY());
        M.set(2, 0, this.top.getZ());
        M.set(3, 0, this.bottom.getX());
        M.set(4, 0, this.bottom.getY());
        M.set(5, 0, this.bottom.getZ());
    }

    public void getPlanarXYMatrix(DMatrix M) {
        M.set(0, 0, this.top.getX());
        M.set(1, 0, this.top.getY());
        M.set(2, 0, this.bottom.getZ());
    }

    public void getPlanarXZMatrix(DMatrix M) {
        M.set(0, 0, this.top.getX());
        M.set(1, 0, this.top.getZ());
        M.set(2, 0, this.bottom.getY());
    }

    public void getPlanarYZMatrix(DMatrix M) {
        M.set(0, 0, this.top.getY());
        M.set(1, 0, this.top.getZ());
        M.set(2, 0, this.bottom.getX());
    }

    public void scale(double t) {
        this.top.scale(t);
        this.bottom.scale(t);
    }

    public void add(SpatialVector sV) {
        this.top.add((Tuple3DReadOnly)sV.top);
        this.bottom.add((Tuple3DReadOnly)sV.bottom);
    }

    public void add(SpatialVector sV1, SpatialVector sV2) {
        this.top.add((Tuple3DReadOnly)sV1.top, (Tuple3DReadOnly)sV2.top);
        this.bottom.add((Tuple3DReadOnly)sV1.bottom, (Tuple3DReadOnly)sV2.bottom);
    }

    public double innerProduct(SpatialVector sV) {
        return this.top.dot((Vector3DReadOnly)sV.bottom) + this.bottom.dot((Vector3DReadOnly)sV.top);
    }

    public void setInitArticulatedZeroAccel(double mass, Vector3DReadOnly w_i, Matrix3DReadOnly Inertia, RotationMatrixReadOnly Ri_0, double gX, double gY, double gZ) {
        this.top.setX(-gX * mass);
        this.top.setY(-gY * mass);
        this.top.setZ(-gZ * mass);
        Ri_0.transform((Tuple3DBasics)this.top);
        this.temp1.set((Tuple3DReadOnly)w_i);
        Inertia.transform((Tuple3DBasics)this.temp1);
        this.bottom.cross((Tuple3DReadOnly)w_i, (Tuple3DReadOnly)this.temp1);
    }

    public boolean containsNaN() {
        if (this.top.containsNaN()) {
            return true;
        }
        return this.bottom.containsNaN();
    }
}

