/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import java.util.List;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.GroundContactPointsHolder;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BidirectionGroundContactModel
implements GroundContactModel {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final long serialVersionUID = -2481515446904072547L;
    private static final double DEFAULT_K_XY = 1422.0;
    private static final double DEFAULT_B_XY = 15.6;
    private static final double DEFAULT_K_Z = 125.0;
    private static final double DEFAULT_B_Z = 300.0;
    private final YoDouble groundKxy = new YoDouble("groundKxy", "BidirectionGroundContactModel x and y spring constant", this.registry);
    private final YoDouble groundBxy = new YoDouble("groundBxy", "BidirectionalGroundContactModel x and y damping constant", this.registry);
    private final YoDouble groundKz = new YoDouble("groundKz", "BidirectionalGroundContactModel z spring constant", this.registry);
    private final YoDouble groundBz = new YoDouble("groundBz", "BidirectionalGroundContactModel z damping constant", this.registry);
    private List<GroundContactPoint> groundContactPoints;
    private GroundProfile3D groundProfile3D;
    private final Point3D touchdownLocation = new Point3D();
    private final Point3D position = new Point3D();
    private final Vector3D deltaPositionFromTouchdown = new Vector3D();
    private final Vector3D velocity = new Vector3D();

    public BidirectionGroundContactModel(GroundContactPointsHolder groundContactPointsHolder, YoRegistry parentRegistry) {
        this(groundContactPointsHolder, 1422.0, 15.6, 125.0, 300.0, parentRegistry);
    }

    public BidirectionGroundContactModel(GroundContactPointsHolder groundContactPointsHolder, double groundKxy, double groundBxy, double groundKz, double groundBz, YoRegistry parentRegistry) {
        this(groundContactPointsHolder, 0, groundKxy, groundBxy, groundKz, groundBz, parentRegistry);
    }

    public BidirectionGroundContactModel(GroundContactPointsHolder groundContactPointsHolder, int groundContactGroupIdentifier, double groundKxy, double groundBxy, double groundKz, double groundBz, YoRegistry parentRegistry) {
        this.groundContactPoints = groundContactPointsHolder.getGroundContactPoints(groundContactGroupIdentifier);
        this.groundKxy.set(groundKxy);
        this.groundBxy.set(groundBxy);
        this.groundKz.set(groundKz);
        this.groundBz.set(groundBz);
        parentRegistry.addChild(this.registry);
    }

    public void setXYStiffness(double xyStiffness) {
        this.groundKxy.set(xyStiffness);
    }

    public void setZStiffness(double zStiffness) {
        this.groundKz.set(zStiffness);
    }

    public void setXYDamping(double xyDamping) {
        this.groundBxy.set(xyDamping);
    }

    public void setZDamping(double zDamping) {
        this.groundBz.set(zDamping);
    }

    @Override
    public void setGroundProfile3D(GroundProfile3D profile3D) {
        this.groundProfile3D = profile3D;
    }

    @Override
    public GroundProfile3D getGroundProfile3D() {
        return this.groundProfile3D;
    }

    @Override
    public void doGroundContact() {
        for (int i = 0; i < this.groundContactPoints.size(); ++i) {
            this.doGroundContact(this.groundContactPoints.get(i));
        }
    }

    private void doGroundContact(GroundContactPoint groundContactPoint) {
        if (groundContactPoint.isDisabled()) {
            groundContactPoint.setForce(0.0, 0.0, 0.0);
            return;
        }
        boolean inContact = groundContactPoint.isInContact();
        if (!inContact) {
            groundContactPoint.setNotInContact();
            groundContactPoint.setIsSlipping(false);
            groundContactPoint.setForce(0.0, 0.0, 0.0);
            return;
        }
        this.resolveContactForce(groundContactPoint);
    }

    private void resolveContactForce(GroundContactPoint groundContactPoint) {
        groundContactPoint.getTouchdownLocation((Point3DBasics)this.touchdownLocation);
        groundContactPoint.getPosition((Tuple3DBasics)this.position);
        groundContactPoint.getVelocity((Vector3DBasics)this.velocity);
        this.deltaPositionFromTouchdown.sub((Tuple3DReadOnly)this.touchdownLocation, (Tuple3DReadOnly)this.position);
        this.resolveContactForceZUp(this.deltaPositionFromTouchdown, this.velocity, groundContactPoint);
    }

    private void resolveContactForceZUp(Vector3D deltaPositionFromTouchdown, Vector3D velocity, GroundContactPoint groundContactPoint) {
        double xForce = this.groundKxy.getDoubleValue() * (deltaPositionFromTouchdown.getX() - this.groundBxy.getDoubleValue()) * velocity.getX();
        double yForce = this.groundKxy.getDoubleValue() * (deltaPositionFromTouchdown.getY() - this.groundBxy.getDoubleValue()) * velocity.getY();
        double zForce = this.groundKz.getDoubleValue() * deltaPositionFromTouchdown.getZ() / 0.002 - this.groundBz.getDoubleValue() * velocity.getZ();
        groundContactPoint.setForce(xForce, yForce, zForce);
    }
}

