/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.yoVariableSearch;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.gui.DoubleClickListener;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.HorizontalSpinnerUI;
import us.ihmc.simulationconstructionset.gui.YoGraph;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanelJPopupMenu;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanelTransferHandler;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariableSearchPanel;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoVariable;
import us.ihmc.yoVariables.variable.YoVariableType;

public abstract class YoVariablePanel
extends JPanel
implements KeyListener,
MouseListener,
FocusListener,
ComponentListener {
    private static final long serialVersionUID = -5860355582880221731L;
    private static ArrayList<YoVariableChangedListener> variableChangedListeners = new ArrayList();
    protected static final int SPINNER_HEIGHT = 16;
    protected static final int MINIMUM_TOTAL_WIDTH = 220;
    private static final int SPINNER_WIDTH = 84;
    protected final SelectedVariableHolder selectedVariableHolder;
    protected final YoVariablePanelJPopupMenu varPanelJPopupMenu;
    protected int selectedVariableIndex = -1;
    private boolean hasFocus = false;
    private final ArrayList<JSpinner> yoVariableSpinners = new ArrayList(0);
    private final NumberFormat numberFormat;
    private DoubleClickListener doubleClickListener;
    private static final Color EMPTY_COLOR = Color.red;
    private static final Color REGULAR_COLOR = Color.black;
    private static final Color SELECTED_COLOR = Color.red;
    private static boolean showNamespace = false;
    private final YoVariableSearchPanel searchPanel;

    public static void attachVariableChangedListener(YoVariableChangedListener listener) {
        variableChangedListeners.add(listener);
    }

    public static boolean areNamespacesShown() {
        return showNamespace;
    }

    public static void removeVariableChangedListener(YoVariableChangedListener listener) {
        variableChangedListeners.remove(listener);
    }

    public static void addNamespaceToVarNames() {
        showNamespace = !showNamespace;
    }

    public YoVariablePanel(String name, SelectedVariableHolder holder, YoVariablePanelJPopupMenu varPanelJPopupMenu, YoVariableSearchPanel searchPanel) {
        this.selectedVariableHolder = holder;
        this.setName(name);
        this.varPanelJPopupMenu = varPanelJPopupMenu;
        varPanelJPopupMenu.addFocusListener(this);
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(4);
        this.numberFormat.setMinimumFractionDigits(1);
        this.numberFormat.setGroupingUsed(false);
        this.searchPanel = searchPanel;
        this.init();
    }

    public YoVariablePanel(YoVariableList list, SelectedVariableHolder holder, YoVariablePanelJPopupMenu varPanelJPopupMenu) {
        this(list.getName(), holder, varPanelJPopupMenu, null);
    }

    public YoVariablePanel(String name, SelectedVariableHolder holder, YoVariablePanelJPopupMenu varPanelJPopupMenu) {
        this(name, holder, varPanelJPopupMenu, null);
    }

    protected abstract int getNumberOfYoVariables();

    protected abstract YoVariable getYoVariable(int var1);

    protected abstract List<YoVariable> getAllYoVariablesCopy();

    public abstract YoVariable getYoVariable(String var1);

    private void init() {
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(new ToolTipMouseMotionListener());
        this.addKeyListener(this);
        this.setRequestFocusEnabled(true);
        this.setTransferHandler(new YoVariablePanelTransferHandler());
        this.setMinimumSize(new Dimension(220, 16));
        this.addComponentListener(this);
        this.selectedVariableHolder.addChangeListener((ChangeListener)new UpdateUIChangeListener());
        this.addFocusListener(this);
    }

    protected void clearAndSetUpTextFields() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                YoVariablePanel.this.yoVariableSpinners.clear();
                for (int i = 0; i < YoVariablePanel.this.getNumberOfYoVariables(); ++i) {
                    YoVariablePanel.this.addTextFieldForVariable(YoVariablePanel.this.getYoVariable(i));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTextFieldForVariable(YoVariable yoVariable) {
        JSpinner spinner = this.createSpinnerForVariable(yoVariable);
        ArrayList<JSpinner> arrayList = this.yoVariableSpinners;
        synchronized (arrayList) {
            this.yoVariableSpinners.add(spinner);
        }
        this.add(spinner);
        this.setPanelSize(this.getNumberOfYoVariables());
    }

    private JSpinner createSpinnerForVariable(YoVariable yoVariable) {
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setStepSize(yoVariable.getType() == YoVariableType.DOUBLE ? 0.1 : 1.0);
        spinnerNumberModel.setValue(yoVariable.getValueAsDouble());
        final JSpinner spinner = new JSpinner(spinnerNumberModel);
        spinner.setName(yoVariable.getFullNameString());
        String tooltip = "<html>You can scroll to modify the current value<br />Press shift to be more precise OR Control to change by bigger increments</html>";
        spinner.setToolTipText(tooltip);
        spinner.addMouseWheelListener(new MouseWheelListener(){
            private static final double SCROLL_FACTOR = 1.0;
            private static final double SHIFT_FACTOR = 0.1;
            private static final double CTRL_FACTOR = 10.0;

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                double modifierFactor = mouseWheelEvent.isShiftDown() ? 0.1 : (mouseWheelEvent.isControlDown() ? 10.0 : 1.0);
                double currentValue = Double.parseDouble(spinner.getValue().toString());
                double delta = spinnerNumberModel.getStepSize().doubleValue() * (double)mouseWheelEvent.getWheelRotation() * 1.0 * modifierFactor;
                spinner.setValue(currentValue + delta);
            }
        });
        spinner.setUI(new HorizontalSpinnerUI());
        spinner.setBorder(null);
        spinner.setBackground(this.getBackground());
        int width = 84;
        int height = 16;
        int x = this.getViewableWidth() - 84;
        int y = this.yoVariableSpinners.size() * height;
        spinner.setBounds(x, y, width, height);
        spinner.addChangeListener(new SetYoVariableBasedOnTextFieldActionListener(spinner, yoVariable));
        spinner.addFocusListener(this);
        return spinner;
    }

    public void refreshPanelWidth() {
        for (int i = 0; i < this.yoVariableSpinners.size(); ++i) {
            this.yoVariableSpinners.get(i).setLocation(this.getViewableWidth() - 84, i * 16);
        }
    }

    public boolean isEmpty() {
        return this.getNumberOfYoVariables() == 0;
    }

    public void setPanelSize(int nVars) {
        this.setPreferredSize(new Dimension(this.getViewableWidth() < 220 ? 220 : this.getViewableWidth(), 16 * nVars));
    }

    public int getViewableWidth() {
        return (int)this.getVisibleRect().getWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int xStringStart = 2;
        int yStringStart = 10;
        if (this.isEmpty()) {
            graphics.setColor(EMPTY_COLOR);
            String text = new String("Empty");
            graphics.drawString(text, xStringStart, yStringStart);
        } else {
            List<YoVariable> allVariables = this.getAllYoVariablesCopy();
            graphics.setColor(REGULAR_COLOR);
            YoVariable selectedVariable = this.selectedVariableHolder.getSelectedVariable();
            Rectangle rectangle = this.getVisibleRect();
            int minIndexOfVisibleVariables = this.getMinIndexOfVisibleVariables(rectangle);
            int maxIndexOfVisibleVariables = this.getMaxIndexOfVisibleVariables(rectangle);
            int longestLengthAllowed = this.getWidth() - (84 + yStringStart);
            for (int i = minIndexOfVisibleVariables; i < maxIndexOfVisibleVariables; ++i) {
                double value;
                String text;
                YoVariable v = allVariables.get(i);
                JFormattedTextField jTextField = null;
                ArrayList<JSpinner> arrayList = this.yoVariableSpinners;
                synchronized (arrayList) {
                    if (i >= 0 && i < this.yoVariableSpinners.size()) {
                        jTextField = ((JSpinner.DefaultEditor)this.yoVariableSpinners.get(i).getEditor()).getTextField();
                    }
                }
                if (jTextField == null) continue;
                if (selectedVariable == v) {
                    graphics.setColor(SELECTED_COLOR);
                } else {
                    graphics.setColor(REGULAR_COLOR);
                }
                String formattedName = this.formatName(graphics, longestLengthAllowed, v);
                graphics.drawString(formattedName, xStringStart, i * 16 + yStringStart);
                if (jTextField.hasFocus() || (text = this.formatDouble(value = v.getValueAsDouble())).equals(jTextField.getText())) continue;
                jTextField.setText(text);
                jTextField.setCaretPosition(0);
            }
        }
    }

    private String formatName(Graphics graphics, int longestLengthAllowed, YoVariable v) {
        String formattedName;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String name = "";
        name = showNamespace ? v.getNamespace().getShortName() + "." + v.getName() : v.getName();
        if (fontMetrics.stringWidth(name) < longestLengthAllowed) {
            formattedName = name;
        } else {
            int lastHalfLength;
            int firstHalfLength;
            String ellipsis = "...";
            int lengthOfEllipsis = fontMetrics.stringWidth(ellipsis);
            int lengthAvailableForName = longestLengthAllowed - lengthOfEllipsis;
            int lengthAvailableForNamePart = lengthAvailableForName / 2;
            for (firstHalfLength = 1; firstHalfLength < name.length() && fontMetrics.stringWidth(name.substring(0, firstHalfLength)) < lengthAvailableForNamePart; ++firstHalfLength) {
            }
            String firstHalf = name.substring(0, --firstHalfLength);
            for (lastHalfLength = name.length(); lastHalfLength >= 0 && fontMetrics.stringWidth(name.substring(lastHalfLength, name.length())) < lengthAvailableForNamePart; --lastHalfLength) {
            }
            String lastHalf = name.substring(++lastHalfLength, name.length());
            formattedName = firstHalf + ellipsis + lastHalf;
        }
        return formattedName;
    }

    private String formatDouble(double value) {
        String text = Double.isNaN(value) || Double.isInfinite(value) ? Double.toString(value) : this.numberFormat.format(value);
        return text;
    }

    public SelectedVariableHolder getVariableHolder() {
        return this.selectedVariableHolder;
    }

    protected List<JSpinner> getYoVariableSpinners() {
        return this.yoVariableSpinners;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        YoVariable selectedVariable;
        if (!this.isFocusOwner() && !this.requestFocusInWindow()) {
            System.err.println("Warning: VarPanel failed to gain focus on mousePressed.");
        }
        this.varPanelJPopupMenu.setVisible(false);
        if (!event.isMetaDown() && !event.isAltDown()) {
            YoVariable selectedVariable2;
            int indexOfSelectedVariable = this.getIndexOfClickedVariable(event.getY());
            if (indexOfSelectedVariable >= 0 && indexOfSelectedVariable < this.yoVariableSpinners.size()) {
                this.yoVariableSpinners.get(indexOfSelectedVariable).requestFocusInWindow();
            }
            if ((selectedVariable2 = this.getClickedYoVariable(event.getY())) != null) {
                this.selectedVariableHolder.setSelectedVariable(selectedVariable2);
                JComponent c = (JComponent)event.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, event, 1);
                YoGraph.setSourceOfDrag(this);
                this.repaint();
            }
        } else if (event.isMetaDown() && !event.isAltDown() && (selectedVariable = this.getClickedYoVariable(event.getY())) != null) {
            this.selectedVariableHolder.setSelectedVariable(selectedVariable);
            this.varPanelJPopupMenu.setLocation(event.getXOnScreen(), event.getYOnScreen());
            this.varPanelJPopupMenu.setVisible(true);
        }
    }

    private YoVariable getClickedYoVariable(int mouseY) {
        this.selectedVariableIndex = this.getIndexOfClickedVariable(mouseY);
        if (this.selectedVariableIndex >= 0) {
            return this.getYoVariable(this.selectedVariableIndex);
        }
        return null;
    }

    private int getIndexOfClickedVariable(int mouseY) {
        int indexOfClickedVariable = mouseY / 16;
        if (indexOfClickedVariable >= 0 && indexOfClickedVariable < this.getNumberOfYoVariables()) {
            return indexOfClickedVariable;
        }
        return -1;
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        YoVariable selectedVariable;
        int y = evt.getY();
        if (y < 0) {
            return;
        }
        this.selectedVariableIndex = y / 16;
        if (this.isEmpty()) {
            this.selectedVariableIndex = -1;
        } else if (this.selectedVariableIndex > this.getNumberOfYoVariables()) {
            this.selectedVariableIndex = -1;
        }
        if (this.selectedVariableIndex >= 0 && this.selectedVariableIndex < this.getNumberOfYoVariables()) {
            selectedVariable = this.getYoVariable(this.selectedVariableIndex);
            this.setSelected(selectedVariable);
        }
        if (evt.getClickCount() == 2 && (selectedVariable = this.selectedVariableHolder.getSelectedVariable()) != null && this.doubleClickListener != null) {
            this.doubleClickListener.doubleClicked(selectedVariable);
        }
        this.requestFocus();
        this.repaint();
    }

    public void setDoubleClickListener(DoubleClickListener listener) {
        this.doubleClickListener = listener;
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        switch (code) {
            case 38: {
                this.selectedVariableIndex = Math.max(0, this.selectedVariableIndex - 1);
                break;
            }
            case 40: {
                this.selectedVariableIndex = Math.min(this.getNumberOfYoVariables() - 1, this.selectedVariableIndex + 1);
            }
        }
        if (this.selectedVariableIndex < 0 || this.selectedVariableIndex > this.getNumberOfYoVariables()) {
            this.setSelected(null);
        } else {
            this.setSelected(this.getYoVariable(this.selectedVariableIndex));
        }
        this.repaint();
    }

    private void setSelected(YoVariable var) {
        this.selectedVariableHolder.setSelectedVariable(var);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource().equals(this)) {
            if (this.hasFocus) {
                this.varPanelJPopupMenu.setVisible(false);
            }
        } else if (e.getSource() instanceof JSpinner) {
            YoVariable yoVariable;
            JSpinner spinner = (JSpinner)e.getSource();
            JFormattedTextField textField = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
            Rectangle rectangle = this.getVisibleRect();
            int minIndexOfVisibleVariables = this.getMinIndexOfVisibleVariables(rectangle);
            int maxIndexOfVisibleVariables = this.getMaxIndexOfVisibleVariables(rectangle);
            int indexOfFocusedTextField = this.yoVariableSpinners.indexOf(spinner);
            int focusedTextFieldYPositionOnPanel = indexOfFocusedTextField * 16;
            if (indexOfFocusedTextField <= minIndexOfVisibleVariables || indexOfFocusedTextField >= maxIndexOfVisibleVariables) {
                this.scrollRectToVisible(new Rectangle(0, focusedTextFieldYPositionOnPanel, spinner.getBounds().width, 16));
            }
            if ((yoVariable = this.getYoVariable(indexOfFocusedTextField)) != null) {
                this.selectedVariableHolder.setSelectedVariable(yoVariable);
                this.repaint();
            }
            textField.setCaretPosition(textField.getText().length());
            textField.moveCaretPosition(0);
        }
        this.hasFocus = true;
    }

    private int getMinIndexOfVisibleVariables(Rectangle rectangle) {
        int size = this.getNumberOfYoVariables();
        int minIndexOfVisibleVariables = rectangle.y / 16;
        minIndexOfVisibleVariables = Math.max(minIndexOfVisibleVariables, 0);
        minIndexOfVisibleVariables = Math.min(minIndexOfVisibleVariables, size);
        return minIndexOfVisibleVariables;
    }

    private int getMaxIndexOfVisibleVariables(Rectangle rectangle) {
        int size = this.getNumberOfYoVariables();
        int maxIndexOfVisibleVariables = (rectangle.y + rectangle.height) / 16;
        maxIndexOfVisibleVariables = Math.max(maxIndexOfVisibleVariables, 0);
        maxIndexOfVisibleVariables = Math.min(maxIndexOfVisibleVariables, size);
        return maxIndexOfVisibleVariables;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.varPanelJPopupMenu.setVisible(false);
        this.hasFocus = false;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void componentResized(ComponentEvent e) {
        ArrayList<JSpinner> arrayList = this.yoVariableSpinners;
        synchronized (arrayList) {
            if (e.getSource().equals(this)) {
                int width = this.getSize().width;
                for (JComponent jComponent : this.yoVariableSpinners) {
                    Rectangle currentBounds = jComponent.getBounds();
                    jComponent.setBounds(width - 84, currentBounds.y, currentBounds.width, currentBounds.height);
                }
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private final class SetYoVariableBasedOnTextFieldActionListener
    implements ChangeListener {
        private final JSpinner spinner;
        private final YoVariable variable;

        private SetYoVariableBasedOnTextFieldActionListener(JSpinner spinner, YoVariable variable) {
            this.spinner = spinner;
            this.variable = variable;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                this.variable.setValueFromDouble(Double.parseDouble(this.spinner.getValue().toString()));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.spinner.setValue(this.variable.getValueAsDouble());
            for (int i = 0; i < variableChangedListeners.size(); ++i) {
                YoVariableChangedListener listener = (YoVariableChangedListener)variableChangedListeners.get(i);
                listener.changed(this.variable);
            }
            this.spinner.requestFocusInWindow();
        }
    }

    private final class UpdateUIChangeListener
    implements ChangeListener {
        private UpdateUIChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            YoVariablePanel.this.updateUI();
        }
    }

    private final class ToolTipMouseMotionListener
    implements MouseMotionListener {
        private ToolTipMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            YoVariable yoVariable = YoVariablePanel.this.getClickedYoVariable(event.getY());
            if (yoVariable != null) {
                String displayText = yoVariable.getFullNameString();
                String descriptionText = yoVariable.getDescription();
                if (!descriptionText.equals(null) && !descriptionText.equals("")) {
                    displayText = displayText + "\nDescription: (" + descriptionText + ")";
                }
                displayText = displayText.replaceAll("\n", "<br>");
                displayText = "<html>" + displayText + "</html>";
                YoVariablePanel.this.setToolTipText(displayText);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }
}

