/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoSliderpanel
extends JPanel
implements MouseListener,
YoVariableChangedListener {
    private static final int SHORT_NAME_LENGTH = 20;
    private YoVariable var;
    private double min = 0.0;
    private double max = 0.0;
    private JTextField maxField;
    private JTextField minField;
    private JLabel name;
    private double defaultMinMaxOffset = 10.0;
    private JLabel value;
    private JSlider slider;
    double precision = 1000.0;

    public YoSliderpanel(YoVariable var) {
        this.var = var;
        this.setLayout(new BoxLayout(this, 1));
        this.setup();
        var.addListener((YoVariableChangedListener)this);
    }

    private int convertDoubleToPrecisionInt(double value) {
        double precisionValue = value * this.precision;
        String newVal = precisionValue + "";
        int decimalLocal = newVal.indexOf(".");
        if (decimalLocal != -1) {
            newVal = newVal.substring(0, decimalLocal);
        }
        System.out.println("newVal" + newVal);
        return new Integer(newVal);
    }

    private void setup() {
        this.name = new JLabel(YoSliderpanel.shortenString(this.var.getName(), 20));
        this.min = this.var.getValueAsDouble() - this.defaultMinMaxOffset;
        this.max = this.var.getValueAsDouble() + this.defaultMinMaxOffset;
        this.slider = new JSlider(1, this.convertDoubleToPrecisionInt(this.min), this.convertDoubleToPrecisionInt(this.max), this.convertDoubleToPrecisionInt(this.var.getValueAsDouble()));
        this.setUpMax();
        this.setUpMin();
        this.value = new JLabel(this.var.getValueAsDouble() + "");
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double actualSliderValue = new Double(YoSliderpanel.this.slider.getValue()) / YoSliderpanel.this.precision;
                YoSliderpanel.this.value.setText(actualSliderValue + "");
                YoSliderpanel.this.var.setValueFromDouble(actualSliderValue);
            }
        });
        this.add(this.name);
        this.add(this.maxField);
        this.add(this.slider);
        this.add(this.minField);
        this.add(this.value);
    }

    public static String shortenString(String inputString, int maxLength) {
        int length = inputString.length();
        if (length <= maxLength) {
            return inputString;
        }
        return inputString.substring(0, maxLength / 2 - 2) + "..." + inputString.substring(length - maxLength / 2 + 1, length);
    }

    private void setUpMax() {
        this.maxField = new JTextField(this.max + "");
        this.maxField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double newValue = new Double(YoSliderpanel.this.maxField.getText());
                if (newValue >= YoSliderpanel.this.var.getValueAsDouble()) {
                    YoSliderpanel.this.max = newValue;
                    YoSliderpanel.this.slider.setMaximum(YoSliderpanel.this.convertDoubleToPrecisionInt(YoSliderpanel.this.max));
                } else {
                    System.err.println("cant set max to a value less then the current value");
                    YoSliderpanel.this.maxField.setText(YoSliderpanel.this.max + "");
                }
            }
        });
    }

    private void setUpMin() {
        this.minField = new JTextField(this.min + "");
        this.minField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double newValue = new Double(YoSliderpanel.this.minField.getText());
                if (newValue <= YoSliderpanel.this.var.getValueAsDouble()) {
                    YoSliderpanel.this.min = newValue;
                    YoSliderpanel.this.slider.setMinimum(YoSliderpanel.this.convertDoubleToPrecisionInt(YoSliderpanel.this.min));
                } else {
                    System.err.println("cant set min to a value greater then the current value");
                    YoSliderpanel.this.minField.setText(YoSliderpanel.this.min + "");
                }
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void setSliderValueOnVariableChange() {
        if (this.var.getValueAsDouble() < this.min) {
            this.min = this.var.getValueAsDouble();
            this.slider.setMinimum(this.convertDoubleToPrecisionInt(this.min));
            this.minField.setText(this.min + "");
        }
        if (this.var.getValueAsDouble() > this.max) {
            this.max = this.var.getValueAsDouble();
            this.slider.setMaximum(this.convertDoubleToPrecisionInt(this.max));
            this.maxField.setText(this.max + "");
        }
        this.slider.setValue(this.convertDoubleToPrecisionInt(this.var.getValueAsDouble()));
    }

    public void changed(YoVariable v) {
        this.value.setText(v.getValueAsDouble() + "");
        this.setSliderValueOnVariableChange();
    }
}

