/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.dataBuffer;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class MirroredYoVariableRegistry
extends YoRegistry {
    private final BiMap<YoVariable, YoVariable> variableMap = HashBiMap.create();
    private final ConcurrentLinkedQueue<YoVariable> changedVariablesInMirror = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<YoVariable> changedVariablesInOriginal = new ConcurrentLinkedQueue();
    private boolean enableChangedListener = true;
    private final YoRegistryChangedListener mirroredChangeListener = new YoRegistryChangedListener(this.changedVariablesInMirror);
    private final YoRegistryChangedListener originalChangeListener = new YoRegistryChangedListener(this.changedVariablesInOriginal);

    public MirroredYoVariableRegistry(YoRegistry original) {
        super(original.getName());
        this.copyRegistry(original, this);
    }

    private void copyRegistry(YoRegistry original, YoRegistry target) {
        List vars = original.getVariables();
        for (YoVariable var : vars) {
            YoVariable newVar = var.duplicate(target);
            this.variableMap.put((Object)var, (Object)newVar);
            this.addVariableListener(newVar, var);
        }
        for (YoRegistry child : original.getChildren()) {
            YoRegistry newRegistry = new YoRegistry(child.getName());
            target.addChild(newRegistry);
            this.copyRegistry(child, newRegistry);
        }
    }

    private void addVariableListener(YoVariable newVar, YoVariable var) {
        newVar.addListener((YoVariableChangedListener)this.mirroredChangeListener);
        var.addListener((YoVariableChangedListener)this.originalChangeListener);
    }

    public void updateMirror() {
        this.updateChangedValues();
        this.updateValuesFromOriginal();
    }

    public void updateChangedValues() {
        YoVariable changed = this.changedVariablesInMirror.poll();
        while (changed != null) {
            YoVariable originalVar = (YoVariable)this.variableMap.inverse().get((Object)changed);
            originalVar.setValue(changed, false);
            this.callListenersForVariable(originalVar);
            changed = this.changedVariablesInMirror.poll();
        }
    }

    public void updateValuesFromOriginal() {
        YoVariable changed = this.changedVariablesInOriginal.poll();
        while (changed != null) {
            YoVariable mirroredVar = (YoVariable)this.variableMap.get((Object)changed);
            mirroredVar.setValue(changed, false);
            this.callListenersForVariable(mirroredVar);
            changed = this.changedVariablesInOriginal.poll();
        }
    }

    private void callListenersForVariable(YoVariable variable) {
        this.enableChangedListener = false;
        variable.notifyListeners();
        this.enableChangedListener = true;
    }

    private class YoRegistryChangedListener
    implements YoVariableChangedListener {
        final ConcurrentLinkedQueue<YoVariable> queue;

        private YoRegistryChangedListener(ConcurrentLinkedQueue<YoVariable> queue) {
            this.queue = queue;
        }

        public void changed(YoVariable v) {
            if (MirroredYoVariableRegistry.this.enableChangedListener) {
                this.queue.add(v);
            }
        }
    }
}

