/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.io.Serializable;
import java.util.ArrayList;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.physics.CollisionArbiter;
import us.ihmc.simulationconstructionset.physics.CollisionHandler;
import us.ihmc.simulationconstructionset.physics.ScsCollisionDetector;
import us.ihmc.simulationconstructionset.physics.collision.CollisionDetectionResult;
import us.ihmc.simulationconstructionset.physics.collision.DefaultCollisionVisualizer;
import us.ihmc.simulationconstructionset.scripts.Script;
import us.ihmc.simulationconstructionset.synchronization.SimulationSynchronizer;

public class Simulator
implements Serializable {
    private static final long serialVersionUID = -3492879446149849938L;
    private final SimulationSynchronizer simulationSynchronizer;
    private Robot[] robots;
    private double DT;
    private ArrayList<Script> scripts = null;
    private ScsCollisionDetector collisionDetector;
    private CollisionArbiter collisionArbiter;
    private CollisionHandler collisionHandler;
    private DefaultCollisionVisualizer collisionVisualizer;
    private final CollisionDetectionResult newCollisions = new CollisionDetectionResult();

    public Simulator(SimulationSynchronizer simulationSynchronizer, Robot[] robots, double dt) {
        this.simulationSynchronizer = simulationSynchronizer;
        this.robots = robots;
        this.DT = dt;
    }

    public void setRobots(Robot[] robots) {
        this.robots = robots;
    }

    public void setDT(double simulateDT) {
        this.DT = simulateDT;
    }

    public double getDT() {
        return this.DT;
    }

    protected void addScript(Script script) {
        if (this.scripts == null) {
            this.scripts = new ArrayList();
        }
        this.scripts.add(script);
    }

    protected void simulate() throws UnreasonableAccelerationException {
        this.updateState();
        this.doControl();
        this.doDynamicsAndIntegrate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState() {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            for (Robot robot : this.robots) {
                robot.updateVelocities();
                robot.updateAllGroundContactPointVelocities();
                if (robot.getGroundContactModel() != null) {
                    robot.getGroundContactModel().doGroundContact();
                }
                robot.decideGroundContactPointsInContact();
                robot.doLoopClosure();
                if (this.scripts == null) continue;
                for (Script script : this.scripts) {
                    script.doScript(robot.getTime());
                }
            }
            if (this.collisionDetector != null) {
                if (this.collisionVisualizer != null) {
                    this.collisionVisualizer.callBeforeCollisionDetection();
                }
                this.newCollisions.clear();
                this.collisionDetector.performCollisionDetection(this.newCollisions);
                this.collisionArbiter.processNewCollisions(this.newCollisions);
                CollisionDetectionResult cachedCollisions = this.collisionArbiter.getCollisions();
                this.collisionHandler.handleCollisions(cachedCollisions);
            }
        }
    }

    protected void doControl() {
        for (Robot robot : this.robots) {
            robot.doControllers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDynamicsAndIntegrate() throws UnreasonableAccelerationException {
        SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
        synchronized (simulationSynchronizer) {
            for (int i = 0; i < this.robots.length; ++i) {
                Robot robot = this.robots[i];
                robot.doDynamicsAndIntegrate(this.DT);
                robot.updateIMUMountAccelerations();
            }
        }
    }

    protected void forceClassLoading() {
    }

    public void setCollisions(ScsCollisionDetector collisionDetector, CollisionArbiter collisionArbiter, CollisionHandler collisionHandler, DefaultCollisionVisualizer visulize) {
        this.collisionDetector = collisionDetector;
        this.collisionArbiter = collisionArbiter;
        this.collisionHandler = collisionHandler;
        this.collisionVisualizer = visulize;
    }
}

