/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.io.Serializable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ExternalTorque
implements Serializable {
    private static final long serialVersionUID = 3783457908524107434L;
    private final YoFrameVector3D torque;
    public YoDouble x;
    public YoDouble y;
    public YoDouble z;
    protected final String name;
    protected Joint parentJoint;
    public boolean active;

    public ExternalTorque(String name, YoRegistry registry) {
        this.name = name;
        this.torque = new YoFrameVector3D(name + "_t", "", ReferenceFrame.getWorldFrame(), registry);
        this.x = this.torque.getYoX();
        this.y = this.torque.getYoY();
        this.z = this.torque.getYoZ();
    }

    public void reset() {
        this.active = false;
        this.torque.set(0.0, 0.0, 0.0);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Joint getParentJoint() {
        return this.parentJoint;
    }

    public void setParentJoint(Joint parentJoint) {
        this.parentJoint = parentJoint;
    }

    public YoFrameVector3D getYoTorque() {
        return this.torque;
    }

    public double getTorqueX() {
        return this.x.getDoubleValue();
    }

    public double getTorqueY() {
        return this.y.getDoubleValue();
    }

    public double getTorqueZ() {
        return this.z.getDoubleValue();
    }
}

