/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.RobotFromDescription;

public class FloatingRootJointRobot
extends RobotFromDescription {
    private static final boolean DEBUG = false;
    private final FloatingJoint rootJoint = (FloatingJoint)this.getRootJoints().get(0);

    public FloatingRootJointRobot(RobotDescription robotDescription) {
        this(robotDescription, true, true);
    }

    public FloatingRootJointRobot(RobotDescription robotDescription, boolean enableDamping, boolean enableJointTorqueAndVelocityLimits) {
        super(robotDescription, enableDamping, enableJointTorqueAndVelocityLimits);
        Point3D centerOfMass = new Point3D();
        double totalMass = this.computeCenterOfMass((Point3DBasics)centerOfMass);
    }

    public Quaternion getRootJointToWorldRotationQuaternion() {
        return this.rootJoint.getQuaternion();
    }

    public void getRootJointToWorldTransform(RigidBodyTransform transform) {
        this.rootJoint.getTransformToWorld((RigidBodyTransformBasics)transform);
    }

    public void setPositionInWorld(Tuple3DReadOnly offset) {
        this.rootJoint.setPosition(offset);
    }

    public void setOrientation(double yaw, double pitch, double roll) {
        this.rootJoint.setYawPitchRoll(yaw, pitch, roll);
    }

    public void setOrientation(QuaternionReadOnly quaternion) {
        this.rootJoint.setQuaternion(quaternion);
    }

    public void setAngularVelocity(Vector3DReadOnly velocity) {
        this.rootJoint.setAngularVelocityInBody(velocity);
    }

    public void setLinearVelocity(Vector3DReadOnly velocity) {
        this.rootJoint.setVelocity((Tuple3DReadOnly)velocity);
    }

    public FloatingJoint getRootJoint() {
        return this.rootJoint;
    }

    public FrameVector3D getRootJointVelocity() {
        FrameVector3D ret = new FrameVector3D(ReferenceFrame.getWorldFrame());
        this.rootJoint.getVelocity((FrameVector3DBasics)ret);
        return ret;
    }

    public FrameVector3D getRootJointAngularVelocityInRootJointFrame(ReferenceFrame rootJointFrame) {
        Vector3D angularVelocity = this.rootJoint.getAngularVelocityInBody();
        return new FrameVector3D(rootJointFrame, (Tuple3DReadOnly)angularVelocity);
    }

    public Vector3D getPositionInWorld() {
        Vector3D position = new Vector3D();
        this.getPositionInWorld((Vector3DBasics)position);
        return position;
    }

    public void getPositionInWorld(Vector3DBasics vectorToPack) {
        this.rootJoint.getPosition((Tuple3DBasics)vectorToPack);
    }

    public void getVelocityInWorld(Vector3DBasics vectorToPack) {
        this.rootJoint.getVelocity((Tuple3DBasics)vectorToPack);
    }

    public void getOrientationInWorld(QuaternionBasics quaternionToPack) {
        this.rootJoint.getQuaternion(quaternionToPack);
    }

    public void getAngularVelocityInBody(Vector3DBasics vectorToPack) {
        this.rootJoint.getAngularVelocityInBody(vectorToPack);
    }
}

